/*
 * Decompiled with CFR 0.152.
 */
package org.havi.ui;

import java.awt.Image;
import org.havi.ui.HGraphicButton;
import org.havi.ui.HGraphicLook;
import org.havi.ui.HInvalidLookException;
import org.havi.ui.HSound;
import org.havi.ui.HSwitchable;
import org.havi.ui.HToggleGroup;
import org.videolan.BDJXletContext;

public class HToggleButton
extends HGraphicButton
implements HSwitchable {
    private static final String PROPERTY_LOOK = "HToggleButton";
    private HToggleGroup toggleGroup = null;
    private HSound unsetActionSound = null;
    private static final long serialVersionUID = 2602166176018744707L;

    public HToggleButton() {
        this.iniz();
    }

    public HToggleButton(Image image, int x, int y, int width, int height) {
        super(image, x, y, width, height);
        this.iniz();
    }

    public HToggleButton(Image image) {
        super(image);
        this.iniz();
    }

    public HToggleButton(Image image, int x, int y, int width, int height, boolean state) {
        this(image, x, y, width, height);
        this.setSwitchableState(state);
    }

    public HToggleButton(Image imageNormal, Image imageFocused, Image imageActioned, Image imageNormalActioned, int x, int y, int width, int height, boolean state) {
        super(imageNormal, imageFocused, imageActioned, x, y, width, height);
        this.setGraphicContent(imageNormalActioned, 130);
        this.setSwitchableState(state);
        this.iniz();
    }

    public HToggleButton(Image imageNormal, Image imageFocused, Image imageActioned, Image imageNormalActioned, boolean state) {
        super(imageNormal, imageFocused, imageActioned);
        this.setGraphicContent(imageNormalActioned, 130);
        this.setSwitchableState(state);
        this.iniz();
    }

    public HToggleButton(Image image, int x, int y, int width, int height, boolean state, HToggleGroup group) {
        this(image, x, y, width, height, state);
        this.setToggleGroup(group);
    }

    public HToggleButton(Image image, boolean state, HToggleGroup group) {
        this(image);
        this.setSwitchableState(state);
        this.setToggleGroup(group);
    }

    public HToggleButton(Image imageNormal, Image imageFocused, Image imageActioned, Image imageNormalActioned, int x, int y, int width, int height, boolean state, HToggleGroup group) {
        this(imageNormal, imageFocused, imageActioned, imageNormalActioned, x, y, width, height, state);
        this.setToggleGroup(group);
    }

    public HToggleButton(Image imageNormal, Image imageFocused, Image imageActioned, Image imageNormalActioned, boolean state, HToggleGroup group) {
        this(imageNormal, imageFocused, imageActioned, imageNormalActioned, state);
        this.setToggleGroup(group);
    }

    private void iniz() {
        try {
            this.setLook(HToggleButton.getDefaultLook());
        }
        catch (HInvalidLookException hInvalidLookException) {
            // empty catch block
        }
    }

    public void setToggleGroup(HToggleGroup group) {
        HToggleGroup oldGroup = this.toggleGroup;
        if (oldGroup != null) {
            if (oldGroup == group) {
                return;
            }
            oldGroup.remove(this);
        }
        this.toggleGroup = group;
        if (group != null) {
            group.add(this);
        }
    }

    public HToggleGroup getToggleGroup() {
        return this.toggleGroup;
    }

    public void removeToggleGroup() {
        this.setToggleGroup(null);
    }

    public static void setDefaultLook(HGraphicLook hlook) {
        BDJXletContext.setXletDefaultLook(PROPERTY_LOOK, hlook);
    }

    public static HGraphicLook getDefaultLook() {
        return (HGraphicLook)BDJXletContext.getXletDefaultLook(PROPERTY_LOOK, DEFAULT_LOOK);
    }

    public boolean getSwitchableState() {
        return (this.getInteractionState() & 2) != 0;
    }

    public void setSwitchableState(boolean state) {
        int old = this.getInteractionState();
        this.setInteractionState(state ? old | 2 : old & 0xFFFFFFFD);
    }

    public void setUnsetActionSound(HSound sound) {
        this.unsetActionSound = sound;
    }

    public HSound getUnsetActionSound() {
        return this.unsetActionSound;
    }
}

