#include <windows.h>
#include <scrnsave.h>
#include <process.h>
#include "tinyptc.h"
#include <malloc.h>

//#include "..\goom_core.h"
extern void  __stdcall goom_init (unsigned int resx, unsigned int, int cinemascope);
extern void  __stdcall goom_set_resolution (unsigned int resx, unsigned int resy, int cinemascope);
extern unsigned int * __stdcall goom_update ( short data[2][512], int forceMode, float fps,
											char *songTitle, char *message);
extern void     __stdcall goom_close ();

#include "frame_rate_tester.h"
#include "gmtimer.h"

extern int ptc_gl_update(void *buf);
extern int ptc_gl_open(char *title, int w, int h);
extern int ptc_gl_close();
extern int ptc_gl_set_hwnd(void *hWnd1);

/*
extern int goom_main();
extern void goom_init();
extern void goom_refresh();
extern void goom_shutdown();
extern HANDLE goom_thread_init();
extern void goom_thread_shutdown();
*/

#pragma comment(lib,"libgoommmx.a")

#ifdef SCREENSAVBUILD
#include "resource_ss.h"

HDC hDC;
HWND hWndSSGoom;

#define MINXVEL  240
#define MINYVEL  160
#define DEFXVEL  480
#define DEFYVEL  360
#define DEFCSCOPE 0
 
static LONG lXres = DEFXVEL;
static LONG lYres = DEFYVEL;
static LONG	lCScope = DEFCSCOPE;
static LONG sleeprate = -1;
static float spf = -1.0f;
static BOOL showfps = TRUE;
static BOOL showgl = FALSE;

static CHAR szTemp[20];
static CHAR szXres[] = "GOOMXres";
static CHAR szYres[] = "GOOMYres";
static CHAR szCScope[] = "GOOMCScope";
static CHAR szCFPS[] = "GOOMCFPS";
static CHAR szCTitle[] = "GOOMCTitle";
static CHAR szFPSLim[] = "GOOMFPSLim";
static CHAR szCGL[] = "GOOMCGL";
static CHAR szZshift[] = "GOOMZshift";
extern float zshift;

TCHAR myszAppName[] = "goomsc";
TCHAR myszIniFile[] = "goomsc.ini";

static int thread_stop=0;
HANDLE hThread;

static GMTimer *tgl = NULL;
static float glstart;

#define UPDINV 64
void goom_thread_main(void *pv)
{
	static gint16 data[2][512];
	int i,updsw;
	gint16 j,stp,glast,gnext,updinv;
	GMTimer *t;
	float time1,time2;

	if (showgl) {
		tgl = gmtimer_new();
		glstart = gmtimer_getvalue(tgl);
		ptc_gl_set_hwnd(hWndSSGoom);
		ptc_gl_open("Whatever...",640,480);
		goom_init(256,256,lCScope);
	} else {
		ptc_set_hwnd(hWndSSGoom);
		ptc_open("Whatever...",lXres,lYres);
		goom_init(lXres,lYres,lCScope);
	}

	updinv=UPDINV;
	updsw=0;

	framerate_tester_init();
	t = gmtimer_new();
	time1 = gmtimer_getvalue (t);
	while (thread_stop == 0) {
		float f;
		updsw++;
		if (updsw > (512/updinv)) {
			updsw=0;
			updinv = updinv >> 1;
			if (updinv < 2) updinv = UPDINV;
		}
		gnext=(gint16)(rand());
		for (i = 0 ; i < (512-updinv+1) ; i+=updinv) {
			data[0][i] = gnext;
			data[1][i] = data[0][i];
			glast=data[0][i];
			gnext=(gint16)(rand());
			stp = (gnext-data[0][i])/updinv;
			for (j = 1; j < updinv; j++) {
				data[0][i+j]=glast+stp*j;
				data[1][i+j]=data[0][i+j];
			}
		}
		f = framerate_tester_getvalue();
		if (!showfps) f=-1.0f;
		if (showgl) {
			ptc_gl_update (goom_update (data,0,f,NULL,NULL));
		} else {
			ptc_update (goom_update (data,0,f,NULL,NULL));
		}
		framerate_tester_newframe();
		time2 = gmtimer_getvalue (t);
		if (spf < 0) {
			time1=time2;
		} else {
			if ((time2 - time1) < spf) {
				DWORD ti = (DWORD)(1000.0*(spf + time1 - time2));
				Sleep (ti);
				time1 = time1 + spf;
			}
			else
				time1 = time2;
		}
	}
	gmtimer_delete(&t);
	framerate_tester_close();
	if (showgl) {
		gmtimer_delete(&tgl);
		ptc_gl_close();
	} else {
		ptc_close();
	}
	goom_close();
}

void goom_thread_init() {

	thread_stop = 0;
	hThread=(HANDLE)_beginthread(goom_thread_main,0,NULL);
}

void goom_thread_shutdown()
{
	thread_stop = 1;
	WaitForSingleObject(hThread,1000);
}

void GetGoomInitValues()
{
	LONG ltmp;
      /* Retrieve the application name from the .rc file. */ 

//      LoadString(hMainInstance, idsAppName, szAppName, 40); 

      /* Retrieve the .ini (or registry) file name. */ 

//      LoadString(hMainInstance, idsIniFile, szIniFile, 
//                 MAXFILELEN); 
 
      lXres = GetPrivateProfileInt(myszAppName, szXres, 
        DEFXVEL, myszIniFile); 
      lYres = GetPrivateProfileInt(myszAppName, szYres, 
         DEFYVEL, myszIniFile); 
//      lCScope = GetPrivateProfileInt(myszAppName, szCScope,
//         DEFCSCOPE, myszIniFile);
      sleeprate = GetPrivateProfileInt(myszAppName, szFPSLim,
         -1, myszIniFile);
	  if (sleeprate==0) sleeprate=-1;
	  spf=1.0f/(float)sleeprate;
      ltmp = GetPrivateProfileInt(myszAppName, szCFPS,
         1, myszIniFile);
	  showfps = (ltmp != 0);
      ltmp = GetPrivateProfileInt(myszAppName, szCGL,
         0, myszIniFile);
	  showgl = (ltmp != 0);
      ltmp = GetPrivateProfileInt(myszAppName, szZshift,
         -5, myszIniFile);
	  zshift = (float)ltmp;

 
      if(lXres > GetSystemMetrics(SM_CXSCREEN) || lXres < MINXVEL) 
         lXres = DEFXVEL; 

      if(lYres > GetSystemMetrics(SM_CYSCREEN) || lYres < MINYVEL) 
           lYres = DEFYVEL; 
 
}

LRESULT WINAPI ScreenSaverProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
        static RECT re;
        static UINT uTimer;

        switch(message)
        {
                case WM_CREATE:
						GetGoomInitValues();
//                        uTimer=SetTimer(hwnd, 1, 5, NULL);
						hWndSSGoom=hwnd;
						SetPriorityClass(GetCurrentProcess(),IDLE_PRIORITY_CLASS);
						goom_thread_init();
                        break;
                case WM_ERASEBKGND:
                        hDC=GetDC(hwnd);
                        GetClientRect(hwnd, &re);
                        FillRect(hDC, &re, GetStockObject(BLACK_BRUSH));
                        ReleaseDC(hwnd, hDC);
                        break;
                case WM_TIMER:
//						goom_refresh();
                       break;
				case WM_MOUSEMOVE:
				case WM_CLOSE:
						if (showgl) {
							if (tgl != NULL) {
								float tnow = gmtimer_getvalue(tgl);
								if (2.0f > (tnow-glstart)) {
									return 0;
								}
							}
						}
                        return (DefScreenSaverProc(hwnd, message, wParam, lParam));
                case WM_DESTROY:
//                        if(uTimer)
//                                KillTimer(hwnd, uTimer);
						goom_thread_shutdown();

                        break;
                default:
                        return (DefScreenSaverProc(hwnd, message, wParam, lParam));
        }
        return 0;
}


extern char *readme();

BOOL WINAPI ScreenSaverConfigureDialog(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
//        return TRUE;
    static HWND hXres; 
    static HWND hYres; 
    static HWND hXlab; 
    static HWND hYlab; 
    static HWND hCScope;
	static HWND hlim;
	static HWND hCFPS;
	static HWND hCTitle;
	static HWND hCGL;

    LONG *pVar;

    switch(message) 
    { 
        case WM_INITDIALOG: 
 
            GetGoomInitValues();

            hXlab = GetDlgItem(hDlg, IDC_XRESLAB); 
            hYlab = GetDlgItem(hDlg, IDC_YRESLAB); 
 
            hXres = GetDlgItem(hDlg, IDC_XRES_SCROLL); 
            hYres = GetDlgItem(hDlg, IDC_YRES_SCROLL); 

//            hCScope = GetDlgItem(hDlg,IDC_CHECK_CSCOPE);

            SetScrollRange(hXres, SB_CTL, MINXVEL, GetSystemMetrics(SM_CXSCREEN), FALSE); 
            SetScrollPos(hXres, SB_CTL, lXres, TRUE); 
 
            SetScrollRange(hYres, SB_CTL, MINYVEL, GetSystemMetrics(SM_CYSCREEN), FALSE); 
            SetScrollPos(hYres, SB_CTL, lYres, TRUE); 
 
            wsprintf(szTemp, "Xres : %ld", lXres); 
            SetWindowText(hXlab,szTemp);
            wsprintf(szTemp, "Yres : %ld", lYres); 
            SetWindowText(hYlab,szTemp);

//            if (lCScope != 0) {
//               SendMessage(hCScope,BM_SETCHECK,BST_CHECKED,0);
//             }  else {
//               SendMessage(hCScope,BM_SETCHECK,BST_UNCHECKED,0);
//             }
			hlim = GetDlgItem(hDlg,IDC_COMBO_FPSLIM);
			SendMessage(hlim,CB_ADDSTRING,0,(LPARAM)"5");
			SendMessage(hlim,CB_ADDSTRING,0,(LPARAM)"10");
			SendMessage(hlim,CB_ADDSTRING,0,(LPARAM)"15");
			SendMessage(hlim,CB_ADDSTRING,0,(LPARAM)"20");
			SendMessage(hlim,CB_ADDSTRING,0,(LPARAM)"25");
			SendMessage(hlim,CB_ADDSTRING,0,(LPARAM)"30");
			SendMessage(hlim,CB_ADDSTRING,0,(LPARAM)"None");
			if (sleeprate == 5) SendMessage(hlim,CB_SETCURSEL,0,0);
			else if (sleeprate == 10) SendMessage(hlim,CB_SETCURSEL,1,0);
			else if (sleeprate == 15) SendMessage(hlim,CB_SETCURSEL,2,0);
			else if (sleeprate == 20) SendMessage(hlim,CB_SETCURSEL,3,0);
			else if (sleeprate == 25) SendMessage(hlim,CB_SETCURSEL,4,0);
			else if (sleeprate == 30) SendMessage(hlim,CB_SETCURSEL,5,0);
			else SendMessage(hlim,CB_SETCURSEL,6,0);
			hCFPS = GetDlgItem(hDlg,IDC_CHECK_FPS);
			if (showfps) {
				SendMessage(hCFPS,BM_SETCHECK,BST_CHECKED,0);
			} else {
				SendMessage(hCFPS,BM_SETCHECK,BST_UNCHECKED,0);
			}
			hCTitle = GetDlgItem(hDlg,IDC_CHECK_TITLE);
			ShowWindow(hCTitle,SW_HIDE);
			hCGL = GetDlgItem(hDlg,IDC_CHECK_GL);
			if (showgl) {
				SendMessage(hCGL,BM_SETCHECK,BST_CHECKED,0);
			} else {
				SendMessage(hCGL,BM_SETCHECK,BST_UNCHECKED,0);
			}

			if (zshift == -1.0f) {
				CheckRadioButton(hDlg,IDC_RADIO_ZSM5,IDC_RADIO_ZSM1,IDC_RADIO_ZSM1);
			} else if (zshift == -2.0f) {
				CheckRadioButton(hDlg,IDC_RADIO_ZSM5,IDC_RADIO_ZSM1,IDC_RADIO_ZSM3);
			} else {
				CheckRadioButton(hDlg,IDC_RADIO_ZSM5,IDC_RADIO_ZSM1,IDC_RADIO_ZSM5);
			}
            return TRUE; 
 
        case WM_HSCROLL: 
 
            if ((HWND)lParam == hXres) {
               pVar = &lXres;
            } else {
               pVar = &lYres;
            }
 
            switch (LOWORD(wParam)) 
                { 
                    case SB_PAGEUP: 
                        (*pVar)-=20; 
                    break; 
 
                    case SB_LINEUP: 
                        (*pVar)--; 
                    break; 
 
                    case SB_PAGEDOWN: 
                        (*pVar)+=20; 
                    break; 
 
                    case SB_LINEDOWN: 
                        (*pVar)++; 
                    break; 
 
                    case SB_THUMBPOSITION: 
                         *pVar = HIWORD(wParam); 
                    break; 
 
                    case SB_BOTTOM: 
                        if (pVar == &lXres)
                           *pVar = MINXVEL; 
                        else
                           *pVar = MINYVEL;
                    break; 
 
                    case SB_TOP: 
                        if (pVar == &lYres)
                           *pVar = GetSystemMetrics(SM_CXSCREEN); 
                        else
                           *pVar = GetSystemMetrics(SM_CYSCREEN);
                    break; 
 
                    case SB_THUMBTRACK: 
                         *pVar = HIWORD(wParam); 
                    break; 

                    case SB_ENDSCROLL: 
                        return TRUE; 
                    break; 
                } 
                if(lXres > GetSystemMetrics(SM_CXSCREEN)) 
                  lXres = GetSystemMetrics(SM_CXSCREEN); 
                if(lXres < MINXVEL) 
                  lXres = MINXVEL; 

                if(lYres > GetSystemMetrics(SM_CYSCREEN)) 
                  lYres = GetSystemMetrics(SM_CYSCREEN); 
                if(lYres < MINYVEL) 
                  lYres = MINYVEL; 
 
                SetScrollPos((HWND) lParam, SB_CTL, *pVar, TRUE); 

                 wsprintf(szTemp, "Xres : %ld", lXres); 
                 SetWindowText(hXlab,szTemp);
                 wsprintf(szTemp, "Yres : %ld", lYres); 
                 SetWindowText(hYlab,szTemp);
            break; 
 
        case WM_COMMAND: 
            switch(LOWORD(wParam)) 
            {
				int ichk;
//				case IDC_CHECK_CSCOPE:
				case IDC_CHECK_FPS:
				case IDC_CHECK_TITLE:
				case IDC_COMBO_FPSLIM:
				case IDC_CHECK_GL:
				case IDC_RADIO_ZSM5:
				case IDC_RADIO_ZSM3:
				case IDC_RADIO_ZSM1:
					return TRUE;

                case ID_OK: 
 
 
                    wsprintf(szTemp, "%ld", lXres); 
                    WritePrivateProfileString(myszAppName, szXres, 
                        szTemp, myszIniFile); 
                    wsprintf(szTemp, "%ld", lYres); 
                    WritePrivateProfileString(myszAppName, szYres, 
                        szTemp, myszIniFile); 
//                    lCScope = SendMessage(hCScope,BM_GETCHECK,0,0);
//                    wsprintf(szTemp, "%ld", lCScope);
//                    WritePrivateProfileString(myszAppName, szCScope,
//                        szTemp, myszIniFile);
 					ichk=SendMessage(hlim,CB_GETCURSEL,0,0);
					switch (ichk) {
					case 0:
						sleeprate = 5;
						break;
					case 1:
						sleeprate = 10;
						break;
					case 2:
						sleeprate = 15;
						break;
					case 3:
						sleeprate = 20;
						break;
					case 4:
						sleeprate = 25;
						break;
					case 5:
						sleeprate = 30;
						break;
					case 6:
						sleeprate = -1;
						break;
					}
                    wsprintf(szTemp, "%ld", sleeprate);
                    WritePrivateProfileString(myszAppName, szFPSLim,
                        szTemp, myszIniFile);
					spf=1.0f/(float)sleeprate;
					showfps = (SendMessage(hCFPS,BM_GETCHECK,0,0) == BST_CHECKED);
					if (showfps) {
						wsprintf(szTemp, "%ld", 1);
					} else {
						wsprintf(szTemp, "%ld", 0);
					}
                    WritePrivateProfileString(myszAppName, szCFPS,
                        szTemp, myszIniFile);
					showgl = (SendMessage(hCGL,BM_GETCHECK,0,0) == BST_CHECKED);
					if (showgl) {
						wsprintf(szTemp, "%ld", 1);
					} else {
						wsprintf(szTemp, "%ld", 0);
					}
                    WritePrivateProfileString(myszAppName, szCGL,
                        szTemp, myszIniFile);
					if (IsDlgButtonChecked(hDlg,IDC_RADIO_ZSM1)) {
						ichk=-1;
					} else if (IsDlgButtonChecked(hDlg,IDC_RADIO_ZSM3)) {
						ichk=-2;
					} else {
						ichk=-5;
					}
					wsprintf(szTemp, "%ld", ichk);
                    WritePrivateProfileString(myszAppName, szZshift,
                        szTemp, myszIniFile);
					zshift=(float)ichk;

                case ID_CANCEL: 
                    EndDialog(hDlg, LOWORD(wParam) == ID_OK); 
                return TRUE; 

				case ID_ABOUT:
					MessageBox(hDlg,readme(),"Goom",MB_OK);
					return TRUE;
            } 
		case WM_CLOSE:
			EndDialog(hDlg,0);
			return TRUE;
    } 
    return FALSE; 
}

BOOL WINAPI RegisterDialogClasses(HANDLE hInst)
{
        return TRUE;
}

#else

#ifdef WAVEINBUILD
void jeko_mono_to_stereo_render(gint16 *mondat)
{
	static gint16 data[2][512];
	int i;
	static int iinit = 0;
	
	if (iinit == 0) {
		iinit = 1;
		ptc_open("What A GOOM!",320,240);
		goom_init(320,240,0);
	}

	for (i = 0 ; i < 512 ; i++) {
		data[0][i] = mondat[i];
		data[1][i] = data[0][i];
	}
	ptc_update(goom_update(data,0,34.5f,NULL,NULL));
}

extern BOOL goom_audio_start();
extern void goom_audio_wait();
extern BOOL goom_audio_finished();
#endif

int main()
{	

	MSG msg;
	int iret;
	static gint16 data[2][512];
	int i;
	float f;
	unsigned int *buf;

	framerate_tester_init();

#ifndef WAVEINBUILD
	ptc_open("What A GOOM!",400,300);
	goom_init(400,300,0);
	while(1) {
//		if (PeekMessage(&msg,NULL,0,0,PM_NOREMOVE)) {
//			iret = (int)GetMessage(&msg,NULL,0,0);
//			if (iret == 0) break;
//			TranslateMessage(&msg);
//			DispatchMessage(&msg);
//		}
		for (i = 0 ; i < 512 ; i++) {
			data[0][i] = (gint16)(rand());
			data[1][i] = data[0][i];
		}
		f = framerate_tester_getvalue();
//		f=0.0f;
		buf = goom_update(data,0,f,"","");
		if (!ptc_update(buf)) break;
		framerate_tester_newframe();
	}
#else
//	ptc_open("What A GOOM!",320,240);
//	goom_init(320,240);
	if (!goom_audio_start()) {
		MessageBox(NULL,"Could Not Get Wave Input Handle","GoomWaveIn",MB_OK);
		return 0;
	}
	goom_audio_wait();
//	while(1) {
//		if (PeekMessage(&msg,NULL,0,0,PM_NOREMOVE)) {
//			iret = (int)GetMessage(&msg,NULL,0,0);
//			if (iret == 0) break;
//			TranslateMessage(&msg);
//			DispatchMessage(&msg);
//		}
//		if (goom_audio_finished()) break;
//	}
//	ExitProcess(0);
#endif

	goom_close();
	return 0;
}

#endif
