/****************************************************************************
** libebml : parse EBML files, see http://embl.sourceforge.net/
**
** <file/class description>
**
** Copyright (C) 2002-2003 Steve Lhomme.  All rights reserved.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding an other license may use this file in accordance with 
** the Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.matroska.org/license/qpl/ for QPL licensing information.
** See http://www.matroska.org/license/gpl/ for GPL licensing information.
**
** Contact license@matroska.org if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/
/*!
	\file
	\version \$Id: WinIOCallback.h,v 1.1 2003/07/16 14:41:35 robux4 Exp $
	\author Steve Lhomme     <robux4 @ users.sf.net>
*/

#ifndef LIBEBML_WINIOCALLBACK_H
#define LIBEBML_WINIOCALLBACK_H

#include <windows.h>
#include "ebml/IOCallback.h"

START_LIBEBML_NAMESPACE

class WinIOCallback: public IOCallback
{	
public:
	WinIOCallback(TCHAR* Path, const open_mode Mode);
	virtual ~WinIOCallback();

	virtual uint32 read(void*Buffer,size_t Size);
	virtual size_t write(const void*Buffer,size_t Size);
	virtual void setFilePointer(int64 Offset,seek_mode Mode=seek_beginning);
	virtual uint64 getFilePointer();
	virtual void close();
private:
	HANDLE mFile;

};

END_LIBEBML_NAMESPACE

#endif // LIBEBML_WINIOCALLBACK_H
