dnl Autoconf support for C++ convenience macros
dnl Copyright (C) 1988 Eleftherios Gkioulekas <lf@amath.washington.edu>
dnl  
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl 
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl 
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software 
dnl Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
dnl 
dnl As a special exception to the GNU General Public License, if you 
dnl distribute this file as part of a program that contains a configuration 
dnl script generated by Autoconf, you may include it under the same 
dnl distribution terms that you use for the rest of that program.

# -----------------------------------------------------------------
# This macro defines some convenient macros for C++ prorgramming
# It requires LF_CXX_PORTABILITY
# When called, the macro does the following things:
# 1. Fortran-like looping macros.
# 2. Java-like scoping qualifiers.
# 3. An 18-digit approximation of pi
# 3. USE_ASSERT if the user wants to use assertions
# Seperately we provide some config.h.bot code to be added to acconfig.h
# that implements work-arounds for these problems.
# ------------------------------------------------------------------

dnl ACCONFIG TEMPLATE
dnl #undef NDEBUG
dnl END ACCONFIG

AC_DEFUN(LF_CXX_CONVENIENCE,[

  dnl
  dnl Define convenient C++ constructs
  dnl

  AC_REQUIRE([LF_CXX_PORTABILITY])

  AC_LANG_SAVE
  AC_LANG_CPLUSPLUS

  dnl Test whether the user wants to enable assertions
  AC_MSG_CHECKING(whether user wants assertions)
  AC_ARG_ENABLE(assert,
                [  --disable-assert        don't use cpp.h assert],
                [ AC_DEFINE(NDEBUG)
                  AC_MSG_RESULT(no)  ],
                [ AC_MSG_RESULT(yes) ],
               )

  dnl Done with the portability checks
  AC_LANG_RESTORE
])

dnl ACCONFIG BOTTOM
dnl 
dnl // This file defines convenience macros for C++ programming
dnl 
dnl 
dnl //
dnl // Fortran-like integer looping macros
dnl // these critters depend on the scoping work-around above
dnl //
dnl 
dnl #define loop(COUNTER,BEGIN,END)  \
dnl for (int COUNTER = BEGIN ; COUNTER <= END ; COUNTER ## ++)
dnl 
dnl #define inverse_loop(COUNTER,END,BEGIN) \
dnl for (int COUNTER = END; COUNTER >= BEGIN; COUNTER ## --)
dnl 
dnl #define integer_loop(COUNTER,BEGIN,END,STEP) \
dnl for (int COUNTER = BEGIN; COUNTER <= END; COUNTER += STEP)
dnl 
dnl //
dnl // Class protection levels
dnl // addictive syntactic sugar to make coding nicer
dnl //
dnl 
dnl #define pub public:
dnl #define pro protected:
dnl #define pri private:
dnl 
dnl //
dnl // Every mathematician would like to know pi
dnl // so this is as good a place as any to throw it in.
dnl //
dnl 
dnl #define pi 3.14159265358979324
dnl 
dnl #include <assert.h>
dnl 
dnl END ACCONFIG
