/* Trivial modification of usage.c and printversion.c in texk/web2c/lib.
   The two files are in public domain. */

#include "config.h"
#include <lib/lib.h>
#include <kpathsea/version.h>

void
usage(const_string str)
{
  fprintf (stderr, "Try `%s --help' for more information.\n", str);
  uexit (1);
}

void
usagehelp(const_string *message, const_string bug_email)
{
    if (!bug_email)
        bug_email = "sakurai@math.s.chiba-u.ac.jp";
    while (*message) {
        fprintf(stdout, "%s\n", *message);
        ++message;
    }
    fprintf(stdout, "\nEmail bug reports to %s.\n", bug_email);
    fflush(stdout);
    uexit(0);
}

void
printversionandexit(const_string banner,
                    const_string copyright_holder,  
                    const_string author,
                    char *extra_info)
{
  string prog_name;
  unsigned len;
#ifdef BIBTEX
  const_string base_prog_name = "BibTeX";
#else
  const_string base_prog_name = "TeX";
#endif
  const_string prog_name_end = strchr (banner, ',');
  const_string prog_version = prog_name_end + sizeof("Version") + 2;
  assert (prog_name_end && prog_version);
  
  len = prog_name_end - banner - sizeof ("This is");
  prog_name = (string)xmalloc (len + 1);
  strncpy (prog_name, banner + sizeof ("This is"), len);
  prog_name[len] = 0;

  /* The Web2c version string starts with a space.  */
  fprintf (stdout,"%s %s%s\n", prog_name, prog_version, versionstring);
  fputs (kpathsea_version_string, stdout); fputs("\n", stdout);

  if (copyright_holder) {
    printf ("Copyright 2021 %s.\n", copyright_holder);
    if (!author)
      author = copyright_holder;
  }

  fputs ("There is NO warranty.  Redistribution of this software is\n",
         stdout);
  fputs ("covered by the terms of ", stdout);
  /* DVIcopy is GPL'd, so no additional words needed. */
  if (/*copyright_holder && */!STREQ (prog_name, "DVIcopy")) {
    fprintf (stdout, "both the %s copyright and\n", base_prog_name);
  }
  fputs ("the GNU General Public License.\n", stdout);
  fputs ("For more information about these matters, see the files\n", stdout);
  fprintf (stdout, "named COPYING and the %s and %s source.\n",
	  base_prog_name, prog_name);
  fprintf (stdout, "Primary author of %s: %s; %s author: %s.\n",
          base_prog_name, copyright_holder, prog_name, author);
  fflush(stdout);

  if (extra_info) {
    puts (extra_info);
  }

  uexit (0);
}
