---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, renvois, références croisées par nom
---

# Comment obtenir des références intégrant des noms ?

Le mécanisme de références croisées de LaTeX est conçu pour le monde assez impersonnel
de la publication académique, dans lequel tout a un numéro. 
Aussi, une extension est nécessaire si nous voulons afficher le *nom* des choses auxquelles nous faisons référence. 

:::{todo} Ajouter des exemples.
:::

## Avec l'extension <ctanpkg:titleref>

L'extension <ctanpkg:titleref> fournit la commande `\titleref`. 
Il convient cependant de ne pas l'utiliser dans un document 
dans lequel vous devez également utiliser l'extension <ctanpkg:hyperref>.


## Avec l'extension [byname](ctanpkg:smartref)

L'extension [byname](ctanpkg:smartref) fait partie de l'ensemble <ctanpkg:smartref> 
et fonctionne d'ailleurs bien avec <ctanpkg:smartref>. 
Elle fonctionne (dans une certaine mesure) avec <ctanpkg:hyperref> 
mais les liens qu'elle définit ne sont pas des hyperliens.


## Avec la classe <ctanpkg:memoir>

La classe <ctanpkg:memoir> incorpore la fonctionnalité de <ctanpkg:titleref> 
mais ne fonctionne pas avec [byname](ctanpkg:smartref) (mais des correctifs existent).

:::{todo} Trouver ces correctifs.
:::


## Avec l'extension <ctanpkg:nameref> (et <ctanpkg:hyperref>)

L'ensemble <ctanpkg:hyperref> comprend une extension <ctanpkg:nameref>, qui fonctionnera seule 
(c'est-à-dire sans <ctanpkg:hyperref> mais alors, bien sûr, les références ne sont pas hypertextes). 
Les commandes de l'extension <ctanpkg:nameref> peuvent être utilisées dans un document de classe <ctanpkg:memoir>.

Si vous chargez l'extension <ctanpkg:hyperref> elle-même, alors <ctanpkg:nameref> est automatiquement chargée. 
La classe <ctanpkg:memoir> nécessite l'extension <ctanpkg:memhfixc> lors de l'exécution avec <ctanpkg:hyperref>, 
comme suit :

```{noedit}
\documentclass[...]{memoir}
...
\usepackage[...]{hyperref}
\usepackage{memhfixc}
```


## Avec l'extension <ctanpkg:zref>

L'extension <ctanpkg:zref> propose un remplacement complet des mécanismes de références croisées de LaTeX 
et offre en particulier une fonctionnalité de référence avec le nom :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

  \usepackage[user,titleref]{zref}

\begin{document}
\section{Un exemple}\zlabel{sec:un}
Le nom de cette section exemplaire est : \og \ztitleref{sec:un} \fg{}.
\end{document}
```


Chacune des extensions <ctanpkg:titleref>, [byname](ctanpkg:smartref) et <ctanpkg:nameref> 
définit une commande de référence avec le même nom que l'extension : `\titleref`, `\byname` et `\nameref`. 
L'extension <ctanpkg:nameref> définit également une commande `\byshortnameref`, 
qui utilise l'argument optionnel court des commandes de chapitre et de section. 
Par contre, l'extension <ctanpkg:zref>, du même auteur (Heiko Oberdiek), *ne définit pas* une telle variante.

:::{sources}
[Referring to things by their name](faquk:FAQ-nameref)
:::