/*# --------------------------------------------------------------------------
###  package    = "FTETX"
###  version    = "0.04"
###  date       = "1997/08/20"
###  filename   = "./CONTRIB/FTETX004/SRC/TXLAUNCH.003/prf.c"
###  local      = "NO"
### --------------------------------------------------------------------------
###  txlaunch-version = "0.03"
### -------------------------- Copyright (c) 1997, Oliver John von Zydowitz */

#define __PRF_C__

#include "common.h"

#include "global.h"
#include "prf.h"
#include "fn.h"
#include "msg.h"
#include "str.h"

#include "debug.h"


/*-----------------------------------------------------------------------------
  void PRF_debug_file(PSZ szMsg, PRF prf)
  output of filename(s) for -Df
  given:  Message string; profile
*/

void PRF_debug_file(PSZ szMsg, PRF prf)
{
  if (!OPT_debug_files) return;
  MSG_msg(szMsg);
  MSG_msg(prf->szGivenFile);
  MSG_msg(" (");
  MSG_msg(prf->szFileName);
  MSG_msg(")\n");
}

/*-----------------------------------------------------------------------------
  P_PRF PRF_open_file(PSZ szFilename, PPRF pProfile, int fatal_code )
  given:  Filename (szFilename)
          Pointer to Profile (pProfile) / NULL when first file, valid pointer
            when opening files nested ($include)
          no. of fatal msg if open fails
  returns: 1 on success; 0 on fail
  Note: when nesting profiles, previous pointer to profile is stored in the
        new profile. (linked list)
*/

int PRF_open_file(PSZ szFile, PPRF pPrf, int fatal_code )
{
PRF  prf1;

DBG2("PRF_open_file() : szFile = >%s<\n", szFile);

  if (!(prf1 = malloc(sizeof(PRFSTRUCT)))) MSG_fatal_n(FAT_NOMEM); /* get new profile */

  prf1->szGivenFile = NULL;                                        /* and initialize  */
  prf1->szAbsPath = NULL;
  prf1->szFileName = NULL;
  prf1->lineno = 0;
  prf1->prf_nest_upper = *pPrf;
  
  STR_copy_string(&(prf1->szGivenFile), szFile);                   /* save given name */
                                                                   /* resolve abs path */
  if (*pPrf)
    {
      DBG2("PRF_open_file() : (*pPrf)->szAbsPath = >%s<\n", (*pPrf)->szAbsPath);
      DBG2("PRF_open_file() : (*pPrf)->szFileName = >%s<\n", (*pPrf)->szFileName);
      FN_MakeAbs (&(prf1->szFileName), szFile, (*pPrf)->szAbsPath);
      FN_GetDrvPath(&(prf1->szAbsPath), prf1->szFileName);           /* abs path of next prf */
    }
  else
    {
      DBG1("PRF_open_file() : (*pPrf)==NULL\n");
      FN_MakeAbs (&(prf1->szFileName), szFile, NULL);
      FN_GetDrvPath(&(prf1->szAbsPath), prf1->szFileName);           /* abs path of prf, prf is 1st */
    }
  DBG2("PRF_open_file() : prf1->szAbsPath = >%s<\n", prf1->szAbsPath);
  DBG2("PRF_open_file() : prf1->szFileName = >%s<\n", prf1->szFileName);

  prf1->fp = fopen(prf1->szFileName,"r");
  PRF_debug_file("open:  ", prf1);

  if (!(prf1->fp))
    {
      MSG_fatal_n(fatal_code);
      DBG1("PRF_open_file() : failed\n");
      return 0;
    }
  *pPrf=prf1;                                                     /* ready */
  DBG1("PRF_open_file() : ok\n");
  return 1;
}


/*-----------------------------------------------------------------------------
  void PRF_close_file(PPRF pPrf)
  closes a profile. changes *pPtf to the upper profile in chain (when nesting
  files)
  given: pointer to profile
*/

void PRF_close_file(PPRF pPrf)
{
PRF prf1;

  DBG1("PRF_close_file\n");

  prf1 = *pPrf;

  fclose(prf1->fp);                        /* close file */
  PRF_debug_file("close: ", prf1);

  STR_delete_string(&(prf1->szGivenFile));      /* free */
  STR_delete_string(&(prf1->szAbsPath));
  STR_delete_string(&(prf1->szFileName));
  
  *pPrf = prf1->prf_nest_upper;                /* uplink */
  free(prf1);
}


/*-----------------------------------------------------------------------------
  void PRF_close_allfiles(PPRF pPrf)
  closes all profiles from chain.
  given: pointer to profile
*/

void PRF_close_allfiles(PPRF pPrf)
{
PRF prf1;
    
  DBG1("PRF_close_allfiles\n");
  prf1 = *pPrf;
  while (prf1) PRF_close_file(&prf1);        /* run along chain */
  *pPrf = NULL;
}

/*-----------------------------------------------------------------------------
  int PRF_readln0(PPRF pPrf, PPSZ pszLineBuf, int fatal_code)
  reads next line from profile. lines are terminated with the OS-specific
  character-sequence (\n on UNIX, \r\n on DOS/WIN-machines).
  the last line of a file needs no eol-sequence (but should have one).
  given: pointer to profile,
         address of (char *) to store line,
         no. of fatal-msg on read-err
  returns: 1 if line is read in, 0 on eof.
  Note: this is the *basic* readline.
  */
  
int PRF_readln0(PPRF pPrf, PPSZ pszLineBuf, int fatal_code)
{ 
char szFBuf[256];
PCH  p1;

  if (feof((*pPrf)->fp))  return 0;  /* at endof current file */

  STR_copy_string(pszLineBuf, "");
  for(;;)
    {
      *szFBuf = 0;
      fgets(szFBuf, 256, (*pPrf)->fp);  /* get 'some' chars of the line */

      if (ferror((*pPrf)->fp))
          MSG_fatal_n(fatal_code);        /* fatal */
      if (feof((*pPrf)->fp))
          break;                          /* break loop, still chars in szFBuf */
      p1 = strchr(szFBuf, '\n');          /* check if we got a '\n' */
      if (p1)                             /* we got one, break */
       {
         (*pPrf)->lineno++;
         break;
       }
      STR_concat_string(pszLineBuf, szFBuf);    /* we didn't, get ready for next loop */
    }
                                               /* we have chars in szFBuf */
  STR_concat_string(pszLineBuf, szFBuf);       /* move them now */
  STR_remove_whitesp(pszLineBuf);              /* at last get rid of spaces and nl */
  return 1;  
}


/*-----------------------------------------------------------------------------
  int PRF_readln1(PPRF pPrf, PPSZ pszLineBuf, int fatal_code)
  PRF_readln1() calls PRF_readln0() and handles $include-lines.
  Note: if an $include-line is found, an empty line is returned.
*/

int PRF_readln1(PPRF pPrf, PPSZ pszLineBuf, int fatal_code)
{
int rd0;
int morelines = 1;
PSZ szFileName;

  do
    {
       rd0 = PRF_readln0(pPrf, pszLineBuf, fatal_code);   /* read next line */
       if (!rd0)                                     /* no one in this file */
         {
           PRF_close_file(pPrf);                     /* close the file */
           if (!(*pPrf)) morelines = 0;
         }
     }
   while
   /*until!*/  (! ( (!morelines) || (rd0) ) );    /* retry until no more lines or one read in */
   if (!rd0)
     {
       STR_copy_string(pszLineBuf,"");      /* return an empty line */
       return 0;                            /* and say eof */
     }
   if  ((szFileName = STR_is_leader(*pszLineBuf,"$include=")))   /* an $include= ? */
    {
       PRF_open_file(szFileName, pPrf, FAT_OPEN);       /* open nested */
       STR_copy_string(pszLineBuf,"");                  /* and return an empty line */
       return 1;
     }
  return 1;
}


/*-----------------------------------------------------------------------------
  int PRF_readln(PPRF pPrf, PPSZ pszLineBuf, int fatal_code)
  PRF_readln() calls PRF_readln1(). This strips empty lines and comments.
  Note: This is the exported readline-function.
*/

int PRF_readln(PPRF pPrf, PPSZ pszLineBuf, int fatal_code)
{
int rd1;
int valid = 0;

  while (!valid)
     {
        rd1 = PRF_readln1(pPrf, pszLineBuf, fatal_code);
        if (!rd1) return 0;
        if ( (**pszLineBuf!='#') && (**pszLineBuf!=';') && (**pszLineBuf!=0  ) )
          valid = 1;                           /* ignore comments and empty lines */
      }
  /* DBG2("PRF_readline -> `%s'\n", *pszLineBuf); */
  return 1;
}


/*------------------------------------------------------------------------- */
