################################################################################
#
# Makefile  : LaTeX2HTML
# Author    : Fabrice Popineau <Fabrice.Popineau@supelec.fr>
# Platform  : Win32, Microsoft VC++ 6.0, depends upon fpTeX 0.5 sources
# Time-stamp: <01/11/19 14:04:28 popineau>
#
################################################################################
root_srcdir = ..\..
INCLUDE=$(INCLUDE);$(root_srcdir)\texk

!include <msvc/common.mak>

# All programs
SCRIPTS = latex2html.pl texexpand.pl pstoimg.pl

# Modules
MODULES = l2hconf.pm

# for dependencies
wrappers = wrapper/dos.pin wrapper/macos.pin wrapper/os2.pin \
        wrapper/unix.pin wrapper/win32.pin

# Switch for Perl Warnings; should always be on
# temporary solution until latexhtml is cleaned up
PERLW =# -w

#### End of system configuration section. ####

# Files that can be generated, but should be up to date for a distribution.
DISTDEP = configure Makefile MANIFEST

buildcmd = config/build.pl
ARGS=#
BUILDOPT=# nothing special, but -devel is a good idea!
TESTCASE=l2htest# can be overridden on the command line
installcmd = config/install.pl
cfgfile = cfgcache.pm

LATEX2HTML = $(prefix)
LATEX2HTMLDIR = $(prefix)\latex2html

.PRECIOUS: $(cfgfile)

all: $(SCRIPTS) $(MODULES)

devel:
	$(MAKE) all BUILDOPT=-devel

# .SUFFIXES:

pstoimg.pl:  $(cfgfile) $(srcdir)/$(buildcmd) pstoimg.pin $(wrappers)
	$(perl) $(srcdir)/$(buildcmd) -x $(BUILDOPT) $(@:.pl=)
	sed -e "1,19d" < $(@:.pl=.bat) > $@
	$(touch) $@

latex2html.pl:  $(cfgfile) $(srcdir)/$(buildcmd) latex2html.pin $(wrappers)
	$(perl) $(srcdir)/$(buildcmd) -x $(BUILDOPT) $(@:.pl=)
	sed -e "1,19d" < $(@:.pl=.bat) > $@
	$(touch) $@

texexpand.pl:  $(cfgfile) $(srcdir)/$(buildcmd) texexpand.pin $(wrappers)
	$(perl) $(srcdir)/$(buildcmd) -x $(BUILDOPT) $(@:.pl=)
	sed -e "1,19d" < $(@:.pl=.bat) > $@
	$(touch) $@

$(cfgfile): fptex.pm
#	$(perl) config/config.pl
	$(copy) fptex.pm $(cfgfile)

l2hconf.pm: $(cfgfile) $(srcdir)/$(buildcmd) l2hconf.pin
	$(perl) $(srcdir)/$(buildcmd) $(BUILDOPT) $@
	$(touch) l2hconf.pm

test: all
	set LATEX2HTMLDIR=$(srcdir)
	@echo "*** Running test on latex2html"
	cd tests & $(perl) -I.. ../latex2html.pl -test_mode $(ARGS) $(TESTCASE)

test_clean:
	-@cd tests & \
	for %%i in (*.tex) do \
	  $(deldir) /q/s %%~ni
	-@cd tests & del /q/f *.aux *.dvi *.log

test_pstoimg: pstoimg.pl
	set LATEX2HTMLDIR=$(srcdir)
	echo "*** Running test: pstoimg $(ARGS)"
	$(perl) ./pstoimg.pl $(ARGS)

texlive: texlive.pm
	$(copy) texlive.pm $(cfgfile)
	$(make) all

#check: all
#	LATEX2HTMLDIR=$(srcdir); export LATEX2HTMLDIR ; \
#	for file in versions/*.pl styles/*.perl; do \
#	  $(perl) $(perlW) -c $$file || exit 1; \
#	done ; \
#	for file in $(SCRIPTS) $(MODULES); do \
#	  test -s $$file && ( $(perl) $(perlW) -c $$file || exit 1 ); \
#	  test -s $$file.pl && ( $(perl) $(perlW) -c $$file.pl || exit 1 ); \
#	done ; \
#	exit 0

install: all $(mktexdir) $(runperl)
	$(mktexdir) $(prefix)\latex2html\bin
	$(perl) $(installcmd)
	$(copy) $(runperl) $(prefix)\latex2html\bin
	for %%f in ($(SCRIPTS)) do \
		$(copy) $(runperl) $(prefix)\latex2html\bin\%%~nf.exe \
		& $(copy) %%f $(prefix)\latex2html\bin\%%f \
		& $(del) -f $(prefix)\latex2html\bin\%%~nf.bat

# Don't cd, to avoid breaking install-sh references.

#$(srcdir)/configure:
#	cd $(srcdir) && \
#	$(AUTOCONF)

#Makefile: Makefile.in config.status
#	./config.status

#config.status: $(srcdir)/configure config/config.pl
#	./config.status --recheck

clean mostlyclean distclean:: test_clean
	-@$(del) $(SCRIPTS) $(MODULES) *.tmp *.bak *.pl
	-@$(deldir) bin

distclean::
	-@$(del) Makefile config.status config.cache config.log $(cfgfile)
	-@$(del) test.bat install.bat

MANIFEST:
	$(perl) make_manifest \
	  -x configure.in \
	  -x make_manifest \
	> MANIFEST

#
# Local Variables:
# mode: makefile
# End:
