/*
Copyright (C) 2016, 2017 Siep Kroonenberg

This file is part of TLaunch.

TLaunch is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

TLaunch is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with TLaunch.  If not, see <http://www.gnu.org/licenses/>.
*/

// To facilitate command-line testing of library functions,
// the functions below also have a non-GUI implementation.
// This required placing them outside tla_utils.c.

#include "tla_utils.h"

BOOL CALLBACK DlgLongMessProc(
    HWND hwnd, UINT uiMsg, WPARAM wParam, LPARAM lParam );

// info-, warn- and error messageboxes
#define INFOFLAGS MB_ICONINFORMATION | MB_TASKMODAL | MB_SETFOREGROUND
#define WARNFLAGS MB_ICONWARNING | MB_TASKMODAL | MB_SETFOREGROUND
#define DIEFLAGS MB_ICONERROR | MB_TASKMODAL | MB_SETFOREGROUND

void tlinfo( HWND hwnd, wchar_t * fmt, ... ) {
  wchar_t * buf;
  va_list ap;
  int len;
  va_start( ap, fmt );
  len = tl_vwasprintf( &buf, fmt, ap );
  va_end( ap );
  if ( len >= 0 ) {
    MessageBox( hwnd, buf, L"INFO", INFOFLAGS );
    free( buf );
  }
  // Sleep( 250 );
}

void tlwarn( HWND hwnd, wchar_t * fmt, ... ) {
  wchar_t * buf;
  va_list ap;
  int len;
  va_start( ap, fmt );
  len = tl_vwasprintf( &buf, fmt, ap );
  va_end( ap );
  if ( len >= 0 ) {
    MessageBox( hwnd, buf, L"WARNING!", WARNFLAGS );
    free( buf );
  } else {
    MessageBox( hwnd, L"Some problem", L"WARNING!", WARNFLAGS );
  }
  // Sleep( 250 );
}

void tldie( HWND hwnd, wchar_t * fmt, ... ) {
  wchar_t * buf;
  va_list ap;
  int len;
  va_start( ap, fmt );
  len = tl_vwasprintf( &buf, fmt, ap );
  va_end( ap );
  if ( len >= 0 ) {
    MessageBox( hwnd, buf, L"ERROR!", DIEFLAGS );
    free( buf );
  } else {
    MessageBox( hwnd, L"Some fatality", L"ERROR!", DIEFLAGS );
  }
  PostQuitMessage( 1 );
  // does nothing without a message loop, therefore call ExitProcess as well
  Sleep( 1000 );
  ExitProcess( 1 );
}

// too big for messagebox?
BOOL too_big( wchar_t * s ) {
  int i, l, n;
  n = 0;
  l = wcslen( s );
  if ( l > 1000 ) return 1;
  for ( i=0; i<l; i++ ) {
    if ( s[i]==L'\n' ) n++;
    if ( n > 10 ) return 1;
  }
  return 0;
}

void display_string( HWND hwnd, wchar_t * str, wchar_t * capt ) {
  INT_PTR ret;
  wchar_t * twostrings[2];
  if( str ) {
    if( !too_big( str )) {
      MessageBox( hwnd, str, capt, MB_SETFOREGROUND );
    } else {
      twostrings[0] = str;
      twostrings[1] = capt;
      ret = DialogBoxParam( NULL, MAKEINTRESOURCE( IDD_TEXT ), hwnd,
          DlgLongMessProc, (LPARAM)twostrings );
      if( !ret || ret == -1 )
          tlwarn( hwnd, L"Text display failed: %ld", GetLastError( ));
    }
  } else {
    tlwarn( hwnd, L"No output" );
  }
}

//  Dialog procedure for displaying longer texts
BOOL CALLBACK DlgLongMessProc(
    HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam ) {
  static wchar_t ** lp_wc;
  static HWND htext;

  switch(Message) {
    case WM_INITDIALOG: {

      // get the text into the text widget
      lp_wc = ( wchar_t ** )lParam;
      htext = GetDlgItem(hwnd, ID_TEXT ); // window handle for ID_TEXT
      SetWindowText( htext, lp_wc[0] );
      SetWindowText( hwnd, lp_wc[1] ); // caption
      return TRUE;
    }
    case WM_COMMAND: {
      switch(LOWORD(wParam)) {
        case ID_TEXT: {
          if( HIWORD( wParam ) == EN_SETFOCUS ) {
            SendMessage( htext, EM_SETSEL, -1, -1 ); // select none, dont move
            SendMessage( htext, WM_VSCROLL, SB_BOTTOM, 0 );
            UpdateWindow( htext );
            return TRUE; // added 20160120
          }
          return FALSE;
        } // ID_TEXT
        case IDOK:
          EndDialog(hwnd, IDOK);
          return TRUE;
        default: // other WM_COMMAND
          return FALSE;
      } // switch(LOWORD(wParam))
    } // case WM_COMMAND
    default: // other message
      return FALSE;
  } // switch(Message)
} // DlgLongMessProc
