#ifndef lint
static char sccsid[] = "@(#)auxiliary.c	3.1\t11/16/89";
#endif lint

#include <stdio.h>
#include <ctype.h>
#include "defs.h"
#include "struct.h"

extern int  exit();
extern FILE *outfp;
extern bool  C_create;		/* are we creating an output file?	*/
extern bool  C_debug;		/* are we writing debugging info?	*/
extern int   G_exitcode;	/* number of errors encountered		*/
extern char  G_Logname[];	/* name of log file, if created		*/
extern FILE *G_logfp;		/* log file pointer (for errors)	*/
extern bool  C_nowarn;		/* don't print out warnings		*/
extern char  G_progname[];	/* program name				*/
extern bool  C_quiet;		/* for quiet operation			*/

#ifdef CREOPT
extern char G_outfname[];
#endif CREOPT

char *digit = "0123456789ABCDEF";

void AbortRun();
void CopyFile();
void Fatal();
void GetBytes();
int  IsSame();
int  NoSignExtend();
int  PixRound();
void Progress();
void PutInt();
void PutOct();
int  RuleRound();
int  SignExtend();
void Warning();


/**********************************************************************/
/***************************  AbortRun  *******************************/
/**********************************************************************/
void
AbortRun(code)
int code;
{
    exit(code);
}


/*********************************************************************/
/***************************** CopyFile ******************************/
/*********************************************************************/
void
CopyFile( str )
char    *str;
{
        register FILE *spfp;
        register int t;

        if( (spfp=fopen(str,"r")) == NULL ) {
                Warning("Unable to open file %s\n", str );
                return;
                }
        Progress(" [%s", str);
        while( (t = getc(spfp)) != EOF ) {
                if (t >= '\010') EMITC(t); /* Don't transmit controls */
                }              
        (void) fclose(spfp);
        Progress("]\n");
}


/**********************************************************************/
/******************************  Fatal  *******************************/
/**********************************************************************/
/*VARARGS1*/
void
Fatal(fmt, a, b, c)	/* issue a fatal error message */
char *fmt;		/* format */
char *a, *b, *c;	/* arguments */
{
    G_exitcode += 1;

    if (G_logfp != NULL && G_logfp != stderr) {
	(void) fprintf(G_logfp, fmt, a, b, c);
	(void) fprintf(G_logfp,"\n");
    }
    (void) fprintf(stderr, fmt, a, b, c);
    (void) fprintf(stderr,"\n");
#ifdef CREOPT
    if (C_create && outfp != NULL) {
        (void) fclose(outfp);
	(void) unlink(G_outfname);
        }
#endif CREOPT
    AbortRun(G_exitcode);
}


/**********************************************************************/
/*****************************  GetBytes  *****************************/
/**********************************************************************/
void
GetBytes(fp, cp, n)	/* get n bytes from file fp */
register FILE *fp;	/* file pointer	 */
register char *cp;	/* character pointer */
register int n;		/* number of bytes  */
{
    while (n--)
	*cp++ = getc(fp);
}


/**********************************************************************/
/*******************************  IsSame  *****************************/
/**********************************************************************/
/* compare strings, ignore case */
int 
IsSame(a, b) 
char *a, *b;
{
        for( ; *a != '\0'; )
                if( tolower(*a++) != tolower(*b++) ) return( FALSE );
        return( *a == *b ? TRUE : FALSE );
}


/**********************************************************************/
/***************************  NoSignExtend  ***************************/
/**********************************************************************/
int
NoSignExtend(fp, n)	/* return n byte quantity from file fd */
register FILE *fp;	/* file pointer    */
register int n;		/* number of bytes */
{
    register int r;	/* number being constructed */

    r = 0;
    while (n--)  {
	r <<= 8;
	r |= getc(fp);
    }
    return(r);
}


/**********************************************************************/
/*****************************  PixRound  *****************************/
/**********************************************************************/
int
PixRound(r, conv)	/* return rounded number of pixels */
register int r;		/* in DVI units     */
int conv;		/* conversion factor */
{
    return((int)((r + (conv >> 1)) / conv));
}


/***********************************************************************/
/*****************************  Progress  ******************************/
/***********************************************************************/
/* all communication to the user about progress goes through here 
 * also used for Statistics information. */
/* VARARGS1 */
void
Progress(fmt, a, b, c, d, e, f)	/* issue a warning */
char *fmt;			/* format   */
char *a, *b, *c, *d, *e, *f;	/* arguments */
{
    if (G_logfp != NULL && G_logfp != stderr)
	(void) fprintf(G_logfp, fmt, a, b, c, d, e, f);
    if (C_quiet) return;
    (void) fprintf(stderr, fmt, a, b, c, d, e, f);
}


/**********************************************************************/
/*****************************  PutInt  *******************************/
/**********************************************************************/
/* output an integer followed by a space */
void
PutInt(n)
register int n;
{
    char buf[10];
    register char *b;

    if( n == 0 )
        EMITC('0'); 
    else {
        if( n < 0 ) {
            EMITC('-');
            n = -n;
            }
    
        for(b=buf;  n>0;  ) {
            *b++ = digit[n%10];
            n /= 10;
            }
    
        for( ; b>buf; )
            EMITC(*--b);
        }

    EMITC(' ');
}


/**********************************************************************/
/*****************************  PutOct  *******************************/
/**********************************************************************/
/* output a 3 digit octal number preceded by a "\" */
void
PutOct(n)
register int n;
{                  
    EMITC( '\\' ); 
    EMITC( digit[(n&0300)>>6] );
    EMITC( digit[(n&0070)>>3] ); 
    EMITC( digit[n&0007] );
}


/**********************************************************************/
/*****************************  RuleRound  ****************************/
/**********************************************************************/
int
RuleRound(r, conv)	/* return rounded number of pixels */
register int r;		/* in DVI units     */
int conv;		/* conversion factor */
{
    return((int)((r + conv - 1) / conv));
}


/**********************************************************************/
/****************************  SignExtend  ****************************/
/**********************************************************************/
int
SignExtend(fp, n)   /* return n byte quantity from file */
register FILE *fp;  /* file pointer    */
register int n;     /* number of bytes */
{
    register int r;		/* number being constructed */

    r = (unsigned) getc(fp);	/* get first (high-order) byte */
    switch (n) {
    case 1:
	r = (r < 128 ? r : 256 - r);
	break;
    case 2:
	if (r >= 128)
	    r |= (65535 << 8);
	r = (r << 8) | (unsigned) getc(fp);
	break;
    case 3:
	if (r >= 128)
	    r |= (255 << 8);
	r = (r << 8) | (unsigned) getc(fp);
	r = (r << 8) | (unsigned) getc(fp);
	break;
    case 4:
	r = (r << 8) | (unsigned) getc(fp);
	r = (r << 8) | (unsigned) getc(fp);
	r = (r << 8) | (unsigned) getc(fp);
	break;
    default:
	Fatal("internal -- SignExtend overflow\n");
    }
    return (r);
}

/**********************************************************************/
/*****************************  Warning  ******************************/
/**********************************************************************/
/*VARARGS1*/
void
Warning(fmt, a, b, c)  /* issue a warning */
char *fmt;		/* format   */
char *a, *b, *c;	/* arguments */
{
    G_exitcode += 1;
    if (G_logfp != NULL && G_logfp != stderr) {
	(void) fprintf(G_logfp, fmt, a, b, c);
	(void) fprintf(G_logfp,"\n");
    }
    if (C_nowarn) return;
    (void) fprintf(stderr, fmt, a, b, c);
    (void) fprintf(stderr,"\n");
 }
