---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, note de bas de page
---

# Comment obtenir une note de bas de page ?

La commande `\footnote` permet de générer une note de bas de page. 
Dans sa syntaxe exacte `\footnote[⟨valeur⟩]{⟨note⟩}` :
- l'argument obligatoire, `⟨note⟩`, est le texte qui est alors composé en bas de page. 
  À l'endroit où elle est positionnée, la commande place un *appel de note* ou renvoi, 
  sous forme de numéro (ou de symbole). Ce numéro est obtenu par un compteur, 
  également appelé `footnote` ;
- l'argument optionnel, `⟨valeur⟩`, permet au besoin de forcer la valeur 
  de l'appel de note.

Voici un exemple de code l'utilisant :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Voici un exemple\footnote{Cet exemple est très largement 
perfectible.} de note de bas de page\footnote[7]{Étonnant, non ?}.
\end{document}
```

La commande `\footnote` se divise en fait en deux commandes :

- la commande `\footnotemark`, qui se charge de placer le renvoi avec son numéro 
  dans le texte ;
- et la commande `\footnotetext` qui place le texte en bas de page.

Il est parfois nécessaire d'utiliser ces deux commandes à la place de `\footnote`, 
comme le montre par exemple la question 
"[](/3_composition/tableaux/notes_de_bas_de_tableau)".