---
myst:
  html_meta:
    keywords: LaTeX, généralités, bases, ConTeXt, documentation
---

# Comment débuter avec ConTeXt ?

Cette page donne des conseils pratiques pour apprendre à utiliser ConTeXt.
Pour une présentation générale du format,
consultez les références indiquées à la question 
"[](/1_generalites/glossaire/context)".


## Installation

Si vous avez déjà une TeX Live complète, ConTeXt est déjà installé
sur votre ordinateur.

Sinon, vous avez plusieurs possibilités :

* [Installer TeX Live](https://tug.org/texlive/doc/texlive-fr/texlive-fr.html) 
  avec
  [la configuration pour ConTeXt](https://tug.org/texlive/doc/texlive-fr/texlive-fr.html#x1-300003.2.2) ;
* Si vous êtes sur Linux, installer le paquet ConTeXt fourni 
  par votre gestionnaire de paquets ;
* Télécharger directement le programme 
  [sur le site de ConTeXt](https://wiki.contextgarden.net/Installation)
  et l'installer manuellement.

À la date du 19 décembre 2023, seule la dernière méthode permet d'avoir 
ConTeXt LMTX : TeX Live inclut encore la précédente version ConTeXt MkIV.
Cependant, dans un premier temps, cette question peut être laissée 
à plus tard : vous verrez à l'usage si vous avez besoin 
de fonctionnalités spécifiques à LMTX.


## Sources d'information

(guides-base)=
### Guides en français

Le manuel de base quasi-officiel pour débuter avec ConTeXt est
[Une courte (?) introduction à ConTeXt](https://raw.githubusercontent.com/contextgarden/not-so-short-introduction-to-context/main/fr2/introCTX_fra_s.pdf).
Il reste utile même pour des utilisateurs chevronnés, en particulier parce que
l'auteur a testé extensivement les effets de nombreuses commandes.
Il s'agit d'une traduction en français d'un original
[en espagnol](https://raw.githubusercontent.com/contextgarden/not-so-short-introduction-to-context/main/es/introCTX_esp_s.pdf).
À la date du 19 décembre 2023, cette traduction est à jour.

Une autre ressource excellente, agréable à lire et parfois complémentaire 
du précédent, est 
[Les fiches à Bébert](http://www.lesfichesabebert.fr/TeX/context/context-intro.html),
de Bertrand Masson.


(manuels)=
### Les manuels officiels

Le site de ConTeXt fournit 
[de nombreux manuels officiels](https://wiki.contextgarden.net/Documentation)
sur des sujets divers. Attention cependant, ils sont généralement
trop détaillés pour être utilisés en première approche
et peuvent parfois être datés.
Ils constituent cependant une mine de renseignements
quand vous vous posez des questions avancées
auxquelles les ressources précédentes ne permettent pas de répondre
et documentent certains aspects de bas niveau de ConTeXt et de LuaTeX.


(wiki)=
### Le wiki

Le [wiki de ConTeXt](https://wiki.contextgarden.net/Main_Page)
va rapidement être votre principale source de renseignements, notamment 
parce que c'est là que sont documentées toutes les commandes 
avec leurs options. Pour accéder aux informations sur une commande,
vous pouvez utiliser la barre de recherche ou écrire directement l'URL
sous la forme `https://wiki.contextgarden.net/Command/⟨nom de la commande⟩`
(par exemple <https://wiki.contextgarden.net/Command/blank>).

Le wiki contient également des pages générales sur certains sujets :
voir notamment la liste des pages 
dans la [catégorie _Basics_](https://wiki.contextgarden.net/Category:Basics).


(liste-mail)=
### La liste de discussions

Souvent, les questions que vous vous posées ont été soulevées par d'autres sur
[la liste mail](https://www.mail-archive.com/search?l=ntg-context%40ntg.nl&q=context&a=1) :
il vaut toujours la peine de faire une recherche dans les archives,
on y trouve des explications ou des astuces données par les développeurs.
C'est également sur cette liste que vous pouvez signaler d'éventuels bugs.
Avant d'envoyez un message, lisez 
les [instructions sur le wiki](https://wiki.contextgarden.net/Mailing_Lists).


## Trouver comment faire certaines choses avec ConTeXt

Pour trouver les commandes appropriées à votre besoin, commencez par formuler
votre besoin en termes typographiques plutôt qu'en termes d'application 
ou d'usage. Dans certains cas, il existe une page sur le wiki, voire un module
pour votre domaine d'application (par exemple
pour [rédiger une lettre](https://wiki.contextgarden.net/Letter)).
Cependant, en général, vous devrez vous-même concevoir votre mise en page :
ainsi, plutôt que de chercher directement comment faire une fiche d'exercices,
interrogez-vous sur les composants qui font une fiche d'exercices :
des notes en marge dans lesquelles vous affichez le barême, un espace blanc 
après chaque question configurable en fonction de la réponse attendue, etc.
ConTeXt fournit rarement des solutions prêtes à l'emploi, mais il vous offre
les éléments à partir desquels vous pourrez créer vos modèles.
    
Une fois que vous avez déterminé le composant typographique 
dont vous avez besoin, vérifiez que l'information ne se trouve pas 
dans les [guides de base](#guides-base), sur une page dédiée 
sur le [wiki](#wiki), ou, en troisième lieu, 
sur la [liste de discussion](#liste-mail). Vous gagnerez parfois un temps 
non négligeable.

En deuxième ressort, en cherchant sur le wiki, vous trouverez probablement
des pages dédiées à des commandes qui semblent correspondre à votre besoin.
Certaines commandes sont très bien documentées ; pour d'autres, vous aurez
simplement la liste des options générée automatiquement à partir 
du code source. Dans ce cas, pour déterminer quelle option fait quoi :

* Créez un fichier test minimal que vous pourrez compiler rapidement
  et faites des essais en utilisant les différentes options ;
* Parfois, quand il s'agit d'un `setup⟨quelque chose⟩`,
  il peut être utile de chercher la configuration par défaut
  de la commande dans le code source grâce au lien indiqué en bas de la page
  (par exemple [pour `\setuphead`](https://source.contextgarden.net/strc-sec.mkiv#l353)).
  Pour lire cette configuration, il faut ignorer les `\c!` et les `\!v`.
  Comparer la configuration par défaut avec le rendu que vous observez
  vous permettra, dans certains cas, de deviner ce que font des options
  au nom obscur.
* Quand vous avez trouvé, faites-vous une petite note pour retrouver 
  l'information la prochaine fois ! C'est d'autant plus utile 
  que certaines options reviennent d'une commande à l'autre 
  avec des significations semblables (p. ex. `stopper`, `after`, `before`, 
  `distance`, `inedge`,…).

Si vous ne trouvez pas, faites appel à un ami. Si vous n'avez pas d'ami 
sous la main qui utilise ConTeXt ou s'il ne trouve pas non plus,
vous pouvez [écrire à la liste de diffusion](#liste-mail)
après avoir lu les 
[instructions sur le wiki](https://wiki.contextgarden.net/Mailing_Lists).
Si vous pensez avoir trouvé un bug, vérifiez 
[ici](https://tracker.luatex.org/my_view_page.php)
s'il n'a pas déjà été traité, ou du moins signalé.


## Écrire vos propres commandes

ConTeXt n'offre pas les mêmes abstractions que LaTeX (telles que 
`\newcommand`, `\NewDocumentCommand` ou les diverses extensions 
de programmation) pour écrire vos propres commandes.
[Une page du ConTeXtgarden](https://wiki.contextgarden.net/Inside_ConTeXt)
fournit la liste des pages du wiki qui concernent la programmation avec ConTeXt.
Il est utile d'apprendre les bases de la programmation en TeX décrites 
à la question "[](/2_programmation/macros/que_sont_les_macros)".