{$N-,V-,W-,G+}

Unit wbibdlg;

Interface

uses
  WinDos, Wobjects, WinTypes, WinProcs, strings, win31,
  wbibdisp, wbibgui, wbibslct, rc_strng, rc_id, streams,
  bibvars, bibstrm, bibstrg, bibfile, bibutil, bibtext, bibsrtpt, lfnunit, wc_help,
  bibtmplt, wbibabv1, wbibabv2, wbibtbar, wbibinit, bibcache, wbibole, wbibbmp;


type
  PFieldsDlg = ^TFieldsDlg;
  TFieldsDlg = object(TBasicDialog)
    OldInd: integer;
    constructor init(AParent: PWindowsObject);
    procedure   SetupWindow; virtual;
    procedure   BibEnterIdle(var Msg: TMessage); virtual wm_First+bib_EnterIdle;
    procedure   GetCBox(id: integer; var on: boolean);
    procedure   PutCBox(id: integer; on: boolean);
    procedure   FieldsLBox(var Msg: TMessage); virtual id_first+dl_FieldsLBox;
    procedure   ClearBtn(var Msg: TMessage);   virtual id_first+dl_FieldsClear;
    procedure   UpBtn(var Msg: TMessage);      virtual id_first+dl_FieldsUp;
    procedure   DownBtn(var Msg: TMessage);    virtual id_first+dl_FieldsDown;
    procedure   DeleteBtn(var Msg: TMessage);  virtual id_first+dl_FieldsDelete;
    procedure   Add(ind: integer);
    procedure   InsertBtn(var Msg: TMessage);  virtual id_first+dl_FieldsInsert;
    procedure   AppendBtn(var Msg: TMessage);  virtual id_first+dl_FieldsAppend;
    procedure   wmDestroy(var Msg: TMessage);  virtual wm_first+wm_Destroy;
    procedure   ok(var Msg: TMessage); virtual id_first+id_ok;
  end;

  PGUIOptDlg = ^TGUIOptDlg;
  TGUIOptDlg = object(TBasicDialog)
    IniAbbrevs: TAbbrevList;
    IniAbbrevsChanged: boolean;
    Btns: ToolBtnArr;
    LargeBtns: integer;
    constructor init(AParent: PWindowsObject);
    procedure   SetupWindow; virtual;
    procedure   ExpAbbrevCBox(var Msg: TMessage); virtual id_first+dl_GUIExpandIniAbbrev;
    procedure   EdAbbrevsBtn(var Msg: TMessage);  virtual id_first+dl_GUIEditIniAbbrev;
    procedure   ToolbarConf(var Msg: TMessage);   virtual id_first+dl_GUITbarConf;
    procedure   ok(var Msg: TMessage);            virtual id_first+id_ok;
    destructor  done; virtual;
  end;

  TExportRec = record
    ExpFrom,ExpTo,InsertNum: longint;
    ExpNum,ExpTagged,ExpAll,ExpOrder,ExpCurrent: boolean;
    AtEnd,AtFirst,AtNum,AtBefore: boolean;
    ExportToClipboard: boolean;
  end;
  PExportRec = ^TExportRec;

  PExportDlg = ^TExportDlg;
  TExportDlg = object(TBasicDialog)
    Entry: EntryRecPtr;
    IORec: PExportRec;
    EBox1,EBox2,EBox3: PEditNoCR;
    constructor init(Aparent: PWindowsObject; AEntry: EntryRecPtr;
                     AIORec: PExportRec);
    procedure   SetupWindow; virtual;
    procedure   Update;
    procedure   HandleClipCBox(var Msg: TMessage);virtual id_first+dl_ExportClip;
    procedure   HandleFileCBox(var Msg: TMessage);virtual id_first+dl_ExportToFile;
    procedure   ExportFErase(var Msg: TMessage);  virtual id_first+dl_ExportFClear;
    procedure   ExportFBrowse(var Msg: TMessage); virtual id_first+dl_ExportFBrowse;
    procedure   LabelsOnly(var Msg: TMessage);    virtual id_first+dl_ExportLabels;
    procedure   ExportFields(var Msg: TMessage);  virtual id_first+dl_ExportFields;
    procedure   ExportFileFormat(var Msg: TMessage); virtual id_first+dl_ExportFileFormat;
    procedure   ExportEntNum(var Msg: TMessage);  virtual id_first+dl_ExportEntNum;
    procedure   ExportAllEnt(var Msg: TMessage);  virtual id_first+dl_ExportAllEnt;
    procedure   ExportTagged(var Msg: TMessage);  virtual id_first+dl_ExportTagged;
    procedure   ExportOrder(var Msg: TMessage);   virtual id_first+dl_ExportOrder;
    procedure   ok(var Msg: TMessage); virtual id_first+id_ok;
  end;

  PImportDlg = ^TImportDlg;
  TImportDlg = object(TBasicDialog)
    ImpFile: PString;
    FileIsSorted: boolean;
    constructor init(AParent: PWindowsObject; AImpFile: PString);
    procedure   SetupWindow; virtual;
    procedure   HandleClipCBox(var Msg: TMessage);
                                              virtual id_first+dl_ImportClipboard;
    procedure   HandleFileCBox(var Msg: TMessage);
                                              virtual id_first+dl_ImportFromFile;
    procedure   BibEnterIdle(var Msg: TMessage);
                                              virtual wm_first+bib_EnterIdle;
    procedure   BrowseBtn(var Msg: TMessage); virtual id_first+dl_ImportBrowse;
    procedure   FormatCBox(var Msg: TMessage);virtual id_first+dl_ImportFormat;
    function    CanClose: boolean;            virtual;
    procedure   ok(var Msg: TMessage);        virtual id_first+id_ok;
  end;

  PHyperOptionsDlg = ^THyperOptionsDlg;
  THyperOptionsDlg = object(TBasicDialog)
    TypesArr: HyperTypesArrType;
    NTypes,OrigWWWBrowser: integer;
    constructor init(AParent: PWindowsObject);
    procedure   SetupWindow; virtual;
    procedure   DispFont(var Msg: TMessage);  virtual id_first+dl_HyperFontDisp;
    procedure   PrintFont(var Msg: TMessage); virtual id_first+dl_HyperFontPrint;
    procedure   NewBtn(var Msg: TMessage);    virtual id_first+dl_HyperNew;
    procedure   ModifyBtn(var Msg: TMessage); virtual id_first+dl_HyperModify;
    procedure   DelBtn(var Msg: TMessage);    virtual id_first+dl_HyperDelete;
    procedure   HandleLBox(var Msg: TMessage);virtual id_first+dl_HyperLBox;
    procedure   ok(var Msg: TMessage);        virtual id_first+id_ok;
    destructor  Done; virtual;
  end;

  PObjectImageOptions = ^TObjectImageOptions;
  TObjectImageOptions = object(TBasicDialog)
    constructor init(AParent: PWindowsObject);
    procedure   SetupWindow; virtual;
    procedure   ok(var Msg: TMessage); virtual id_first+id_ok;
  end;

procedure About;
function  Preferences: boolean;
function  FileFormatOptions: boolean;


Implementation

{ TFieldsDlg methods }

type
  PFieldObj = ^TFieldObj;
  TFieldObj = object(TObject)
    Name,Alt: PChar;
    Params: FieldParamsRec;
    constructor init(var AName: string; AParams: FieldParamsRec);
    destructor  done; virtual;
  end;

constructor TFieldObj.init(var AName: string; AParams: FieldParamsRec);
var
  F: PChar;
begin
  TObject.init;
  GetMem(F,256);
  StrPCopy(F,AName); Name:=StrNew(F);
  Params:=AParams;
  Alt:=Nil;
  with Params do
  begin
    if AltName<>Nil then 
    begin
      StrPCopy(F,AltName^); Alt:=StrNew(F);
    end;
    AltName:=Nil;
  end;
  FreeMem(F,256);
end;              { TFieldObj.init }

destructor TFieldObj.Done;
begin
  if Alt<>Nil then StrDispose(Alt);
  StrDispose(Name);
  TObject.Done;
end;

constructor TFieldsDlg.init(AParent: PWindowsObject);
begin
  TBasicDialog.init(AParent,PChar(rc_FieldsDlg));
  OldInd:=-1;
  HelpContext:=hc_FieldProperties;
end;

procedure TFieldsDlg.BibEnterIdle(var Msg: TMessage);
var
  Ind,Num,txt: integer;
  F: array[0..3] of char;
begin
  Ind:=SendDlgItemMsg(dl_FieldsLBox,lb_GetCurSel,0,0);
  Num:=SendDlgItemMsg(dl_FieldsLBox,lb_GetCount,0,0);
  txt:=GetDlgItemText(HWindow,dl_FieldsName,F,2);
  EnableWindow(GetItemHandle(dl_FieldsUp),(Ind>IniFieldLast) and (Num>1));
  EnableWindow(GetItemHandle(dl_FieldsDown),(Ind>=IniFieldLast) and (Num>1) and (Ind<Num-1));
  EnableWindow(GetItemHandle(dl_FieldsAppend),(
      txt>0) and (Ind>=IniFieldLast-1) and (Num>0) and (Num<MaxField));
  EnableWindow(GetItemHandle(dl_FieldsInsert),
      (txt>0) and (Ind>=IniFieldLast) and (Num<MaxField));
  EnableWindow(GetItemHandle(dl_FieldsDelete),
      (Ind<>lb_Err) and (Ind>=IniFieldLast) and (Num>0));
  EnableWindow(GetItemHandle(id_ok),Num>0);
end;                { TFieldsDlg.BibEnterIdle }

procedure TFieldsDlg.SetupWindow;
var
  i,ind: integer;
  F: array[0..255] of char;
  Msg: TMessage;
begin
  TBasicDialog.SetupWindow;
  for i:=1 to OrigFieldLast do
  begin
    StrPCopy(F,TypeField^[i]);
    ind:=SendDlgItemMsg(dl_FieldsLBox,lb_AddString,0,Longint(@F));
    SendDlgItemMsg(dl_FieldsLBox,lb_SetItemData,Ind,longint(
      New(PFieldObj,init(TypeField^[i],FieldParams^[i]))));
  end;
  SendDlgItemMsg(dl_FieldsLBox,lb_SetCurSel,0,0);
  Msg.lParamHi:=lbn_SelChange; FieldsLBox(Msg);
end;             { TFieldsDlg.SetupWindow }

procedure TFieldsDlg.PutCBox(id: integer; on: boolean);
begin
  if On then CheckDlgButton(HWindow,id,bf_Checked)
  else CheckDlgButton(HWindow,id,bf_UnChecked);
end;

procedure TFieldsDlg.GetCBox(id: integer; var on: boolean);
begin
  on:=IsDlgButtonChecked(HWindow,id)=bf_Checked;
end;

procedure TFieldsDlg.FieldsLBox(var Msg: TMessage);
var
  i,Ind: integer;
  P: PFieldObj;
  F: Pchar;

begin
  if Msg.lParamHi=lbn_SelChange then
  begin
    GetMem(F,256);
    if (OldInd>=0) and (GetDlgItemText(HWindow,dl_FieldsName,F,255)>0) then
    begin
      P:=PFieldObj(SendDlgItemMsg(dl_FieldsLBox,lb_GetItemData,OldInd,0));
      i:=SendDlgItemMsg(dl_FieldsLBox,lb_FindStringExact,word(-1),longint(F));
      if (i<>lb_Err) and (i<>OldInd) then
        ErrorMessageRC(Str_DupFieldName,StrPas(F))
      else with P^ do
      begin
        with Params do
        begin
          GetCBox(dl_FieldsAuth,Authorlike); GetCBox(dl_FieldsCap,Capitalize);
          GetCBox(dl_FieldsNumeric,Numeric); GetCBox(dl_FieldsCase,ProtectCase);
          GetCBox(dl_FieldsProtCap,ProtectCap);
        end;
        if (OldInd>=IniFieldLast) and (Name<>Nil) and (StrIComp(Name,F)<>0) then
        begin
          StrDispose(Name); Name:=StrNew(F);
          SendDlgItemMsg(dl_FieldsLBox,lb_DeleteString,OldInd,0);
          SendDlgItemMsg(dl_FieldsLbox,lb_InsertString,OldInd,Longint(F));
          SendDlgItemMsg(dl_FieldsLBox,lb_SetItemData,OldInd,Longint(P));
        end;
        if Alt<>Nil then StrDispose(Alt); Alt:=Nil;
        if GetDlgItemText(HWindow,dl_FieldsAlt,F,255)>0 then Alt:=StrNew(F);
      end;
    end;
    FreeMem(F,256);
    Ind:=SendDlgItemMsg(dl_FieldsLBox,lb_GetCurSel,0,0);
    if Ind<>lb_Err then
    begin
      P:=PFieldObj(SendDlgItemMsg(dl_FieldsLBox,lb_GetItemData,Ind,0));
      with P^ do
      begin
        SetDlgItemText(HWindow,dl_FieldsName,Name);
        SetDlgItemText(HWindow,dl_FieldsAlt,Alt);
        with Params do
        begin
          PutCBox(dl_FieldsAuth,Authorlike); PutCBox(dl_FieldsCap,Capitalize);
          PutCBox(dl_FieldsNumeric,Numeric); PutCBox(dl_FieldsCase,ProtectCase);
          PutCBox(dl_FieldsProtCap,ProtectCap);
        end;
      end;
    end;
    OldInd:=Ind;
  end;
end;                       { TFieldsDlg.FieldsLBox }

procedure TFieldsDlg.ClearBtn(var Msg: TMessage);
var
  ch: char;
begin
  ch:=#0;
  SetDlgItemText(HWindow,dl_FieldsName,@ch);
  SetDlgItemText(HWindow,dl_FieldsAlt,@ch);
  CheckDlgButton(HWindow,dl_FieldsAuth,bf_Unchecked);
  CheckDlgButton(HWindow,dl_FieldsCap,bf_Unchecked);
  CheckDlgButton(HWindow,dl_FieldsNumeric,bf_Unchecked);
  CheckDlgButton(HWindow,dl_FieldsCase,bf_Unchecked);
  CheckDlgButton(HWindow,dl_FieldsProtCap,bf_Unchecked);
end;                      { TFieldsDlg.ClearBtn }

procedure TFieldsDlg.UpBtn(var Msg: TMessage);
var
  P: PFieldObj;
  Ind: integer;
begin
  Ind:=SendDlgItemMsg(dl_FieldsLBox,lb_GetCurSel,0,0);
  if (Ind=lb_Err) or (Ind<IniFieldLast) then Exit;
  P:=PFieldObj(SendDlgItemMsg(dl_FieldsLBox,lb_GetItemData,Ind,0));
  SendDlgItemMsg(dl_FieldsLBox,lb_DeleteString,Ind,0);
  dec(Ind);
  SendDlgItemMsg(dl_FieldsLBox,lb_InsertString,Ind,Longint(P^.Name));
  SendDlgItemMsg(dl_FieldsLBox,lb_SetItemData,Ind,Longint(P));
  SendDlgItemMsg(dl_FieldsLBox,lb_SetCurSel,Ind,0);
  OldInd:=Ind;
end;         { TFieldsDlg.UpBtn }

procedure TFieldsDlg.DownBtn(var Msg: TMessage);
var
  P: PFieldObj;
  Ind: integer;
begin
  Ind:=SendDlgItemMsg(dl_FieldsLBox,lb_GetCurSel,0,0);
  if (Ind=lb_Err) or (Ind<IniFieldLast) or
     (Ind=SendDlgItemMsg(dl_FieldsLBox,lb_GetCount,0,0)) then Exit;
  P:=PFieldObj(SendDlgItemMsg(dl_FieldsLBox,lb_GetItemData,Ind,0));
  SendDlgItemMsg(dl_FieldsLBox,lb_DeleteString,Ind,0);
  inc(Ind);
  SendDlgItemMsg(dl_FieldsLBox,lb_InsertString,Ind,Longint(P^.Name));
  SendDlgItemMsg(dl_FieldsLBox,lb_SetItemData,Ind,Longint(P));
  SendDlgItemMsg(dl_FieldsLBox,lb_SetCurSel,Ind,0);
  OldInd:=Ind;
end;         { TFieldsDlg.DownBtn }

procedure TFieldsDlg.DeleteBtn(var Msg: TMessage);
var
  P: PFieldObj;
  Ind: integer;
begin
  Ind:=SendDlgItemMsg(dl_FieldsLBox,lb_GetCurSel,0,0);
  if (Ind=lb_Err) or (Ind<IniFieldLast) then Exit;
  P:=PFieldObj(SendDlgItemMsg(dl_FieldsLBox,lb_GetItemData,Ind,0));
  SendDlgItemMsg(dl_FieldsLBox,lb_DeleteString,Ind,0);
  Dispose(P,Done);
  if Ind=0 then
  begin
    ClearBtn(Msg); OldInd:=-1;
  end else
  begin
    if Ind>=SendDlgItemMsg(dl_FieldsLBox,lb_GetCount,0,0) then dec(Ind);
    SendDlgItemMsg(dl_FieldsLBox,lb_SetCurSel,Ind,0);
    OldInd:=-1; Msg.lParamHi:=lbn_SelChange;
    FieldsLBox(Msg);
  end;
end;                  { TFieldsDlg.DeleteBtn }

procedure TFieldsDlg.Add(Ind: integer);
var
  F: array[0..255] of char;
  tmp: PString;
  P: PFieldObj;
  Params: FieldParamsRec;
  Msg: TMessage;
begin
  if Ind<IniFieldLast then Exit;
  if SendDlgItemMsg(dl_FieldsLBox,lb_GetCount,0,0)>=MaxField then Exit;
  if GetDlgItemText(HWindow,dl_FieldsName,F,255)=0 then Exit;
  StrLower(F);
  tmp:=NewStr(StrPas(F));
  SendDlgItemMsg(dl_FieldsLBox,lb_InsertString,Ind,Longint(@F));
  with Params do
  begin
    AltName:=Nil;
    if GetDlgItemText(HWindow,dl_FieldsAlt,F,255)>0 then AltName:=NewStr(StrPas(F));
    GetCBox(dl_FieldsAuth,Authorlike); GetCBox(dl_FieldsCap,Capitalize);
    GetCBox(dl_FieldsNumeric,Numeric); GetCBox(dl_FieldsCase,ProtectCase);
    GetCBox(dl_FieldsProtCap,ProtectCap);
  end;
  SendDlgItemMsg(dl_FieldsLBox,lb_SetItemData,Ind,longint(
       New(PFieldObj,init(tmp^,Params))));
  if Params.AltName<>Nil then DisposeStr(Params.AltName);
  DisposeStr(tmp);
  SendDlgItemMsg(dl_FieldsLBox,lb_SetCurSel,Ind,0);
  OldInd:=-1; Msg.lParamHi:=lbn_SelChange; FieldsLBox(Msg);
end;                 { TFieldsDlg.Add }

procedure TFieldsDlg.InsertBtn(var Msg: TMessage);
var
  Ind: integer;
begin
  Ind:=SendDlgItemMsg(dl_FieldsLBox,lb_GetCurSel,0,0);
  if Ind=lb_Err then Add(0) else Add(Ind);
end;

procedure TFieldsDlg.AppendBtn(var Msg: TMessage);
var
  Ind: integer;
begin
  Ind:=SendDlgItemMsg(dl_FieldsLBox,lb_GetCurSel,0,0);
  if Ind=lb_Err then Add(0) else Add(Ind+1);
end;

procedure TFieldsDlg.wmDestroy(var Msg: TMessage);
var
  i: integer;
begin
  for i:=0 to SendDlgItemMsg(dl_FieldsLBox,lb_GetCount,0,0)-1 do
    Dispose(PFieldObj(SendDlgItemMsg(dl_FieldsLBox,lb_GetItemData,i,0)),Done);
  TBasicDialog.wmDestroy(Msg);
end;

procedure TFieldsDlg.ok(var Msg: TMessage);
var
  num,Ind,i: integer;
  P: PFieldObj;
  F: array[0..255] of char;
begin
  num:=SendDlgItemMsg(dl_FieldsLBox,lb_GetCount,0,0);
  if Num<=0 then Exit;
  Msg.lParamHi:=lbn_SelChange; FieldsLBox(Msg);
  for i:=1 to MaxField do
  begin
    if i>IniFieldLast then TypeField^[i]:='';
    with FieldParams^[i] do
    begin
      if AltName<>Nil then DisposeStr(AltName); AltName:=Nil;
      Capitalize:=false; Numeric:=false; Authorlike:=false;
      ProtectCase:=false; ProtectCap:=false;
    end;
  end;
  for i:=1 to Num do
  begin
    P:=PFieldObj(SendDlgItemMsg(dl_FieldsLBox,lb_GetItemData,i-1,0));
    with P^ do
    begin
      if i>IniFieldLast then
      begin
        DumpFields[i]:=DumpUndecFields;
        if StrLen(Name)>ListArrRecLen then
        begin
          Name[ListArrRecLen]:=#0;
          TypeField^[i]:=StrPas(Name);
          Name[ListArrRecLen]:=#1;
        end else TypeField^[i]:=StrPas(Name);
      end;
      FieldParams^[i]:=Params;
      if Alt<>Nil then FieldParams^[i].AltName:=NewStr(StrPas(Alt));
    end;
  end;

  OrigFieldLast:=Num; DefFieldLast:=Num; FieldLast:=Num;
  OptionsModified.Fields:=true;
  EndDlg(id_ok);
end;               { TFieldsDlg.ok }

type

  PPreferencesDlg = ^TPreferencesDlg;
  TPreferencesDlg = object(TBasicDialog)
    LabelTempEBox: PEditTemplate;
    constructor init(AParent: PWindowsObject);
    procedure   SetupWindow; virtual;
    procedure   Allow;
    procedure   AutoLabelEnable(var Msg: TMessage);
                                virtual id_first+dl_PrefsAutoLabels;
    procedure   UsePreambleCBox(var Msg: TMessage);
                                virtual id_first+dl_PrefsUsePreamble;
    procedure   UseIndexCBox(var Msg: TMessage);
                                virtual id_first+dl_PrefsUseIndex;
    procedure   ok(var Msg: TMessage); virtual id_first+id_ok;
  end;

  PFileFormatDlg = ^TFileFormatDlg;
  TFileFormatDlg = object(TBasicDialog)
    BibTeXWid,TibWid,ReferWid: PEditNoCr;
    TibLFields,ReferLFields: PEditNoCr;
    constructor init(AParent: PWindowsObject);
    procedure   SetupWindow; virtual;
    procedure   ok(var Msg: TMessage); virtual id_first+id_ok;
  end;

  PAboutDlg = ^TAboutDlg;
  TAboutDlg = object(TBasicDialog)
    constructor init(AParent: PWindowsObject);
    procedure   SetupWindow; virtual;
  end;

{ TGUIOptDlg methods }

constructor TGUIOptDlg.init(AParent: PWindowsObject);
begin
  TBasicDialog.Init(AParent,PChar(rc_GUIOptDlg));
  HelpContext:=hc_GUIOptions;
  IniAbbrevs.init(50,50,false,false);
  LoadIniAbbrevs(IniAbbrevs);
  IniAbbrevsChanged:=false;
  Move(ToolBtns,Btns,sizeof(Btns));
  LargeBtns:=LargeTBarBtns;
end;

procedure TGUIOptDlg.SetupWindow;
var
  F: array[0..255] of char;
  btmp: boolean;
  i: integer;
  Msg: TMessage;

procedure SetCopyMode(var R: ENameClickRec; C1,C2,C3,C4: integer);
begin
  with R do
  case action of
    ENameClick_Copy:   CheckDlgButton(HWindow,C1,bf_Checked);
    ENameClick_CopyEx: CheckDlgButton(HWindow,C2,bf_Checked);
    ENameClick_String:
      begin
        CheckDlgButton(HWindow,C3,bf_Checked);
        if S<>Nil then
        begin
          StrPCopy(F,S^); SetDlgItemText(HWindow,C4,F);
        end;
      end;
  end;
end;
 
begin
  TBasicDialog.SetupWindow;
  if UseToolbar       then CheckDlgButton(HWindow,dl_GUIToolbar,bf_Checked);
  if UseCoffeeCup     then CheckDlgButton(HWindow,dl_GUICoffee, bf_Checked);
  if UseCtl3d         then CheckDlgButton(HWindow,dl_GUI3d,     bf_Checked);
  if StripExtraBraces then CheckDlgButton(HWindow,dl_GUIStripBraces,    bf_Checked);
  if ExpandStrings    then CheckDlgButton(HWindow,dl_GUIExpandStrings,  bf_Checked);
  if ExpandIniAbbrevs then CheckDlgButton(HWindow,dl_GUIExpandIniAbbrev,bf_Checked)
  else EnableWindow(GetItemHandle(dl_GUIEditIniAbbrev),false);

  SetCopyMode(NameClickShift,    dl_GUIShiftCopy,dl_GUIShiftExt,
                                         dl_GUIShiftString,dl_GUIShiftEBox);
  SetCopyMode(NameClickCtrl,     dl_GUICtrlCopy, dl_GUICtrlExt,
                                         dl_GUICtrlString, dl_GUICtrlEBox);
  SetCopyMode(NameClickCtrlShift,dl_GUISCtrlCopy,dl_GUISCtrlExt,
                                         dl_GUISctrlString,dl_GUISCtrlEBox);
  if NameClickMenuString<>Nil then
  begin
    StrPCopy(F,NameClickMenuString^);
    SetDlgItemText(HWindow,dl_GUIMenuEBox,F);
  end;
  if (BibTeXHelpMode=0) then
    CheckDlgButton(HWindow,dl_GUIBibTeXOff,bf_Checked)
  else
  begin
    CheckDlgButton(HWindow,dl_GUIBibTeXOn,bf_Checked);
    if (BibTeXHelpMode=2) and (BibTeXHelpFile<>Nil) then
      SetDlgItemText(HWindow,dl_GUIBibTeXEBox,BibTeXHelpFile);
  end;

  Btmp:=false;
  for i:=1 to TBar_LastBtn do if ToolBtns[i].Order<>0 then Btmp:=true;
  EnableWindow(GetItemHandle(dl_GUIToolbar),Btmp);

  StrPCopy(F,num2str(WinYieldStep));
  SetDlgItemText(HWindow,dl_GUITasking,F);

  InitPos;
end;                        { TGUIOptDlg.SetupWindow }

procedure TGUIOptDlg.ExpAbbrevCBox(var Msg: TMessage);
begin
  if IsDlgButtonChecked(HWindow,dl_GUIExpandIniAbbrev)=bf_Checked then
    EnableWindow(GetItemHandle(dl_GUIEditIniAbbrev),true)
  else EnableWindow(GetItemHandle(dl_GUIEditIniAbbrev),false);
  DefWndProc(Msg);
end;

procedure TGUIOptDlg.EdAbbrevsBtn(var Msg: TMessage);
begin
  if Application^.ExecDialog(New(PEdIniAbbrevsDlg,init(@Self,@IniAbbrevs)))=id_ok then
  begin
    IniAbbrevsChanged:=true;
  end;
end;

procedure TGUIOptDlg.ToolbarConf(var Msg: TMessage);
begin
  Application^.ExecDialog(New(PToolbarConfDlg,init(@Self,@Btns,@LargeBtns)));
end;

procedure TGUIOptDlg.ok(var Msg: TMessage);
var
  F: array[0..255] of char;
  tmp,D,N,E: Pstring;
  i,j: integer;
  Buf,BufRoot: PChar;
  SLen: word;

procedure SetCopyMode(var R: ENameClickRec; C1,C2,C3: integer);
begin
  with R do
  begin
    if S<>Nil then DisposeStr(S); S:=Nil;
    if       IsDlgButtonChecked(HWindow,c1)=bf_Checked then
      action:=ENameClick_Copy
    else if  IsDlgButtonChecked(HWindow,c2)=bf_Checked then
      action:=ENameClick_CopyEx
    else begin
      StrPCopy(F,''); GetDlgItemText(HWindow,c3,F,255);
      if StrLen(F)=0 then
        action:=ENameClick_Copy
      else begin
        S:=NewStr(StrPas(F)); action:=ENameClick_String;
      end;
    end;
  end;
end;

begin
  if not CanClose then Exit;
  AllocStrings(true,@tmp,@D,@N,@E);
  UseToolbar:=IsDlgButtonChecked(HWindow,dl_GUIToolbar)=bf_Checked;
  UseCoffeeCup:=IsDlgButtonChecked(HWindow,dl_GUICoffee)=bf_Checked;
  UseCtl3d:=IsDlgButtonChecked(HWindow,dl_GUI3d)=bf_Checked;
  StripExtraBraces:=IsDlgButtonChecked(HWindow,dl_GUIStripBraces)=bf_Checked;
  ExpandStrings:=IsDlgButtonChecked(HWindow,dl_GUIExpandStrings)=bf_Checked;
  ExpandIniAbbrevs:=IsDlgButtonChecked(HWindow,dl_GUIExpandIniAbbrev)=bf_Checked;

  GetDlgItemText(HWindow,dl_GUITasking,F,6);
  if IsOff(StrPas(F)) then WinYieldStep:=0
  else if IsOn(StrPas(F)) then WinYieldStep:=1
  else begin
    Val(StrPas(F),i,j);
    if (j=0) then WinYieldStep:=i;
    if WinYieldStep<0 then WinYieldStep:=0;
  end;
  WinYieldCounter:=0;

  SetCopyMode(NameClickShift,    dl_GUIShiftCopy,dl_GUIShiftExt,dl_GUIShiftEBox);
  SetCopyMode(NameClickCtrl,     dl_GUICtrlCopy, dl_GUICtrlExt, dl_GUICtrlEBox);
  SetCopyMode(NameClickCtrlShift,dl_GUISCtrlCopy,dl_GUISCtrlExt,dl_GUISCtrlEBox);
  DisposeStr(NameClickMenuString); NameClickMenuString:=Nil;
  StrPCopy(F,''); GetDlgItemText(Hwindow,dl_GUIMenuEBox,F,255);
  if StrLen(F)>0 then NameClickMenuString:=NewStr(StrPas(F));

  StrDispose(BibTeXHelpFile); BibTeXHelpFile:=Nil;
  if IsDlgButtonChecked(HWindow,dl_GUIBibTeXOff)=bf_Checked then
    BibTeXHelpMode:=0
  else begin
    StrPCopy(F,'');
    GetDlgItemText(HWindow,dl_GUIBibTeXEBox,F,255);
    if StrLen(F)=0 then
    begin
      tmp^:=ProgramDir^+BibTeXHelpName+'.HLP'; BibTeXHelpMode:=1;
    end else
    begin
      LFNFSplit(LFNFExpand(StrPas(F)),D,N,E);
      if D^='' then D^:=ProgramDir^;
      if E^='' then E^:='.HLP';
      tmp^:=D^+N^+E^;
      BibTeXHelpMode:=2;
    end;
    if (tmp^<>'') and LFNFileExist(tmp^) then
    begin
      StrPCopy(F,tmp^);
      BibTeXHelpFile:=StrNew(F);
    end else BibTeXHelpMode:=0;
  end;
  if IniAbbrevsChanged then
  begin
    GetMem(Buf,BufSize); BufRoot:=Buf;
    i:=GetPrivateProfileString(AbbrevSec,Nil,'',Buf,BufSize,IniFile);
    SLen:=StrLen(Buf);
    if i>=3 then
    begin
      while SLen>0 do
      begin
        WritePrivateProfileString(AbbrevSec,Buf,Nil,IniFile);
        Buf:=Buf+Slen+1;
        SLen:=StrLen(Buf);
      end;
    end;
    FreeMem(BufRoot,BufSize);
    for i:=0 to IniAbbrevs.Count-1 do
    with POneStringObj(IniAbbrevs.at(i))^ do
    begin
      StrPCopy(F,SName^);
      WritePrivateProfileString(AbbrevSec,F,SValue,IniFile);
    end;
  end;

  for i:=1 to TBar_LastBtn do ToolBtns[i].Order:=Btns[i].Order;
  LargeTBarBtns:=LargeBtns;

  AllocStrings(false,@tmp,@D,@N,@E);
  EndDlg(id_ok);
end;                           { TGUIOptDlg.ok }

destructor TGUIOptDlg.done;
begin
  IniAbbrevs.Done;
  TBasicDialog.Done;
end;

{ TPreferencesDlg methods }

constructor TPreferencesDlg.init(AParent: PWindowsObject);
begin
  TBasicDialog.init(AParent,PChar(rc_PreferencesDlg));
  New(LabelTempEBox,InitResource(@Self,dl_PrefsAutoTempEBox));
  HelpContext:=hc_Preferences;
end;

procedure TPreferencesDlg.SetupWindow;
var
  i: integer;
  tmp: string;
  F: array[0..255] of char;

procedure CheckIt(id: integer; Checked: boolean);
begin
  if Checked then SendDlgItemMsg(id,bm_SetCheck,bf_Checked,0)
  else SendDlgItemMsg(id,bm_SetCheck,bf_Unchecked,0);
end;

procedure AddToCombo(id,StrId: integer);
var
  Nstr: integer;
begin
  LoadString(Hinstance,StrId,F,255);
  SendDlgItemMsg(id,cb_AddString,0,Longint(@F));
end;

begin
  TBasicDialog.SetupWindow;

  { General }
  CheckIt(dl_PrefsUseIndex,UseIndexFile);
  CheckIt(dl_PrefsSticky,StickyList);
  CheckIt(dl_PrefsWrap,WrapEOF2BOF);
  CheckIt(dl_PrefsBuildIndex,AutoBuildIndex);
  CheckIt(dl_PrefsAutoCap,UseAutoCap);
  CheckIt(dl_PrefsReadAll,AlwaysRead);
  CheckIt(dl_PrefsAutoCache,AutoLoadCache);
  CheckIt(dl_PrefsAutoSCache,AutoSaveCache);
  AddToCombo(dl_PrefsDupNames,Str_AllowDupNames);
  AddToCombo(dl_PrefsDupNames,Str_NoDupsCaseSen);
  AddToCombo(dl_PrefsDupNames,Str_NoDupsNoCase);
  AddToCombo(dl_PrefsDupNames,Str_NoDupsWarn);
  case CheckDuplicate of
    AllowDuplicate:    i:=0;
    DuplicateCaseOff:  i:=1;
    DuplicateCaseOn:   i:=2;
    DuplicateCaseWarn: i:=3;
  end;
  SendDlgItemMsg(dl_PrefsDupNames,cb_SetCurSel,i,0);
  CheckIt(dl_PrefsUsePreamble,UsePreamble);
  StrPCopy(F,PreambleName^);
  SetDlgItemText(HWindow,dl_PrefsPreambleName,F);

  { Auto labels }
  CheckIt(dl_PrefsAutoLabels,LabelMode<>OffLabelMode);
  CheckIt(dl_PrefsAutoLVerify,LabelMode=VerifyLabelMode);
  DecompTemplate(tmp,LabelTemplate^); StrPCopy(F,tmp);
  SetWindowText(LabelTempEBox^.HWindow,F);

  { Sorting }
  CheckIt(dl_PrefsSortNew,SortNewFiles);
  CheckIt(dl_PrefsSortByDefault,SortedByDefault);
  AddToCombo(dl_PrefsAddSortTo,Str_AddSortToNoNew);
  AddToCombo(dl_PrefsAddSortTo,Str_AddSortToAllNew);
  AddToCombo(dl_PrefsAddSortTo,Str_AddSortToSorted);
  case AddSort2New of
    AddToNoNew:     i:=0;
    AddToAllNew:    i:=1;
    AddToSortedNew: i:=2;
  end;
  SendDlgItemMsg(dl_PrefsAddSortTo,cb_SetCurSel,i,0);
  Allow;

  InitPos;
end;                           { TPreferencesDlg.SetupWindow }

procedure TPreferencesDlg.Allow;
var
  on: boolean;
begin
  on:=SendDlgItemMsg(dl_PrefsAutoLabels,bm_GetCheck,0,0)<>0;
  EnableWindow(GetItemHandle(dl_PrefsAutoLVerify),on);
  EnableWindow(GetItemHandle(dl_PrefsLabelTempStatic),on);
  EnableWindow(GetItemHandle(dl_PrefsAutoTempEBox),on);
  on:=SendDlgItemMsg(dl_PrefsUsePreamble,bm_GetCheck,0,0)<>0;
  EnableWindow(GetItemHandle(dl_PrefsPreambleName),on);
  on:=SendDlgItemMsg(dl_PrefsUseIndex,bm_GetCheck,0,0)<>0;
  EnableWindow(GetItemHandle(dl_PrefsBuildIndex),on);
end;

procedure TPreferencesDlg.AutoLabelEnable(var Msg: TMessage);
begin Allow; end;

procedure TPreferencesDlg.UsePreambleCBox(var Msg: TMessage);
begin Allow; end;

procedure TPreferencesDlg.UseIndexCBox(var Msg: TMessage);
begin Allow; end;

procedure TPreferencesDlg.ok(var Msg: TMessage);
var
  ch1,ch2: boolean;
  F: array[0..255] of char;

procedure IsChecked(id: integer; var chk: boolean);
begin
  Chk:=SendDlgItemMsg(id,bm_GetCheck,0,0)<>0;
end;

begin
  if CanClose then
  begin
    { General }
    IsChecked(dl_PrefsUseIndex,UseIndexFile);
    IsChecked(dl_PrefsSticky,StickyList);
    IsChecked(dl_PrefsWrap,WrapEOF2BOF);
    IsChecked(dl_PrefsAutoCap,UseAutoCap);
    IsChecked(dl_PrefsReadAll,AlwaysRead);
    IsChecked(dl_PrefsAutoCache,AutoLoadCache);
    IsChecked(dl_PrefsAutoSCache,AutoSaveCache);
    case SendDlgItemMsg(dl_PrefsDupNames,cb_GetCurSel,0,0) of
      0: CheckDuplicate:=AllowDuplicate;
      1: CheckDuplicate:=DuplicateCaseOff;
      2: CheckDuplicate:=DuplicateCaseOn;
      3: CheckDuplicate:=DuplicateCaseWarn;
    end;
    IsChecked(dl_PrefsUsePreamble,UsePreamble);
    GetDlgItemText(HWindow,dl_PrefsPreambleName,F,255);
    PreambleName^:=StrPas(F);

    { Auto labels }
    IsChecked(dl_PrefsAutoLabels,ch1);
    IsChecked(dl_PrefsAutoLVerify,ch2);
    if ch1 then
    begin
      if ch2 then LabelMode:=VerifyLabelMode
      else LabelMode:=AutoLabelMode;
    end else LabelMode:=OffLabelMode;
    GetWindowText(LabelTempEBox^.HWindow,F,255);
    LabelTemplate^:=StrPas(F); PrepareTemplate(LabelTemplate^);

    { Sorting }
    IsChecked(dl_PrefsSortNew,SortNewFiles);
    IsChecked(dl_PrefsSortByDefault,SortedByDefault);
    case SendDlgItemMsg(dl_PrefsAddSortTo,cb_GetCurSel,0,0) of
      0: AddSort2New:=AddToNoNew;
      1: AddSort2New:=AddToAllNew;
      2: AddSort2New:=AddToSortedNew;
    end;

    OptionsModified.Preferences:=true;
    EndDlg(id_ok);
  end;
end;                         { TPreferencesDlg.ok }

{ TFileFormatDlg methods }

constructor TFileFormatDlg.Init(AParent: PWindowsObject);
begin
  TBasicDialog.Init(AParent,PChar(rc_FileFormatDlg));
  New(BibTeXWid,InitResource(@Self,dl_FileFormBibWidth,3,[#0..#255]-['0'..'9']));
  New(TibWid,InitResource(@Self,dl_FileFormTibWidth,3,[#0..#255]-['0'..'9']));
  New(ReferWid,InitResource(@Self,dl_FileFormRefWidth,3,[#0..#255]-['0'..'9']));
  New(TibLFields,InitResource(@Self,dl_FileFormTibLFields,255,
                           [#0..#255]-['A'..'Z','a'..'z','%',',',' ','\']));
  New(ReferLFields,InitResource(@Self,dl_FileFormRefLFields,255,
                           [#0..#255]-['A'..'Z','a'..'z','%',',',' ','\']));
  HelpContext:=hc_FormOptions;
end;                    { TFileFormatDlg.Init }

procedure TFileFormatDlg.SetupWindow;
var
  F: array[0..255] of char;
  tmp: string;
  i: integer;

procedure SetRadio(V: VerificationType; R1,R2,R3: integer);
var
  State: array[1..3] of integer;
begin
  case V of
    VerifyOff:
      begin
        State[1]:=bf_Checked; State[2]:=bf_Unchecked; State[3]:=bf_Unchecked;
      end; 
    VerifyLabel:
      begin
        State[1]:=bf_Unchecked; State[2]:=bf_Checked; State[3]:=bf_Unchecked;
      end; 
    VerifyEntry:
      begin
        State[1]:=bf_Unchecked; State[2]:=bf_Unchecked; State[3]:=bf_Checked;
      end; 
  end;
  SendDlgItemMsg(R1,bm_SetCheck,State[1],0);
  SendDlgItemMsg(R2,bm_SetCheck,State[2],0);
  SendDlgItemMsg(R3,bm_SetCheck,State[3],0);
end;                            { SetRadio }

begin             { TFileFormatDlg.SetupWindow }
  TBasicDialog.SetupWindow; InitPos;

  { BibTeX }
  SetRadio(Verify[BibTeXFormat],dl_FileFormBibVerOff,dl_FileFormBibVerLabels,
                                dl_FileFormBibVerOn);
  StrPCopy(F,num2str(LineWidth[BibTeXFormat])); SetWindowText(BibTeXWid^.HWindow,F);

  { Comma delimited }
  SetRadio(Verify[CommaDelimited],dl_FileFormComVerOff,dl_FileFormComVerLabels,
                                  dl_FileFormComVerOn);

  { Tib }
  SetRadio(Verify[TibFormat],dl_FileFormTibVerOff,dl_FileFormTibVerLabels,
                             dl_FileFormTibVerOn);
  StrPCopy(F,num2str(LineWidth[TibFormat])); SetWindowText(TibWid^.HWindow,F);
  tmp:='';
  for i:=1 to length(TibLabels) do
  begin
    if tmp<>'' then tmp:=tmp+',';
    tmp:=tmp+'%'+TibLabels[i];
  end;
  StrPCopy(F,tmp); SetWindowText(TibLFields^.HWindow,F);
  i:=bf_Checked; if TibMacros in [NotImpOrExp,ExpOnly] then i:=bf_Unchecked;
  SendDlgItemMsg(dl_FileFormTibMacToTeX,bm_SetCheck,i,0);
  i:=bf_Checked; if TibMacros in [NotImpOrExp,ImpOnly] then i:=bf_Unchecked;
  SendDlgItemMsg(dl_FileFormTibMacToTib,bm_SetCheck,i,0);

  { Refer }
  SetRadio(Verify[ReferFormat],dl_FileFormRefVerOff,dl_FileFormRefVerLabels,
                               dl_FileFormRefVerOn);
  StrPCopy(F,num2str(LineWidth[ReferFormat])); SetWindowText(ReferWid^.HWindow,F);
  tmp:='';
  for i:=1 to length(ReferLabels) do
  begin
    if tmp<>'' then tmp:=tmp+',';
    tmp:=tmp+'%'+ReferLabels[i];
  end;
  StrPCopy(F,tmp); SetWindowText(ReferLFields^.HWindow,F);
end;                               { TFileFormatDlg.SetupWindow }

procedure TFileFormatDlg.ok(var Msg: TMessage);
var
  F: array[0..255] of char;
  icode: integer;

function GetRadio(R2,R3: integer): VerificationType;
begin
  GetRadio:=VerifyOff;
  if SendDlgItemMsg(R2,bm_GetCheck,0,0)<>bf_Unchecked then
     GetRadio:=VerifyLabel
  else if SendDlgItemMsg(R3,bm_GetCheck,0,0)<>bf_Unchecked then
     GetRadio:=VerifyEntry;
end;

begin             { TFileFormatDlg.ok }
  if CanClose then
  begin
    { BibTeX }
    Verify[BibTeXFormat]:=GetRadio(dl_FileFormBibVerLabels,dl_FileFormBibVerOn);
    GetWindowText(BibTeXWid^.HWindow,F,4);
    Val(StrPas(F),LineWidth[BibTeXFormat],icode);

    { Comma delimited }
    Verify[CommaDelimited]:=GetRadio(dl_FileFormComVerLabels,dl_FileFormComVerOn);

    { Tib }
    Verify[TibFormat]:=GetRadio(dl_FileFormTibVerLabels,dl_FileFormTibVerOn);
    GetWindowText(TibWid^.HWindow,F,4);
    Val(StrPas(F),LineWidth[TibFormat],icode);
    GetWindowText(TibLFields^.HWindow,F,255);  TibLabels:=StrPas(F);
    ChrDel(TibLabels,'%'); ChrDel(TibLabels,' '); ChrDel(TibLabels,',');
    TibMacros:=NotImpOrExp;
    if SendDlgItemMsg(dl_FileFormTibMacToTeX,bm_GetCheck,0,0)<>0 then
      TibMacros:=ImpOnly;
    if SendDlgItemMsg(dl_FileFormTibMacToTib,bm_GetCheck,0,0)<>0 then
    begin
      if TibMacros=NotImpOrExp then TibMacros:=ExpOnly
      else TibMacros:=ImpAndExp;
    end;

    { Refer }
    Verify[ReferFormat]:=GetRadio(dl_FileFormRefVerLabels,dl_FileFormRefVerOn);
    GetWindowText(ReferWid^.HWindow,F,4);
    Val(StrPas(F),LineWidth[ReferFormat],icode);
    GetWindowText(ReferLFields^.HWindow,F,255);  ReferLabels:=StrPas(F);
    ChrDel(ReferLabels,'%'); ChrDel(ReferLabels,' '); ChrDel(ReferLabels,',');

    OptionsModified.Formats:=true;
    EndDlg(id_ok);
  end;
end;                                { TFileFormatDlg.ok }

{ TAboutDlg methods }

constructor TAboutDlg.init(AParent: PWindowsObject);
begin
  TBasicDialog.init(Aparent,PChar(rc_ABoutDlg));
end;

procedure TAboutDlg.SetupWindow;
var
  F: array[0..63] of char;
  S: string[10];
  S1: string[63];
  fspace: longint;
begin
  TBasicDialog.SetupWindow;
  StrPCopy(F,num2str(GetFreeSystemResources(GFSR_GDIRESOURCES)));
  SetWindowText(GetItemHandle(dl_AboutFreeGDI),F);
  StrPCopy(F,num2str(GetFreeSystemResources(GFSR_USERRESOURCES)));
  SetWindowText(GetItemHandle(dl_AboutFreeUser),F);
  StrPCopy(F,num2str(GetFreeSystemResources(GFSR_SYSTEMRESOURCES)));
  SetWindowText(GetItemHandle(dl_AboutFreeSystem),F);
  fspace:=GetFreeSpace(0) div 1024;
  S:=num2str(fspace mod 1000);
  if fspace>=1000 then
  begin
    if fspace mod 1000<10 then S:='00'+S
    else if fspace mod 1000<100 then S:='0'+S;
    S:=num2str(fspace div 1000)+','+S;
  end;
  StrPCopy(F,S);
  SetWindowText(GetItemHandle(dl_AboutFreeMem),F);

  GetDlgItemText(HWindow,dl_AboutDDEService,F,63); S1:=StrPas(F);
  StrRepl(S1,'%s',StrPas(ServiceName),1,255,255);  StrPCopy(F,S1);
  SetDlgItemText(HWindow,dl_AboutDDEService,F);

  InitPos;
end;                     { TAboutDlg.SetupWindow }

{ TExportDlg methods }

constructor TExportDlg.init(AParent: PWindowsObject; AEntry: EntryRecPtr;
                            AIORec: PExportRec);
begin
  TBasicDialog.init(AParent,PChar(rc_ExportDlg));
  Entry:=AEntry;
  IORec:=AIORec;
  New(EBox1,InitResource(@Self,dl_ExportEntFrom,  5,[#0..#255]-['0'..'9']));
  New(EBox1,InitResource(@Self,dl_ExportEntTo,    5,[#0..#255]-['0'..'9']));
  New(EBox1,InitResource(@Self,dl_ExportAtNumEBox,5,[#0..#255]-['0'..'9']));
  HelpContext:=hc_ExportDialog;
end;               { TExportDlg.init }

procedure TExportDlg.SetupWindow;
var
  F: array[0..255] of char;
  i: integer;
begin
  TBasicDialog.SetupWindow;

  CheckDlgButton(HWindow,dl_ExportEntNum,bf_Checked);
  StrPCopy(F,num2str(Entry^.EntryNum));
  SetDlgItemText(HWindow,dl_ExportEntFrom,F);
  SetDlgItemText(HWindow,dl_ExportEntTo,F);

  CheckDlgButton(HWindow,dl_ExportEOF,bf_Checked);

  CheckDlgButton(HWindow,dl_ExportToFile,bf_Checked);

  StrPCopy(F,DumpName^); SetDlgItemText(HWindow,dl_ExportFileStatic,@F);
  SendDlgItemMsg(dl_ExportFileFormat,cb_AddString,0,longint(BibTeXStr));
  SendDlgItemMsg(dl_ExportFileFormat,cb_AddString,0,longint(CommaStr));
  SendDlgItemMsg(dl_ExportFileFormat,cb_AddString,0,longint(TibStr));
  SendDlgItemMsg(dl_ExportFileFormat,cb_AddString,0,longint(ReferStr));
  for i:=FirstUserFormat to FirstUserFormat+NumUserFormats-1 do
  begin
    StrPCopy(F,UserFormatName[i]^);
    SendDlgItemMsg(dl_ExportFileFormat,cb_AddString,0,longint(@F));
  end;
  if EditOnlyStrings then
    SendDlgItemMsg(dl_ExportFileFormat,cb_SetCurSel,BibTeXFormat-1,0)
  else
    SendDlgItemMsg(dl_ExportFileFormat,cb_SetCurSel,ExportFormat-1,0);
  if DumpLabelsOnly then CheckDlgButton(HWindow,dl_ExportLabels,bf_Checked);
  Update;
  if EditOnlyStrings then EnableWindow(GetItemHandle(dl_ExportFileFormat),false);
end;                           { TExportDlg.SetupWindow }

procedure TExportDlg.Update;
var
  Active: boolean;
begin
  if (ExportFormat<>BibTeXFormat) or EditOnlyStrings or DumpLabelsOnly
    or (DumpName^='') then
  begin
    CheckDlgButton(HWindow,dl_ExportEOF,bf_Checked);
    CheckDlgButton(HWindow,dl_ExportAtNum,bf_Unchecked);
    CheckDlgButton(HWindow,dl_ExportBeforeEnt,bf_Unchecked);
    CheckDlgButton(HWindow,dl_ExportBOF,bf_Unchecked);
  end;
  Active:=(ExportFormat=BibTeXFormat) and not ExportSortMode^.SortingOn
    and (DumpName^<>'') and not EditOnlyStrings and not DumpLabelsOnly;
  EnableWindow(GetItemHandle(dl_ExportWhereGBox),Active);
  EnableWindow(GetItemHandle(dl_ExportEOF),Active);
  EnableWindow(GetItemHandle(dl_ExportAtNum),Active);
  EnableWindow(GetItemHandle(dl_ExportAtNumEBox),Active);
  EnableWindow(GetItemHandle(dl_ExportBOF),Active);
  EnableWindow(GetItemHandle(dl_ExportBeforeEnt),Active);

  EnableWindow(GetItemHandle(dl_ExportFields),not DumpLabelsOnly);

  Active:=IsDlgButtonChecked(HWindow,dl_ExportEntNum)=bf_Checked;
  EnableWindow(GetItemHandle(dl_ExportEntFrom),Active);
  EnableWindow(GetItemHandle(dl_ExportEntTo),Active);
  EnableWindow(GetItemHandle(dl_ExportEntToStatic),Active);

  InitPos;
end;                         { TExportDlg.Update }

procedure TExportDlg.HandleClipCBox(var Msg: TMessage);
var
  IsClip: boolean;
begin
  IsClip:=IsDlgButtonChecked(HWindow,dl_ExportClip)=bf_Checked;
  EnableWindow(GetItemHandle(dl_ExportFBrowse),   not IsClip);
  EnableWindow(GetItemHandle(dl_ExportFClear),    not IsClip);
  EnableWindow(GetItemHandle(dl_ExportEOF),       not IsClip);
  EnableWindow(GetItemHandle(dl_ExportAtNum),     not IsClip);
  EnableWindow(GetItemHandle(dl_ExportAtNumEBox), not IsClip);
  EnableWindow(GetItemHandle(dl_ExportBeforeEnt), not IsClip);
  EnableWindow(GetItemHandle(dl_ExportBOF),       not IsClip);
  EnableWindow(GetItemHandle(dl_ExportWhereGBox), not IsClip);
end;                    { TExportDlg.HandleClipCBox }

procedure TExportDlg.HandleFileCBox(var Msg: TMessage);
begin HandleClipCBox(Msg); end;

procedure TExportDlg.ExportFErase(var Msg: TMessage);
var
  dump: Text;
  SortPattern: PatRecPtr;
begin
  if (DumpName^<>'') and LFNFileExist(DumpName^) and
     AskIf(' Clear file '+DumpName^+'? ','','Clear','Cancel') then
  begin                          { Clear dump file }
    LFNNew(dump,true); LFNAssign(dump,dumpname^);
    LFNErase(dump); LFNDispose(dump);
    New(SortPattern);
    RecallBufferStack(SortPattern^,SortPattPosDef);
    PushBufferStack(SortPattern^,sizeof(PatRec),SortPattModeExp,SortPattPosExp);
    Dispose(SortPattern); SortPattern:=Nil;
    ExportSortMode^:=ConfigSortMode^;
    ExportSortMode^.SortingOn:=SortNewFiles;
    DumpFileExists:=false; DumpFirstTime:=true;
    Update;
  end else messagebeep(0);
end;                       { TExportDlg.ExportFErase }

procedure TExportDlg.ExportFBrowse(var Msg: TMessage);
var
  F: array[0..255] of char;
begin
  NewDump(true,bibname^);
  StrPCopy(F,DumpName^); SetDlgItemText(HWindow,dl_ExportFileStatic,@F);
  Update;
end;

procedure TExportDlg.ExportEntNum(var Msg: TMessage);
begin Update; end;
procedure TExportDlg.ExportAllEnt(var Msg: TMessage);
begin Update; end;
procedure TExportDlg.ExportTagged(var Msg: TMessage);
begin Update; end;
procedure TExportDlg.ExportOrder(var Msg: TMessage);
begin Update; end;

procedure TExportDlg.LabelsOnly(var Msg: TMessage);
begin
  DumpLabelsOnly:=IsDlgButtonChecked(HWindow,dl_ExportLabels)=bf_Checked;
  Update;
end;

procedure TExportDlg.ExportFields(var Msg: TMessage);
begin
  UpdateExpFields;
end;

procedure TExportDlg.ExportFileFormat(var Msg: TMessage);
var
  F: array[0..255] of char;
begin
  if Msg.lParamHi=cbn_SelChange then
  begin
    ExportFormat:=SendDlgItemMsg(dl_ExportFileFormat,cb_GetCurSel,0,0)+1;
    DumpName^:=DumpFileList^[ExportFormat];
    NewDump(false,bibname^);
    StrPCopy(F,DumpName^); SetDlgItemText(HWindow,dl_ExportFileStatic,@F);
    Update;
  end;
end;                  { TExportDlg.ExportFileFormat }

function GetNum(H: HWnd; id: integer): longint;
var
  F: array[0..31] of char;
  num: longint;
  i: integer;
begin
  GetNum:=0;
  GetDlgItemText(H,id,F,31);
  i:=0; num:=0;
  while F[i]<>#0 do
  begin
    if F[i] in ['0'..'9'] then num:=10*num+Ord(F[i])-Ord('0');
    inc(i);
  end;
  GetNum:=num;
end;           { GetNum }

procedure TExportDlg.ok(var Msg: TMessage);

begin          { TExportDlg.ok }
  if not CanClose then Exit;
  with IORec^ do
  begin
    ExpFrom  :=GetNum(HWindow,dl_ExportEntFrom);
    ExpTo    :=GetNum(HWindow,dl_ExportEntTo);
    if ExpFrom<0 then ExpFrom:=0;
    if ExpTo<0   then ExpTo:=0;
    ExpNum   :=IsDlgButtonChecked(HWindow,dl_ExportEntNum)=bf_Checked;
    ExpTagged:=IsDlgButtonChecked(HWindow,dl_ExportTagged)=bf_Checked;
    ExpAll   :=IsDlgButtonChecked(HWindow,dl_ExportAllEnt)=bf_Checked;
    ExpOrder :=IsDlgButtonChecked(HWindow,dl_ExportOrder )=bf_Checked;
    ExpCurrent:=ExpNum and (ExpFrom=Entry^.EntryNum)
                       and (ExpTo  =Entry^.EntryNum);
    ExpNum:=ExpNum and not ExpCurrent;

    InsertNum:=GetNum(HWindow,dl_ExportAtNumEBox);
    AtEnd    :=IsDlgButtonChecked(HWindow,dl_ExportEOF      )=bf_Checked;
    AtFirst  :=IsDlgButtonChecked(HWindow,dl_ExportBOF      )=bf_Checked;
    AtNum    :=IsDlgButtonChecked(HWindow,dl_ExportAtNum    )=bf_Checked;
    AtBefore :=IsDlgButtonChecked(HWindow,dl_ExportBeforeEnt)=bf_Checked;

    if AtNum and (InsertNum<=0) then
    begin
      SetFocus(GetItemHandle(dl_ExportAtNumEBox));
      messagebeep(0); Exit;
    end;
    if ExpNum and (ExpFrom>0) and (ExpTo>0) and (ExpFrom>ExpTo) then
    begin
      SetFocus(GetItemHandle(dl_ExportEntTo));
      messagebeep(0); Exit;
    end;
    ExportToClipboard:=IsDlgButtonChecked(HWindow,dl_ExportClip)=bf_Checked;
  end;
  EndDlg(id_ok);
end;                       { TExportDlg.ok }

{ TImportDlg methods }

constructor TImportDlg.init(AParent: PWindowsObject; AImpFile: PString);
begin
  TBasicDialog.init(AParent,PChar(rc_ImportDlg));
  ImpFile:=AImpFile;
  HelpContext:=hc_ImportDialog;
end;

procedure TImportDlg.SetupWindow;
begin
  TBasicDialog.SetupWindow; InitPos;
  CheckDlgButton(HWindow,dl_ImportFromFile,bf_Checked);
  { Format }
  SendDlgItemMsg(dl_ImportFormat,cb_AddString,0,longint(BibTeXStr));
  SendDlgItemMsg(dl_ImportFormat,cb_AddString,0,longint(CommaStr));
  SendDlgItemMsg(dl_ImportFormat,cb_AddString,0,longint(TibStr));
  SendDlgItemMsg(dl_ImportFormat,cb_AddString,0,longint(ReferStr));
  SendDlgItemMsg(dl_ImportFormat,cb_SetCurSel,ImportFormat-1,0);
  { Verification }
  case Verify[ImportFormat] of
    VerifyOff:   CheckDlgButton(HWindow,dl_ImportVerOff,   bf_Checked);
    VerifyLabel: CheckDlgButton(HWindow,dl_ImportVerLabels,bf_Checked);
    VerifyEntry: CheckDlgButton(HWindow,dl_ImportVerOn,    bf_Checked);
  end;
  { Insertion point }
  if EditOnlyStrings then
    FileIsSorted:=(CurrentSortMode^.StringNameSort<>StrSortOff)
  else FileIsSorted:=CurrentSortMode^.SortingOn;
  EnableWindow(GetItemHandle(dl_ImportWhereGBox),    not FileIsSorted);
  EnableWindow(GetItemHandle(dl_ImportAtCurrent),    not FileIsSorted);
  EnableWindow(GetItemHandle(dl_ImportBeforeCurrent),not FileIsSorted);
  EnableWindow(GetItemHandle(dl_ImportEOF),          not FileIsSorted);
  {
  EnableWindow(GetItemHandle(dl_ImportAtNum),        not FileIsSorted);
  EnableWindow(GetItemHandle(dl_ImportAtNumEBox),    not FileIsSorted);
  }
  EnableWindow(GetItemHandle(dl_ImportBeforeEnt),    not FileIsSorted);
  EnableWindow(GetItemHandle(dl_ImportBOF),          not FileIsSorted);
  if not FileIsSorted then CheckDlgButton(HWindow,dl_ImportAtCurrent,bf_Checked);
end;            { TImportDlg.SetupWindow }

procedure TImportDlg.BrowseBtn(var Msg: TMessage);
var
  accept: boolean;
  S: Pstring; F: PChar;
begin
  New(S); S^:='*';
  FileChoose(S^,DefExtension[ImportFormat]^,TexInputList,
                   AnyFile and (not (Directory or SysFile)),
                   true,true,false,Nil,'Import File:','',accept);
  if accept and (S^<>'') then
  begin
    GetMem(F,255);
    StrPCopy(F,S^); SetDlgItemText(HWindow,dl_ImportFile,F);
    FreeMem(F,255);
  end;
  Dispose(S);
end;              { TImportDlg.BrowseBtn }

procedure TImportDlg.HandleClipCBox(var Msg: TMessage);
var
  IsClip: boolean;
begin
  IsClip:=(IsDlgButtonChecked(HWindow,dl_ImportClipboard)=bf_checked);
  EnableWindow(GetItemHandle(dl_ImportFile),not IsClip);
  EnableWindow(GetItemHandle(dl_ImportBrowse),not IsClip);
end;                   { TImportDlg.HandleClipCBox }

procedure TImportDlg.HandleFileCBox(var Msg: TMessage);
begin
  HandleClipCBox(Msg);
end;

procedure TImportDlg.BibEnterIdle(var Msg: TMessage);
var
  HasClip,IsClip: boolean;
begin
  HasClip:=IsClipboardFormatAvailable(cf_text);
  IsClip:=IsDlgButtonChecked(HWindow,dl_ExportClip)=bf_Checked;
  if IsClip and not HasClip then
  begin
    CheckDlgButton(HWindow,dl_ExportClip,bf_UnChecked);
    CheckDlgButton(Hwindow,dl_ExportToFile,bf_Checked);
  end;
  HandleClipCBox(Msg);
  EnableWindow(GetItemHandle(dl_ExportClip),HasClip);
end;                      { TImportDlg.BibEnterIdle }

procedure TImportDlg.FormatCBox(var Msg: TMessage);
var
  i,j: integer;
begin
  if Msg.lParamHi=cbn_SelChange then
  begin
    i:=SendDlgItemMsg(dl_ImportFormat,cb_GetCurSel,0,0); j:=0;
    if i<>cb_Err then
    begin
      CheckDlgButton(HWindow,dl_ImportVerOff,   bf_UnChecked);
      CheckDlgButton(HWindow,dl_ImportVerLabels,bf_UnChecked);
      CheckDlgButton(HWindow,dl_ImportVerOn,    bf_UnChecked);
      case Verify[i+1] of
        VerifyOff:   CheckDlgButton(HWindow,dl_ImportVerOff,   bf_Checked);
        VerifyLabel: CheckDlgButton(HWindow,dl_ImportVerLabels,bf_Checked);
        VerifyEntry: CheckDlgButton(HWindow,dl_ImportVerOn,    bf_Checked);
      end;
    end;
  end;
end;                 { TImportDlg.FormatCBox }

function TImportDlg.CanClose: boolean;
var
  F: array[0..7] of char;
begin
  CanClose:=false; if not TBasicDialog.CanClose then Exit;
  if ((IsDlgButtonChecked(HWindow,dl_ImportClipboard)=bf_Unchecked) and
      (GetDlgItemText(HWindow,dl_ImportFile,F,5)=0)) or
    (SendDlgItemMsg(dl_ImportFormat,cb_GetCurSel,0,0)=cb_Err) or
  ((IsDlgButtonChecked(HWindow,dl_ImportAtNum)=bf_Checked) and
   (GetDlgItemText(HWindow,dl_ImportAtNumEBox,F,5)=0)) then
      MessageBeep(0)
  else CanClose:=true;
end;             { TImportDlg.CanClose }

procedure TImportDlg.ok(var Msg: TMessage);
var
  F: array[0..255] of char;
  ind: integer;
begin
  if not CanClose then Exit;
  { File }
  if IsDlgButtonChecked(HWindow,dl_ImportClipboard)=bf_Checked then
    ImpFile^:=File_Clipboard
  else begin
    GetDlgItemText(HWindow,dl_ImportFile,F,255);
    ImpFile^:=StrPas(F); CanonicalFname(ImpFile^);
  end;
  { Format and Verification }
  ImportFormat:=SendDlgItemMsg(dl_ImportFormat,cb_GetCurSel,0,0)+1;
  if IsDlgButtonChecked(HWindow,dl_ImportVerOff)=bf_Checked then
    Verify[ImportFormat]:=VerifyOff
  else if IsDlgButtonChecked(HWindow,dl_ImportVerLabels)=bf_Checked then
    Verify[ImportFormat]:=VerifyLabel
  else if IsDlgButtonChecked(HWindow,dl_ImportVerOn)=bf_Checked then
    Verify[ImportFormat]:=VerifyEntry;

  { Insertion point }
  Ind:=0;
  if FileIsSorted then Ind:=CIns_Sorted
  else if IsDlgButtonChecked(HWindow,dl_ImportAtCurrent)=bf_Checked then
      Ind:=CIns_AfterCurr
  else if IsDlgButtonChecked(HWindow,dl_ImportBeforeCurrent)=bf_Checked then
      Ind:=CIns_BeforeCurr
  else if IsDlgButtonChecked(HWindow,dl_ImportEOF)=bf_Checked then
      Ind:=CIns_EOF
  else if IsDlgButtonChecked(HWindow,dl_ImportBOF)=bf_Checked then
      Ind:=CIns_FirstEntry
  else if IsDlgButtonChecked(HWindow,dl_ImportBeforeEnt)=bf_Checked then
      Ind:=CIns_EntryList;

  if Ind=0 then EndDlg(id_cancel)
  else EndDlg(id_ok*100+Ind);
  OptionsModified.Formats:=true;
end;                 { TImportDlg.ok }

{ THyperOptionsDlg methods }

type
  PHyperTypeDlg = ^THyperTypeDlg;
  THyperTypeDlg = object(TBasicDialog)
    HyperType: HyperTypePtr;
    HyperInd: integer;
    AddNew: boolean;
    constructor init(AParent: PWindowsObject; AHyperType: HyperTypePtr;
                     AHyperInd: integer);
    procedure   SetupWindow; virtual;
    procedure   ok(var Msg: TMessage); virtual id_first+id_ok;
  end;

constructor THyperTypeDlg.init(AParent: PWindowsObject;
                     AHyperType: HyperTypePtr; AHyperInd: integer);
begin
  if (AHyperInd<Hyper_User) then
    TBasicDialog.init(AParent,PChar(rc_HyperClassPreDlg))
  else TBasicDialog.init(AParent,PChar(rc_HyperTagDlg));
  HyperType:=AHyperType;
  HyperInd:=AHyperInd;
  AddNew:=(HyperInd>=Hyper_User) and
    ((HyperType^.pre=Nil) or (HyperType^.pre^=''));
  HelpContext:=hc_HyperlinkOptions;
end;                 { THyperTypeDlg.init }

procedure THyperTypeDlg.SetupWindow;
var
  F: array[0..255] of char;
  tmp: string;
  i: integer;

procedure InitEBox(P: PString; id: integer);
begin
  if P<>Nil then
  begin
    StrPCopy(F,P^);
    SetDlgItemText(HWindow,id,@F);
  end;
end;

begin            { THyperTypeDlg.SetupWindow }
  TBasicDialog.SetupWindow; InitPos;
  InitEBox(HyperType^.TeXMacro,dl_HyperTagMacro);
  if (HyperInd<Hyper_User) then
  begin
    GetWindowText(HWindow,F,255); tmp:=StrPas(F);
    StrRepl(tmp,'%s',HyperTypesArr^[HyperInd].pre^,1,255,255);
    StrPCopy(F,tmp); SetWindowText(HWindow,F);
    if HyperInd<>Hyper_Run then
    begin
      ShowWindow(GetItemHandle(dl_HyperRunVerify),sw_hide);
    end;
  end else if HyperInd>=Hyper_User then
  with HyperType^ do
  begin
    InitEBox(Pre,dl_HyperTagName);
    InitEBox(App,dl_HyperTagCommand);
    if not AddNew then
    begin
      EnableWindow(GetItemHandle(dl_HyperTagName),false);
      EnableWindow(GetItemHandle(dl_HyperTagNameStatic),false);
    end;
    for i:=1 to Hyper_User-1 do
    begin
      StrPCopy(F,HyperTypesArr^[i].pre^);
      SendDlgItemMsg(dl_HyperTagHType,cb_AddString,0,longint(@F));
    end;
    if HyperTypesArr^[HyperInd].HType>0 then
      SendDlgItemMsg(dl_HyperTagHType,cb_SetCurSel,
                     HyperTypesArr^[HyperInd].HType-1,0)
    else SendDlgItemMsg(dl_HyperTagHType,cb_SetCurSel,Hyper_Run-1,0);
  end;    
  if HyperTypesArr^[HyperInd].Flags and HClass_on>0 then
    CheckDlgButton(HWindow,dl_HyperTagEnable,bf_Checked);
  if (HyperInd=Hyper_Run) and (HyperTypesArr^[HyperInd].Flags and HClass_on>0) then
    CheckDlgButton(HWindow,dl_HyperRunVerify,bf_Checked);
end;                  { THyperTypeDlg.SetupWindow }

procedure THyperTypeDlg.ok(var Msg: TMessage);
var
  i: integer;

procedure PutIt(var S: PString; id: integer; AddSlash: boolean);
var
  F: array[0..255] of char;
begin
  if S<>Nil then
  begin
    DisposeStr(S); S:=Nil;
  end;
  GetDlgItemText(HWindow,id,F,255);
  if StrLen(F)>0 then
  begin
    if (not AddSlash) or (F[0]='\') then S:=NewStr(StrPas(F))
    else S:=NewStr('\'+StrPas(F));
  end;
end;

begin                 { THyperTypeDlg.ok }
  PutIt(HyperType^.TeXMacro,dl_HyperTagMacro,true);
  if HyperInd>=Hyper_User then
  begin
    PutIt(HyperType^.pre,dl_HyperTagName,false);
    PutIt(HyperType^.App,dl_HyperTagCommand,false);
    i:=SendDlgItemMsg(dl_HyperTagHType,cb_GetCurSel,0,0);
    if i=cb_Err then HyperType^.HType:=Hyper_Run
    else HyperType^.HType:=i+1;
  end;
  HyperType^.Flags:=0;
  if IsDlgButtonChecked(HWindow,dl_HyperTagEnable)=bf_Checked then
    HyperType^.Flags:=HyperType^.Flags or HClass_on;
  if (HyperInd=Hyper_Run) and
    (IsDlgButtonChecked(HWindow,dl_HyperRunVerify)=bf_Checked) then
    HyperType^.Flags:=HyperType^.Flags or HRun_Verify;
  EndDlg(id_ok);
end;               { THyperTypeDlg.ok }

constructor THyperOptionsDlg.init(AParent: PWindowsObject);
var
  i: integer;
begin
  TBasicDialog.init(AParent,PChar(rc_Hyperlinks));
  NTypes:=NHyperTypes;
  for i:=1 to NTypes do
  begin
    TypesArr[i].pre:=NewStr(HyperTypesArr^[i].pre^);   
    if HyperTypesArr^[i].TeXMacro=Nil then TypesArr[i].TeXMacro:=Nil
    else TypesArr[i].TeXMacro:=NewStr(HyperTypesArr^[i].TeXMacro^);
    if HyperTypesArr^[i].App=Nil then TypesArr[i].App:=Nil
    else TypesArr[i].App:=NewStr(HyperTypesArr^[i].App^);
    TypesArr[i].Flags:=HyperTypesArr^[i].Flags;
    if i<Hyper_User then TypesArr[i].HType:=i
    else TypesArr[i].HType:=HyperTypesArr^[i].HType;
  end;
  OrigWWWBrowser:=0;
  HelpContext:=hc_HyperlinkOptions;
end;                     { THyperOptionsDlg.init }

procedure THyperOptionsDlg.SetupWindow;
var
  i,j: integer;
  F,F1: array[0..255] of char;
  P,P1: PChar;
begin
  TBasicDialog.SetupWindow; InitPos;

  { Hyperlinks }
  with HyperlinkFlags do
  begin
    if on then CheckDlgButton(HWindow,dl_HyperActive,bf_Checked);
    if LaTeX and HTML then i:=dl_HyperBoth
    else if LaTeX then i:=dl_HyperLaTeX
    else i:=dl_HyperHTML;
    CheckDlgButton(HWindow,i,bf_Checked);
  end;
  for i:=1 to NTypes do
  begin
    StrPCopy(F,TypesArr[i].pre^);
    SendDlgItemMsg(dl_HyperLBox,lb_AddString,0,longint(@F));
  end;
  SendDlgItemMsg(dl_HyperLBox,lb_SetCurSel,0,0);
  if UseMAPI then CheckDlgButton(HWindow,dl_HyperMAPI,bf_Checked)
  else CheckDlgButton(Hwindow,dl_HyperBrMail,bf_Checked);

  { WWW }
  if WWWUploadDir<>Nil then SetDlgItemText(HWindow,dl_HyperWWWUploadDir,
                                     WWWUploadDir);
  if (WWWBrowserList<>Nil) and (StrLen(WWWBrowserList)>0) then
  begin
    StrCopy(F,WWWBrowserList); P:=@F[0]; i:=0; j:=0;
    repeat
      while (P^=' ') do P:=P+1;
      P1:=StrScan(P,',');
      if P1<>Nil then P1^:=#0;
      if P^='*' then
      begin
        j:=i; inc(P);
      end;
      if P^='<' then
        SendDlgItemMsg(dl_HyperWWWBrowser,cb_AddString,0,longint(P))
      else begin
        GetPrivateProfileString(P,BrowserNameN,'<none>',F1,255,IniFile);
        SendDlgItemMsg(dl_HyperWWWBrowser,cb_AddString,0,longint(@F1));
      end;
      if P1=Nil then P:=P1 else P:=P1+1;
      inc(i);
    until (P=Nil) or (P^=#0);
    SendDlgItemMsg(dl_HyperWWWBrowser,cb_SetCurSel,j,0);
    OrigWWWBrowser:=j;
  end;
end;                   { THyperOptionsDlg.SetupWindow }

procedure THyperOptionsDlg.DispFont(var Msg: TMessage);
begin
  SelectFont(HWindow,HyperFont,true);
end;

procedure THyperOptionsDlg.PrintFont(var Msg: TMessage);
begin
  SelectFont(HWindow,PrintHyperFont,true);
end;

procedure THyperOptionsDlg.NewBtn(var Msg: TMessage);
var
  i: integer;
  double: boolean;
  F: array[0..255] of char;
begin
  if NTypes>=MaxHyperTypes then
  begin
    messagebeep(0); Exit;
  end;
  with TypesArr[NTypes+1] do
  begin
    pre:=Nil; TeXMacro:=Nil; App:=Nil; HType:=0; Flags:=HClass_on;
  end;
  if (Application^.ExecDialog(New(PHyperTypeDlg,init(@Self,@TypesArr[NTypes+1],
                   NTypes+1)))=id_ok) and (TypesArr[NTypes+1].pre<>Nil)
                   and (TypesArr[NTypes+1].pre^<>'') then
  begin
    double:=false;
    for i:=1 to NTypes do
      if StrCmpI(TypesArr[Ntypes+1].pre^,TypesArr[i].pre^,1,1,255)=0 then
        double:=true;
    if double then ErrorMessageRC(Str_HyperDoubleName,TypesArr[Ntypes+1].pre^)
    else begin
      inc(NTypes);
      StrPCopy(F,TypesArr[Ntypes].pre^);
      SendDlgItemMsg(dl_HyperLBox,lb_AddString,0,longint(@F));
    end;
  end;
end;                   { THyperOptionsDlg.NewBtn }

procedure THyperOptionsDlg.ModifyBtn(var Msg: TMessage);
var
  i: integer;
begin
  i:=SendDlgItemMsg(dl_HyperLBox,lb_GetCurSel,0,0);
  if i<>LB_ERR then
    Application^.ExecDialog(New(PHyperTypeDlg,init(@Self,@TypesArr[i+1],
                   i+1)));
end;                    { THyperOptionsDlg.ModifyBtn }

procedure THyperOptionsDlg.DelBtn(var Msg: TMessage);
var
  Ind,i: Integer;
begin
  Ind:=SendDlgItemMsg(dl_HyperLBox,lb_GetCurSel,0,0);
  if (Ind=LB_Err) or (Ind+1<Hyper_User) then
  begin
    messagebeep(0); Exit;
  end;
  Inc(Ind);
  with TypesArr[Ind] do
  begin
    if Pre<>Nil then DisposeStr(Pre); Pre:=Nil;
    if TeXMacro<>Nil then DisposeStr(TeXMacro); TeXMacro:=Nil;
    if App<>Nil then DisposeStr(App); App:=Nil;
  end;
  for i:=Ind to NTypes-1 do TypesArr[i]:=TypesArr[i+1];
  dec(NTypes);
  SendDlgItemMsg(dl_HyperLBox,lb_DeleteString,Ind-1,0);
  if Ind>NTypes then dec(Ind);
  SendDlgItemMsg(dl_HyperLBox,lb_SetCurSel,Ind-1,0);
end;                    { THyperOptionsDlg.DelBtn }

procedure THyperOptionsDlg.HandleLBox(var Msg: TMessage);
begin
  if Msg.lParamHi=lbn_DblClk then ModifyBtn(Msg);
end;

procedure THyperOptionsDlg.ok(var Msg: TMessage);
var
  i,k: integer;
  j: byte;
  F: array[0..255] of char;
  P: PChar;
  tmp,tmp1: string;
begin
  { Hyperlinks }
  with HyperlinkFlags do
  begin
    on:=IsDlgButtonChecked(HWindow,dl_HyperActive)=bf_Checked;
    LaTeX:=false; html:=false;
    if IsDlgButtonChecked(HWindow,dl_HyperBoth)=bf_Checked then
    begin
      LaTeX:=true; HTML:=true;
    end else if IsDlgButtonChecked(HWindow,dl_HyperLaTeX)=bf_Checked then
      LaTeX:=true
    else HTML:=true;
  end;
  for i:=1 to NHyperTypes do with HyperTypesArr^[i] do
  begin
    if pre<>Nil then DisposeStr(Pre); Pre:=Nil;
    if TeXMacro<>Nil then DisposeStr(TeXMacro); TeXMacro:=Nil;
    if App<>Nil then DisposeStr(App); App:=Nil;
    HType:=0; Flags:=0;
  end;
  MaxHyperTypeLen:=0;
  for i:=1 to NTypes do with HyperTypesArr^[i] do
  begin
    pre:=NewStr(TypesArr[i].pre^);
    if TypesArr[i].TeXMacro<>Nil    then TeXMacro:=NewStr(TypesArr[i].TeXMacro^);
    if TypesArr[i].App<>Nil         then App:=NewStr(TypesArr[i].App^);
    Flags:=TypesArr[i].Flags;
    if i<Hyper_User then HType:=i else HType:=TypesArr[i].HType;
    if length(pre^)>MaxHyperTypeLen then MaxHyperTypeLen:=length(pre^);
  end;
  NHyperTypes:=NTypes;

  UseMAPI:=IsDlgButtonChecked(HWindow,dl_HyperMAPI)=bf_Checked;

  { WWW }
  GetDlgItemText(HWindow,dl_HyperWWWUploadDir,F,255);
  StrDispose(WWWUploadDir); WWWUploadDir:=StrNew(F);
  i:=SendDlgItemMsg(dl_HyperWWWBrowser,cb_GetCurSel,0,0);
  if (i<>OrigWWWBrowser) and (i<>cb_Err) then    { Change browser }
  begin
    tmp:=StrPas(WWWBrowserList); F[0]:=#0; j:=1; k:=-1;
    P:=@F[0];
    repeat
      WrdToken(tmp1,tmp,' ,*',j);
      if tmp1<>'' then
      begin
        inc(k); if k=i then tmp1:='*'+tmp1;
        if k=0 then StrPCopy(P,tmp1)
        else StrPCopy(P,','+tmp1);
        P:=P+StrLen(P);
      end;
    until j=0;
    StrDispose(WWWBrowserList); WWWBrowserList:=StrNew(F);
    UploadBrowserInfo(HWindow,WWWBrowserList);
  end;

  EndDlg(id_ok);
end;                   { THyperOptionsDlg.ok }

destructor THyperOptionsDlg.Done;
var
  i: integer;
begin
  for i:=1 to NTypes do
  begin
    if TypesArr[i].pre     <>Nil then DisposeStr(TypesArr[i].pre);
    if TypesArr[i].TeXMacro<>Nil then DisposeStr(TypesArr[i].TeXMacro);
    if TypesArr[i].App     <>Nil then DisposeStr(TypesArr[i].App);
  end;
  TBasicDialog.Done;
end;                       { THyperOptionsDlg.Done }

{ TObjectImageOptions methods }

constructor TObjectImageOptions.init(AParent: PWindowsObject);
begin
  TBasicDialog.init(AParent,PChar(rc_ObjectsImagesDlg));
  HelpContext:=hc_ObjImgOptions;
end;

procedure TObjectImageOptions.SetupWindow;
var
  F: array[0..256] of char;
  i: integer;
begin
  TBasicDialog.SetupWindow;
  InitPos;

  { Objects }
  if ResolveObjects then CheckDlgButton(HWindow,dl_ObjectsOn,bf_Checked);
  StrPCopy(F,ObjectTeXMacro^);
  SetDlgItemText(HWindow,dl_ObjectsTeXMacro,F);
  if LockOleServers  then CheckDlgButton(HWindow,dl_LockOleServers, bf_Checked);
  if CompressObjects then CheckDlgButton(HWindow,dl_ObjectsCompress,bf_Checked);

  { Images }
  StrPCopy(F,ImageTeXMacro^);
  SetDlgItemText(HWindow,dl_ImageTeXMacro,F);
  if UseGraphicsFilters then
    CheckDlgButton(HWindow,dl_ImageUseFilters,bf_Checked);
  if CompressImages then
    CheckDlgButton(HWindow,dl_ImagesCompress,bf_Checked);
  if IconizeImages then
    CheckDlgButton(HWindow,dl_ImagesIconize,bf_Checked);
  if (HTMLImages<>Nil) and (HTMLImages^<>'') then
  begin
    StrPCopy(F,HTMLImages^);
    if HTMLImages^[length(HTMLImages^)]=';' then
      F[length(HTMLImages^)-1]:=#0;
    SetDlgItemText(HWindow,dl_ImageToHTML,F);
  end;
  F[0]:=#0;
  for i:=1 to GrExt_Last do
    with IntGraphList[i] do
      if not on then StrLCat(F,Ext,255); StrLCat(F,';',255);
  if (F[0]<>#0) and (F[StrLen(F)-1]=';') then F[StrLen(F)-1]:=#0;
  SetDlgItemText(HWindow,dl_ImageRenderExternal,F);
end;                   { TObjectImageOptions.SetupWindow }

procedure TObjectImageOptions.ok(var Msg: TMessage);
var
  F: array[0..255] of char;
  i: integer;
  PF,PF2: PChar;
  tmp: string;
  ch: char;
begin
  if not CanClose then Exit;

  { Objects }
  ResolveObjects:=IsDlgButtonChecked(HWindow,dl_ObjectsOn)=bf_Checked;
  if GetDlgItemText(HWindow,dl_ObjectsTeXMacro,F,255)>0 then
  begin
    DisposeStr(ObjectTeXMacro); ObjectTeXMacro:=Nil;
    if F[0]='\' then ObjectTeXMacro:=NewStr(StrPas(F))
    else ObjectTeXMacro:=NewStr('\'+StrPas(F));
  end;
  LockOleServers :=IsDlgButtonChecked(HWindow,dl_LockOleServers) =bf_Checked;
  CompressObjects:=IsDlgButtonChecked(HWindow,dl_ObjectsCompress)=bf_Checked;

  { Images }
  if GetDlgItemText(HWindow,dl_ImageTeXMacro,F,255)>0 then
  begin
    DisposeStr(ImageTeXMacro); ImageTeXMacro:=Nil;
    if F[0]='\' then ImageTeXMacro:=NewStr(StrPas(F))
    else ImageTeXMacro:=NewStr('\'+StrPas(F));
  end;

  UseGraphicsFilters:=IsDlgButtonChecked(HWindow,dl_ImageUseFilters)=bf_Checked;
  if HTMLImages<>Nil then DisposeStr(HTMLImages);
  GetDlgItemText(HWindow,dl_ImageToHTML,F,254);
  StrLower(F); PF:=@F; tmp:='';
  while (PF^ in [';',',',' ','.',#9]) do inc(PF);
  while PF^<>#0 do
  begin
    PF2:=PF;
    while not (PF2^ in [#0,';',',',' ','.',#9]) do inc(PF2);
    ch:=PF2^; PF2^:=#0;
    tmp:=tmp+'.'+StrPas(PF)+';';
    PF2^:=ch;
    PF:=PF2; while (PF^ in [';',',',' ','.',#9]) do inc(PF);
  end;
  if tmp<>'' then HTMLImages:=NewStr(tmp);

  for i:=1 to GrExt_Last do IntGraphList[i].on:=true;
  GetDlgItemText(HWindow,dl_ImageRenderExternal,F,255);
  StrLower(F); tmp:=StrPas(F);
  ChrDel(tmp,'.'); ChrDel(tmp,'*'); ChrDel(tmp,' ');
  StrRepl(tmp,',',';',1,255,255);
  StrPCopy(F,tmp); if tmp[length(tmp)]<>';' then StrCat(F,';');
  PF:=@F;
  while (PF<>Nil) and (PF^<>#0) do
  begin
    PF2:=StrScan(PF,';'); if PF2<>Nil then PF2^:=#0;
    for i:=1 to GrExt_Last do
    with IntGraphList[i] do
      if (Ext<>Nil) and (Ext+2=PF) then on:=false;
    if PF2=Nil then PF:=Nil else PF:=PF2+1;
  end;
  CompressImages:=IsDlgButtonChecked(HWindow,dl_ImagesCompress)=bf_Checked;
  IconizeImages:=IsDlgButtonChecked(HWindow,dl_ImagesIconize)=bf_Checked;

  EndDlg(id_ok);
end;               { TObjectImageOptions.ok }

{ Other procedures }

procedure About;
begin
  Application^.ExecDialog(New(PAboutDlg,init(MainW)));
end;                                { About }

function Preferences: boolean;
begin
  Preferences:=Application^.ExecDialog(New(PPreferencesDlg,Init(MainW)))=id_ok;
end;                                    { Options }

function FileFormatOptions: boolean;
begin
  FileFormatOptions:=Application^.ExecDialog(New(PFileFormatDlg,Init(MainW)))=id_ok;
end;                                    { FileFormatOptions }




end.
