{$N-,E-}
Unit BibWindo;

interface
Uses bibCrt;

Type
  PixelType = record
    ch: char;
    at: Byte;
  end;
var
  CurrentWindow: Byte;
  ExplodeDelay: Word;
  ExplodingWindows: Boolean;

function  Attr(Fore,Back: byte): Byte;
procedure PrintChar(y,x: integer; ch: char; at: byte);
procedure GetPixel(x,y: integer; Var Pixel: PixelType);
procedure GetPixelAttr(x,y: integer; Var Attr: byte);
function  PixelAttr(x,y: integer): byte;
procedure GetPixelChar(x,y: integer; var ch: char);
function  PixelChar(x,y: integer): char;
procedure TpwPrint(y,x: integer; s: string; at: byte);
procedure TpwPrintW(y,x: integer; s: string; at: byte);
procedure TpwFill(y,x,ny,nx: integer; ch: char; at: byte);
procedure TpwFillW(y,x,ny,nx: integer; ch: char; at: byte);
procedure TpwAttr(y,x,ny,nx: integer; at: byte);
procedure TpwAttrW(y,x,ny,nx: integer; at: byte);
procedure MakeBox(Row,Col,Rows,Cols,Wattr,Battr,border,sattr,shadow,
                  zoom: integer);
procedure MakeWindow(Row,Col,Rows,Cols,Wattr,Battr,border,sattr,shadow,
                     zoom: integer);
procedure MakeWindowNo(Row,Col,Rows,Cols,Wattr,Battr,border,sattr,shadow,
                     zoom: integer);
procedure RemoveWindow;
procedure prtwindow(row,col: integer; s: string);
procedure prtcwindow(row: integer; s: string);
procedure TitleWindow(loc,attrb: byte; s: string);
procedure WindowsInit;

implementation


CONST
  SaveTheScreen = true;
  WindowsNumLimit = 10;
  
TYPE
  WindowCoordType = record
    firstrow,nrows,firstcol,ncols,at: byte;
    keptrow,keptcol,keptrows,keptcols: byte;
    Xcur,Ycur: byte;
    buf: pointer;
    Segment,Offset: Word;
  end;
  
VAR
  i,j: Byte;
  windowCoord: array[1..WindowsNumLimit] of WindowCoordType;
  CurrentAttr: Byte;
  tmp: string;
  dvaware,debug: boolean;

function Attr(fore,back: Byte): Byte;
var temp: byte;
begin
  temp := (back*16)+fore;
  if fore>15 then temp := temp+112;
  Attr := temp
end;

procedure printchar(y,x: integer; ch: char; at: byte);
Var
  Point: pointer;
  pixel: PixelType;
begin
  if (y<1) or (x<1) or (y>ScrLen) or (x>ScrWidth) then Exit;
  Pixel.ch:=ch; Pixel.at:=at;
  point:=Ptr(VideoSeg,VideoOfs+(y-1)*2*ScrWidth+(x-1)*2);
  move(pixel,point^,2);
end;

procedure GetPixel(x,y: integer; var Pixel: PixelType);
Var
  Point: pointer;
begin
  if (y<1) or (x<1) or (y>ScrLen) or (x>ScrWidth) then Exit;
  point:=Ptr(VideoSeg,VideoOfs+(y-1)*2*ScrWidth+(x-1)*2);
  move(point^,Pixel,2);
end;

procedure GetPixelAttr(x,y: integer; var Attr: byte);
Var
  Point: pointer;
  Pixel: PixelType;
begin
  if (y<1) or (x<1) or (y>ScrLen) or (x>ScrWidth) then Exit;
  Attr:=Mem[VideoSeg:VideoOfs+(y-1)*2*ScrWidth+(x-1)*2+1];
  {
  point:=Ptr(VideoSeg,VideoOfs+(y-1)*2*ScrWidth+(x-1)*2);
  move(point^,Pixel,2);
  Attr:=Pixel.at;
  }
end;

function PixelAttr(x,y: integer): byte;
var
  at: byte;
begin
  GetPixelAttr(x,y,at);
  PixelAttr:=at;
end;

procedure GetPixelChar(x,y: integer; var ch: char);
Var
  Point: pointer;
  Pixel: PixelType;
begin
  if (y<1) or (x<1) or (y>ScrLen) or (x>ScrWidth) then Exit;
  point:=Ptr(VideoSeg,VideoOfs+(y-1)*2*ScrWidth+(x-1)*2);
  move(point^,Pixel,2);
  ch:=Pixel.ch;
end;

function PixelChar(x,y: integer): char;
var
  ch: char;
begin
  GetPixelChar(x,y,ch);
  PixelChar:=ch;
end;

procedure WuStrCut(var s: string; n: integer);
begin
  if length(s)>n then s[0]:=Chr(n);
end;

procedure TpwPrint(y,x: integer; s: string; at: byte);
Var
  Point: pointer;
  i: integer;
  line: array[1..132] of PixelType;
  l: byte;
begin
  if (y<1) or (x<1) or (y>ScrLen) or (x>ScrWidth) then Exit;
  WUstrcut(s,ScrWidth+1-x); l:=length(s);
  for i:=1 to l do
  begin
    line[i].ch:=s[i]; line[i].at:=at;
  end;
  point:=Ptr(VideoSeg,VideoOfs+(y-1)*2*ScrWidth+(x-1)*2);
  move(line[1],point^,2*l);
end;

procedure TpwPrintW(y,x: integer; s: string; at: byte);
begin
  if (x+length(s)-1<WinX0) or (x>WinX1) or (y<WinY0) or (y>WinY1) then exit;
  if x<WinX0 then
  begin
    Delete(s,1,WinX0-x); x:=WinX0;
  end;
  if x+length(s)-1>WinX1 then s[0]:=Chr(WinX1-x+1);
  TpwPrint(y,x,s,at);
end;

procedure Tpwfill(y,x,ny,nx: integer; ch: char; at: byte);
Var
  Point: pointer;
  shft,nmove: Word;
  i: integer;
  line: array[1..MaxScrWidth] of PixelType;
begin
  if (nx<1) or (ny<1) or (y<1) or (x<1) or (y>ScrLen) or (x>ScrWidth) then Exit;
  if x+nx>ScrWidth+1 then nx:=ScrWidth+1-x;
  for i:=1 to nx do
  begin
    line[i].ch:=ch; line[i].at:=at;
  end;
  shft:=(y-1)*2*ScrWidth+(x-1)*2;
  nmove:=2*nx;
  for i:=1 to ny do
  begin
    point:=Ptr(VideoSeg,VideoOfs+shft);
    move(line[1],point^,nmove);
    shft:=shft+2*ScrWidth;
  end;
end;

procedure TpwfillW(y,x,ny,nx: integer; ch: char; at: byte);
begin
  if (x+nx-1<WinX0) or (x>WinX1) or (y+ny-1<WinY0) or (y>WinY1) then exit;
  if x<WinX0 then
  begin
    nx:=nx-(WinX0-x); x:=WinX0;
  end;
  if x+nx-1>WinX1 then nx:=WinX1-x+1;
  if y<WinY0 then
  begin
    ny:=ny-(WinY0-y); y:=WinY0;
  end;
  if y+ny-1>WinY1 then ny:=WinY1-y+1;
  TpwFill(y,x,ny,nx,ch,at);
end;

procedure TpwAttr(y,x,ny,nx: integer; at: byte);
Var
  Point: pointer;
  shft,nmove: Word;
  i,j: integer;
  line,origline: array[1..132] of PixelType;
begin
  if (nx<1) or (ny<1) then Exit;
  if x+nx>ScrWidth+1 then nx:=ScrWidth+1-x;
  shft:=(y-1)*2*ScrWidth+(x-1)*2;
  for i:=1 to nx do line[i].at:=at;
  nmove:=2*nx;
  for i:=1 to ny do
  begin
    point:=Ptr(VideoSeg,VideoOfs+shft);
    move(point^,origline[1],nmove);
    for j:=1 to nx do line[j].ch:=origline[j].ch;
    move(line[1],point^,nmove);
    shft:=shft+2*ScrWidth;
  end;
end;

procedure TpwAttrW(y,x,ny,nx: integer; at: byte);
begin
  if (x+nx-1<WinX0) or (x>WinX1) or (y+ny-1<WinY0) or (y>WinY1) then exit;
  if x<WinX0 then
  begin
    nx:=nx-(WinX0-x); x:=WinX0;
  end;
  if x+nx-1>WinX1 then nx:=WinX1-x+1;
  if y<WinY0 then
  begin
    ny:=ny-(WinY0-y); y:=WinY0;
  end;
  if y+ny-1>WinY1 then ny:=WinY1-y+1;
  TpwAttr(y,x,ny,nx,at);
end;

procedure MakeBox(Row,Col,Rows,Cols,Wattr,Battr,border,sattr,shadow,
                  zoom : integer);
var
  Horiz,vert,ul,ur,ll,lr: char;
  i,xstart,xend,ystart,yend: integer;
  OrigRow,OrigCol,OrigRows,OrigCols: integer;
  first: boolean;
begin
  if (Row>ScrLen-2) or (col>ScrWidth-2) or (Row+Rows-1<1) or (col+cols-1<1) then Exit;
  if col<1 then
  begin
    cols:=cols-(1-col); col:=1;
  end;
  if col+cols-1>ScrWidth then cols:=ScrWidth-col+1;
  if row<1 then
  begin
    rows:=rows-(1-row); row:=1;
  end;
  if row+rows-1>ScrLen then rows:=ScrLen-row+1;
  {
  if (Row<1) or (Row>ScrLen-2) or (col<1) or (col>ScrWidth-2) or (Rows<2) or (cols<2)
             or (Row+Rows>ScrLen+1) or (Col+Cols>ScrWidth+1) then Exit;
  }
  if (Row+Rows-1>=ScrLen) or (col+cols>=ScrWidth) then Shadow:=0;
  if not ExplodingWindows then zoom:=0;
  Case border of
    1 : begin
          Horiz:=#196; vert:=#179;
          ul:=#218; ur:=#191; ll:=#192; lr:=#217;
        end;
    2 : begin
          horiz:=#205; vert:=#186;
          ul:=#201; ur:=#187; ll:=#200; lr:=#188;
        end;
    3 : begin
          horiz:=#196; vert:=#186;
          ul:=#214; ur:=#183; ll:=#211; lr:=#189;
        end;
    4 : begin
          horiz:=#205; vert:=#179;
          ul:=#213; ur:=#184; ll:=#212; lr:=#190;
        end;
    else begin
          horiz:=' '; vert:=' '; ul:=' '; ur:=' '; ll:=' '; lr:=' ';
         end;
  end;
  with WindowCoord[CurrentWindow] do
  begin
    at:=Wattr;
    firstrow:=row; nrows:=rows;
    firstcol:=col; ncols:=cols;
  end;
  CurrentAttr:=WAttr;
  Window(Col+1,Row+1,col+cols-2,row+rows-2);
  OrigRows:=Rows; OrigCols:=Cols; OrigCol:=Col; OrigRow:=Row;
  if zoom=1 then
  begin
    row:=row + (Rows div 2)-1; Rows:=2;
    if Odd(cols) then
    begin
      Col:=(Col + Cols div 2) -1; Cols:=3
    end else
    begin
      Col:=(Col + Cols div 2) -1; Cols:=2;
    end;
  end;
  first:=true;
  repeat
    if not first then
    begin
      if Col>OrigCol then Dec(Col);
      if Cols<OrigCols then Cols:=Cols+2;
      if Odd(rows) and (Row>OrigRow) then Dec(Row);
      if (Rows<OrigRows) then Inc(Rows);
      if ExplodeDelay>0 then delay(ExplodeDelay);
    end;
    first:=false;
    TpwFill(row+1,col+1,rows-2,cols-2,' ',Wattr);
    TpwFill(row,col+1,1,cols-2,horiz,battr);
    TpwFill(row+rows-1,col+1,1,cols-2,horiz,battr);
    TpwFill(row+1,col,rows-2,1,vert,battr);
    TpwFill(row+1,col+cols-1,rows-2,1,vert,battr);
    PrintChar(row,col,ul,battr);
    PrintChar(row,col+cols-1,ur,battr);
    PrintChar(row+rows-1,col,ll,battr);
    PrintChar(row+rows-1,col+cols-1,lr,battr);
    if shadow in [2,4,6,8,10] then
    begin
      xstart:=col+2;
      xend:=col+cols+1; if xend>ScrWidth then xend:=ScrWidth;
      yend:=row+rows; if yend>ScrLen then yend:=ScrLen;
      for i:=col+cols to xend do TpwAttr(row+1,i,yend-row,1,sattr);
      if yend=row+rows then TpwAttr(yend,xstart,1,xend-xstart+1,sattr);
    end else if shadow in [1,3,5,7,9] then
    begin
      xstart:=col-2; if xstart<1 then xstart:=1;
      xend:=col+cols-3;
      yend:=row+rows; if yend>ScrLen then yend:=ScrLen;
      for i:=xstart to col-1 do TpwAttr(row+1,i,yend-row,1,sattr);
      if yend=row+rows then TpwAttr(yend,xstart,1,xend-xstart+1,sattr);
    end;
  until (Row<=OrigRow) and (Col<=OrigCol) and (Rows>=OrigRows) and
        (Cols>=OrigCols);
  GotoXY(1,1);
end;

procedure MakeWindow(Row,Col,Rows,Cols,Wattr,Battr,border,sattr,shadow,
                     zoom: integer);
var
  buffer,screen: pointer;
  nmove,shft,i: word;
begin
  if (Row<1) or (Row>ScrLen-2) or (col<1) or (col>ScrWidth-2) or (Rows<2) or (cols<2)
             or (Row+Rows>ScrLen+1) or (Col+Cols>ScrWidth+1) then Exit;
  if (CurrentWindow<1) or (CurrentWindow>=WindowsNumLimit) then Exit;
  with WindowCoord[CurrentWindow] do
  begin
    Xcur:=WhereX; YCur:=WhereY;
    KeptCol:=Col; KeptRow:=Row; KeptRows:=Rows; KeptCols:=Cols;
    if shadow in [2,4,6,8,10] then
    begin
      if row+Rows<ScrLen+1 then Inc(KeptRows);
      if Keptcol+KeptCols<ScrWidth+1 then Inc(KeptCols);
      if Keptcol+KeptCols<ScrWidth+1 then Inc(KeptCols);
    end else if shadow in [1,3,5,7,9] then
    begin
      if row+Rows<ScrLen+1 then Inc(KeptRows);
      if Keptcol>1 then
      begin
        Inc(KeptCols); Dec(KeptCol);
      end;
      if Keptcol>1 then
      begin
        Inc(KeptCols); Dec(KeptCol);
      end;
    end;
    shft:=(keptrow-1)*2*ScrWidth+(keptcol-1)*2;
    nmove:=2*keptcols;
    GetMem(buf,2*keptrows*keptcols);
    Segment:=Seg(buf^); Offset:=ofs(buf^);
    for i:=1 to keptrows do
    begin
      Screen:=Ptr(VideoSeg,VideoOfs+shft);
      buffer:=Ptr(Segment,Offset+(i-1)*nmove);
      Move(Screen^,Buffer^,nmove);
      shft:=shft+2*ScrWidth;
    end;
  end;
  Inc(CurrentWindow);
  MakeBox(Row,Col,Rows,Cols,Wattr,Battr,border,sattr,shadow,zoom);
end;


procedure MakeWindowNo(Row,Col,Rows,Cols,Wattr,Battr,border,sattr,shadow,
                     zoom: integer);
begin
  if (Row<1) or (Row>ScrLen-2) or (col<1) or (col>ScrWidth-2) or (Rows<2) or (cols<2)
             or (Row+Rows>ScrLen+1) or (Col+Cols>ScrWidth+1) then Exit;
  if (CurrentWindow<1) or (CurrentWindow>=WindowsNumLimit) then Exit;
  with WindowCoord[CurrentWindow] do
  begin
    Xcur:=WhereX; YCur:=WhereY;
    KeptCol:=Col; KeptRow:=Row; KeptRows:=Rows; KeptCols:=Cols;
    if shadow in [2,4,6,8,10] then
    begin
      if row+Rows<ScrLen+1 then Inc(KeptRows);
      if Keptcol+KeptCols<ScrWidth+1 then Inc(KeptCols);
      if Keptcol+KeptCols<ScrWidth+1 then Inc(KeptCols);
    end else if shadow in [1,3,5,7,9] then
    begin
      if row+Rows<ScrLen+1 then Inc(KeptRows);
      if Keptcol>1 then
      begin
        Inc(KeptCols); Dec(KeptCol);
      end;
      if Keptcol>1 then
      begin
        Inc(KeptCols); Dec(KeptCol);
      end;
    end;
    buf:=Nil;
  end;
  Inc(CurrentWindow);
  MakeBox(Row,Col,Rows,Cols,Wattr,Battr,border,sattr,shadow,zoom);
end;

procedure RemoveWindow;
var
  buffer,screen: pointer;
  nmove,shft,lastnrows,lastncols,i: word;
begin
  if CurrentWindow<=1 then Exit;
  dec(CurrentWindow);
  with WindowCoord[CurrentWindow] do
  begin
    if buf<>Nil then
    begin
      shft:=(keptrow-1)*2*ScrWidth+(keptcol-1)*2;
      nmove:=2*keptcols;
      for i:=1 to keptrows do
      begin
        Screen:=Ptr(VideoSeg,VideoOfs+shft);
        buffer:=Ptr(Segment,Offset+(i-1)*nmove);
        Move(Buffer^,Screen^,nmove);
        shft:=shft+2*ScrWidth;
      end;
      FreeMem(buf,keptrows*keptcols*2); buf:=Nil;
    end;
    CurrentAttr:=at;
    Window(FirstCol+1,FirstRow+1,Firstcol+ncols-2,firstrow+nrows-2);
    GotoXY(1,1);
  end;
end;

procedure prtwindow(row,col: Integer; s: string);
begin
  with WindowCoord[CurrentWindow] do
  begin
    if (row<1) or (row>nrows-2) or (col<1) or (col>ncols-2) then Exit;
    WUstrcut(s,ncols-col-1);
    Tpwprint(row+firstrow,col+firstcol,s,CurrentAttr);
  end;
end;

procedure prtcwindow(row: integer; s: string);
begin
  with WindowCoord[CurrentWindow] do
  begin
    if (row<1) or (row>nrows-2) then Exit;
    WUstrcut(s,ncols);
    Tpwprint(row+firstrow,firstcol+(ncols-length(s)) div 2,s,CurrentAttr);
  end;
end;

procedure TitleWindow(loc,attrb: byte; s: string);
begin
  with WindowCoord[CurrentWindow] do
  begin
    WUstrcut(s,ncols-2);
    case loc of
      1: Tpwprint(firstrow,firstcol+2,s,attrb);
      2: Tpwprint(firstrow,firstcol+(ncols-length(s)) div 2,s,attrb);
      3: Tpwprint(firstrow,firstcol+ncols-length(s)-2,s,attrb);
      4: Tpwprint(firstrow+nrows-1,firstcol+2,s,attrb);
      5: Tpwprint(firstrow+nrows-1,firstcol+(ncols-length(s)) div 2,s,attrb);
      6: Tpwprint(firstrow+nrows-1,firstcol+ncols-length(s)-2,s,attrb);
    end;
  end;
end;

procedure WindowsInit;
begin
  CurrentWindow:=1;
  for i:=1 to WindowsNumLimit do
  with WindowCoord[1] do
  begin
    firstcol:=1; firstrow:=1;
    ncols:=ScrWidth; nrows:=ScrLen;
    Xcur:=1; Ycur:=1;
    Keptrow:=0; Keptcol:=0;
    Keptrows:=0; Keptcols:=0;
    buf:=Nil;
    Segment:=$FFFF; offset:=0;
  end;
end;

begin
  ExplodeDelay:=2; ExplodingWindows:=true;
  if MultiTasking then DirectVideo:=false;
  CurrentWindow:=0;
end.
