/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.rules;

import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.util.Debug;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Properties;
import net.n3.nanoxml.XMLElement;

public class JavaCondition
extends Condition {
    protected String classname;
    protected String methodname;
    protected String fieldname;
    protected boolean complete;
    protected String returnvalue;
    protected String returnvaluetype;
    protected Class usedclass;
    protected Field usedfield;
    protected Method usedmethod;

    private boolean isTrue(Properties variables) {
        if (!this.complete) {
            return false;
        }
        if (this.usedclass == null) {
            ClassLoader loader = ClassLoader.getSystemClassLoader();
            try {
                this.usedclass = loader.loadClass(this.classname);
            }
            catch (ClassNotFoundException e) {
                Debug.log("Can't find class " + this.classname);
                return false;
            }
        }
        if (this.usedfield == null && this.fieldname != null) {
            try {
                this.usedfield = this.usedclass.getField(this.fieldname);
            }
            catch (SecurityException e) {
                Debug.log("No permission to access specified field: " + this.fieldname);
                return false;
            }
            catch (NoSuchFieldException e) {
                Debug.log("No such field: " + this.fieldname);
                return false;
            }
        }
        if (this.usedmethod == null && this.methodname != null) {
            Debug.log("not implemented yet.");
            return false;
        }
        if (this.usedfield != null) {
            if ("boolean".equals(this.returnvaluetype)) {
                try {
                    boolean returnval = this.usedfield.getBoolean(null);
                    boolean expectedreturnval = Boolean.valueOf(this.returnvalue);
                    return returnval == expectedreturnval;
                }
                catch (IllegalArgumentException e) {
                    Debug.log("IllegalArgumentexeption " + this.fieldname);
                }
                catch (IllegalAccessException e) {
                    Debug.log("IllegalAccessException " + this.fieldname);
                }
            } else {
                Debug.log("not implemented yet.");
                return false;
            }
        }
        return false;
    }

    public void readFromXML(XMLElement xmlcondition) {
        XMLElement fieldel;
        if (xmlcondition.getChildrenCount() != 2) {
            Debug.log("Condition of type java needs (java,returnvalue)");
            return;
        }
        XMLElement javael = xmlcondition.getFirstChildNamed("java");
        XMLElement classel = javael.getFirstChildNamed("class");
        if (classel == null) {
            Debug.log("Java-Element needs (class,method?,field?)");
            return;
        }
        this.classname = classel.getContent();
        XMLElement methodel = javael.getFirstChildNamed("method");
        if (methodel != null) {
            this.methodname = methodel.getContent();
        }
        if ((fieldel = javael.getFirstChildNamed("field")) != null) {
            this.fieldname = fieldel.getContent();
        }
        if (this.methodname == null && this.fieldname == null) {
            Debug.log("java element needs (class, method?,field?)");
            return;
        }
        XMLElement returnvalel = xmlcondition.getFirstChildNamed("returnvalue");
        if (returnvalel == null) {
            Debug.log("no returnvalue-element specified.");
            return;
        }
        this.returnvalue = returnvalel.getContent();
        this.returnvaluetype = returnvalel.getAttribute("type");
        this.complete = true;
    }

    public boolean isTrue() {
        return this.isTrue(this.installdata.getVariables());
    }
}

