# Copyright (C) 2009 Google Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may not
# use this file except in compliance with the License. You may obtain a copy of
# the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations under
# the License.

import os
import psutil

class Android(object):
  def __init__(self,addr=None):
    self.onEPGUpdated = None
    self.onPlaylistUpdated = None

  @staticmethod
  def getAceStreamHome():
    return os.path.abspath(os.curdir)

  @staticmethod
  def makeToast(msg):
    print msg

  @staticmethod
  def getDeviceName():
    return "RaspberyPi"

  @staticmethod
  def getDeviceModel():
     return os.uname()[0]

  @staticmethod
  def getDeviceProductName():
    return "RaspberyPi"

  @staticmethod
  def getDisplayLanguage():
    return "ru_RU"

  @staticmethod
  def getRAMSize():
    return psutil.virtual_memory().total

  @staticmethod
  def getTotalMemory():
    return psutil.virtual_memory().total

  @staticmethod
  def getMaxMemory():
    return psutil.virtual_memory().available

  @staticmethod
  def getMemoryClass():
    return 16

  @staticmethod
  def getDeviceId():
    return "RPi3"

  @staticmethod
  def getBlockSize(self):
    return 4096

  @staticmethod
  def getBlockCount(self):
    return 26214400
    #16777216 - 64Gb
    #26214400 - 100Gb

  @staticmethod
  def getAvailableBlocks(self):
    return 25690112
    #16252928 - 62Gb
    #25690112 - 98Gb
