




import os
import shutil
import sys
import urllib
import xbmc
import xbmcaddon
import xbmcgui,xbmcplugin
import xbmcvfs,logging
import uuid

__addon__ = xbmcaddon.Addon()
__author__     = __addon__.getAddonInfo('author')
__scriptid__   = __addon__.getAddonInfo('id')
__scriptname__ = __addon__.getAddonInfo('name')
__version__    = __addon__.getAddonInfo('version')
__language__   = __addon__.getLocalizedString

__cwd__        = xbmc.translatePath( __addon__.getAddonInfo('path') ).decode("utf-8")
__profile__    = xbmc.translatePath( __addon__.getAddonInfo('profile') ).decode("utf-8")
__resource__   = xbmc.translatePath( os.path.join( __cwd__, 'resources', 'lib' ) ).decode("utf-8")
__temp__       = xbmc.translatePath( os.path.join( __profile__, 'temp', '') ).decode("utf-8")

if xbmcvfs.exists(__temp__):
  shutil.rmtree(__temp__)
xbmcvfs.mkdirs(__temp__)

sys.path.append (__resource__)

from OSUtilities import OSDBServer, log, hashFile, normalizeString

def Search_opensubtitle( item,imdb_id ,mode_subtitle):
  search_data = []
  #try:
   
 
  search_data = OSDBServer().searchsubtitles(item,imdb_id)

  #except:
  #  log( __name__, "failed to connect to service for subtitle search")
  #  xbmc.executebuiltin((u'Notification(%s,%s)' % (__scriptname__ , __language__(32001))).encode('utf-8'))
  #  return
  subtitle_list=[]
 

  if search_data != None:
   
    search_data.sort(key=lambda x: [not x['MatchedBy'] == 'moviehash',
				     not os.path.splitext(x['SubFileName'])[0] == os.path.splitext(os.path.basename(urllib.unquote(item['file_original_path'])))[0],
				     not normalizeString(xbmc.getInfoLabel("VideoPlayer.OriginalTitle")).lower() in x['SubFileName'].replace('.',' ').lower(),
				     not x['LanguageName'] == 'Undetermined'])
    x=1
    url_list=[]
    for item_data in search_data:



      ## hack to work around issue where Brazilian is not found as language in XBMC

      try:
       item['season']=int(item['season'])
       item['episode']=int(item['episode'])
       item_data['SeriesSeason']=int(item_data['SeriesSeason'])
       item_data['SeriesEpisode']=int(item_data['SeriesEpisode'])
      except:
         pass
      if ((item['season'] == item_data['SeriesSeason'] and
          item['episode'] == item_data['SeriesEpisode']) or
          (item['season'] == 0 and item['episode'] == 0) ## for file search, season and episode == ""
         ):
  

        listitem = xbmcgui.ListItem(label          = item_data["LanguageName"],
                                    label2         = '[COLOR bisque]'+str(x)+ '. '+' [OPS]'+item_data["SubFileName"]+'[/COLOR]',
                                    iconImage      = str(int(round(float(item_data["SubRating"])/2))),
                                    thumbnailImage = item_data["ISO639"]
                                    )
        
        listitem.setProperty( "sync", ("false", "true")[str(item_data["MatchedBy"]) == "moviehash"] )
        listitem.setProperty( "hearing_imp", ("false", "true")[int(item_data["SubHearingImpaired"]) != 0] )
        url = "plugin://%s/?action=download&link=%s&ID=%s&filename=%s&format=%s&source=%s" % (__scriptid__,
                                                                          item_data["ZipDownloadLink"],
                                                                          item_data["IDSubtitleFile"],
                                                                          item_data["SubFileName"],
                                                                          item_data["SubFormat"],
                                                                          'opensubtitle'
                                                                          )

        json_data={'url':url,
                 'label':item_data["LanguageName"],
                 'label2':'[COLOR bisque]'+str(x)+ '. '+' [OPS]'+item_data["SubFileName"]+'[/COLOR]',
                 'iconImage':str(int(round(float(item_data["SubRating"])/2))),
                 'thumbnailImage':item_data["ISO639"],
                 'hearing_imp':("false", "true")[int(item_data["SubHearingImpaired"]) != 0],
                 'sync': ("false", "true")[str(item_data["MatchedBy"]) == "moviehash"]}

        if mode_subtitle>1  :
          if url not in url_list:
           
            url_list.append(url)
            subtitle_list.append(json_data)
          #xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]),url=url,listitem=listitem,isFolder=False)
          x=x+1
        else:
          subtitle_list.append(json_data)
          return  Download_opensubtitle( item_data["IDSubtitleFile"],item_data["ZipDownloadLink"],item_data["SubFormat"],mode_subtitle),subtitle_list
          
          break
    return " ",subtitle_list
def Download_opensubtitle(id,url,format,mode_subtitle,stack=False):
  subtitle_list = []
  exts = [".srt", ".sub", ".txt", ".smi", ".ssa", ".ass" ]
  if stack:         ## we only want XMLRPC download if movie is not in stack,
                    ## you can only retreive multiple subs in zip
    result = False
  else:
    subtitle = os.path.join(__temp__, "%s.%s" %(str(uuid.uuid4()), format))
    try:
      result =OSDBServer().download(id, subtitle)
    except:
      log( __name__, "failed to connect to service for subtitle download")
      return subtitle_list
  if not result:
    log( __name__,"Download Using HTTP")
    zip = os.path.join( __temp__, "OpenSubtitles.zip")
    f = urllib.urlopen(url)
    with open(zip, "wb") as subFile:
      subFile.write(f.read())
    subFile.close()
    xbmc.sleep(500)
    xbmc.executebuiltin(('XBMC.Extract("%s","%s")' % (zip,__temp__,)).encode('utf-8'), True)
    for file in xbmcvfs.listdir(zip)[1]:
      file = os.path.join(__temp__, file)
      if (os.path.splitext( file )[1] in exts):
        subtitle_list.append(file)
  else:
    subtitle_list.append(subtitle)

  if xbmcvfs.exists(subtitle_list[0]):
    if mode_subtitle>1:
      return subtitle_list
    else:
      return subtitle_list[0]

      #xbmc.Player().setSubtitles(subtitle_list[0])
    