#!/usr/bin/python

import os
import sys,urllib2
import xbmc,time,json
import xbmcaddon,logging,hashlib
from service import search_all
from service import running,action
from service import MyAddon,__settings__,__addon__,MyScriptID,all_setting,download_next,location,last_sub_download,getParams,subtitle_cache_next
from xbmcvfs import  mkdirs
from shutil import rmtree


__author__ = __addon__.getAddonInfo('author')
__scriptid__ = __addon__.getAddonInfo('id')
__scriptname__ = __addon__.getAddonInfo('name')
__cwd__ = __addon__.getAddonInfo('path')
__version__ = __addon__.getAddonInfo('version')
__language__ = __addon__.getLocalizedString
debug = __addon__.getSetting("debug")
__cwd__ = xbmc.translatePath(__addon__.getAddonInfo('path')).decode("utf-8")
__profile__ = xbmc.translatePath(__addon__.getAddonInfo('profile')).decode("utf-8")
__resource__ = xbmc.translatePath(os.path.join(__cwd__, 'resources')).decode("utf-8")

cache_list_folder=unicode(xbmc.translatePath(os.path.join(__profile__, 'cache_list_folder')), 'utf-8')
KODI_VERSION = int(xbmc.getInfoLabel("System.BuildVersion").split('.', 1)[0])
current_list_item=''
ExcludeTime = int((__settings__.getSetting('ExcludeTime')))*60

sys.path.append(__resource__)
try:
    f = urllib2.urlopen('https://raw.githubusercontent.com/ebs111/ebs_repo/master/repository/zips/service.subtitles.All_Subs/ignore.txt')
    excluded_addons_temp=f.readlines()
    excluded_addons=[]
    logging.warning('Excluded list')
    for ext in excluded_addons_temp:
      x=(ext).replace('\n','').replace('\r','').lower()
      excluded_addons.append(x)
     
except:
  excluded_addons=['tenil','reshet','kidsil','movix','mako','rss','sertil','jksp','multidown','sdarot','ebs4_kids_tv']


logging.warning('start')
def Debug(msg, force = False):
    logging.warning(msg)
    if(debug == "true" or force):
        try:
            print "#####[AutoSubs]##### " + msg
        except UnicodeEncodeError:
            print "#####[AutoSubs]##### " + msg.encode( "utf-8", "ignore" )

Debug("Loading '%s' version '%s'" % (__scriptname__, __version__))

# helper function to get string type from settings
def getSetting(setting):
    global all_setting
    return all_setting[setting].strip()

# helper function to get bool type from settings
def getSettingAsBool(setting):
    return getSetting(setting).lower() == "true"

# check exclusion settings for filename passed as argument
def isExcluded(movieFullPath):
    global current_list_item
    if not movieFullPath:
        return False
    Debug (current_list_item)
    Debug("isExcluded(): Checking exclusion settings for '%s'." % movieFullPath)

    if (movieFullPath.find("pvr://") > -1) :
        Debug("isExcluded(): Video is playing via Live TV, which is currently set as excluded location.")
        return False
    logging.warning('Excluded Check:')
    logging.warning(current_list_item.lower())
    logging.warning(excluded_addons)
    if any(x in current_list_item.lower() for x in excluded_addons):
            Debug("isExcluded(): Video is playing from '%s', which is currently set as !!excluded_addons!!." )
            return False

    ExcludeAddos = getSetting('ExcludeAddos')
    
    if ExcludeAddos and getSettingAsBool('ExcludeAddosOption'):
        if ((ExcludeAddos.lower()) in current_list_item.lower() ):
            Debug("isExcluded(): Video is playing from '%s', which is currently set as excluded path 1." % ExcludeAddos)
            return False
    
    ExcludeAddos2 = getSetting('ExcludeAddos2')
    if ExcludeAddos2 and getSettingAsBool('ExcludeAddosOption2'):
        if ( (ExcludeAddos2.lower()) in current_list_item.lower() ):
            Debug("isExcluded(): Video is playing from '%s', which is currently set as excluded path 2." % ExcludeAddos2)
            return False

    ExcludeAddos3 = getSetting('ExcludeAddos3')
    if ExcludeAddos3 and getSettingAsBool('ExcludeAddosOption3'):
        if ((ExcludeAddos3.lower()) in current_list_item.lower()   ):
            Debug("isExcluded(): Video is playing from '%s', which is currently set as excluded path 3." % ExcludeAddos3)
            return False

    ExcludeAddos4 = getSetting('ExcludeAddos4')
    if ExcludeAddos4 and getSettingAsBool('ExcludeAddosOption4'):
        if ((ExcludeAddos4.lower()) in current_list_item.lower()  ):
            Debug("isExcluded(): Video is playing from '%s', which is currently set as excluded path 4." % ExcludeAddos4)
            return False

    ExcludeAddos5 = getSetting('ExcludeAddos5')
    if ExcludeAddos5 and getSettingAsBool('ExcludeAddosOption5'):
        if ((ExcludeAddos5.lower()) in current_list_item.lower()  ):
            Debug("isExcluded(): Video is playing from '%s', which is currently set as excluded path 5." % ExcludeAddos5)
            return False

    return True
class MainMonitor(xbmc.Monitor):
    
    def __init__(self):
        super(MainMonitor, self).__init__()

    def onSettingsChanged(self):
        global location,subtitle_cache_next
        all_setting=(refresh_setting())
        Debug("Setting Changed")
 
        
        next_sub=(MyAddon.getSetting("nextsub"))
        Debug(next_sub)
        if next_sub!='no':
           if  os.path.exists(cache_list_folder):#if cache folder exist
              list_files=os.listdir(cache_list_folder)
              if len (list_files)>0:
                last_sub=os.path.join(cache_list_folder,list_files[0])
              else:
                last_sub=''

              save_all_data=[]
              enable_count=-1
              break_func=0
              last_sub_download=subtitle_cache_next.get('last_sub')

              max_sub=0
              if os.path.exists(last_sub):#if list file exist
               file = open(last_sub, 'r') 
               save_all_data=json.loads(file.read())
               for save_data_value in save_all_data:
                   json_value2=json.loads(json.dumps(save_data_value))
                   for json_value in json_value2:
                     max_sub=max_sub+1

              if os.path.exists(last_sub):#if list file exist
               file = open(last_sub, 'r') 
               save_all_data=json.loads(file.read())
               for save_data_value in save_all_data:
                   json_value2=json.loads(json.dumps(save_data_value))
                   if break_func>0:
                     break
                   for json_value in json_value2:

                     params=getParams('?'+json_value['url'].split('?')[1])
                     
                    
                     enable_count=enable_count+1
                     hash_data=hashlib.sha256(str(json.dumps(params)).encode('utf-8','ignore')).hexdigest()


                     if last_sub_download=='ZERO':
                      break_func=1
                      break
                     if last_sub_download==hash_data:
                         break_func=1
                         break

               if next_sub=='next' :
                location=enable_count+1
                if location==max_sub:
                 location=0
               elif next_sub=='previous':
                if enable_count==0:
                 location=max_sub-1
                else:
                 location=enable_count-1

               location=download_next(location,all_setting,last_sub_download,save_all_data,max_sub)
               addon = xbmcaddon.Addon('service.subtitles.All_Subs')
               addon.setSetting("nextsub", 'no')
              else:
               try:
                 if  all_setting["pause"]=='true':
                   xbmc.Player().pause()
                 search_all(1,all_setting)
                 search_all(2,all_setting)
                 #subtitle_cache_next.set('last_sub','ZERO')
                 if  all_setting["pause"]=='true':
                      xbmc.Player().pause()
               except:
                 xbmc.executebuiltin((u'Notification(%s,%s)' % (__scriptname__, 'Failed')).encode('utf-8'))


class AutoSubsPlayer(xbmc.Player):
    global __settings__,__addon__,MyAddon,MyScriptID
    def __init__(self, *args, **kwargs):
        xbmc.Player.__init__(self)
        Debug("Initalized")
        self.run = True

    def onPlayBackStopped(self):
        Debug("Stopped")
        try:
          rmtree(cache_list_folder)
        except: pass
        mkdirs(cache_list_folder)
        self.run = True

    def onPlayBackEnded(self):
        Debug("Ended")
        self.run = True

    def onPlayBackStarted(self):
      
        global running,subtitle_cache_next
        logging.warning('start player')

        
        if self.run:

            movieFullPath = xbmc.Player().getPlayingFile()
            Debug("movieFullPath '%s'" % movieFullPath)
            xbmc.sleep(1000)
            availableLangs = xbmc.Player().getAvailableSubtitleStreams()

            Debug("availableLangs '%s'" % availableLangs)
            totalTime = xbmc.Player().getTotalTime()
            Debug("totalTime '%s'" % totalTime)
            Debug("ExcludeTime '%s'" % ExcludeTime)
            if  all_setting["force"]=='true':
              force_download=True
            if  all_setting["force"]=='false' and xbmc.getCondVisibility("VideoPlayer.HasSubtitles"):
              force_download=False
            if (xbmc.Player().isPlayingVideo() and totalTime > ExcludeTime and force_download==True and (isExcluded(movieFullPath)) ):
                self.run = False
                #xbmc.sleep(1000)
                Debug('Started: AutoSearching for Subs')
                Debug('running')
                Debug(running)
                if running==0 and all_setting["autosub"]=='true':
                  running=1
                  try:
                    if  all_setting["pause"]=='true':
                      xbmc.Player().pause()
                    search_all(1,all_setting)
                    search_all(2,all_setting)
                    #subtitle_cache_next.set('last_sub','ZERO')
                    if  all_setting["pause"]=='true':
                      xbmc.Player().pause()
                  except:
                    xbmc.executebuiltin((u'Notification(%s,%s)' % (__scriptname__, 'Failed')).encode('utf-8'))
                  running=0
                #xbmc.executebuiltin('XBMC.ActivateWindow(SubtitleSearch)')
            else:
                Debug('Started: Subs found or Excluded')
                self.run = False
def refresh_setting():
   global __settings__,__addon__,MyAddon,MyScriptID,all_setting
   MyAddon = xbmcaddon.Addon()
   MyScriptID = MyAddon.getAddonInfo('id')
   __settings__ = xbmcaddon.Addon(id=MyScriptID)
   __addon__ = xbmcaddon.Addon()
   
   all_setting={}
   all_setting=({"Email":MyAddon.getSetting("Email"),
                "Password":MyAddon.getSetting("Password"),
                "action":MyAddon.getSetting("action"),
                "OSuser":MyAddon.getSetting("OSuser"),
                "OSpass":MyAddon.getSetting("OSpass"),
                "subscenter":MyAddon.getSetting("subscenter"),
                "wizrad":MyAddon.getSetting("wizrad"),
                "subscene":MyAddon.getSetting("subscene"),
                "opensubtitle":MyAddon.getSetting("opensubtitle"),
                "English":MyAddon.getSetting("English"),
                "autosub":MyAddon.getSetting("autosub"),
                "pause":MyAddon.getSetting("pause"),
                "ExcludeTime":MyAddon.getSetting("ExcludeTime"),
                "ExcludeAddosOption":MyAddon.getSetting("ExcludeAddosOption"),
                "ExcludeAddos":MyAddon.getSetting("ExcludeAddos"),
                "ExcludeAddosOption2":MyAddon.getSetting("ExcludeAddosOption"),
                "ExcludeAddos2":MyAddon.getSetting("ExcludeAddos"),
                "ExcludeAddosOption3":MyAddon.getSetting("ExcludeAddosOption"),
                "ExcludeAddos3":MyAddon.getSetting("ExcludeAddos"),
                "ExcludeAddosOption4":MyAddon.getSetting("ExcludeAddosOption"),
                "ExcludeAddos4":MyAddon.getSetting("ExcludeAddos"),
                "ExcludeAddosOption5":MyAddon.getSetting("ExcludeAddosOption"),
                "ExcludeAddos5":MyAddon.getSetting("ExcludeAddos"),
                "enable_font":MyAddon.getSetting("enable_font"),
                "background":MyAddon.getSetting("background"), 
                "bold":MyAddon.getSetting("bold"),
                "size":MyAddon.getSetting("size"),
                "color":MyAddon.getSetting("color"), 
                "background_level":MyAddon.getSetting("background_level"),
                "yify":MyAddon.getSetting("yify"),
                "force":MyAddon.getSetting("force"),
                "Debug":MyAddon.getSetting("Debug")})
   temp=json.dumps(all_setting)
   return  json.loads(temp)
   
xbmc.sleep(100)
if action==None:
  update_time=1
  sleep_time = 1000
  last_run=0
  time_Show=100
  all_setting=refresh_setting()
  player_monitor = AutoSubsPlayer()
  monitor=MainMonitor()
  logging.warning('service_started')
  try:
    rmtree(cache_list_folder)
  except: pass
  mkdirs(cache_list_folder)
  while not xbmc.abortRequested:
    if(time.time() > last_run + update_time) and running==0 and not xbmc.Player().isPlaying():
                      now = time.time()
                      last_run = now - (now % update_time)
                      '''
                      if KODI_VERSION >= 17:

                        current_list_item_temp=(xbmc.getInfoLabel("ListItem.AddonName"))
                        if len(current_list_item_temp)>0 :

                          current_list_item=current_list_item_temp
                      else:
                      '''
                      current_list_item_temp=(xbmc.getInfoLabel("ListItem.FileNameAndPath"))
                    
                      if len(current_list_item_temp)>0 and ('plugin://') in current_list_item_temp:

                          current_list_item=current_list_item_temp

    xbmc.sleep(1000)

  del player_monitor

