#
#      Copyright (C) 2017 On-Tapp-Networks Limited
#

import xbmc
import xbmcaddon
import os
import re

import dixie

ADDONID = 'script.tvguidedixie'
ADDON   =  xbmcaddon.Addon(ADDONID)
HOME    =  ADDON.getAddonInfo('path')
PROFILE =  xbmc.translatePath(ADDON.getAddonInfo('profile'))


def mapLabel(labelmap, text):
    name = text.strip()
    for item in labelmap:
        if name.upper() == item[0].upper():
            # dixie.log('===== mapLabel match =====')
            # dixie.log(item[1].upper())
            return item[1].upper()
    # dixie.log('===== mapLabel name =====')
    # dixie.log(name)
    return name


def cleanLabel(name):
    # dixie.log('===== mappings =====')
    # dixie.log(name)
    name  = re.sub('\([0-9)]*\)', '', name)
    items = name.split(']')
    name  = ''

    for item in items:
        if len(item) == 0:
            continue

        item += ']'
        item  = re.sub('\[[^)]*\]', '', item)

        if len(item) > 0:
            name += item

    name = name.replace('[', '')
    name = name.replace(']', '')
    name = name.strip()

    while True:
        length = len(name)
        name = name.replace('  ', ' ')
        if length == len(name):
            break

    return name.strip()


def cleanPrefix(text):
    name     = text.strip()
    tmplabel = stripName(name)

    if 'HD.' in tmplabel:
        tmplabel = tmplabel.replace('HD.', 'HD')

    prefixes  = ['UK:', 'INT: ', 'LIVE ', 'UK l ', 'IN l ', 'DE l ', 'RAD l ', ' Local', 'USA/CA : ', 'USA/CA: ', 'CA: ','CA : ','CA ', 'UK : ', 'UK: ', 'UK | ', 'USA : ', 'USA :', 'USA: ', 'USA | ', 'USA ', 'US | ','US: ', ' -']
    viplabels = ['VIP', 'VIP: ', 'VIP : ', 'VIp : ', 'V.I.P : ']
    replacers = ['=', '>', '<' '@', ' | ', '|', '.', ' : ', ':', '     ', '    ', '   ', '  ']

    for prefix in prefixes:
        if prefix in tmplabel:
            tmplabel = tmplabel.replace(prefix, '')

    for item in viplabels:
        if item in tmplabel:
            tmplabel = tmplabel.replace(item, '')

    for item in replacers:
        if item in tmplabel:
            tmplabel = tmplabel.replace(item, ' ')

    tmplabel = tmplabel.replace(' ---------', '')

    return tmplabel.strip()


def mapChannelName(maps, text):
    name = text.strip().upper()
    for item in maps:
        if name == item[0]:
            # dixie.log('===== map match =====')
            # dixie.log(item[1])
            return item[1]
    # dixie.log('===== map name =====')
    # dixie.log(name)
    return name


def stripName(text):
    stripList = os.path.join(PROFILE, 'ini', 'strip.txt')

    if os.path.exists(stripList):
        with open(stripList) as f:
            names = f.read().splitlines()
            for name in names:
                if text == name:
                    fixed = text.replace('SKY ', '')
                    return fixed
    return text

