# coding: utf-8
import os
import shutil
import time

import xbmc
import xbmcgui


def get_old_files(dir_path, older_than_days):
    """
    return a list of all files under dir_path older than older_than_days
    :param dir_path directory
    :param older_than_days  days
    """
    older_than_days *= 86400  # convert days to seconds
    present = time.time()
    for root, dirs, files in os.walk(dir_path, topdown=False):
        for name in files:
            filename = os.path.join(root, name)
            if (present - os.path.getmtime(filename)) > older_than_days:
                yield filename


def get_setting(key, converter=str, choices=None):
    import xbmcaddon
    value = xbmcaddon.Addon().getSetting(id=key)
    if converter is str:
        return value
    elif converter is unicode:
        return value.decode('utf-8')
    elif converter is bool:
        return value == 'true'
    elif converter is int:
        return int(value)
    elif isinstance(choices, (list, tuple)):
        return choices[int(value)]
    else:
        raise TypeError('Acceptable converters are str, unicode, bool and '
                        'int. Acceptable choices are instances of list '
                        ' or tuple.')


folder_source = xbmc.translatePath(get_setting('folder_source'))
folder_destination = xbmc.translatePath(get_setting('folder_destination'))
older_than_days = get_setting('older_than_days', int)
if os.path.isdir(folder_source) and os.path.isdir(folder_destination):
    if xbmcgui.Dialog().yesno('Script', "Are you sure to move the files from %s?" % folder_source):
        for file_name in get_old_files(folder_source, older_than_days):
            shutil.move(file_name, folder_destination)
