# -*- coding: utf-8 -*-
__author__ = "DiMartino"
import re
import requests
import httplib
from kinopoisk.HTTP import *
from utilities import Debug, get_string_setting

USER_AGENT = 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_3) AppleWebKit/537.22 (KHTML, like Gecko) Chrome/25.0.1364.172 Safari/537.22'

class Rate():
    def __init__(self, rate, kpId):
        Debug("Init class Rate!")
        self.login = get_string_setting('login')
        self.password = get_string_setting('password')
        if self.login != '' and self.password != '':
            self.get_client()
        else:
            Debug("No login or password for Kinopoisk!")
            return

        self.kpId=kpId
        self.code, self.token=self.get_code()
        self.rate=rate


    def get_code(self):
        url = 'http://www.kinopoisk.ru/film/'+str(self.kpId)+'/'
        data = self.get_data(url)

        reobj = re.compile('user_code:\'(.+?)\',')
        code = reobj.findall(data)[0]
        reobj = re.compile('token = \'([a-f0-9]+)\';')
        token = reobj.findall(data)[0]
        return code, token

    def rateit(self):
        url = 'http://www.kinopoisk.ru/vote.php?film='+str(self.kpId)+'&film_vote='+str(self.rate)+'&c='+self.code
        data = self.get_data(url)
        if str(data)=='Ok':
            return True

    def moveit(self, folderid):
        if folderid:
            url = 'http://www.kinopoisk.ru/handler_mustsee_ajax.php?mode=add_film&id_film='+str(self.kpId)+'&to_folder='+str(folderid)+'&token='+self.token
            data = self.get_data(url)

    def get_data(self, url):
        if self.client:
            req = self.client.get(url, headers=self.headers)
            return req.text.encode("utf-8", "ignore")
        else:
            Debug('No client for Kinopoisk!', True)

    def get_client(self):
        self.headers = {
            'Connection': 'keep-alive',
            #'Content-Length': '37',
            'Origin': 'https://plus.kinopoisk.ru',
            'User-Agent': 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/53.0.2785.116 YaBrowser/16.10.0.2564 Yowser/2.5 Safari/537.36',
            'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8',
            'Accept': '*/*',
            'X-Requested-With': 'XMLHttpRequest',
            'Referer': 'https://plus.kinopoisk.ru/embed/login/?retPath=https%3A%2F%2Fwww.kinopoisk.ru%2F',
            'Accept-Language': 'ru,en;q=0.8',
        }

        data = {
            'login': self.login,
            'password': self.password
        }

        conn = httplib.HTTPSConnection("plus.kinopoisk.ru")
        conn.request("GET", "/")
        r1 = conn.getresponse()
        html = r1.read()
        getheaders = r1.getheaders()
        conn.close()

        match = re.search("csrf&quot;:&quot;(.+?)&quot;", html, re.DOTALL)
        if match:
            result = match.group(1)
            self.headers['X-CSRF-Token'] = result
            match2 = re.search("(csrftoken=.+?);", str(getheaders), re.DOTALL)
            Debug('Found X-CSRF-Token: %s' % result)
            if match2:
                self.headers['Cookie'] = match2.group(1)
                Debug('Found Cookie: %s' % match2.group(1))

                self.client = requests.session()
                url_login = 'https://plus.kinopoisk.ru/user/resolve-by-password/'
                r2 = self.client.post(url_login, data=data, headers=self.headers)
                cookies = r2.cookies.get_dict()

                Debug('cookies: %s' % str(cookies))
                Debug('Login text: %s' % r2.text)

            else:
                Debug('Failed to find Cookie', True)
        else:
            Debug('Failed to find X-CSRF-Token', True)
        return

