# coding: utf-8
# Name:        service.py
# Author:      Mancuniancol
# Created on:  28.11.2016
# Licence:     GPL v.3: http://www.gnu.org/copyleft/gpl.html
"""
Service module of Magnetic
"""
import datetime
import threading
from BaseHTTPServer import BaseHTTPRequestHandler
from BaseHTTPServer import HTTPServer
from SocketServer import ThreadingMixIn

import xbmc

from resources.lib import logger
from resources.lib import magnetic
from resources.lib.constants import MAGNETIC_SERVICE_HOST, MAGNETIC_SERVICE_PORT, ADDON_VERSION
from resources.lib.storage import Storage
from resources.lib.utils import clean_cache, timedelta_total_seconds
from resources.lib.video_info import Video


class ThreadedHTTPServer(ThreadingMixIn, HTTPServer):
    """
    Handle requests in a separate thread.
    """
    daemon_threads = True
    allow_reuse_address = True


# noinspection PyPep8Naming
class ParserHandler(BaseHTTPRequestHandler):
    def do_HEAD(self):
        self.send_response(200)
        self.send_header('Content-type', 'text/html')
        self.end_headers()

    # parser add-on callback to append results to response
    def do_POST(self):
        magnetic.process_parser(self)

    # Kodi call to get results
    def do_GET(self):
        magnetic.process_torrent(self) if "uri=" in self.path else magnetic.get_results(self)


if __name__ == '__main__':
    from BaseHTTPServer import HTTPServer

    server = ThreadedHTTPServer((MAGNETIC_SERVICE_HOST, MAGNETIC_SERVICE_PORT), ParserHandler)
    clean_cache()
    timer_storage = Storage.open('time', ttl=None)
    timer = timer_storage.get('time', datetime.datetime.now() - datetime.timedelta(seconds=86400))
    logger.info('')
    logger.info('                          _   _')
    logger.info(' _ __  __ _ __ _ _ _  ___| |_(_)__')
    logger.info("| '  \/ _' / _' | ' \/ -_)  _| / _|")
    logger.info('|_|_|_\__,_\__, |_||_\___|\__|_\__|')
    logger.info('          |___/')
    logger.info('')
    logger.info('Author: mancuniancol')
    logger.info('Version: %s' % ADDON_VERSION)
    logger.info('Magnetic service at ' + str(MAGNETIC_SERVICE_HOST) + ":" + str(MAGNETIC_SERVICE_PORT))
    logger.info('Last subscription update: %s' % timer)
    threading.Timer(0, server.serve_forever).start()
    while not xbmc.abortRequested:
        xbmc.sleep(1500)
        if timedelta_total_seconds(datetime.datetime.now() - timer) > 86400:
            Video.update_subscription()
            timer = datetime.datetime.now()
            timer_storage['time'] = timer
            timer_storage.sync()
            logger.info('Next update at %s' % str(timer))
    server.shutdown()
    timer_storage.close()
    logger.info("Exiting Magnetic service, Bye!")
