# coding: utf-8
# Name:        play.py
# Author:      Mancuniancol
# Created on:  28.11.2016
# Licence:     GPL v.3: http://www.gnu.org/copyleft/gpl.html
"""
Play a link from torrent or magnet
"""
from contextlib import closing
from urllib import quote_plus

import logger
from browser import get_links
from dialog_select import DialogSelect
from normalize import normalize_string
from storage import Storage
from utils import *


def play(uri):
    """
    Play a magnet or torrent
    :param uri: magnet or torrent to be played
    :type uri: str
    """
    plugin = get_setting('plugin')
    list_players = ['Quasar', 'Pulsar', 'KmediaTorrent', 'XBMCtorrent', 'Torrenter', 'YATP']
    if plugin not in list_players:
        selection = xbmcgui.Dialog().select(string(32133), list_players)
        if selection == -1:
            return

        plugin = list_players[selection]

    filename = get_links(uri)
    if not filename.startswith('magnet'):
        filename = "http://%s:%s?uri=%s" % (str(MAGNETIC_SERVICE_HOST), str(MAGNETIC_SERVICE_PORT),
                                            quote_plus(filename))
    uri_string = quote_plus(filename)
    logger.debug('Filename: %s' % filename)
    if plugin == 'Quasar':
        link = 'plugin://plugin.video.quasar/play?uri=%s' % uri_string

    elif plugin == 'Pulsar':
        link = 'plugin://plugin.video.pulsar/play?uri=%s' % uri_string

    elif plugin == 'KmediaTorrent':
        link = 'plugin://plugin.video.kmediatorrent/play/%s' % uri_string

    elif plugin == "Torrenter":
        link = 'plugin://plugin.video.torrenter/?action=playSTRM&url=' + uri_string

    elif plugin == "YATP":
        link = 'plugin://plugin.video.yatp/?action=play&torrent=' + uri_string

    else:
        link = 'plugin://plugin.video.xbmctorrent/play/%s' % uri_string

    # Play media
    magnetizer_storage = Storage.open("magnetizer")
    if 'info' in magnetizer_storage:
        info = magnetizer_storage['info']
        info['FileName'] = filename
        info['Path'] = filename
        list_item = xbmcgui.ListItem(info["Title"])
        list_item.setInfo('video', info)
        list_item.setProperty("IsPlayable", "true")
        xbmc.Player().play(link, list_item, False)
        # player.setSubtitles(MainURL + srt)
    else:
        xbmc.executebuiltin("PlayMedia(%s)" % link)

    # Erase the dialog
    xbmc.executebuiltin('Dialog.Close(all, true)')


def search(info=None):
    # Request data
    operation = info.get('search', '')
    query = info.get('title', '')
    title = quote_plus(query)
    imdb_id = info.get('imdb_id')
    payload = ''
    if operation == 'general':
        payload = '?search=general&imdb_id=%s&title=%s' % (imdb_id, title)

    elif operation == "movie":
        year = info.get('year', '')
        payload = '?search=movie&imdb_id=%s&title=%s&year=%s' % (imdb_id, title, year)

    elif operation == "episode":
        season = info.get('season', '')
        episode = info.get('episode', '')
        payload = '?search=episode&imdb_id=%s&title=%s&season=%s&episode=%s' % (imdb_id, title, season, episode)

    elif operation == "season":
        season = info.get('season', '')
        payload = '?search=episode&imdb_id=%s&title=%s&season=%s' % (imdb_id, title, season)

    # Erase dialogs
    xbmc.executebuiltin('Dialog.Close(all, true)')
    magnetic_url = "http://%s:%s" % (str(MAGNETIC_SERVICE_HOST), str(MAGNETIC_SERVICE_PORT))
    url = magnetic_url + payload
    logger.debug(url)
    results = dict()
    try:
        req = urllib2.Request(url, None)
        with closing(urllib2.urlopen(req, timeout=120)) as response:
            results = loads(response.read())

    except Exception as e:
        logger.error("Error trying to search %s: %s" % (url, repr(e)))

    items = results.get('magnets', [])
    if len(items) == 0:
        dialog = xbmcgui.Dialog()
        dialog.ok("Magnetic", string(32075))
        del dialog

    else:
        check_played(items)
        query = normalize_string(query)
        window = DialogSelect("DialogSelectResults.xml",
                              ADDON_PATH,
                              "Default",
                              title=string(32074) % (len(items), query),
                              items=items)
        window.doModal()
        selection = window.ret
        del window
        if selection > -1:
            played = Storage.open('played', ttl=60 * 24 * 30)
            key = 'info_hash' if len(items[selection]['info_hash']) > 0 else 'uri'
            played[items[selection][key]] = 'x'
            played.close()
            play(items[selection]['uri'])


def check_played(items=None):
    played = Storage.open('played', ttl=60 * 24 * 30)
    for item in items:
        key = 'info_hash' if len(item['info_hash']) > 0 else 'uri'
        if item[key] in played:
            item['played'] = 'true'

        else:
            item['played'] = 'false'

    played.close()
