# coding: utf-8
# Name:        main.py
# Author:      Mancuniancol
# Created on:  28.11.2016
# Licence:     GPL v.3: http://www.gnu.org/copyleft/gpl.html
"""
Main Menu Magnetic
"""
import sys
import xbmcaddon
import xbmcgui
import xbmcplugin
from os import path
from re import findall
from urlparse import parse_qsl

import resources.lib.utils as utils
from resources.lib.play import search
from resources.lib.storage import *

base_url = sys.argv[0]
add_on_handle = int(sys.argv[1])
args = dict(parse_qsl(sys.argv[2][1:]))

listing = []
speed_parsers = Storage.open("speed")

mode = args.get('mode', None)
imdb_id = args.get('imdb_id', None)
operation = args.get('search', None)
add_on_id = args.get('addonid', '')


# functions
def erase():
    """
    Erase cache with the parsers information
    """
    Storage.open("parsers").clear()
    utils.clean_cache()


# Mode Menu
if operation:
    # contextual menu - Magnetizer
    xbmcplugin.endOfDirectory(add_on_handle, True, False, False)
    search(info=args)

elif mode == 'add_library':
    utils.add_library(imdb_id)

elif mode == 'magnetizer':
    utils.magnetizer()

elif mode == 'parser':
    erase()
    xbmcaddon.Addon(add_on_id).openSettings()

elif mode == 'settings':
    erase()
    xbmcaddon.Addon().openSettings()

elif mode == 'clear_cache':
    erase()
    xbmcgui.Dialog().ok('Magnetic', utils.string(32076))

elif mode == 'copy':
    erase()
    path_folder = xbmcaddon.Addon(add_on_id).getAddonInfo('path')
    value = dict()  # it contains all the settings from xml file
    fileName = path.join(path_folder, "resources", "settings.xml")
    if path.isfile(fileName):
        with open(fileName, 'r') as fp:
            data = fp.read()

        for key in findall('id="(\w+)"', data):
            if 'url' not in key and 'separator' not in key:
                value[key] = xbmcaddon.Addon(add_on_id).getSetting(id=key)

        items = []
        for one_parser in utils.get_list_parsers():
            if one_parser['enabled']:
                items.append(one_parser['addonid'])

        items.remove(add_on_id)
        ret = xbmcgui.Dialog().select(utils.string(32077), [utils.string(32078)] + items + ['CANCEL'])
        list_copy = (items if ret == 0 else [items[ret - 1]])
        if ret != -1 and ret <= len(items):
            for key, val in value.items():
                if not key.endswith('_search') and 'read_magnet_link' not in key:
                    for one_parser in list_copy:
                        xbmcaddon.Addon(one_parser).setSetting(id=key, value=val)

            xbmcgui.Dialog().ok('Magnetic', utils.string(32078) % (add_on_id, '\n'.join(list_copy)))

elif mode == 'check':
    speed_parsers[add_on_id] = utils.check_parser(add_on_id)
    speed_parsers.close()
    xbmc.executebuiltin("Container.Refresh")

elif mode == 'check_all':
    from xbmcgui import Dialog

    dialog = Dialog()
    for one_parser in utils.get_list_parsers():
        if one_parser['enabled']:
            dialog.notification(one_parser['name'], utils.string(32093), one_parser['thumbnail'], 10000)
            speed_parsers[one_parser['addonid']] = utils.check_parser(one_parser['addonid'])
            speed_parsers.close()

    dialog.notification('Magnetic', utils.string(32094), time=50)
    del dialog
    xbmc.executebuiltin("Container.Refresh")

elif mode == 'check_group':
    erase()
    message = utils.check_group_parser()
    xbmcgui.Dialog().ok('Magnetic', utils.string(32095) % message)

elif mode == 'enable':
    erase()
    utils.enable_parser(add_on_id)
    xbmc.executebuiltin("Container.Refresh")

elif mode == 'disable':
    erase()
    utils.disable_parser(add_on_id)
    xbmc.executebuiltin("Container.Refresh")

elif mode == 'enable_all':
    erase()
    for one_parser in utils.get_list_parsers():
        utils.enable_parser(one_parser['addonid'])

    xbmc.executebuiltin("Container.Refresh")

elif mode == 'disable_all':
    for one_parser in utils.get_list_parsers():
        utils.disable_parser(one_parser['addonid'])
    xbmc.executebuiltin("Container.Refresh")

elif mode == 'defaults_all':
    import shutil
    import os.path

    erase()
    base_path = xbmc.translatePath('special://userdata/addon_data')
    for one_parser in utils.get_list_parsers():
        folder = path.join(base_path, one_parser['addonid'])
        if os.path.isfile(folder):
            shutil.rmtree(folder)

    xbmcgui.Dialog().ok('Magnetic', utils.string(32096))

if not mode:
    # creation menu
    for one_parser in utils.get_list_parsers():
        name_parser = one_parser['name']  # gets name
        tag = '[B][COLOR FF008542][%s] [/COLOR][/B]' % utils.string(32090)
        menu_check = [(utils.string(32082), 'XBMC.RunPlugin(plugin://script.module.magnetic?mode=check&addonid=%s)' %
                       one_parser['addonid'])]
        menu_enable = (utils.string(32081), 'XBMC.RunPlugin(plugin://script.module.magnetic?mode=disable&addonid=%s)' %
                       one_parser['addonid'])

        if not one_parser['enabled']:
            tag = '[B][COLOR FFC40401][%s] [/COLOR][/B]' % utils.string(32091)
            menu_enable = (utils.string(32080),
                           'XBMC.RunPlugin(plugin://script.module.magnetic?mode=enable&addonid=%s)' %
                           one_parser['addonid'])
            menu_check = []

        speed = speed_parsers.get(one_parser['addonid'], '')
        list_item = xbmcgui.ListItem(label=tag + name_parser + speed)
        icon = one_parser["thumbnail"]
        fanart = one_parser["fanart"]
        list_item.setArt({'thumb': icon,
                          'icon': icon,
                          'fanart': fanart})

        if one_parser['enabled']:
            url = base_url + '?mode=parser&addonid=%s' % one_parser['addonid']

        else:
            url = ''
        is_folder = False
        list_item.addContextMenuItems(menu_check +
                                      [(utils.string(32083),
                                        'XBMC.RunPlugin(plugin://script.module.magnetic?mode=check_all)'),
                                       (utils.string(32084),
                                        'XBMC.RunPlugin(plugin://script.module.magnetic?mode=check_group)'),
                                       menu_enable,
                                       (utils.string(32085),
                                        'XBMC.RunPlugin(plugin://script.module.magnetic?mode=enable_all)'),
                                       (utils.string(32086),
                                        'XBMC.RunPlugin(plugin://script.module.magnetic?mode=disable_all)'),
                                       (utils.string(32087),
                                        'XBMC.RunPlugin(plugin://script.module.magnetic?mode=copy&addonid=%s)' %
                                        one_parser['addonid']),
                                       (utils.string(32088),
                                        'XBMC.RunPlugin(plugin://script.module.magnetic?mode=defaults_all)'),
                                       (utils.string(32089),
                                        'XBMC.RunPlugin(plugin://script.module.magnetic?mode=settings)')],
                                      replaceItems=True)
        listing.append((url, list_item, is_folder))

    xbmcplugin.addDirectoryItems(add_on_handle, listing, len(listing))
    xbmcplugin.addSortMethod(add_on_handle, xbmcplugin.SORT_METHOD_LABEL_IGNORE_THE)
    xbmcplugin.endOfDirectory(add_on_handle, updateListing=True)

del speed_parsers
