# coding: utf-8

import re
import sys
import xbmc
from urllib import quote_plus

from resources.lib.storage import Storage


def main():
    try:
        title = xbmc.getInfoLabel("ListItem.OriginalTitle")
        if len(title) == 0 and hasattr(sys, 'listitem'):
            title = sys.listitem.getLabel()

        title = re.sub('\[.*?\]', '', title).replace('(', '').replace(')', '')
        # erase year
        value = title + ' 0000 '  # checking year
        s_year = re.search(' [0-9][0-9][0-9][0-9] ', value)
        year = s_year.group(0).strip()
        pos = value.find(year)
        if pos > 0:
            title = value[:pos].strip()
            rest = value[pos + 5:].strip().replace('0000', '')
        else:
            title = value.replace('0000', '')
            rest = ''

        imdb_id = xbmc.getInfoLabel("ListItem.IMDBNumber")
        year = xbmc.getInfoLabel("ListItem.Year")
        if len(year) == 0:
            year = rest
        tv_show_title = xbmc.getInfoLabel("ListItem.TVShowTitle")
        season = xbmc.getInfoLabel("ListItem.Season")
        episode = xbmc.getInfoLabel("ListItem.Episode")
        # info_labels
        info = {'Title': title,
                'Label': xbmc.getInfoLabel("ListItem.Title"),
                'Label2': xbmc.getInfoLabel("ListItem.Label2"),
                'OriginalTitle': xbmc.getInfoLabel("ListItem.OriginalTitle"),
                'Year': year,
                'code': imdb_id,
                'TVShowTitle': tv_show_title,
                'Episode': episode,
                'EpisodeName': xbmc.getInfoLabel("ListItem.EpisodeName"),
                'Season': season,
                'FileName': '',
                'DBTYPE': xbmc.getInfoLabel("ListItem.DBTYPE"),
                'DBID': xbmc.getInfoLabel("ListItem.DBID"),
                'Tag': xbmc.getInfoLabel("ListItem.Tag"),
                'Tagline': xbmc.getInfoLabel("ListItem.Tagline"),
                'PlotOutline': xbmc.getInfoLabel("ListItem.PlotOutline"),
                'Plot': xbmc.getInfoLabel("ListItem.Plot"),
                'Genre': xbmc.getInfoLabel("ListItem.Genre"),
                'Director': xbmc.getInfoLabel("ListItem.Director"),
                'Writer': xbmc.getInfoLabel("ListItem.Writer"),
                'Thumb': xbmc.getInfoLabel("ListItem.Thumb"),
                'Icon': xbmc.getInfoLabel("ListItem.Icon"),
                }
        # Episode
        if len(tv_show_title) > 0 and len(season) > 0 and len(episode) > 0:
            info['Title'] = info['Label'] = tv_show_title
            payload = '?search=episode&imdb_id=%s&title=%s&season=%s&episode=%s' % (
                info['code'], quote_plus(tv_show_title), season, episode)

        # Season            
        elif len(tv_show_title) > 0 and len(season) > 0:
            info['Title'] = info['Label'] = tv_show_title
            payload = '?search=episode&imdb_id=%s&title=%s&season=%s' % (
                info['code'], quote_plus(tv_show_title), season)

        # Movie            
        elif xbmc.getCondVisibility("Container.Content(movies)"):
            payload = '?search=movie&imdb_id=%s&title=%s&year=%s' % (info['code'], quote_plus(title), year)

        # General
        else:
            payload = '?search=general&imdb_id=%s&title=%s' % (info['code'], quote_plus(title))

        # Save the info_labels
        magnetizer = Storage.open("magnetizer")
        magnetizer['info'] = info
        magnetizer.close()

        # Send the information to magnetic
        xbmc.executebuiltin("XBMC.RunPlugin(plugin://script.module.magnetic%s)" % payload)

    except Exception as e:
        print 'Error contextual menu Magnetizer: %s' % repr(e)


if __name__ == '__main__':
    main()
