# coding: utf-8
from provider import *

__author__ = 'mancuniancol'


def extract_torrents(html=None):
    if html is not None:
        dom = Html().feed(html)
        for item in dom.find_once('table', ('class', 'bordered'), order=2).find_all('tr'):
            name = item(tag='a')
            cm = 0
            serial = ''
            for i in item(tag='a', attribute='href').split('/'):
                serial = i
                cm += 1
                if cm == 3:
                    break
            magnet = '%s/down/%s.torrent' % (Settings.url, serial)
            size = item.find_once('td', ('class', 's'))()
            seeds = item.find_once('td', ('class', 'u'))()
            peers = item.find_once('td', ('class', 'd'))()
            yield (name, '', magnet, size, seeds, peers)  # name, info_hash, magnet, size, seeds, peers


def search(info):
    Filtering.use_general(info)
    return process(generator=extract_torrents)


def search_movie(info):
    Filtering.use_movie(info)
    return process(generator=extract_torrents)


def search_episode(info):
    if info['absolute_number'] == 0:
        Filtering.use_tv(info)
    else:
        Filtering.use_anime(info)
    return process(generator=extract_torrents)


def search_season(info):
    Filtering.use_season(info)
    return process(generator=extract_torrents)


# This registers your module for use
register(search, search_movie, search_episode, search_season)
