# coding: utf-8
from provider import *

__author__ = 'mancuniancol'

# Gets the token
Browser.open("%s/pubapi_v2.php?get_token=get_token&app_id=script.magnetic.rarbg-mc" % Settings.url)
items = parse_json(Browser.content)


def extract_torrents(html):
    links = parse_json(html)
    logger.log.debug(links)
    if "error" not in links:
        for link in links.get("torrent_results", []):
            name = link["filename"]  # name
            magnet = link["download"]  # magnet
            yield (name, "", magnet, None, 0, 0)  # name, info_hash, magnet, size, seeds, peers


def search(info):
    Filtering.use_general(info)
    Filtering.get_data = dict(mode='search',
                              search_string='QUERY',
                              app_id='script.magnetic.rarbg-mc',
                              token=items["token"])
    return process(generator=extract_torrents)


def search_movie(info):
    Filtering.use_movie(info)
    Filtering.get_data = dict(mode='search',
                              search_string='QUERY',
                              app_id='script.magnetic.rarbg-mc',
                              token=items["token"])
    return process(generator=extract_torrents)


def search_episode(info):
    if info['absolute_number'] == 0:
        Filtering.use_tv(info)
    else:
        Filtering.use_anime(info)
    Filtering.get_data = dict(mode='search',
                              search_string='QUERY',
                              app_id='script.magnetic.rarbg-mc',
                              token=items["token"])
    return process(generator=extract_torrents)


def search_season(info):
    return []


# This registers your module for use
register(search, search_movie, search_episode, search_season)
