# coding: utf-8
from provider import *

__author__ = 'mancuniancol'


def extract_torrents(html=None):
    if html is not None:
        dom = Html().feed(html)
        for elem in dom.find_all('tr', ('class', "tlistrow")):
            columns = elem.find_all('td')
            if len(columns) == 8:
                name = columns[1]()  # name
                magnet = columns[2](tag='a', attribute="href").replace('//www', 'http://www')  # magnet
                size = columns[3]()  # size
                seeds = columns[4]()  # seeds
                peers = columns[5]()  # peers
                yield (name, "", magnet, size, seeds, peers)  # name, info_hash, magnet, size, seeds, peers


def search(info):
    Filtering.use_general(info)
    return process(generator=extract_torrents)


def search_movie(info):
    Filtering.use_movie(info)
    return process(generator=extract_torrents)


def search_episode(info):
    if info['absolute_number'] == 0:
        Filtering.use_tv(info)
    else:
        Filtering.use_anime(info)
    return process(generator=extract_torrents)


def search_season(info):
    Filtering.use_season(info)
    return process(generator=extract_torrents)


# This registers your module for use
register(search, search_movie, search_episode, search_season)
