from boto3.dynamodb.conditions import Key, Attr
from tinydb import TinyDB, where

import boto3
import htpcsolutions.debug as debug
import htpcsolutions.parameters as parameters
import htpcsolutions.settings as settings
import htpcsolutions.ui as ui
import os
import subprocess
import xbmc, xbmcaddon, xbmcgui

####################################################################################################

db_file = xbmc.translatePath( settings.get('database.local') % ( xbmcaddon.Addon().getAddonInfo('id') ) )

####################################################################################################

if not os.path.isdir(os.path.dirname(db_file)):
	os.makedirs(os.path.dirname(db_file))

####################################################################################################

addon = xbmcaddon.Addon()
db = TinyDB(db_file)
commands = db.table("commands")

####################################################################################################

session = boto3.session.Session(
	aws_access_key_id = 'AKIAJHZD2C7DFJQMBLKQ',
	aws_secret_access_key = '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',
	region_name = 'eu-west-1'
)

dynamodb = session.resource('dynamodb')

####################################################################################################

def list_main(**kwargs):

	name = kwargs.get('name', None)
	value = kwargs.get('value', None)

	categories = []

	for c in commands.all():
		if c['category'] not in categories:
			ui.add(
				c["category"], "commands", None, image=None, isFolder=True, params = {
					'category': c["category"] 
				}
			)
			categories.append(c["category"] )

	ui.add("Update", "update", None, image=None, isFolder=False)
	ui.end()

def list_commands():

	if parameters.has("category"):
		cmds = commands.search(
			where('category') == parameters.get("category")
		)
	else:
		cmds = commands.all()

	for c in cmds:
		ui.add(
			c["name"], "launch", None, image=None, isFolder=False, params = dict(c)
		)
	ui.end()

def launch():

	if parameters.has("pin") and parameters.get("pin") != 'None':

		if not parameters.get("pin") == xbmcgui.Dialog().input('Enter PIN Number', type=xbmcgui.INPUT_ALPHANUM, option=xbmcgui.ALPHANUM_HIDE_INPUT):
			debug.notify("Incorrect PIN Number")
			return
	
	if not os.path.isfile(parameters.get("command")):
		debug.notify("Command file not found")
		return

	arguments = [
		parameters.get("command")
	]

	if parameters.has('parameters') and parameters.get('parameters') != None:
		arguments.extend([
			parameters.get('parameters')
		])

	subprocess.call(arguments, shell=False)

def update():

	debug.notice("Performing Update")

	response = dynamodb.Table("Commands").query(
		IndexName = "OS-index",
		KeyConditionExpression = Key('OS').eq('Win')
	)
	meta = response['ResponseMetadata']
	
	if (meta['HTTPStatusCode'] == 200) and (response['Count'] > 0):
		commands.remove()
		for i in response['Items']:
			
			if i['Pin'] != None:
				i['Pin'] = int(i['Pin'])

			commands.insert({
				'category': i['Category'],
				'id': int(i['Id']),
				'name': i['Name'],
				'command': i['Command'],
				'parameters': i['Parameters'],
				'pin': i['Pin']
			})

		debug.notify("Successfully updated command list.")
	else:
		debug.notify("Failed to retrieve update command list.")


####################################################################################################

if __name__ == "__main__":
	
	if parameters.count() < 1:
		list_main()
		
	elif parameters.has("mode") and parameters.has("action"):	

		mode = parameters.get("mode")
		action = parameters.get("action")

		if mode == "commands":
			list_commands()
		elif mode == "launch":
			launch()
		elif mode == "update":
			update()

	else:
		ui.end(False)
