SET autocommit=0;

START TRANSACTION;

CREATE TABLE IF NOT EXISTS `lists` (
	`id` int(11) NOT NULL AUTO_INCREMENT,
	`list` VARCHAR(125) NULL, 
	`slug` VARCHAR(125) NULL, 
	`media` VARCHAR(10) NULL, 
	`sync` TINYINT(1) DEFAULT 1, 
	PRIMARY KEY (`id`), 
	UNIQUE INDEX `slug_UNIQUE` (`slug`, `media` ASC)
);

CREATE TABLE IF NOT EXISTS `list_movies`(
	`id` int(11) NOT NULL AUTO_INCREMENT,
	`list_id` int(11) NOT NULL, 
	`imdb_id` VARCHAR(15) NULL, 
	`path` VARCHAR(255) NULL, 
	PRIMARY KEY (`id`)
);

CREATE TABLE IF NOT EXISTS `hosts` (
	`id` INT NOT NULL AUTO_INCREMENT, 
	`host` VARCHAR(75) NULL, 
	`title` VARCHAR(75) NULL, 
	`enabled` TINYINT NULL DEFAULT 1, 
	PRIMARY KEY (`id`), 
	UNIQUE INDEX `host_UNIQUE` (`host` ASC)
);

CREATE TABLE IF NOT EXISTS `fetch_count` (
	`id` int(11) NOT NULL AUTO_INCREMENT, 
	`num` int(11) DEFAULT NULL, 
	`ts` date DEFAULT NULL, 
	PRIMARY KEY (`id`), 
	UNIQUE KEY `ts_UNIQUE` (`ts`)
);

COMMIT;

SET autocommit=1;


