# File: class_defs.py
# Library: DOPAL - DO Python Azureus Library
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details ( see the COPYING file ).
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

'''
Defines all constants, variables and methods available on classes in Azureus's
plugin API.

Not all classes are defined here are mentioned in this API documentation
(simply because too much documentation will be generated).

For each class that DOPAL has explicit support for, there will be a class
defined here which contains the class information. The list of classes
supported in this version is described in L{classes}.

For each class that we support, there will be a class in this module with the
same name with the suffix of "DataType". It will have a C{get_xml_type} method
defined on the class. It may have some of the following attributes on the
class:
  - A C{__az_methods__} attribute (which will be a L{AzureusMethods}
    instance) - defining what methods we support. These correlate to the
    methods defined on each class.
  - A C{__az_constants__} attribute (which will be a dictionary) - defining
    what class constants are defined. These correlate to the constants on
    the class.
  - A C{__az_attributes__} attribute (which will be a dictionary) - defining
    what attributes will be on the object. These attributes are unique to the
    XML/HTTP plugin. The plugin defines certain precalculated 'attributes' when
    returning the data for a given object, by invoking certain methods on the
    object. This saves the client making multiple calls on an object to
    retrieve certain pieces of information, by calculating it and returning it
    all in one go.

If you are interested to know what methods are available on each classes, then
please look at Azureus's own
U{Javadoc API documentation<http://azureus.sourceforge.net/plugins/docCVS/>}.

The meta-attributes for these classes are defined by the XML/HTTP plugin - you
can find their definitions in the
U{GenericRPAttributes.java<http://cvs.sourceforge.net/viewcvs.py/azureus/azureus2/org/gudy/azureus2/pluginsimpl/remote/GenericRPAttributes.java?view=markup>}
source file.
'''

#
# The contents of this module are automatically generated by
# class_defs_make.py.
#

from dopal.aztypes import AzMethod as _method
from dopal.aztypes import AzureusMethods


# ------------------------------------------------------------------------------
#
# Classes for package:
#     org.gudy.azureus2.plugins
#
#------------------------------------------------------------------------------

class LaunchablePluginDataType:
    def get_xml_type():
        return "LaunchablePlugin"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('initialize', ['PluginInterface']),
        _method('process', [], 'boolean'),
        _method('setDefaults', ['String[]']),
    ])


class PluginDataType:
    def get_xml_type():
        return "Plugin"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('initialize', ['PluginInterface']),
    ])


class PluginConfigDataType:
    def get_xml_type():
        return "PluginConfig"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'CORE_PARAM_BOOLEAN_FRIENDLY_HASH_CHECKING': "CORE_PARAM_BOOLEAN_FRIENDLY_HASH_CHECKING",
        'CORE_PARAM_BOOLEAN_MAX_ACTIVE_SEEDING': "Max Active Torrents When Only Seeding Enabled",
        'CORE_PARAM_BOOLEAN_MAX_UPLOAD_SPEED_SEEDING': "Max Upload Speed When Only Seeding Enabled",
        'CORE_PARAM_BOOLEAN_NEW_SEEDS_START_AT_TOP': "Newly Seeding Torrents Get First Priority",
        'CORE_PARAM_BOOLEAN_SOCKS_PROXY_NO_INWARD_CONNECTION': "SOCKS Proxy No Inward Connection",
        'CORE_PARAM_INT_MAX_ACTIVE': "Max Active Torrents",
        'CORE_PARAM_INT_MAX_ACTIVE_SEEDING': "Max Active Torrents When Only Seeding",
        'CORE_PARAM_INT_MAX_CONNECTIONS_GLOBAL': "Max Connections Global",
        'CORE_PARAM_INT_MAX_CONNECTIONS_PER_TORRENT': "Max Connections Per Torrent",
        'CORE_PARAM_INT_MAX_DOWNLOAD_SPEED_KBYTES_PER_SEC': "Max Download Speed KBs",
        'CORE_PARAM_INT_MAX_DOWNLOADS': "Max Downloads",
        'CORE_PARAM_INT_MAX_UPLOAD_SPEED_KBYTES_PER_SEC': "Max Upload Speed KBs",
        'CORE_PARAM_INT_MAX_UPLOAD_SPEED_SEEDING_KBYTES_PER_SEC': "Max Upload Speed When Only Seeding KBs",
        'CORE_PARAM_INT_MAX_UPLOADS': "Max Uploads",
        'CORE_PARAM_INT_MAX_UPLOADS_SEEDING': "Max Uploads Seeding",
        'CORE_PARAM_STRING_LOCAL_BIND_IP': "CORE_PARAM_STRING_LOCAL_BIND_IP",
    }

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   List getPluginListParameter(String, List)
    #   Map getPluginMapParameter(String, Map)
    #   void setPluginListParameter(String, List)
    #   void setPluginMapParameter(String, Map)
    #   
    __az_methods__ = AzureusMethods([
        _method('addListener', ['PluginConfigListener']),
        _method('getBooleanParameter', ['String', 'boolean'], 'boolean'),
        _method('getBooleanParameter', ['String'], 'boolean'),
        _method('getByteParameter', ['String', 'byte[]'], 'byte[]'),
        _method('getFloatParameter', ['String'], 'float'),
        _method('getIntParameter', ['String'], 'int'),
        _method('getIntParameter', ['String', 'int'], 'int'),
        _method('getParameter', ['String'], 'ConfigParameter'),
        _method('getPluginBooleanParameter', ['String', 'boolean'], 'boolean'),
        _method('getPluginBooleanParameter', ['String'], 'boolean'),
        _method('getPluginByteParameter', ['String', 'byte[]'], 'byte[]'),
        _method('getPluginConfigKeyPrefix', [], 'String'),
        _method('getPluginIntParameter', ['String'], 'int'),
        _method('getPluginIntParameter', ['String', 'int'], 'int'),
        _method('getPluginParameter', ['String'], 'ConfigParameter'),
        _method('getPluginStringParameter', ['String'], 'String'),
        _method('getPluginStringParameter', ['String', 'String'], 'String'),
        _method('getPluginUserFile', ['String'], 'File'),
        _method('getStringParameter', ['String'], 'String'),
        _method('getStringParameter', ['String', 'String'], 'String'),
        _method('save'),
        _method('setBooleanParameter', ['String', 'boolean']),
        _method('setIntParameter', ['String', 'int']),
        _method('setPluginParameter', ['String', 'byte[]']),
        _method('setPluginParameter', ['String', 'int']),
        _method('setPluginParameter', ['String', 'String']),
        _method('setPluginParameter', ['String', 'boolean']),
    ])

    # 
    # The following constants are not defined here, because their types
    # are not available in DOPAL:
    # 
    #   "cached_property_values" (has type "java.lang.Object[])"
    #   
    __az_attributes__ = {
        'cached_property_names': 'String[]',
    }


class PluginConfigListenerDataType:
    def get_xml_type():
        return "PluginConfigListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('configSaved'),
    ])


class PluginEventDataType:
    def get_xml_type():
        return "PluginEvent"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'PEV_CONFIGURATION_WIZARD_COMPLETES': 2,
        'PEV_CONFIGURATION_WIZARD_STARTS': 1,
        'PEV_FIRST_USER_EVENT': 1024,
        'PEV_INITIALISATION_PROGRESS_PERCENT': 4,
        'PEV_INITIALISATION_PROGRESS_TASK': 3,
    }

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   Object getValue()
    #   
    __az_methods__ = AzureusMethods([
        _method('getType', [], 'int'),
    ])


class PluginEventListenerDataType:
    def get_xml_type():
        return "PluginEventListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('handleEvent', ['PluginEvent']),
    ])


class PluginInterfaceDataType:
    def get_xml_type():
        return "PluginInterface"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   void addView(PluginView)
    #   PluginInterface getLocalPluginInterface(Class, String)
    #   ClassLoader getPluginClassLoader()
    #   Properties getPluginProperties()
    #   
    __az_methods__ = AzureusMethods([
        _method('addColumnToMyTorrentsTable', ['String', 'PluginMyTorrentsItemFactory']),
        _method('addColumnToPeersTable', ['String', 'PluginPeerItemFactory']),
        _method('addConfigSection', ['ConfigSection']),
        _method('addConfigUIParameters', ['Parameter[]', 'String']),
        _method('addEventListener', ['PluginEventListener']),
        _method('addListener', ['PluginListener']),
        _method('firePluginEvent', ['PluginEvent']),
        _method('getAzureusName', [], 'String'),
        _method('getAzureusVersion', [], 'String'),
        _method('getClientIDManager', [], 'ClientIDManager'),
        _method('getConnectionManager', [], 'ConnectionManager'),
        _method('getDistributedDatabase', [], 'DistributedDatabase'),
        _method('getDownloadManager', [], 'DownloadManager'),
        _method('getIPC', [], 'IPCInterface'),
        _method('getIPFilter', [], 'IPFilter'),
        _method('getLogger', [], 'Logger'),
        _method('getMessageManager', [], 'MessageManager'),
        _method('getPeerProtocolManager', [], 'PeerProtocolManager'),
        _method('getPlatformManager', [], 'PlatformManager'),
        _method('getPlugin', [], 'Plugin'),
        _method('getPluginconfig', [], 'PluginConfig'),
        _method('getPluginConfigUIFactory', [], 'PluginConfigUIFactory'),
        _method('getPluginDirectoryName', [], 'String'),
        _method('getPluginID', [], 'String'),
        _method('getPluginManager', [], 'PluginManager'),
        _method('getPluginName', [], 'String'),
        _method('getPluginVersion', [], 'String'),
        _method('getShareManager', [], 'ShareManager'),
        _method('getShortCuts', [], 'ShortCuts'),
        _method('getTorrentManager', [], 'TorrentManager'),
        _method('getTracker', [], 'Tracker'),
        _method('getUIManager', [], 'UIManager'),
        _method('getUpdateManager', [], 'UpdateManager'),
        _method('getUtilities', [], 'Utilities'),
        _method('isBuiltIn', [], 'boolean'),
        _method('isDisabled', [], 'boolean'),
        _method('isMandatory', [], 'boolean'),
        _method('isOperational', [], 'boolean'),
        _method('isUnloadable', [], 'boolean'),
        _method('openTorrentFile', ['String']),
        _method('openTorrentURL', ['String']),
        _method('reload'),
        _method('removeConfigSection', ['ConfigSection']),
        _method('removeEventListener', ['PluginEventListener']),
        _method('removeListener', ['PluginListener']),
        _method('setDisabled', ['boolean']),
        _method('uninstall'),
        _method('unload'),
    ])

    __az_attributes__ = {
        'azureus_name': 'String',
        'azureus_version': 'String',
        'plugin_id': 'String',
        'plugin_name': 'String',
    }


class PluginListenerDataType:
    def get_xml_type():
        return "PluginListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('closedownComplete'),
        _method('closedownInitiated'),
        _method('initializationComplete'),
    ])


class PluginManagerDataType:
    def get_xml_type():
        return "PluginManager"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'PR_MULTI_INSTANCE': "MULTI_INSTANCE",
        'UI_NONE': 0,
        'UI_SWT': 1,
    }

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   boolean equals(Object)
    #   Class getClass()
    #   PluginInterface getPluginInterfaceByClass(Class)
    #   void registerPlugin(Class)
    #   PluginManager startAzureus(int, Properties)
    #   
    __az_methods__ = AzureusMethods([
        _method('firePluginEvent', ['int']),
        _method('getDefaultPluginInterface', [], 'PluginInterface'),
        _method('getDefaults', [], 'PluginManagerDefaults'),
        _method('getPluginInstaller', [], 'PluginInstaller'),
        _method('getPluginInterfaceByClass', ['String'], 'PluginInterface'),
        _method('getPluginInterfaceByID', ['String'], 'PluginInterface'),
        _method('getPluginInterfaces', [], 'PluginInterface[]'),
        _method('getPlugins', [], 'PluginInterface[]'),
        _method('hashCode', [], 'int'),
        _method('notify'),
        _method('notifyAll'),
        _method('refreshPluginList'),
        _method('registerPlugin', ['Plugin', 'String']),
        _method('restartAzureus'),
        _method('stopAzureus'),
        _method('toString', [], 'String'),
        _method('wait', ['long', 'int']),
        _method('wait'),
        _method('wait', ['long']),
    ])


class PluginManagerArgumentHandlerDataType:
    def get_xml_type():
        return "PluginManagerArgumentHandler"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('processArguments', ['String[]']),
    ])


class PluginManagerDefaultsDataType:
    def get_xml_type():
        return "PluginManagerDefaults"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'PID_CLIENT_ID': "Client ID",
        'PID_CORE_PATCH_CHECKER': "Core Patch Checker",
        'PID_CORE_UPDATE_CHECKER': "Core Update Checker",
        'PID_DEFAULT_TRACKER_WEB': "Default Tracker Web",
        'PID_DHT': "DHT",
        'PID_DHT_TRACKER': "DHT Tracker",
        'PID_EXTERNAL_SEED': "External Seed",
        'PID_JPC': "JPC",
        'PID_LOCAL_TRACKER': "Local Tracker",
        'PID_MAGNET': "Magnet URI Handler",
        'PID_PLATFORM_CHECKER': "Platform Checker",
        'PID_PLUGIN_UPDATE_CHECKER': "Plugin Update Checker",
        'PID_REMOVE_RULES': "Torrent Removal Rules",
        'PID_SHARE_HOSTER': "Share Hoster",
        'PID_START_STOP_RULES': "Start/Stop Rules",
        'PID_UPNP': "UPnP",
        'PLUGIN_IDS': [
            "Start/Stop Rules",
            "Torrent Removal Rules",
            "Share Hoster",
            "Default Tracker Web",
            "Core Update Checker",
            "Core Patch Checker",
            "Platform Checker",
            "UPnP",
            "Client ID",
            "DHT",
            "DHT Tracker",
            "Magnet URI Handler",
            "JPC",
            "External Seed",
            "Local Tracker",
        ],
    }

    __az_methods__ = AzureusMethods([
        _method('getApplicationEntryPoint', [], 'String'),
        _method('getApplicationIdentifier', [], 'String'),
        _method('getApplicationName', [], 'String'),
        _method('getDefaultPlugins', [], 'String[]'),
        _method('isDefaultPluginEnabled', ['String'], 'boolean'),
        _method('setApplicationEntryPoint', ['String']),
        _method('setApplicationIdentifier', ['String']),
        _method('setApplicationName', ['String']),
        _method('setDefaultPluginEnabled', ['String', 'boolean']),
        _method('setSingleInstanceHandler', ['int', 'PluginManagerArgumentHandler']),
    ])


class UnloadablePluginDataType:
    def get_xml_type():
        return "UnloadablePlugin"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('initialize', ['PluginInterface']),
        _method('unload'),
    ])


#------------------------------------------------------------------------------
#
# Classes for package:
#     org.gudy.azureus2.plugins.clientid
#
#------------------------------------------------------------------------------

class ClientIDGeneratorDataType:
    def get_xml_type():
        return "ClientIDGenerator"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'PR_URL': "URL",
        'PR_USER_AGENT': "User-Agent",
    }

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   void generateHTTPProperties(Properties)
    #   
    __az_methods__ = AzureusMethods([
        _method('filterHTTP', ['String[]'], 'String[]'),
        _method('generatePeerID', ['Torrent', 'boolean'], 'byte[]'),
    ])


class ClientIDManagerDataType:
    def get_xml_type():
        return "ClientIDManager"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('getGenerator', [], 'ClientIDGenerator'),
        _method('setGenerator', ['ClientIDGenerator', 'boolean']),
    ])


#------------------------------------------------------------------------------
#
# Classes for package:
#     org.gudy.azureus2.plugins.config
#
#------------------------------------------------------------------------------

class ConfigParameterDataType:
    def get_xml_type():
        return "ConfigParameter"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('addConfigParameterListener', ['ConfigParameterListener']),
        _method('removeConfigParameterListener', ['ConfigParameterListener']),
    ])


class ConfigParameterListenerDataType:
    def get_xml_type():
        return "ConfigParameterListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('configParameterChanged', ['ConfigParameter']),
    ])


#------------------------------------------------------------------------------
#
# Classes for package:
#     org.gudy.azureus2.plugins.ddb
#
#------------------------------------------------------------------------------

class DistributedDatabaseDataType:
    def get_xml_type():
        return "DistributedDatabase"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'OP_EXHAUSTIVE_READ': 1,
        'OP_NONE': 0,
    }

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   DistributedDatabaseKey createKey(Object)
    #   DistributedDatabaseKey createKey(Object, String)
    #   DistributedDatabaseValue createValue(Object)
    #   DistributedDatabaseContact importContact(InetSocketAddress)
    #   
    __az_methods__ = AzureusMethods([
        _method('addTransferHandler', ['DistributedDatabaseTransferType', 'DistributedDatabaseTransferHandler']),
        _method('delete', ['DistributedDatabaseListener', 'DistributedDatabaseKey']),
        _method('getStandardTransferType', ['int'], 'DistributedDatabaseTransferType'),
        _method('isAvailable', [], 'boolean'),
        _method('isExtendedUseAllowed', [], 'boolean'),
        _method('read', ['DistributedDatabaseListener', 'DistributedDatabaseKey', 'long']),
        _method('read', ['DistributedDatabaseListener', 'DistributedDatabaseKey', 'long', 'int']),
        _method('write', ['DistributedDatabaseListener', 'DistributedDatabaseKey', 'DistributedDatabaseValue[]']),
        _method('write', ['DistributedDatabaseListener', 'DistributedDatabaseKey', 'DistributedDatabaseValue']),
    ])


class DistributedDatabaseContactDataType:
    def get_xml_type():
        return "DistributedDatabaseContact"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   InetSocketAddress getAddress()
    #   
    __az_methods__ = AzureusMethods([
        _method('getName', [], 'String'),
        _method('isAlive', ['long'], 'boolean'),
        _method('isOrHasBeenLocal', [], 'boolean'),
        _method('openTunnel', [], 'boolean'),
        _method('read',
                ['DistributedDatabaseProgressListener', 'DistributedDatabaseTransferType', 'DistributedDatabaseKey',
                 'long'], 'DistributedDatabaseValue'),
        _method('write', ['DistributedDatabaseTransferType', 'DistributedDatabaseKey', 'DistributedDatabaseValue']),
    ])


class DistributedDatabaseEventDataType:
    def get_xml_type():
        return "DistributedDatabaseEvent"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'ET_OPERATION_COMPLETE': 4,
        'ET_OPERATION_TIMEOUT': 5,
        'ET_VALUE_DELETED': 3,
        'ET_VALUE_READ': 2,
        'ET_VALUE_WRITTEN': 1,
    }

    __az_methods__ = AzureusMethods([
        _method('getContact', [], 'DistributedDatabaseContact'),
        _method('getKey', [], 'DistributedDatabaseKey'),
        _method('getType', [], 'int'),
        _method('getValue', [], 'DistributedDatabaseValue'),
    ])


class DistributedDatabaseKeyDataType:
    def get_xml_type():
        return "DistributedDatabaseKey"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   Object getKey()
    #   
    __az_methods__ = AzureusMethods([
        _method('getDescription', [], 'String'),
    ])


class DistributedDatabaseListenerDataType:
    def get_xml_type():
        return "DistributedDatabaseListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('event', ['DistributedDatabaseEvent']),
    ])


class DistributedDatabaseProgressListenerDataType:
    def get_xml_type():
        return "DistributedDatabaseProgressListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('reportActivity', ['String']),
        _method('reportCompleteness', ['int']),
        _method('reportSize', ['long']),
    ])


class DistributedDatabaseTransferHandlerDataType:
    def get_xml_type():
        return "DistributedDatabaseTransferHandler"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('read', ['DistributedDatabaseContact', 'DistributedDatabaseTransferType', 'DistributedDatabaseKey'],
                'DistributedDatabaseValue'),
        _method('write', ['DistributedDatabaseContact', 'DistributedDatabaseTransferType', 'DistributedDatabaseKey',
                          'DistributedDatabaseValue']),
    ])


class DistributedDatabaseTransferTypeDataType:
    def get_xml_type():
        return "DistributedDatabaseTransferType"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'ST_TORRENT': 1,
    }


class DistributedDatabaseValueDataType:
    def get_xml_type():
        return "DistributedDatabaseValue"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   Object getValue(Class)
    #   
    __az_methods__ = AzureusMethods([
        _method('getContact', [], 'DistributedDatabaseContact'),
        _method('getCreationTime', [], 'long'),
        _method('getVersion', [], 'long'),
    ])


#------------------------------------------------------------------------------
#
# Classes for package:
#     org.gudy.azureus2.plugins.disk
#
#------------------------------------------------------------------------------

class DiskManagerDataType:
    def get_xml_type():
        return "DiskManager"

    get_xml_type = staticmethod(get_xml_type)


class DiskManagerChannelDataType:
    def get_xml_type():
        return "DiskManagerChannel"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('createRequest', [], 'DiskManagerRequest'),
        _method('destroy'),
    ])


class DiskManagerEventDataType:
    def get_xml_type():
        return "DiskManagerEvent"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'EVENT_TYPE_BLOCKED': 3,
        'EVENT_TYPE_FAILED': 2,
        'EVENT_TYPE_SUCCESS': 1,
    }

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   Throwable getFailure()
    #   
    __az_methods__ = AzureusMethods([
        _method('getBuffer', [], 'PooledByteBuffer'),
        _method('getLength', [], 'int'),
        _method('getOffset', [], 'long'),
        _method('getRequest', [], 'DiskManagerRequest'),
        _method('getType', [], 'int'),
    ])


class DiskManagerFileInfoDataType:
    def get_xml_type():
        return "DiskManagerFileInfo"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'READ': 1,
        'WRITE': 2,
        'PRIORITY_HIGH': 1,
        'PRIORITY_LOW': -1,
        'PRIORITY_NORMAL': 0
    }

    __az_methods__ = AzureusMethods([
        _method('createChannel', [], 'DiskManagerChannel'),
        _method('getAccessMode', [], 'int'),
        _method('getDownload', [], 'Download'),
        _method('getDownloaded', [], 'long'),
        _method('getFile', [], 'File'),
        _method('getFirstPieceNumber', [], 'int'),
        _method('getIndex', [], 'int'),
        _method('getLength', [], 'long'),
        _method('getLink', [], 'File'),
        _method('getNumPieces', [], 'int'),
        _method('getNumericPriority', [], 'int'),
        _method('isDeleted', [], 'boolean'),
        _method('isPriority', [], 'boolean'),
        _method('isSkipped', [], 'boolean'),
        _method('setDeleted', ['boolean']),
        _method('setLink', ['File']),
        _method('setNumericPriority', ['int']),
        _method('setPriority', ['boolean']),
        _method('setSkipped', ['boolean']),
    ])

    __az_attributes__ = {
        'access_mode': 'int',
        'downloaded': 'long',
        'file': 'File',
        'first_piece_number': 'int',
        'is_priority': 'boolean',
        'is_skipped': 'boolean',
        'num_pieces': 'int',
    }


class DiskManagerListenerDataType:
    def get_xml_type():
        return "DiskManagerListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('eventOccurred', ['DiskManagerEvent']),
    ])


class DiskManagerRequestDataType:
    def get_xml_type():
        return "DiskManagerRequest"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'REQUEST_READ': 1,
    }

    __az_methods__ = AzureusMethods([
        _method('addListener', ['DiskManagerListener']),
        _method('cancel'),
        _method('removeListener', ['DiskManagerListener']),
        _method('run'),
        _method('setLength', ['long']),
        _method('setOffset', ['long']),
        _method('setType', ['int']),
    ])


#------------------------------------------------------------------------------
#
# Classes for package:
#     org.gudy.azureus2.plugins.download
#
#------------------------------------------------------------------------------

class DownloadDataType:
    def get_xml_type():
        return "Download"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'FLAG_ONLY_EVER_SEEDED': 1,
        'FLAG_SCAN_INCOMPLETE_PIECES': 2,
        'PR_HIGH_PRIORITY': 1,
        'PR_LOW_PRIORITY': 2,
        'ST_DOWNLOADING': 4,
        'ST_ERROR': 8,
        'ST_NAMES': [
            "",
            "Waiting",
            "Preparing",
            "Ready",
            "Downloading",
            "Seeding",
            "Stopping",
            "Stopped",
            "Error",
            "Queued",
        ],
        'ST_PREPARING': 2,
        'ST_QUEUED': 9,
        'ST_READY': 3,
        'ST_SEEDING': 5,
        'ST_STOPPED': 7,
        'ST_STOPPING': 6,
        'ST_WAITING': 1,
    }

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   Map getMapAttribute(TorrentAttribute)
    #   void setMapAttribute(TorrentAttribute, Map)
    #   
    __az_methods__ = AzureusMethods([
        _method('addDownloadWillBeRemovedListener', ['DownloadWillBeRemovedListener']),
        _method('addListener', ['DownloadListener']),
        _method('addPeerListener', ['DownloadPeerListener']),
        _method('addPropertyListener', ['DownloadPropertyListener']),
        _method('addTrackerListener', ['DownloadTrackerListener']),
        _method('canBeRemoved', [], 'boolean'),
        _method('getAttribute', ['TorrentAttribute'], 'String'),
        _method('getCategoryName', [], 'String'),
        _method('getCreationTime', [], 'long'),
        _method('getDiskManager', [], 'DiskManager'),
        _method('getSaveLocationManager', [], 'SaveLocationManager'),
        _method('getDiskManagerFileInfo', [], 'DiskManagerFileInfo[]'),
        _method('getDownloadPeerId', [], 'byte[]'),
        _method('getErrorStateDetails', [], 'String'),
        _method('getFlag', ['long'], 'boolean'),
        _method('getIndex', [], 'int'),
        _method('getLastAnnounceResult', [], 'DownloadAnnounceResult'),
        _method('getLastScrapeResult', [], 'DownloadScrapeResult'),
        _method('getListAttribute', ['TorrentAttribute'], 'String[]'),
        _method('getMaximumDownloadKBPerSecond', [], 'int'),
        _method('getName', [], 'String'),
        _method('getPeerManager', [], 'PeerManager'),
        _method('getPosition', [], 'int'),
        _method('getPriority', [], 'int'),
        _method('getSavePath', [], 'String'),
        _method('getSeedingRank', [], 'int'),
        _method('getState', [], 'int'),
        _method('getStats', [], 'DownloadStats'),
        _method('getSubState', [], 'int'),
        _method('getTorrent', [], 'Torrent'),
        _method('getTorrentFileName', [], 'String'),
        _method('getUploadRateLimitBytesPerSecond', [], 'int'),
        _method('initialize'),
        _method('isChecking', [], 'boolean'),
        _method('isComplete', [], 'boolean'),
        _method('isCompleteExcludingDND', [], 'boolean'),
        _method('isForceStart', [], 'boolean'),
        _method('isMessagingEnabled', [], 'boolean'),
        _method('isPaused', [], 'boolean'),
        _method('isPersistent', [], 'boolean'),
        _method('isPriorityLocked', [], 'boolean'),
        _method('isStartStopLocked', [], 'boolean'),
        _method('moveDataFiles', ['File']),
        _method('moveDown'),
        _method('moveTo', ['int']),
        _method('moveTorrentFile', ['File']),
        _method('moveUp'),
        _method('recheckData'),
        _method('remove'),
        _method('remove', ['boolean', 'boolean']),
        _method('removeDownloadWillBeRemovedListener', ['DownloadWillBeRemovedListener']),
        _method('removeListener', ['DownloadListener']),
        _method('removePeerListener', ['DownloadPeerListener']),
        _method('removePropertyListener', ['DownloadPropertyListener']),
        _method('removeTrackerListener', ['DownloadTrackerListener']),
        _method('requestTrackerAnnounce'),
        _method('requestTrackerAnnounce', ['boolean']),
        _method('requestTrackerScrape', ['boolean']),
        _method('restart'),
        _method('setAnnounceResult', ['DownloadAnnounceResult']),
        _method('setAttribute', ['TorrentAttribute', 'String']),
        _method('setCategory', ['String']),
        _method('setForceStart', ['boolean']),
        _method('setMaximumDownloadKBPerSecond', ['int']),
        _method('setMessagingEnabled', ['boolean']),
        _method('setPosition', ['int']),
        _method('setPriority', ['int']),
        _method('setScrapeResult', ['DownloadScrapeResult']),
        _method('setSeedingRank', ['int']),
        _method('setSessionAuthenticator', ['SessionAuthenticator']),
        _method('setUploadRateLimitBytesPerSecond', ['int']),
        _method('start'),
        _method('stop'),
        _method('startDownload'),
        _method('stopDownload'),
        _method('stopAndQueue'),
    ])

    __az_attributes__ = {
        'announce_result': 'DownloadAnnounceResult',
        'force_start': 'boolean',
        'position': 'int',
        'scrape_result': 'DownloadScrapeResult',
        'stats': 'DownloadStats',
        'torrent': 'Torrent',
    }


class DownloadAnnounceResultDataType:
    def get_xml_type():
        return "DownloadAnnounceResult"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'RT_ERROR': 2,
        'RT_SUCCESS': 1,
    }

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   Map getExtensions()
    #   
    __az_methods__ = AzureusMethods([
        _method('getDownload', [], 'Download'),
        _method('getError', [], 'String'),
        _method('getNonSeedCount', [], 'int'),
        _method('getPeers', [], 'DownloadAnnounceResultPeer[]'),
        _method('getReportedPeerCount', [], 'int'),
        _method('getResponseType', [], 'int'),
        _method('getSeedCount', [], 'int'),
        _method('getTimeToWait', [], 'long'),
        _method('getURL', [], 'URL'),
    ])

    __az_attributes__ = {
        'non_seed_count': 'int',
        'seed_count': 'int',
    }


class DownloadAnnounceResultPeerDataType:
    def get_xml_type():
        return "DownloadAnnounceResultPeer"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'PROTOCOL_CRYPT': 2,
        'PROTOCOL_NORMAL': 1,
    }

    __az_methods__ = AzureusMethods([
        _method('getAddress', [], 'String'),
        _method('getPeerID', [], 'byte[]'),
        _method('getPort', [], 'int'),
        _method('getProtocol', [], 'short'),
        _method('getSource', [], 'String'),
    ])


class DownloadListenerDataType:
    def get_xml_type():
        return "DownloadListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('positionChanged', ['Download', 'int', 'int']),
        _method('stateChanged', ['Download', 'int', 'int']),
    ])


class DownloadManagerDataType:
    def get_xml_type():
        return "DownloadManager"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('addDownload', ['Torrent', 'File', 'File'], 'Download'),
        _method('addDownload', ['URL', 'URL']),
        _method('addDownload', ['Torrent'], 'Download'),
        _method('addDownload', ['URL']),
        _method('addDownload', ['File']),
        _method('addDownloadWillBeAddedListener', ['DownloadWillBeAddedListener']),
        _method('addListener', ['DownloadManagerListener']),
        _method('addNonPersistentDownload', ['Torrent', 'File', 'File'], 'Download'),
        _method('getDownload', ['byte[]'], 'Download'),
        _method('getDownload', ['Torrent'], 'Download'),
        _method('getDownloads', [], 'Download[]'),
        _method('getDownloads', ['boolean'], 'Download[]'),
        _method('getStats', [], 'DownloadManagerStats'),
        _method('isSeedingOnly', [], 'boolean'),
        _method('pauseDownloads'),
        _method('removeDownloadWillBeAddedListener', ['DownloadWillBeAddedListener']),
        _method('removeListener', ['DownloadManagerListener']),
        _method('resumeDownloads'),
        _method('startAllDownloads'),
        _method('stopAllDownloads'),
    ])


class DownloadManagerListenerDataType:
    def get_xml_type():
        return "DownloadManagerListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('downloadAdded', ['Download']),
        _method('downloadRemoved', ['Download']),
    ])


class DownloadManagerStatsDataType:
    def get_xml_type():
        return "DownloadManagerStats"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('getDataBytesReceived', [], 'long'),
        _method('getDataBytesSent', [], 'long'),
        _method('getDataReceiveRate', [], 'int'),
        _method('getDataSendRate', [], 'int'),
        _method('getOverallDataBytesReceived', [], 'long'),
        _method('getOverallDataBytesSent', [], 'long'),
        _method('getProtocolBytesReceived', [], 'long'),
        _method('getProtocolBytesSent', [], 'long'),
        _method('getProtocolReceiveRate', [], 'int'),
        _method('getProtocolSendRate', [], 'int'),
        _method('getSessionUptimeSeconds', [], 'long'),
    ])


class DownloadPeerListenerDataType:
    def get_xml_type():
        return "DownloadPeerListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('peerManagerAdded', ['Download', 'PeerManager']),
        _method('peerManagerRemoved', ['Download', 'PeerManager']),
    ])


class DownloadPropertyEventDataType:
    def get_xml_type():
        return "DownloadPropertyEvent"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'PT_TORRENT_ATTRIBUTE_WILL_BE_READ': 2,
        'PT_TORRENT_ATTRIBUTE_WRITTEN': 1,
    }

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   Object getData()
    #   
    __az_methods__ = AzureusMethods([
        _method('getType', [], 'int'),
    ])


class DownloadPropertyListenerDataType:
    def get_xml_type():
        return "DownloadPropertyListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('propertyChanged', ['Download', 'DownloadPropertyEvent']),
    ])


class DownloadScrapeResultDataType:
    def get_xml_type():
        return "DownloadScrapeResult"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'RT_ERROR': 2,
        'RT_SUCCESS': 1,
    }

    __az_methods__ = AzureusMethods([
        _method('getDownload', [], 'Download'),
        _method('getNextScrapeStartTime', [], 'long'),
        _method('getNonSeedCount', [], 'int'),
        _method('getResponseType', [], 'int'),
        _method('getScrapeStartTime', [], 'long'),
        _method('getSeedCount', [], 'int'),
        _method('getStatus', [], 'String'),
        _method('getURL', [], 'URL'),
        _method('setNextScrapeStartTime', ['long']),
    ])

    __az_attributes__ = {
        'non_seed_count': 'int',
        'seed_count': 'int',
    }


class DownloadStatsDataType:
    def get_xml_type():
        return "DownloadStats"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'HEALTH_ERROR': 6,
        'HEALTH_KO': 5,
        'HEALTH_NO_REMOTE': 3,
        'HEALTH_NO_TRACKER': 2,
        'HEALTH_OK': 4,
        'HEALTH_STOPPED': 1,
    }

    __az_methods__ = AzureusMethods([
        _method('getAvailability', [], 'float'),
        _method('getCompleted', [], 'int'),
        _method('getDiscarded', [], 'long'),
        _method('getDownloadAverage', [], 'long'),
        _method('getDownloadCompleted', ['boolean'], 'int'),
        _method('getDownloadDirectory', [], 'String'),
        _method('getDownloaded', [], 'long'),
        _method('getElapsedTime', [], 'String'),
        _method('getETA', [], 'String'),
        _method('getHashFails', [], 'long'),
        _method('getHealth', [], 'int'),
        _method('getSecondsDownloading', [], 'long'),
        _method('getSecondsOnlySeeding', [], 'long'),
        _method('getShareRatio', [], 'int'),
        _method('getStatus', ['boolean'], 'String'),
        _method('getStatus', [], 'String'),
        _method('getTargetFileOrDir', [], 'String'),
        _method('getTimeStarted', [], 'long'),
        _method('getTimeStartedSeeding', [], 'long'),
        _method('getTotalAverage', [], 'long'),
        _method('getTrackerStatus', [], 'String'),
        _method('getUploadAverage', [], 'long'),
        _method('getUploaded', [], 'long'),
    ])

    __az_attributes__ = {
        'availability': 'float',
        'completed': 'int',
        'download_average': 'long',
        'downloadCompletedLive': 'int',
        'downloadCompletedStored': 'int',
        'downloaded': 'long',
        'eta': 'String',
        'health': 'int',
        'share_ratio': 'int',
        'status': 'String',
        'status_localised': 'String',
        'upload_average': 'long',
        'uploaded': 'long',
    }


class DownloadTrackerListenerDataType:
    def get_xml_type():
        return "DownloadTrackerListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('announceResult', ['DownloadAnnounceResult']),
        _method('scrapeResult', ['DownloadScrapeResult']),
    ])


class DownloadWillBeAddedListenerDataType:
    def get_xml_type():
        return "DownloadWillBeAddedListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('initialised', ['Download']),
    ])


class DownloadWillBeRemovedListenerDataType:
    def get_xml_type():
        return "DownloadWillBeRemovedListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('downloadWillBeRemoved', ['Download']),
    ])


#------------------------------------------------------------------------------
#
# Classes for package:
#     org.gudy.azureus2.plugins.download.session
#
#------------------------------------------------------------------------------

class SessionAuthenticatorDataType:
    def get_xml_type():
        return "SessionAuthenticator"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   Map createSessionSyn(Peer)
    #   void verifySessionAck(Peer, Map)
    #   Map verifySessionSyn(Peer, Map)
    #   
    __az_methods__ = AzureusMethods([
        _method('decodeSessionData', ['Peer', 'PooledByteBuffer'], 'PooledByteBuffer'),
        _method('encodeSessionData', ['Peer', 'PooledByteBuffer'], 'PooledByteBuffer'),
    ])


#------------------------------------------------------------------------------
#
# Classes for package:
#     org.gudy.azureus2.plugins.installer
#
#------------------------------------------------------------------------------

class FilePluginInstallerDataType:
    def get_xml_type():
        return "FilePluginInstaller"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('getAlreadyInstalledPlugin', [], 'PluginInterface'),
        _method('getDescription', [], 'String'),
        _method('getFile', [], 'File'),
        _method('getId', [], 'String'),
        _method('getInstaller', [], 'PluginInstaller'),
        _method('getName', [], 'String'),
        _method('getVersion', [], 'String'),
        _method('install', ['boolean']),
        _method('uninstall'),
    ])


class InstallablePluginDataType:
    def get_xml_type():
        return "InstallablePlugin"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('getAlreadyInstalledPlugin', [], 'PluginInterface'),
        _method('getDescription', [], 'String'),
        _method('getId', [], 'String'),
        _method('getInstaller', [], 'PluginInstaller'),
        _method('getName', [], 'String'),
        _method('getVersion', [], 'String'),
        _method('install', ['boolean']),
        _method('uninstall'),
    ])


class PluginInstallerDataType:
    def get_xml_type():
        return "PluginInstaller"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('addListener', ['PluginInstallerListener']),
        _method('getStandardPlugins', [], 'StandardPlugin[]'),
        _method('install', ['InstallablePlugin[]', 'boolean']),
        _method('installFromFile', ['File'], 'FilePluginInstaller'),
        _method('removeListener', ['PluginInstallerListener']),
        _method('requestInstall', ['String', 'InstallablePlugin']),
        _method('uninstall', ['PluginInterface[]']),
        _method('uninstall', ['PluginInterface']),
    ])


class PluginInstallerListenerDataType:
    def get_xml_type():
        return "PluginInstallerListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('installRequest', ['String', 'InstallablePlugin'], 'boolean'),
    ])


class StandardPluginDataType:
    def get_xml_type():
        return "StandardPlugin"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('getAlreadyInstalledPlugin', [], 'PluginInterface'),
        _method('getDescription', [], 'String'),
        _method('getId', [], 'String'),
        _method('getInstaller', [], 'PluginInstaller'),
        _method('getName', [], 'String'),
        _method('getVersion', [], 'String'),
        _method('install', ['boolean']),
        _method('uninstall'),
    ])


#------------------------------------------------------------------------------
#
# Classes for package:
#     org.gudy.azureus2.plugins.ipc
#
#------------------------------------------------------------------------------

class IPCInterfaceDataType:
    def get_xml_type():
        return "IPCInterface"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   Object invoke(String, Object[])
    #   


#------------------------------------------------------------------------------
#
# Classes for package:
#     org.gudy.azureus2.plugins.ipfilter
#
#------------------------------------------------------------------------------

class IPBlockedDataType:
    def get_xml_type():
        return "IPBlocked"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('getBlockedIP', [], 'String'),
        _method('getBlockedTime', [], 'long'),
        _method('getBlockedTorrentName', [], 'String'),
        _method('getBlockingRange', [], 'IPRange'),
    ])


class IPFilterDataType:
    def get_xml_type():
        return "IPFilter"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('addRange', ['IPRange']),
        _method('block', ['String']),
        _method('createAndAddRange', ['String', 'String', 'String', 'boolean'], 'IPRange'),
        _method('createRange', ['boolean'], 'IPRange'),
        _method('getBlockedIPs', [], 'IPBlocked[]'),
        _method('getFile', [], 'File'),
        _method('getInRangeAddressesAreAllowed', [], 'boolean'),
        _method('getLastUpdateTime', [], 'long'),
        _method('getNumberOfBlockedIPs', [], 'int'),
        _method('getNumberOfRanges', [], 'int'),
        _method('getRanges', [], 'IPRange[]'),
        _method('isEnabled', [], 'boolean'),
        _method('isInRange', ['String'], 'boolean'),
        _method('markAsUpToDate'),
        _method('reload'),
        _method('removeRange', ['IPRange']),
        _method('save'),
        _method('setEnabled', ['boolean']),
        _method('setInRangeAddressesAreAllowed', ['boolean']),
    ])

    __az_attributes__ = {
        'last_update_time': 'long',
        'number_of_blocked_ips': 'int',
        'number_of_ranges': 'int',
    }


class IPRangeDataType:
    def get_xml_type():
        return "IPRange"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   int compareTo(Object)
    #   
    __az_methods__ = AzureusMethods([
        _method('checkValid'),
        _method('delete'),
        _method('getDescription', [], 'String'),
        _method('getEndIP', [], 'String'),
        _method('getStartIP', [], 'String'),
        _method('isInRange', ['String'], 'boolean'),
        _method('isSessionOnly', [], 'boolean'),
        _method('isValid', [], 'boolean'),
        _method('setDescription', ['String']),
        _method('setEndIP', ['String']),
        _method('setSessionOnly', ['boolean']),
        _method('setStartIP', ['String']),
    ])

    __az_attributes__ = {
        'description': 'String',
        'end_ip': 'String',
        'start_ip': 'String',
    }


#------------------------------------------------------------------------------
#
# Classes for package:
#     org.gudy.azureus2.plugins.logging
#
#------------------------------------------------------------------------------

class LoggerDataType:
    def get_xml_type():
        return "Logger"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   void addFileLoggingListener(FileLoggerAdapter)
    #   void removeFileLoggingListener(FileLoggerAdapter)
    #   
    __az_methods__ = AzureusMethods([
        _method('addAlertListener', ['LoggerAlertListener']),
        _method('getChannel', ['String'], 'LoggerChannel'),
        _method('getChannels', [], 'LoggerChannel[]'),
        _method('getNullChannel', ['String'], 'LoggerChannel'),
        _method('getPluginInterface', [], 'PluginInterface'),
        _method('getTimeStampedChannel', ['String'], 'LoggerChannel'),
        _method('removeAlertListener', ['LoggerAlertListener']),
    ])


class LoggerAlertListenerDataType:
    def get_xml_type():
        return "LoggerAlertListener"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   void alertLogged(String, Throwable, boolean)
    #   
    __az_methods__ = AzureusMethods([
        _method('alertLogged', ['int', 'String', 'boolean']),
    ])


class LoggerChannelDataType:
    def get_xml_type():
        return "LoggerChannel"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'LT_ERROR': 3,
        'LT_INFORMATION': 1,
        'LT_WARNING': 2,
    }

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   void log(Object, int, String)
    #   void log(Object[], int, String)
    #   void log(String, Throwable)
    #   void log(Throwable)
    #   void log(Object[], String, Throwable)
    #   void log(Object, String, Throwable)
    #   void logAlert(String, Throwable)
    #   void logAlertRepeatable(String, Throwable)
    #   
    __az_methods__ = AzureusMethods([
        _method('addListener', ['LoggerChannelListener']),
        _method('getLogger', [], 'Logger'),
        _method('getName', [], 'String'),
        _method('isEnabled', [], 'boolean'),
        _method('log', ['String']),
        _method('log', ['int', 'String']),
        _method('logAlert', ['int', 'String']),
        _method('logAlertRepeatable', ['int', 'String']),
        _method('removeListener', ['LoggerChannelListener']),
        _method('setDiagnostic'),
    ])

    __az_attributes__ = {
        'enabled': 'boolean',
        'name': 'String',
    }


class LoggerChannelListenerDataType:
    def get_xml_type():
        return "LoggerChannelListener"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   void messageLogged(String, Throwable)
    #   
    __az_methods__ = AzureusMethods([
        _method('messageLogged', ['int', 'String']),
    ])


#------------------------------------------------------------------------------
#
# Classes for package:
#     org.gudy.azureus2.plugins.messaging
#
#------------------------------------------------------------------------------

class MessageDataType:
    def get_xml_type():
        return "Message"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'TYPE_DATA_PAYLOAD': 1,
        'TYPE_PROTOCOL_PAYLOAD': 0,
    }

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   Message create(ByteBuffer)
    #   ByteBuffer[] getPayload()
    #   
    __az_methods__ = AzureusMethods([
        _method('destroy'),
        _method('getDescription', [], 'String'),
        _method('getID', [], 'String'),
        _method('getType', [], 'int'),
    ])


class MessageManagerDataType:
    def get_xml_type():
        return "MessageManager"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('cancelCompatiblePeersLocation', ['MessageManagerListener']),
        _method('deregisterMessageType', ['Message']),
        _method('locateCompatiblePeers', ['PluginInterface', 'Message', 'MessageManagerListener']),
        _method('registerMessageType', ['Message']),
    ])


class MessageManagerListenerDataType:
    def get_xml_type():
        return "MessageManagerListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('compatiblePeerFound', ['Download', 'Peer', 'Message']),
        _method('peerRemoved', ['Download', 'Peer']),
    ])


class MessageStreamDecoderDataType:
    def get_xml_type():
        return "MessageStreamDecoder"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   ByteBuffer destroy()
    #   
    __az_methods__ = AzureusMethods([
        _method('getDataBytesDecoded', [], 'int'),
        _method('getProtocolBytesDecoded', [], 'int'),
        _method('pauseDecoding'),
        _method('performStreamDecode', ['Transport', 'int'], 'int'),
        _method('removeDecodedMessages', [], 'Message[]'),
        _method('resumeDecoding'),
    ])


class MessageStreamEncoderDataType:
    def get_xml_type():
        return "MessageStreamEncoder"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('encodeMessage', ['Message'], 'RawMessage'),
    ])


#------------------------------------------------------------------------------
#
# Classes for package:
#     org.gudy.azureus2.plugins.network
#
#------------------------------------------------------------------------------

class ConnectionDataType:
    def get_xml_type():
        return "Connection"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('close'),
        _method('connect', ['ConnectionListener']),
        _method('getIncomingMessageQueue', [], 'IncomingMessageQueue'),
        _method('getOutgoingMessageQueue', [], 'OutgoingMessageQueue'),
        _method('startMessageProcessing'),
    ])


class ConnectionListenerDataType:
    def get_xml_type():
        return "ConnectionListener"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   void connectFailure(Throwable)
    #   void exceptionThrown(Throwable)
    #   
    __az_methods__ = AzureusMethods([
        _method('connectStarted'),
        _method('connectSuccess'),
    ])


class ConnectionManagerDataType:
    def get_xml_type():
        return "ConnectionManager"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'NAT_BAD': 3,
        'NAT_OK': 1,
        'NAT_PROBABLY_OK': 2,
        'NAT_UNKNOWN': 0,
    }

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   Connection createConnection(InetSocketAddress, MessageStreamEncoder, MessageStreamDecoder)
    #   
    __az_methods__ = AzureusMethods([
        _method('getNATStatus', [], 'int'),
    ])


class IncomingMessageQueueDataType:
    def get_xml_type():
        return "IncomingMessageQueue"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('deregisterListener', ['IncomingMessageQueueListener']),
        _method('getPercentDoneOfCurrentMessage', [], 'int'),
        _method('notifyOfExternalReceive', ['Message']),
        _method('registerListener', ['IncomingMessageQueueListener']),
        _method('setDecoder', ['MessageStreamDecoder']),
    ])


class IncomingMessageQueueListenerDataType:
    def get_xml_type():
        return "IncomingMessageQueueListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('bytesReceived', ['int']),
        _method('messageReceived', ['Message'], 'boolean'),
    ])


class OutgoingMessageQueueDataType:
    def get_xml_type():
        return "OutgoingMessageQueue"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('deregisterListener', ['OutgoingMessageQueueListener']),
        _method('getPercentDoneOfCurrentMessage', [], 'int'),
        _method('notifyOfExternalSend', ['Message']),
        _method('registerListener', ['OutgoingMessageQueueListener']),
        _method('sendMessage', ['Message']),
        _method('setEncoder', ['MessageStreamEncoder']),
    ])


class OutgoingMessageQueueListenerDataType:
    def get_xml_type():
        return "OutgoingMessageQueueListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('bytesSent', ['int']),
        _method('messageAdded', ['Message'], 'boolean'),
        _method('messageSent', ['Message']),
    ])


class RawMessageDataType:
    def get_xml_type():
        return "RawMessage"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'TYPE_DATA_PAYLOAD': 1,
        'TYPE_PROTOCOL_PAYLOAD': 0,
    }

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   Message create(ByteBuffer)
    #   ByteBuffer[] getPayload()
    #   ByteBuffer[] getRawPayload()
    #   
    __az_methods__ = AzureusMethods([
        _method('destroy'),
        _method('getDescription', [], 'String'),
        _method('getID', [], 'String'),
        _method('getOriginalMessage', [], 'Message'),
        _method('getType', [], 'int'),
    ])


class TransportDataType:
    def get_xml_type():
        return "Transport"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   long read(ByteBuffer[], int, int)
    #   long write(ByteBuffer[], int, int)
    #   


#------------------------------------------------------------------------------
#
# Classes for package:
#     org.gudy.azureus2.plugins.peers
#
#------------------------------------------------------------------------------

class PeerDataType:
    def get_xml_type():
        return "Peer"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'CLOSING': 40,
        'CONNECTING': 10,
        'DISCONNECTED': 50,
        'HANDSHAKING': 20,
        'TRANSFERING': 30,
    }

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   List getExpiredRequests()
    #   Map getProperties()
    #   List getRequests()
    #   Object getUserData(Object)
    #   void setUserData(Object, Object)
    #   
    __az_methods__ = AzureusMethods([
        _method('addListener', ['PeerListener2']),
        _method('addListener', ['PeerListener']),
        _method('addRequest', ['PeerReadRequest'], 'boolean'),
        _method('cancelRequest', ['PeerReadRequest']),
        _method('close', ['String', 'boolean', 'boolean']),
        _method('getAvailable', [], 'boolean[]'),
        _method('getClient', [], 'String'),
        _method('getConnection', [], 'Connection'),
        _method('getId', [], 'byte[]'),
        _method('getIp', [], 'String'),
        _method('getManager', [], 'PeerManager'),
        _method('getNumberOfRequests', [], 'int'),
        _method('getPercentDone', [], 'int'),
        _method('getPercentDoneInThousandNotation', [], 'int'),
        _method('getPercentDoneOfCurrentIncomingRequest', [], 'int'),
        _method('getPercentDoneOfCurrentOutgoingRequest', [], 'int'),
        _method('getPort', [], 'int'),
        _method('getSnubbedTime', [], 'long'),
        _method('getState', [], 'int'),
        _method('getStats', [], 'PeerStats'),
        _method('getSupportedMessages', [], 'Message[]'),
        _method('getTCPListenPort', [], 'int'),
        _method('getUDPListenPort', [], 'int'),
        _method('isChoked', [], 'boolean'),
        _method('isChoking', [], 'boolean'),
        _method('isDownloadPossible', [], 'boolean'),
        _method('isIncoming', [], 'boolean'),
        _method('isInterested', [], 'boolean'),
        _method('isInteresting', [], 'boolean'),
        _method('isOptimisticUnchoke', [], 'boolean'),
        _method('isPieceAvailable', ['int'], 'boolean'),
        _method('isSeed', [], 'boolean'),
        _method('isSnubbed', [], 'boolean'),
        _method('isTransferAvailable', [], 'boolean'),
        _method('removeListener', ['PeerListener2']),
        _method('removeListener', ['PeerListener']),
        _method('setOptimisticUnchoke', ['boolean']),
        _method('setSnubbed', ['boolean']),
        _method('supportsMessaging', [], 'boolean'),
    ])

    __az_attributes__ = {
        'ip': 'String',
        'port': 'int',
    }


class PeerEventDataType:
    def get_xml_type():
        return "PeerEvent"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'ET_ADD_AVAILABILITY': 3,
        'ET_BAD_CHUNK': 2,
        'ET_REMOVE_AVAILABILITY': 4,
        'ET_STATE_CHANGED': 1,
    }

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   Object getData()
    #   
    __az_methods__ = AzureusMethods([
        _method('getType', [], 'int'),
    ])


class PeerListenerDataType:
    def get_xml_type():
        return "PeerListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('sentBadChunk', ['int', 'int']),
        _method('stateChanged', ['int']),
    ])


class PeerListener2DataType:
    def get_xml_type():
        return "PeerListener2"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('eventOccurred', ['PeerEvent']),
    ])


class PeerManagerDataType:
    def get_xml_type():
        return "PeerManager"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('addListener', ['PeerManagerListener']),
        _method('addPeer', ['String', 'int']),
        _method('addPeer', ['Peer']),
        _method('addPeer', ['String', 'int', 'boolean']),
        _method('createPeerStats', ['Peer'], 'PeerStats'),
        _method('getDiskManager', [], 'DiskManager'),
        _method('getDownload', [], 'Download'),
        _method('getPeers', [], 'Peer[]'),
        _method('getStats', [], 'PeerManagerStats'),
        _method('isSeeding', [], 'boolean'),
        _method('isSuperSeeding', [], 'boolean'),
        _method('removeListener', ['PeerManagerListener']),
        _method('removePeer', ['Peer']),
        _method('requestCancelled', ['PeerReadRequest', 'Peer']),
        _method('requestComplete', ['PeerReadRequest', 'PooledByteBuffer', 'Peer']),
    ])


class PeerManagerListenerDataType:
    def get_xml_type():
        return "PeerManagerListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('peerAdded', ['PeerManager', 'Peer']),
        _method('peerRemoved', ['PeerManager', 'Peer']),
    ])


class PeerManagerStatsDataType:
    def get_xml_type():
        return "PeerManagerStats"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('getConnectedLeechers', [], 'int'),
        _method('getConnectedSeeds', [], 'int'),
        _method('getDiscarded', [], 'long'),
        _method('getDownloadAverage', [], 'long'),
        _method('getDownloaded', [], 'long'),
        _method('getHashFailBytes', [], 'long'),
        _method('getUploadAverage', [], 'long'),
        _method('getUploaded', [], 'long'),
    ])


class PeerReadRequestDataType:
    def get_xml_type():
        return "PeerReadRequest"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('cancel'),
        _method('getLength', [], 'int'),
        _method('getOffset', [], 'int'),
        _method('getPieceNumber', [], 'int'),
        _method('isCancelled', [], 'boolean'),
        _method('isExpired', [], 'boolean'),
        _method('resetTime', ['long']),
    ])


class PeerStatsDataType:
    def get_xml_type():
        return "PeerStats"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('discarded', ['int']),
        _method('getDownloadAverage', [], 'int'),
        _method('getReception', [], 'int'),
        _method('getStatisticSentAverage', [], 'int'),
        _method('getTimeSinceConnectionEstablished', [], 'long'),
        _method('getTotalAverage', [], 'int'),
        _method('getTotalDiscarded', [], 'long'),
        _method('getTotalReceived', [], 'long'),
        _method('getTotalSent', [], 'long'),
        _method('getUploadAverage', [], 'int'),
        _method('received', ['int']),
    ])


#------------------------------------------------------------------------------
#
# Classes for package:
#     org.gudy.azureus2.plugins.peers.protocol
#
#------------------------------------------------------------------------------

class PeerProtocolBTDataType:
    def get_xml_type():
        return "PeerProtocolBT"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following constants are not defined here, because their types
    # are not available in DOPAL:
    # 
    #   "BT_BITFIELD" (has type "byte)"
    #   "BT_CANCEL" (has type "byte)"
    #   "BT_CHOKED" (has type "byte)"
    #   "BT_HAVE" (has type "byte)"
    #   "BT_INTERESTED" (has type "byte)"
    #   "BT_PIECE" (has type "byte)"
    #   "BT_REQUEST" (has type "byte)"
    #   "BT_UNCHOKED" (has type "byte)"
    #   "BT_UNINTERESTED" (has type "byte)"
    #   


class PeerProtocolExtensionHandlerDataType:
    def get_xml_type():
        return "PeerProtocolExtensionHandler"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   Peer[] handleExtension(PeerManager, Map)
    #   


class PeerProtocolManagerDataType:
    def get_xml_type():
        return "PeerProtocolManager"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('registerExtensionHandler', ['String', 'PeerProtocolExtensionHandler']),
    ])


#------------------------------------------------------------------------------
#
# Classes for package:
#     org.gudy.azureus2.plugins.platform
#
#------------------------------------------------------------------------------

class PlatformManagerDataType:
    def get_xml_type():
        return "PlatformManager"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'LOC_MUSIC': 2,
        'LOC_USER_DATA': 1,
    }

    __az_methods__ = AzureusMethods([
        _method('getLocation', ['long'], 'File'),
        _method('isAdditionalFileTypeRegistered', ['String', 'String'], 'boolean'),
        _method('registerAdditionalFileType', ['String', 'String', 'String', 'String']),
        _method('showFile', ['String']),
        _method('unregisterAdditionalFileType', ['String', 'String']),
    ])


#------------------------------------------------------------------------------
#
# Classes for package:
#     org.gudy.azureus2.plugins.sharing
#
#------------------------------------------------------------------------------

class ShareItemDataType:
    def get_xml_type():
        return "ShareItem"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('getTorrent', [], 'Torrent'),
        _method('getTorrentFile', [], 'File'),
    ])


class ShareManagerDataType:
    def get_xml_type():
        return "ShareManager"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('addDir', ['File'], 'ShareResourceDir'),
        _method('addDirContents', ['File', 'boolean'], 'ShareResourceDirContents'),
        _method('addFile', ['File'], 'ShareResourceFile'),
        _method('addListener', ['ShareManagerListener']),
        _method('cancelOperation'),
        _method('getShare', ['File'], 'ShareResource'),
        _method('getShares', [], 'ShareResource[]'),
        _method('initialise'),
        _method('isInitialising', [], 'boolean'),
        _method('removeListener', ['ShareManagerListener']),
    ])


class ShareManagerListenerDataType:
    def get_xml_type():
        return "ShareManagerListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('reportCurrentTask', ['String']),
        _method('reportProgress', ['int']),
        _method('resourceAdded', ['ShareResource']),
        _method('resourceDeleted', ['ShareResource']),
        _method('resourceModified', ['ShareResource']),
    ])


class ShareResourceDataType:
    def get_xml_type():
        return "ShareResource"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'ST_DIR': 2,
        'ST_DIR_CONTENTS': 3,
        'ST_FILE': 1,
    }

    __az_methods__ = AzureusMethods([
        _method('addChangeListener', ['ShareResourceListener']),
        _method('addDeletionListener', ['ShareResourceWillBeDeletedListener']),
        _method('canBeDeleted', [], 'boolean'),
        _method('delete'),
        _method('getAttribute', ['TorrentAttribute'], 'String'),
        _method('getAttributes', [], 'TorrentAttribute[]'),
        _method('getName', [], 'String'),
        _method('getParent', [], 'ShareResourceDirContents'),
        _method('getType', [], 'int'),
        _method('removeChangeListener', ['ShareResourceListener']),
        _method('removeDeletionListener', ['ShareResourceWillBeDeletedListener']),
        _method('setAttribute', ['TorrentAttribute', 'String']),
    ])


class ShareResourceDirDataType:
    def get_xml_type():
        return "ShareResourceDir"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'ST_DIR': 2,
        'ST_DIR_CONTENTS': 3,
        'ST_FILE': 1,
    }

    __az_methods__ = AzureusMethods([
        _method('addChangeListener', ['ShareResourceListener']),
        _method('addDeletionListener', ['ShareResourceWillBeDeletedListener']),
        _method('canBeDeleted', [], 'boolean'),
        _method('delete'),
        _method('getAttribute', ['TorrentAttribute'], 'String'),
        _method('getAttributes', [], 'TorrentAttribute[]'),
        _method('getDir', [], 'File'),
        _method('getItem', [], 'ShareItem'),
        _method('getName', [], 'String'),
        _method('getParent', [], 'ShareResourceDirContents'),
        _method('getType', [], 'int'),
        _method('removeChangeListener', ['ShareResourceListener']),
        _method('removeDeletionListener', ['ShareResourceWillBeDeletedListener']),
        _method('setAttribute', ['TorrentAttribute', 'String']),
    ])


class ShareResourceDirContentsDataType:
    def get_xml_type():
        return "ShareResourceDirContents"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'ST_DIR': 2,
        'ST_DIR_CONTENTS': 3,
        'ST_FILE': 1,
    }

    __az_methods__ = AzureusMethods([
        _method('addChangeListener', ['ShareResourceListener']),
        _method('addDeletionListener', ['ShareResourceWillBeDeletedListener']),
        _method('canBeDeleted', [], 'boolean'),
        _method('delete'),
        _method('getAttribute', ['TorrentAttribute'], 'String'),
        _method('getAttributes', [], 'TorrentAttribute[]'),
        _method('getChildren', [], 'ShareResource[]'),
        _method('getName', [], 'String'),
        _method('getParent', [], 'ShareResourceDirContents'),
        _method('getRoot', [], 'File'),
        _method('getType', [], 'int'),
        _method('isRecursive', [], 'boolean'),
        _method('removeChangeListener', ['ShareResourceListener']),
        _method('removeDeletionListener', ['ShareResourceWillBeDeletedListener']),
        _method('setAttribute', ['TorrentAttribute', 'String']),
    ])


class ShareResourceEventDataType:
    def get_xml_type():
        return "ShareResourceEvent"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'ET_ATTRIBUTE_CHANGED': 1,
    }

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   Object getData()
    #   
    __az_methods__ = AzureusMethods([
        _method('getType', [], 'int'),
    ])


class ShareResourceFileDataType:
    def get_xml_type():
        return "ShareResourceFile"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'ST_DIR': 2,
        'ST_DIR_CONTENTS': 3,
        'ST_FILE': 1,
    }

    __az_methods__ = AzureusMethods([
        _method('addChangeListener', ['ShareResourceListener']),
        _method('addDeletionListener', ['ShareResourceWillBeDeletedListener']),
        _method('canBeDeleted', [], 'boolean'),
        _method('delete'),
        _method('getAttribute', ['TorrentAttribute'], 'String'),
        _method('getAttributes', [], 'TorrentAttribute[]'),
        _method('getFile', [], 'File'),
        _method('getItem', [], 'ShareItem'),
        _method('getName', [], 'String'),
        _method('getParent', [], 'ShareResourceDirContents'),
        _method('getType', [], 'int'),
        _method('removeChangeListener', ['ShareResourceListener']),
        _method('removeDeletionListener', ['ShareResourceWillBeDeletedListener']),
        _method('setAttribute', ['TorrentAttribute', 'String']),
    ])


class ShareResourceListenerDataType:
    def get_xml_type():
        return "ShareResourceListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('shareResourceChanged', ['ShareResource', 'ShareResourceEvent']),
    ])


class ShareResourceWillBeDeletedListenerDataType:
    def get_xml_type():
        return "ShareResourceWillBeDeletedListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('resourceWillBeDeleted', ['ShareResource']),
    ])


#------------------------------------------------------------------------------
#
# Classes for package:
#     org.gudy.azureus2.plugins.torrent
#
#------------------------------------------------------------------------------

class TorrentDataType:
    def get_xml_type():
        return "Torrent"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   Object getAdditionalProperty(String)
    #   Map getMapProperty(String)
    #   byte[][] getPieces()
    #   void setMapProperty(String, Map)
    #   Map writeToMap()
    #   
    __az_methods__ = AzureusMethods([
        _method('getAnnounceURL', [], 'URL'),
        _method('getAnnounceURLList', [], 'TorrentAnnounceURLList'),
        _method('getComment', [], 'String'),
        _method('getCreatedBy', [], 'String'),
        _method('getCreationDate', [], 'long'),
        _method('getEncoding', [], 'String'),
        _method('getFiles', [], 'TorrentFile[]'),
        _method('getHash', [], 'byte[]'),
        _method('getMagnetURI', [], 'URL'),
        _method('getName', [], 'String'),
        _method('getPieceCount', [], 'long'),
        _method('getPieceSize', [], 'long'),
        _method('getPluginStringProperty', ['String'], 'String'),
        _method('getSize', [], 'long'),
        _method('isDecentralised', [], 'boolean'),
        _method('isDecentralisedBackupEnabled', [], 'boolean'),
        _method('isDecentralisedBackupRequested', [], 'boolean'),
        _method('isPrivate', [], 'boolean'),
        _method('removeAdditionalProperties', [], 'Torrent'),
        _method('save'),
        _method('setAnnounceURL', ['URL']),
        _method('setComment', ['String']),
        _method('setComplete', ['File']),
        _method('setDecentralisedBackupRequested', ['boolean']),
        _method('setPluginStringProperty', ['String', 'String']),
        _method('setPrivate', ['boolean']),
        _method('writeToBEncodedData', [], 'byte[]'),
        _method('writeToFile', ['File']),
    ])

    __az_attributes__ = {
        'hash': 'byte[]',
        'name': 'String',
        'size': 'long',
    }


class TorrentAnnounceURLListDataType:
    def get_xml_type():
        return "TorrentAnnounceURLList"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('addSet', ['URL[]']),
        _method('create', ['URL[]'], 'TorrentAnnounceURLListSet'),
        _method('getSets', [], 'TorrentAnnounceURLListSet[]'),
        _method('insertSetAtFront', ['URL[]']),
        _method('setSets', ['TorrentAnnounceURLListSet[]']),
    ])


class TorrentAnnounceURLListSetDataType:
    def get_xml_type():
        return "TorrentAnnounceURLListSet"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('getURLs', [], 'URL[]'),
        _method('setURLs', ['URL[]']),
    ])


class TorrentAttributeDataType:
    def get_xml_type():
        return "TorrentAttribute"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'TA_CATEGORY': "Category",
        'TA_NETWORKS': "Networks",
        'TA_PEER_SOURCES': "PeerSources",
        'TA_SHARE_PROPERTIES': "ShareProperties",
        'TA_TRACKER_CLIENT_EXTENSIONS': "TrackerClientExtensions",
    }

    __az_methods__ = AzureusMethods([
        _method('addDefinedValue', ['String']),
        _method('addTorrentAttributeListener', ['TorrentAttributeListener']),
        _method('getDefinedValues', [], 'String[]'),
        _method('getName', [], 'String'),
        _method('removeDefinedValue', ['String']),
        _method('removeTorrentAttributeListener', ['TorrentAttributeListener']),
    ])


class TorrentAttributeEventDataType:
    def get_xml_type():
        return "TorrentAttributeEvent"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'ET_ATTRIBUTE_VALUE_ADDED': 1,
        'ET_ATTRIBUTE_VALUE_REMOVED': 2,
    }

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   Object getData()
    #   
    __az_methods__ = AzureusMethods([
        _method('getAttribute', [], 'TorrentAttribute'),
        _method('getType', [], 'int'),
    ])


class TorrentAttributeListenerDataType:
    def get_xml_type():
        return "TorrentAttributeListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('event', ['TorrentAttributeEvent']),
    ])


class TorrentDownloaderDataType:
    def get_xml_type():
        return "TorrentDownloader"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('download', [], 'Torrent'),
        _method('download', ['String'], 'Torrent'),
    ])


class TorrentFileDataType:
    def get_xml_type():
        return "TorrentFile"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('getName', [], 'String'),
        _method('getSize', [], 'long'),
    ])


class TorrentManagerDataType:
    def get_xml_type():
        return "TorrentManager"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   Torrent createFromBEncodedInputStream(InputStream)
    #   
    __az_methods__ = AzureusMethods([
        _method('addListener', ['TorrentManagerListener']),
        _method('createFromBEncodedData', ['byte[]'], 'Torrent'),
        _method('createFromBEncodedFile', ['File'], 'Torrent'),
        _method('createFromDataFile', ['File', 'URL', 'boolean'], 'Torrent'),
        _method('createFromDataFile', ['File', 'URL'], 'Torrent'),
        _method('getAttribute', ['String'], 'TorrentAttribute'),
        _method('getDefinedAttributes', [], 'TorrentAttribute[]'),
        _method('getPluginAttribute', ['String'], 'TorrentAttribute'),
        _method('getURLDownloader', ['URL', 'String', 'String'], 'TorrentDownloader'),
        _method('getURLDownloader', ['URL'], 'TorrentDownloader'),
        _method('removeListener', ['TorrentManagerListener']),
    ])


class TorrentManagerEventDataType:
    def get_xml_type():
        return "TorrentManagerEvent"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   Object getData()
    #   


class TorrentManagerListenerDataType:
    def get_xml_type():
        return "TorrentManagerListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('event', ['TorrentManagerEvent']),
    ])


#------------------------------------------------------------------------------
#
# Classes for package:
#     org.gudy.azureus2.plugins.tracker
#
#------------------------------------------------------------------------------

class TrackerDataType:
    def get_xml_type():
        return "Tracker"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'PR_HTTP': 1,
        'PR_HTTPS': 2,
    }

    __az_methods__ = AzureusMethods([
        _method('addAuthenticationListener', ['TrackerAuthenticationListener']),
        _method('addListener', ['TrackerListener']),
        _method('addPageGenerator', ['TrackerWebPageGenerator']),
        _method('createWebContext', ['String', 'int', 'int'], 'TrackerWebContext'),
        _method('createWebContext', ['int', 'int'], 'TrackerWebContext'),
        _method('getName', [], 'String'),
        _method('getPageGenerators', [], 'TrackerWebPageGenerator[]'),
        _method('getTorrent', ['Torrent'], 'TrackerTorrent'),
        _method('getTorrents', [], 'TrackerTorrent[]'),
        _method('getURLs', [], 'URL[]'),
        _method('host', ['Torrent', 'boolean'], 'TrackerTorrent'),
        _method('host', ['Torrent', 'boolean', 'boolean'], 'TrackerTorrent'),
        _method('publish', ['Torrent'], 'TrackerTorrent'),
        _method('removeAuthenticationListener', ['TrackerAuthenticationListener']),
        _method('removeListener', ['TrackerListener']),
        _method('removePageGenerator', ['TrackerWebPageGenerator']),
    ])


class TrackerListenerDataType:
    def get_xml_type():
        return "TrackerListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('torrentAdded', ['TrackerTorrent']),
        _method('torrentChanged', ['TrackerTorrent']),
        _method('torrentRemoved', ['TrackerTorrent']),
    ])


class TrackerPeerDataType:
    def get_xml_type():
        return "TrackerPeer"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('getAmountLeft', [], 'long'),
        _method('getDownloaded', [], 'long'),
        _method('getIP', [], 'String'),
        _method('getIPRaw', [], 'String'),
        _method('getUploaded', [], 'long'),
        _method('isSeed', [], 'boolean'),
    ])


class TrackerPeerEventDataType:
    def get_xml_type():
        return "TrackerPeerEvent"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'ET_PEER_ADDED': 1,
        'ET_PEER_CHANGED': 2,
        'ET_PEER_REMOVED': 3,
    }

    __az_methods__ = AzureusMethods([
        _method('getEventType', [], 'int'),
    ])


class TrackerPeerListenerDataType:
    def get_xml_type():
        return "TrackerPeerListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('eventOccurred', ['TrackerPeerEvent']),
    ])


class TrackerTorrentDataType:
    def get_xml_type():
        return "TrackerTorrent"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'TS_PUBLISHED': 2,
        'TS_STARTED': 0,
        'TS_STOPPED': 1,
    }

    __az_methods__ = AzureusMethods([
        _method('addListener', ['TrackerTorrentListener']),
        _method('addRemovalListener', ['TrackerTorrentWillBeRemovedListener']),
        _method('canBeRemoved', [], 'boolean'),
        _method('disableReplyCaching'),
        _method('getAnnounceCount', [], 'long'),
        _method('getAverageAnnounceCount', [], 'long'),
        _method('getAverageBytesIn', [], 'long'),
        _method('getAverageBytesOut', [], 'long'),
        _method('getAverageDownloaded', [], 'long'),
        _method('getAverageScrapeCount', [], 'long'),
        _method('getAverageUploaded', [], 'long'),
        _method('getBadNATCount', [], 'int'),
        _method('getCompletedCount', [], 'long'),
        _method('getDateAdded', [], 'long'),
        _method('getLeecherCount', [], 'int'),
        _method('getPeers', [], 'TrackerPeer[]'),
        _method('getScrapeCount', [], 'long'),
        _method('getSeedCount', [], 'int'),
        _method('getStatus', [], 'int'),
        _method('getTorrent', [], 'Torrent'),
        _method('getTotalBytesIn', [], 'long'),
        _method('getTotalBytesOut', [], 'long'),
        _method('getTotalDownloaded', [], 'long'),
        _method('getTotalLeft', [], 'long'),
        _method('getTotalUploaded', [], 'long'),
        _method('isPassive', [], 'boolean'),
        _method('remove'),
        _method('removeListener', ['TrackerTorrentListener']),
        _method('removeRemovalListener', ['TrackerTorrentWillBeRemovedListener']),
        _method('start'),
        _method('stop'),
    ])

    __az_attributes__ = {
        'announce_count': 'long',
        'average_announce_count': 'long',
        'average_bytes_in': 'long',
        'average_bytes_out': 'long',
        'average_downloaded': 'long',
        'average_scrape_count': 'long',
        'average_uploaded': 'long',
        'bad_NAT_count': 'int',
        'completed_count': 'long',
        'leecher_count': 'int',
        'scrape_count': 'long',
        'seed_count': 'int',
        'status': 'int',
        'torrent': 'Torrent',
        'total_bytes_in': 'long',
        'total_bytes_out': 'long',
        'total_downloaded': 'long',
        'total_left': 'long',
        'total_uploaded': 'long',
    }


class TrackerTorrentListenerDataType:
    def get_xml_type():
        return "TrackerTorrentListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('postProcess', ['TrackerTorrentRequest']),
        _method('preProcess', ['TrackerTorrentRequest']),
    ])


class TrackerTorrentRequestDataType:
    def get_xml_type():
        return "TrackerTorrentRequest"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'RT_ANNOUNCE': 1,
        'RT_FULL_SCRAPE': 3,
        'RT_SCRAPE': 2,
    }

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   Map getResponse()
    #   
    __az_methods__ = AzureusMethods([
        _method('getPeer', [], 'TrackerPeer'),
        _method('getRequest', [], 'String'),
        _method('getRequestType', [], 'int'),
        _method('getTorrent', [], 'TrackerTorrent'),
    ])


class TrackerTorrentWillBeRemovedListenerDataType:
    def get_xml_type():
        return "TrackerTorrentWillBeRemovedListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('torrentWillBeRemoved', ['TrackerTorrent']),
    ])


#------------------------------------------------------------------------------
#
# Classes for package:
#     org.gudy.azureus2.plugins.tracker.web
#
#------------------------------------------------------------------------------

class TrackerAuthenticationListenerDataType:
    def get_xml_type():
        return "TrackerAuthenticationListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('authenticate', ['URL', 'String', 'String'], 'boolean'),
        _method('authenticate', ['URL', 'String'], 'byte[]'),
    ])


class TrackerWebContextDataType:
    def get_xml_type():
        return "TrackerWebContext"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('addAuthenticationListener', ['TrackerAuthenticationListener']),
        _method('addPageGenerator', ['TrackerWebPageGenerator']),
        _method('getName', [], 'String'),
        _method('getPageGenerators', [], 'TrackerWebPageGenerator[]'),
        _method('getURLs', [], 'URL[]'),
        _method('removeAuthenticationListener', ['TrackerAuthenticationListener']),
        _method('removePageGenerator', ['TrackerWebPageGenerator']),
    ])


class TrackerWebPageGeneratorDataType:
    def get_xml_type():
        return "TrackerWebPageGenerator"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('generate', ['TrackerWebPageRequest', 'TrackerWebPageResponse'], 'boolean'),
    ])


class TrackerWebPageRequestDataType:
    def get_xml_type():
        return "TrackerWebPageRequest"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   InetSocketAddress getClientAddress2()
    #   Map getHeaders()
    #   InputStream getInputStream()
    #   
    __az_methods__ = AzureusMethods([
        _method('getAbsoluteURL', [], 'URL'),
        _method('getClientAddress', [], 'String'),
        _method('getContext', [], 'TrackerWebContext'),
        _method('getHeader', [], 'String'),
        _method('getTracker', [], 'Tracker'),
        _method('getURL', [], 'String'),
        _method('getUser', [], 'String'),
    ])


class TrackerWebPageResponseDataType:
    def get_xml_type():
        return "TrackerWebPageResponse"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   OutputStream getOutputStream()
    #   void useStream(String, InputStream)
    #   
    __az_methods__ = AzureusMethods([
        _method('setContentType', ['String']),
        _method('setExpires', ['long']),
        _method('setHeader', ['String', 'String']),
        _method('setLastModified', ['long']),
        _method('setReplyStatus', ['int']),
        _method('useFile', ['String', 'String'], 'boolean'),
        _method('writeTorrent', ['TrackerTorrent']),
    ])


#------------------------------------------------------------------------------
#
# Classes for package:
#     org.gudy.azureus2.plugins.ui
#
#------------------------------------------------------------------------------

class GraphicDataType:
    def get_xml_type():
        return "Graphic"

    get_xml_type = staticmethod(get_xml_type)


class UIInstanceDataType:
    def get_xml_type():
        return "UIInstance"

    get_xml_type = staticmethod(get_xml_type)


class UIInstanceFactoryDataType:
    def get_xml_type():
        return "UIInstanceFactory"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('detach'),
        _method('getInstance', ['PluginInterface'], 'UIInstance'),
    ])


class UIManagerDataType:
    def get_xml_type():
        return "UIManager"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   PluginView createPluginView(PluginViewModel)
    #   
    __az_methods__ = AzureusMethods([
        _method('addUIEventListener', ['UIManagerEventListener']),
        _method('addUIListener', ['UIManagerListener']),
        _method('attachUI', ['UIInstanceFactory']),
        _method('copyToClipBoard', ['String']),
        _method('createBasicPluginConfigModel', ['String'], 'BasicPluginConfigModel'),
        _method('createBasicPluginConfigModel', ['String', 'String'], 'BasicPluginConfigModel'),
        _method('createBasicPluginViewModel', ['String'], 'BasicPluginViewModel'),
        _method('detachUI', ['UIInstanceFactory']),
        _method('getBasicPluginViewModel', ['String'], 'BasicPluginViewModel'),
        _method('getSWTManager', [], 'SWTManager'),
        _method('getTableManager', [], 'TableManager'),
        _method('openURL', ['URL']),
        _method('removeUIEventListener', ['UIManagerEventListener']),
        _method('removeUIListener', ['UIManagerListener']),
        _method('showConfigSection', ['String'], 'boolean'),
        _method('showTextMessage', ['String', 'String', 'String']),
    ])


class UIManagerEventDataType:
    def get_xml_type():
        return "UIManagerEvent"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'ET_ADD_TABLE_COLUMN': 11,
        'ET_ADD_TABLE_CONTEXT_MENU_ITEM': 12,
        'ET_COPY_TO_CLIPBOARD': 6,
        'ET_CREATE_TABLE_COLUMN': 10,
        'ET_OPEN_TORRENT_VIA_FILE': 2,
        'ET_OPEN_TORRENT_VIA_URL': 3,
        'ET_OPEN_URL': 9,
        'ET_PLUGIN_CONFIG_MODEL_CREATED': 5,
        'ET_PLUGIN_CONFIG_MODEL_DESTROYED': 8,
        'ET_PLUGIN_VIEW_MODEL_CREATED': 4,
        'ET_PLUGIN_VIEW_MODEL_DESTROYED': 7,
        'ET_SHOW_CONFIG_SECTION': 13,
        'ET_SHOW_TEXT_MESSAGE': 1,
    }

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   Object getData()
    #   Object getResult()
    #   void setResult(Object)
    #   
    __az_methods__ = AzureusMethods([
        _method('getType', [], 'int'),
    ])


class UIManagerEventListenerDataType:
    def get_xml_type():
        return "UIManagerEventListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('eventOccurred', ['UIManagerEvent'], 'boolean'),
    ])


class UIManagerListenerDataType:
    def get_xml_type():
        return "UIManagerListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('UIAttached', ['UIInstance']),
        _method('UIDetached', ['UIInstance']),
    ])


class UIPluginViewDataType:
    def get_xml_type():
        return "UIPluginView"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   Object getDataSource()
    #   
    __az_methods__ = AzureusMethods([
        _method('closeView'),
        _method('getViewID', [], 'String'),
    ])


#------------------------------------------------------------------------------
#
# Classes for package:
#     org.gudy.azureus2.plugins.ui.components
#
#------------------------------------------------------------------------------

class UIComponentDataType:
    def get_xml_type():
        return "UIComponent"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'PT_ENABLED': "enabled",
        'PT_VALUE': "value",
        'PT_VISIBLE': "visible",
    }

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   Object getProperty(String)
    #   void setProperty(String, Object)
    #   
    __az_methods__ = AzureusMethods([
        _method('addPropertyChangeListener', ['UIPropertyChangeListener']),
        _method('getEnabled', [], 'boolean'),
        _method('getVisible', [], 'boolean'),
        _method('removePropertyChangeListener', ['UIPropertyChangeListener']),
        _method('setEnabled', ['boolean']),
        _method('setVisible', ['boolean']),
    ])


class UIProgressBarDataType:
    def get_xml_type():
        return "UIProgressBar"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'PT_ENABLED': "enabled",
        'PT_VALUE': "value",
        'PT_VISIBLE': "visible",
    }

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   Object getProperty(String)
    #   void setProperty(String, Object)
    #   
    __az_methods__ = AzureusMethods([
        _method('addPropertyChangeListener', ['UIPropertyChangeListener']),
        _method('getEnabled', [], 'boolean'),
        _method('getPercentageComplete', [], 'int'),
        _method('getVisible', [], 'boolean'),
        _method('removePropertyChangeListener', ['UIPropertyChangeListener']),
        _method('setEnabled', ['boolean']),
        _method('setPercentageComplete', ['int']),
        _method('setVisible', ['boolean']),
    ])


class UIPropertyChangeEventDataType:
    def get_xml_type():
        return "UIPropertyChangeEvent"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   Object getNewPropertyValue()
    #   Object getOldPropertyValue()
    #   
    __az_methods__ = AzureusMethods([
        _method('getPropertyType', [], 'String'),
        _method('getSource', [], 'UIComponent'),
    ])


class UIPropertyChangeListenerDataType:
    def get_xml_type():
        return "UIPropertyChangeListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('propertyChanged', ['UIPropertyChangeEvent']),
    ])


class UITextAreaDataType:
    def get_xml_type():
        return "UITextArea"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'DEFAULT_MAX_SIZE': 60000,
        'PT_ENABLED': "enabled",
        'PT_VALUE': "value",
        'PT_VISIBLE': "visible",
    }

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   Object getProperty(String)
    #   void setProperty(String, Object)
    #   
    __az_methods__ = AzureusMethods([
        _method('addPropertyChangeListener', ['UIPropertyChangeListener']),
        _method('appendText', ['String']),
        _method('getEnabled', [], 'boolean'),
        _method('getText', [], 'String'),
        _method('getVisible', [], 'boolean'),
        _method('removePropertyChangeListener', ['UIPropertyChangeListener']),
        _method('setEnabled', ['boolean']),
        _method('setMaximumSize', ['int']),
        _method('setText', ['String']),
        _method('setVisible', ['boolean']),
    ])


class UITextFieldDataType:
    def get_xml_type():
        return "UITextField"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'PT_ENABLED': "enabled",
        'PT_VALUE': "value",
        'PT_VISIBLE': "visible",
    }

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   Object getProperty(String)
    #   void setProperty(String, Object)
    #   
    __az_methods__ = AzureusMethods([
        _method('addPropertyChangeListener', ['UIPropertyChangeListener']),
        _method('getEnabled', [], 'boolean'),
        _method('getText', [], 'String'),
        _method('getVisible', [], 'boolean'),
        _method('removePropertyChangeListener', ['UIPropertyChangeListener']),
        _method('setEnabled', ['boolean']),
        _method('setText', ['String']),
        _method('setVisible', ['boolean']),
    ])


#------------------------------------------------------------------------------
#
# Classes for package:
#     org.gudy.azureus2.plugins.ui.config
#
#------------------------------------------------------------------------------

class ActionParameterDataType:
    def get_xml_type():
        return "ActionParameter"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'STYLE_BUTTON': 1,
        'STYLE_LINK': 2,
    }

    __az_methods__ = AzureusMethods([
        _method('addConfigParameterListener', ['ConfigParameterListener']),
        _method('addListener', ['ParameterListener']),
        _method('getLabelKey', [], 'String'),
        _method('getLabelText', [], 'String'),
        _method('getStyle', [], 'int'),
        _method('isEnabled', [], 'boolean'),
        _method('isVisible', [], 'boolean'),
        _method('removeConfigParameterListener', ['ConfigParameterListener']),
        _method('removeListener', ['ParameterListener']),
        _method('setEnabled', ['boolean']),
        _method('setLabelKey', ['String']),
        _method('setLabelText', ['String']),
        _method('setStyle', ['int']),
        _method('setVisible', ['boolean']),
    ])


class BooleanParameterDataType:
    def get_xml_type():
        return "BooleanParameter"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('addConfigParameterListener', ['ConfigParameterListener']),
        _method('addDisabledOnSelection', ['Parameter']),
        _method('addEnabledOnSelection', ['Parameter']),
        _method('addListener', ['ParameterListener']),
        _method('getLabelKey', [], 'String'),
        _method('getLabelText', [], 'String'),
        _method('getValue', [], 'boolean'),
        _method('isEnabled', [], 'boolean'),
        _method('isVisible', [], 'boolean'),
        _method('removeConfigParameterListener', ['ConfigParameterListener']),
        _method('removeListener', ['ParameterListener']),
        _method('setEnabled', ['boolean']),
        _method('setLabelKey', ['String']),
        _method('setLabelText', ['String']),
        _method('setValue', ['boolean']),
        _method('setVisible', ['boolean']),
    ])


class ConfigSectionDataType:
    def get_xml_type():
        return "ConfigSection"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'SECTION_CONNECTION': "server",
        'SECTION_FILES': "files",
        'SECTION_INTERFACE': "style",
        'SECTION_PLUGINS': "plugins",
        'SECTION_ROOT': "root",
        'SECTION_TRACKER': "tracker",
        'SECTION_TRANSFER': "transfer",
    }

    __az_methods__ = AzureusMethods([
        _method('configSectionDelete'),
        _method('configSectionGetName', [], 'String'),
        _method('configSectionGetParentSection', [], 'String'),
        _method('configSectionSave'),
    ])


class ConfigSectionSWTDataType:
    def get_xml_type():
        return "ConfigSectionSWT"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'SECTION_CONNECTION': "server",
        'SECTION_FILES': "files",
        'SECTION_INTERFACE': "style",
        'SECTION_PLUGINS': "plugins",
        'SECTION_ROOT': "root",
        'SECTION_TRACKER': "tracker",
        'SECTION_TRANSFER': "transfer",
    }

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   Composite configSectionCreate(Composite)
    #   
    __az_methods__ = AzureusMethods([
        _method('configSectionDelete'),
        _method('configSectionGetName', [], 'String'),
        _method('configSectionGetParentSection', [], 'String'),
        _method('configSectionSave'),
    ])


class DirectoryParameterDataType:
    def get_xml_type():
        return "DirectoryParameter"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('addConfigParameterListener', ['ConfigParameterListener']),
        _method('addListener', ['ParameterListener']),
        _method('getLabelKey', [], 'String'),
        _method('getLabelText', [], 'String'),
        _method('getValue', [], 'String'),
        _method('isEnabled', [], 'boolean'),
        _method('isVisible', [], 'boolean'),
        _method('removeConfigParameterListener', ['ConfigParameterListener']),
        _method('removeListener', ['ParameterListener']),
        _method('setEnabled', ['boolean']),
        _method('setLabelKey', ['String']),
        _method('setLabelText', ['String']),
        _method('setVisible', ['boolean']),
    ])


class EnablerParameterDataType:
    def get_xml_type():
        return "EnablerParameter"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('addConfigParameterListener', ['ConfigParameterListener']),
        _method('addDisabledOnSelection', ['Parameter']),
        _method('addEnabledOnSelection', ['Parameter']),
        _method('addListener', ['ParameterListener']),
        _method('getLabelKey', [], 'String'),
        _method('getLabelText', [], 'String'),
        _method('isEnabled', [], 'boolean'),
        _method('isVisible', [], 'boolean'),
        _method('removeConfigParameterListener', ['ConfigParameterListener']),
        _method('removeListener', ['ParameterListener']),
        _method('setEnabled', ['boolean']),
        _method('setLabelKey', ['String']),
        _method('setLabelText', ['String']),
        _method('setVisible', ['boolean']),
    ])


class IntParameterDataType:
    def get_xml_type():
        return "IntParameter"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('addConfigParameterListener', ['ConfigParameterListener']),
        _method('addListener', ['ParameterListener']),
        _method('getLabelKey', [], 'String'),
        _method('getLabelText', [], 'String'),
        _method('getValue', [], 'int'),
        _method('isEnabled', [], 'boolean'),
        _method('isVisible', [], 'boolean'),
        _method('removeConfigParameterListener', ['ConfigParameterListener']),
        _method('removeListener', ['ParameterListener']),
        _method('setEnabled', ['boolean']),
        _method('setLabelKey', ['String']),
        _method('setLabelText', ['String']),
        _method('setValue', ['int']),
        _method('setVisible', ['boolean']),
    ])


class LabelParameterDataType:
    def get_xml_type():
        return "LabelParameter"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('addConfigParameterListener', ['ConfigParameterListener']),
        _method('addListener', ['ParameterListener']),
        _method('getLabelKey', [], 'String'),
        _method('getLabelText', [], 'String'),
        _method('isEnabled', [], 'boolean'),
        _method('isVisible', [], 'boolean'),
        _method('removeConfigParameterListener', ['ConfigParameterListener']),
        _method('removeListener', ['ParameterListener']),
        _method('setEnabled', ['boolean']),
        _method('setLabelKey', ['String']),
        _method('setLabelText', ['String']),
        _method('setVisible', ['boolean']),
    ])


class ParameterDataType:
    def get_xml_type():
        return "Parameter"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('addConfigParameterListener', ['ConfigParameterListener']),
        _method('addListener', ['ParameterListener']),
        _method('getLabelKey', [], 'String'),
        _method('getLabelText', [], 'String'),
        _method('isEnabled', [], 'boolean'),
        _method('isVisible', [], 'boolean'),
        _method('removeConfigParameterListener', ['ConfigParameterListener']),
        _method('removeListener', ['ParameterListener']),
        _method('setEnabled', ['boolean']),
        _method('setLabelKey', ['String']),
        _method('setLabelText', ['String']),
        _method('setVisible', ['boolean']),
    ])


class ParameterGroupDataType:
    def get_xml_type():
        return "ParameterGroup"

    get_xml_type = staticmethod(get_xml_type)


class ParameterListenerDataType:
    def get_xml_type():
        return "ParameterListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('parameterChanged', ['Parameter']),
    ])


class PasswordParameterDataType:
    def get_xml_type():
        return "PasswordParameter"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'ET_MD5': 3,
        'ET_PLAIN': 1,
        'ET_SHA1': 2,
    }

    __az_methods__ = AzureusMethods([
        _method('addConfigParameterListener', ['ConfigParameterListener']),
        _method('addListener', ['ParameterListener']),
        _method('getLabelKey', [], 'String'),
        _method('getLabelText', [], 'String'),
        _method('getValue', [], 'byte[]'),
        _method('isEnabled', [], 'boolean'),
        _method('isVisible', [], 'boolean'),
        _method('removeConfigParameterListener', ['ConfigParameterListener']),
        _method('removeListener', ['ParameterListener']),
        _method('setEnabled', ['boolean']),
        _method('setLabelKey', ['String']),
        _method('setLabelText', ['String']),
        _method('setVisible', ['boolean']),
    ])


class PluginConfigUIFactoryDataType:
    def get_xml_type():
        return "PluginConfigUIFactory"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('createBooleanParameter', ['String', 'String', 'boolean'], 'EnablerParameter'),
        _method('createColorParameter', ['String', 'String', 'int', 'int', 'int'], 'Parameter'),
        _method('createDirectoryParameter', ['String', 'String', 'String'], 'Parameter'),
        _method('createFileParameter', ['String', 'String', 'String'], 'Parameter'),
        _method('createIntParameter', ['String', 'String', 'int'], 'Parameter'),
        _method('createIntParameter', ['String', 'String', 'int', 'int[]', 'String[]'], 'Parameter'),
        _method('createStringParameter', ['String', 'String', 'String'], 'Parameter'),
        _method('createStringParameter', ['String', 'String', 'String', 'String[]', 'String[]'], 'Parameter'),
    ])


class StringListParameterDataType:
    def get_xml_type():
        return "StringListParameter"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('addConfigParameterListener', ['ConfigParameterListener']),
        _method('addListener', ['ParameterListener']),
        _method('getLabelKey', [], 'String'),
        _method('getLabelText', [], 'String'),
        _method('getValue', [], 'String'),
        _method('isEnabled', [], 'boolean'),
        _method('isVisible', [], 'boolean'),
        _method('removeConfigParameterListener', ['ConfigParameterListener']),
        _method('removeListener', ['ParameterListener']),
        _method('setEnabled', ['boolean']),
        _method('setLabelKey', ['String']),
        _method('setLabelText', ['String']),
        _method('setValue', ['String']),
        _method('setVisible', ['boolean']),
    ])


class StringParameterDataType:
    def get_xml_type():
        return "StringParameter"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('addConfigParameterListener', ['ConfigParameterListener']),
        _method('addListener', ['ParameterListener']),
        _method('getLabelKey', [], 'String'),
        _method('getLabelText', [], 'String'),
        _method('getValue', [], 'String'),
        _method('isEnabled', [], 'boolean'),
        _method('isVisible', [], 'boolean'),
        _method('removeConfigParameterListener', ['ConfigParameterListener']),
        _method('removeListener', ['ParameterListener']),
        _method('setEnabled', ['boolean']),
        _method('setLabelKey', ['String']),
        _method('setLabelText', ['String']),
        _method('setValue', ['String']),
        _method('setVisible', ['boolean']),
    ])


#------------------------------------------------------------------------------
#
# Classes for package:
#     org.gudy.azureus2.plugins.ui.menus
#
#------------------------------------------------------------------------------

class MenuItemDataType:
    def get_xml_type():
        return "MenuItem"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'STYLE_CHECK': 2,
        'STYLE_PUSH': 1,
        'STYLE_RADIO': 3,
        'STYLE_SEPARATOR': 4,
    }

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   Object getData()
    #   void setData(Object)
    #   
    __az_methods__ = AzureusMethods([
        _method('addFillListener', ['MenuItemFillListener']),
        _method('addListener', ['MenuItemListener']),
        _method('getGraphic', [], 'Graphic'),
        _method('getResourceKey', [], 'String'),
        _method('getStyle', [], 'int'),
        _method('isEnabled', [], 'boolean'),
        _method('removeFillListener', ['MenuItemFillListener']),
        _method('removeListener', ['MenuItemListener']),
        _method('setEnabled', ['boolean']),
        _method('setGraphic', ['Graphic']),
        _method('setStyle', ['int']),
    ])


class MenuItemFillListenerDataType:
    def get_xml_type():
        return "MenuItemFillListener"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   void menuWillBeShown(MenuItem, Object)
    #   


class MenuItemListenerDataType:
    def get_xml_type():
        return "MenuItemListener"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   void selected(MenuItem, Object)
    #   


#------------------------------------------------------------------------------
#
# Classes for package:
#     org.gudy.azureus2.plugins.ui.model
#
#------------------------------------------------------------------------------

class BasicPluginConfigModelDataType:
    def get_xml_type():
        return "BasicPluginConfigModel"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('addActionParameter2', ['String', 'String'], 'ActionParameter'),
        _method('addBooleanParameter', ['String', 'String', 'boolean']),
        _method('addBooleanParameter2', ['String', 'String', 'boolean'], 'BooleanParameter'),
        _method('addDirectoryParameter2', ['String', 'String', 'String'], 'DirectoryParameter'),
        _method('addIntParameter2', ['String', 'String', 'int'], 'IntParameter'),
        _method('addLabelParameter2', ['String'], 'LabelParameter'),
        _method('addPasswordParameter2', ['String', 'String', 'int', 'byte[]'], 'PasswordParameter'),
        _method('addStringListParameter2', ['String', 'String', 'String[]', 'String'], 'StringListParameter'),
        _method('addStringListParameter2', ['String', 'String', 'String[]', 'String[]', 'String'],
                'StringListParameter'),
        _method('addStringParameter', ['String', 'String', 'String']),
        _method('addStringParameter2', ['String', 'String', 'String'], 'StringParameter'),
        _method('createGroup', ['String', 'Parameter[]'], 'ParameterGroup'),
        _method('destroy'),
        _method('getParameters', [], 'Parameter[]'),
        _method('getParentSection', [], 'String'),
        _method('getPluginInterface', [], 'PluginInterface'),
        _method('getSection', [], 'String'),
    ])


class BasicPluginViewModelDataType:
    def get_xml_type():
        return "BasicPluginViewModel"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('destroy'),
        _method('getActivity', [], 'UITextField'),
        _method('getConfigSectionID', [], 'String'),
        _method('getLogArea', [], 'UITextArea'),
        _method('getName', [], 'String'),
        _method('getProgress', [], 'UIProgressBar'),
        _method('getStatus', [], 'UITextField'),
        _method('setConfigSectionID', ['String']),
    ])


class PluginConfigModelDataType:
    def get_xml_type():
        return "PluginConfigModel"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('destroy'),
        _method('getPluginInterface', [], 'PluginInterface'),
    ])


class PluginViewModelDataType:
    def get_xml_type():
        return "PluginViewModel"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('destroy'),
        _method('getName', [], 'String'),
    ])


#------------------------------------------------------------------------------
#
# Classes for package:
#     org.gudy.azureus2.plugins.ui.SWT
#
#------------------------------------------------------------------------------

class GraphicSWTDataType:
    def get_xml_type():
        return "GraphicSWT"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   Image getImage()
    #   boolean setImage(Image)
    #   


class SWTManagerDataType:
    def get_xml_type():
        return "SWTManager"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   void addView(PluginView)
    #   void addView(PluginView, boolean)
    #   GraphicSWT createGraphic(Image)
    #   Display getDisplay()
    #   


#------------------------------------------------------------------------------
#
# Classes for package:
#     org.gudy.azureus2.plugins.ui.tables
#
#------------------------------------------------------------------------------

class TableCellDataType:
    def get_xml_type():
        return "TableCell"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   void addListeners(Object)
    #   Object getDataSource()
    #   Comparable getSortValue()
    #   Object getToolTip()
    #   boolean setSortValue(Comparable)
    #   void setToolTip(Object)
    #   
    __az_methods__ = AzureusMethods([
        _method('addDisposeListener', ['TableCellDisposeListener']),
        _method('addMouseListener', ['TableCellMouseListener']),
        _method('addRefreshListener', ['TableCellRefreshListener']),
        _method('addToolTipListener', ['TableCellToolTipListener']),
        _method('getGraphic', [], 'Graphic'),
        _method('getHeight', [], 'int'),
        _method('getTableColumn', [], 'TableColumn'),
        _method('getTableID', [], 'String'),
        _method('getTableRow', [], 'TableRow'),
        _method('getText', [], 'String'),
        _method('getWidth', [], 'int'),
        _method('invalidate'),
        _method('isDisposed', [], 'boolean'),
        _method('isShown', [], 'boolean'),
        _method('isValid', [], 'boolean'),
        _method('removeDisposeListener', ['TableCellDisposeListener']),
        _method('removeMouseListener', ['TableCellMouseListener']),
        _method('removeRefreshListener', ['TableCellRefreshListener']),
        _method('removeToolTipListener', ['TableCellToolTipListener']),
        _method('setFillCell', ['boolean']),
        _method('setForeground', ['int', 'int', 'int'], 'boolean'),
        _method('setGraphic', ['Graphic'], 'boolean'),
        _method('setMarginHeight', ['int']),
        _method('setMarginWidth', ['int']),
        _method('setSortValue', ['float'], 'boolean'),
        _method('setSortValue', ['long'], 'boolean'),
        _method('setText', ['String'], 'boolean'),
    ])


class TableCellAddedListenerDataType:
    def get_xml_type():
        return "TableCellAddedListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('cellAdded', ['TableCell']),
    ])


class TableCellDisposeListenerDataType:
    def get_xml_type():
        return "TableCellDisposeListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('dispose', ['TableCell']),
    ])


class TableCellMouseListenerDataType:
    def get_xml_type():
        return "TableCellMouseListener"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   void cellMouseTrigger(TableCellMouseEvent)
    #   


class TableCellRefreshListenerDataType:
    def get_xml_type():
        return "TableCellRefreshListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('refresh', ['TableCell']),
    ])


class TableCellToolTipListenerDataType:
    def get_xml_type():
        return "TableCellToolTipListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('cellHover', ['TableCell']),
        _method('cellHoverComplete', ['TableCell']),
    ])


class TableColumnDataType:
    def get_xml_type():
        return "TableColumn"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'ALIGN_CENTER': 3,
        'ALIGN_LEAD': 1,
        'ALIGN_TRAIL': 2,
        'INTERVAL_GRAPHIC': -1,
        'INTERVAL_INVALID_ONLY': -3,
        'INTERVAL_LIVE': -2,
        'POSITION_INVISIBLE': -1,
        'POSITION_LAST': -2,
        'TYPE_GRAPHIC': 2,
        'TYPE_TEXT': 1,
        'TYPE_TEXT_ONLY': 3,
    }

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   void addListeners(Object)
    #   
    __az_methods__ = AzureusMethods([
        _method('addCellAddedListener', ['TableCellAddedListener']),
        _method('addCellDisposeListener', ['TableCellDisposeListener']),
        _method('addCellMouseListener', ['TableCellMouseListener']),
        _method('addCellRefreshListener', ['TableCellRefreshListener']),
        _method('addCellToolTipListener', ['TableCellToolTipListener']),
        _method('addContextMenuItem', ['String'], 'TableContextMenuItem'),
        _method('getAlignment', [], 'int'),
        _method('getName', [], 'String'),
        _method('getPosition', [], 'int'),
        _method('getRefreshInterval', [], 'int'),
        _method('getTableID', [], 'String'),
        _method('getType', [], 'int'),
        _method('getWidth', [], 'int'),
        _method('initialize', ['int', 'int', 'int', 'int']),
        _method('initialize', ['int', 'int', 'int']),
        _method('invalidateCells'),
        _method('removeCellAddedListener', ['TableCellAddedListener']),
        _method('removeCellDisposeListener', ['TableCellDisposeListener']),
        _method('removeCellMouseListener', ['TableCellMouseListener']),
        _method('removeCellRefreshListener', ['TableCellRefreshListener']),
        _method('removeCellToolTipListener', ['TableCellToolTipListener']),
        _method('setAlignment', ['int']),
        _method('setPosition', ['int']),
        _method('setRefreshInterval', ['int']),
        _method('setType', ['int']),
        _method('setWidth', ['int']),
    ])


class TableContextMenuItemDataType:
    def get_xml_type():
        return "TableContextMenuItem"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'STYLE_CHECK': 2,
        'STYLE_PUSH': 1,
        'STYLE_RADIO': 3,
        'STYLE_SEPARATOR': 4,
    }

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   Object getData()
    #   void setData(Object)
    #   
    __az_methods__ = AzureusMethods([
        _method('addFillListener', ['MenuItemFillListener']),
        _method('addListener', ['MenuItemListener']),
        _method('getGraphic', [], 'Graphic'),
        _method('getResourceKey', [], 'String'),
        _method('getStyle', [], 'int'),
        _method('getTableID', [], 'String'),
        _method('isEnabled', [], 'boolean'),
        _method('removeFillListener', ['MenuItemFillListener']),
        _method('removeListener', ['MenuItemListener']),
        _method('setEnabled', ['boolean']),
        _method('setGraphic', ['Graphic']),
        _method('setStyle', ['int']),
    ])


class TableManagerDataType:
    def get_xml_type():
        return "TableManager"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'TABLE_MYSHARES': "MyShares",
        'TABLE_MYTORRENTS_COMPLETE': "MySeeders",
        'TABLE_MYTORRENTS_INCOMPLETE': "MyTorrents",
        'TABLE_MYTRACKER': "MyTracker",
        'TABLE_TORRENT_FILES': "Files",
        'TABLE_TORRENT_PEERS': "Peers",
        'TABLE_TORRENT_PIECES': "Pieces",
    }

    __az_methods__ = AzureusMethods([
        _method('addColumn', ['TableColumn']),
        _method('addContextMenuItem', ['String', 'String'], 'TableContextMenuItem'),
        _method('createColumn', ['String', 'String'], 'TableColumn'),
    ])


class TableRowDataType:
    def get_xml_type():
        return "TableRow"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   Object getDataSource()
    #   
    __az_methods__ = AzureusMethods([
        _method('getTableCell', ['String'], 'TableCell'),
        _method('getTableID', [], 'String'),
        _method('isValid', [], 'boolean'),
    ])


#------------------------------------------------------------------------------
#
# Classes for package:
#     org.gudy.azureus2.plugins.ui.tables.mytorrents
#
#------------------------------------------------------------------------------

class MyTorrentsTableItemDataType:
    def get_xml_type():
        return "MyTorrentsTableItem"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('getDownload', [], 'Download'),
        _method('setText', ['String'], 'boolean'),
    ])


class PluginMyTorrentsItemDataType:
    def get_xml_type():
        return "PluginMyTorrentsItem"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('getIntValue', [], 'int'),
        _method('getStringValue', [], 'String'),
        _method('refresh'),
    ])


class PluginMyTorrentsItemFactoryDataType:
    def get_xml_type():
        return "PluginMyTorrentsItemFactory"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'ORIENT_LEFT': "L",
        'ORIENT_RIGHT': "R",
        'POSITION_INVISIBLE': -1,
        'POSITION_LAST': -2,
        'TABLE_ALL': 4,
        'TABLE_COMPLETE': 1,
        'TABLE_INCOMPLETE': 2,
        'TYPE_INT': "I",
        'TYPE_STRING': "S",
    }

    __az_methods__ = AzureusMethods([
        _method('getDefaultPosition', [], 'int'),
        _method('getDefaultSize', [], 'int'),
        _method('getInstance', ['MyTorrentsTableItem'], 'PluginMyTorrentsItem'),
        _method('getName', [], 'String'),
        _method('getOrientation', [], 'String'),
        _method('getTablesVisibleIn', [], 'int'),
        _method('getType', [], 'String'),
    ])


#------------------------------------------------------------------------------
#
# Classes for package:
#     org.gudy.azureus2.plugins.ui.tables.peers
#
#------------------------------------------------------------------------------

class PeerTableItemDataType:
    def get_xml_type():
        return "PeerTableItem"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('getPeer', [], 'Peer'),
        _method('setText', ['String'], 'boolean'),
    ])


class PluginPeerItemDataType:
    def get_xml_type():
        return "PluginPeerItem"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('getIntValue', [], 'int'),
        _method('getStringValue', [], 'String'),
        _method('refresh'),
    ])


class PluginPeerItemFactoryDataType:
    def get_xml_type():
        return "PluginPeerItemFactory"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'TYPE_INT': "I",
        'TYPE_STRING': "S",
    }

    __az_methods__ = AzureusMethods([
        _method('getDefaultSize', [], 'int'),
        _method('getInstance', ['PeerTableItem'], 'PluginPeerItem'),
        _method('getName', [], 'String'),
        _method('getType', [], 'String'),
    ])


#------------------------------------------------------------------------------
#
# Classes for package:
#     org.gudy.azureus2.plugins.update
#
#------------------------------------------------------------------------------

class UpdatableComponentDataType:
    def get_xml_type():
        return "UpdatableComponent"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('checkForUpdate', ['UpdateChecker']),
        _method('getMaximumCheckTime', [], 'int'),
        _method('getName', [], 'String'),
    ])


class UpdateDataType:
    def get_xml_type():
        return "Update"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'RESTART_REQUIRED_MAYBE': 3,
        'RESTART_REQUIRED_NO': 1,
        'RESTART_REQUIRED_YES': 2,
    }

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   Object getDecision(int, String, String, Object)
    #   Object getUserObject()
    #   void setUserObject(Object)
    #   
    __az_methods__ = AzureusMethods([
        _method('addListener', ['UpdateListener']),
        _method('cancel'),
        _method('complete'),
        _method('getCheckInstance', [], 'UpdateCheckInstance'),
        _method('getDescription', [], 'String[]'),
        _method('getDownloaders', [], 'ResourceDownloader[]'),
        _method('getName', [], 'String'),
        _method('getNewVersion', [], 'String'),
        _method('getRestartRequired', [], 'int'),
        _method('isMandatory', [], 'boolean'),
        _method('removeListener', ['UpdateListener']),
        _method('setRestartRequired', ['int']),
    ])


class UpdateCheckerDataType:
    def get_xml_type():
        return "UpdateChecker"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('addListener', ['UpdateCheckerListener']),
        _method('addProgressListener', ['UpdateProgressListener']),
        _method('addUpdate', ['String', 'String[]', 'String', 'ResourceDownloader', 'int'], 'Update'),
        _method('addUpdate', ['String', 'String[]', 'String', 'ResourceDownloader[]', 'int'], 'Update'),
        _method('completed'),
        _method('createInstaller', [], 'UpdateInstaller'),
        _method('failed'),
        _method('getCheckInstance', [], 'UpdateCheckInstance'),
        _method('getComponent', [], 'UpdatableComponent'),
        _method('removeListener', ['UpdateCheckerListener']),
        _method('removeProgressListener', ['UpdateProgressListener']),
        _method('reportProgress', ['String']),
    ])


class UpdateCheckerListenerDataType:
    def get_xml_type():
        return "UpdateCheckerListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('cancelled', ['UpdateChecker']),
        _method('completed', ['UpdateChecker']),
        _method('failed', ['UpdateChecker']),
    ])


class UpdateCheckInstanceDataType:
    def get_xml_type():
        return "UpdateCheckInstance"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'UCI_INSTALL': 1,
        'UCI_UNINSTALL': 3,
        'UCI_UPDATE': 2,
    }

    __az_methods__ = AzureusMethods([
        _method('addDecisionListener', ['UpdateManagerDecisionListener']),
        _method('addListener', ['UpdateCheckInstanceListener']),
        _method('addUpdatableComponent', ['UpdatableComponent', 'boolean']),
        _method('cancel'),
        _method('createInstaller', [], 'UpdateInstaller'),
        _method('getCheckers', [], 'UpdateChecker[]'),
        _method('getManager', [], 'UpdateManager'),
        _method('getName', [], 'String'),
        _method('getType', [], 'int'),
        _method('getUpdates', [], 'Update[]'),
        _method('isCancelled', [], 'boolean'),
        _method('removeDecisionListener', ['UpdateManagerDecisionListener']),
        _method('removeListener', ['UpdateCheckInstanceListener']),
        _method('start'),
    ])


class UpdateCheckInstanceListenerDataType:
    def get_xml_type():
        return "UpdateCheckInstanceListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('cancelled', ['UpdateCheckInstance']),
        _method('complete', ['UpdateCheckInstance']),
    ])


class UpdateInstallerDataType:
    def get_xml_type():
        return "UpdateInstaller"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   void addResource(String, InputStream)
    #   void addResource(String, InputStream, boolean)
    #   
    __az_methods__ = AzureusMethods([
        _method('addChangeRightsAction', ['String', 'String']),
        _method('addMoveAction', ['String', 'String']),
        _method('addRemoveAction', ['String']),
        _method('getInstallDir', [], 'String'),
        _method('getUserDir', [], 'String'),
    ])


class UpdateListenerDataType:
    def get_xml_type():
        return "UpdateListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('complete', ['Update']),
    ])


class UpdateManagerDataType:
    def get_xml_type():
        return "UpdateManager"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('addListener', ['UpdateManagerListener']),
        _method('applyUpdates', ['boolean']),
        _method('createEmptyUpdateCheckInstance', ['int', 'String'], 'UpdateCheckInstance'),
        _method('createInstaller', [], 'UpdateInstaller'),
        _method('createUpdateCheckInstance', [], 'UpdateCheckInstance'),
        _method('createUpdateCheckInstance', ['int', 'String'], 'UpdateCheckInstance'),
        _method('getInstallers', [], 'UpdateInstaller[]'),
        _method('registerUpdatableComponent', ['UpdatableComponent', 'boolean']),
        _method('removeListener', ['UpdateManagerListener']),
        _method('restart'),
    ])


class UpdateManagerDecisionListenerDataType:
    def get_xml_type():
        return "UpdateManagerDecisionListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'DT_STRING_ARRAY_TO_STRING': 0,
    }

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   Object decide(Update, int, String, String, Object)
    #   


class UpdateManagerListenerDataType:
    def get_xml_type():
        return "UpdateManagerListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('checkInstanceCreated', ['UpdateCheckInstance']),
    ])


class UpdateProgressListenerDataType:
    def get_xml_type():
        return "UpdateProgressListener"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('reportProgress', ['String']),
    ])


#------------------------------------------------------------------------------
#
# Classes for package:
#     org.gudy.azureus2.plugins.utils
#
#------------------------------------------------------------------------------

class AggregatedDispatcherDataType:
    def get_xml_type():
        return "AggregatedDispatcher"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   void add(Runnable)
    #   Runnable remove(Runnable)
    #   
    __az_methods__ = AzureusMethods([
        _method('destroy'),
    ])


class AggregatedListDataType:
    def get_xml_type():
        return "AggregatedList"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   void add(Object)
    #   Object remove(Object)
    #   
    __az_methods__ = AzureusMethods([
        _method('destroy'),
    ])


class AggregatedListAcceptorDataType:
    def get_xml_type():
        return "AggregatedListAcceptor"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   void accept(List)
    #   


class ByteArrayWrapperDataType:
    def get_xml_type():
        return "ByteArrayWrapper"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('getBytes', [], 'byte[]'),
    ])


class FormattersDataType:
    def get_xml_type():
        return "Formatters"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   Map bDecode(byte[])
    #   byte[] bEncode(Map)
    #   Comparator getAlphanumericComparator(boolean)
    #   
    __az_methods__ = AzureusMethods([
        _method('base32Decode', ['String'], 'byte[]'),
        _method('base32Encode', ['byte[]'], 'String'),
        _method('decodeBytesFromString', ['String'], 'byte[]'),
        _method('encodeBytesToString', ['byte[]'], 'String'),
        _method('formatByteArray', ['byte[]', 'boolean'], 'String'),
        _method('formatByteCountToKiBEtc', ['long'], 'String'),
        _method('formatByteCountToKiBEtcPerSec', ['long'], 'String'),
        _method('formatDate', ['long'], 'String'),
        _method('formatPercentFromThousands', ['long'], 'String'),
        _method('formatTimeFromSeconds', ['long'], 'String'),
    ])


class LocaleDecoderDataType:
    def get_xml_type():
        return "LocaleDecoder"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('decode', ['byte[]'], 'String'),
        _method('getName', [], 'String'),
    ])


class LocaleListenerDataType:
    def get_xml_type():
        return "LocaleListener"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   void localeChanged(Locale)
    #   


class LocaleUtilitiesDataType:
    def get_xml_type():
        return "LocaleUtilities"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('addListener', ['LocaleListener']),
        _method('getDecoders', [], 'LocaleDecoder[]'),
        _method('getLocalisedMessageText', ['String'], 'String'),
        _method('getLocalisedMessageText', ['String', 'String[]'], 'String'),
        _method('integrateLocalisedMessageBundle', ['String']),
        _method('removeListener', ['LocaleListener']),
    ])


class MonitorDataType:
    def get_xml_type():
        return "Monitor"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('enter'),
        _method('exit'),
        _method('hasWaiters', [], 'boolean'),
        _method('isOwned', [], 'boolean'),
    ])


class PooledByteBufferDataType:
    def get_xml_type():
        return "PooledByteBuffer"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   ByteBuffer toByteBuffer()
    #   
    __az_methods__ = AzureusMethods([
        _method('returnToPool'),
        _method('toByteArray', [], 'byte[]'),
    ])


class SemaphoreDataType:
    def get_xml_type():
        return "Semaphore"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('release'),
        _method('reserve'),
        _method('reserve', ['long'], 'boolean'),
        _method('reserveIfAvailable', [], 'boolean'),
    ])


class ShortCutsDataType:
    def get_xml_type():
        return "ShortCuts"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('getDownload', ['byte[]'], 'Download'),
        _method('getDownloadStats', ['byte[]'], 'DownloadStats'),
        _method('removeDownload', ['byte[]']),
        _method('restartDownload', ['byte[]']),
        _method('stopDownload', ['byte[]']),
    ])


class UtilitiesDataType:
    def get_xml_type():
        return "Utilities"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   ByteBuffer allocateDirectByteBuffer(int)
    #   void createThread(String, Runnable)
    #   void freeDirectByteBuffer(ByteBuffer)
    #   InputStream getImageAsStream(String)
    #   InetAddress getPublicAddress()
    #   Map readResilientBEncodedFile(File, String, boolean)
    #   String reverseDNSLookup(InetAddress)
    #   void writeResilientBEncodedFile(File, String, Map, boolean)
    #   
    __az_methods__ = AzureusMethods([
        _method('allocatePooledByteBuffer', ['byte[]'], 'PooledByteBuffer'),
        _method('allocatePooledByteBuffer', ['int'], 'PooledByteBuffer'),
        _method('compareVersions', ['String', 'String'], 'int'),
        _method('createAggregatedDispatcher', ['long', 'long'], 'AggregatedDispatcher'),
        _method('createAggregatedList', ['AggregatedListAcceptor', 'long', 'long'], 'AggregatedList'),
        _method('createProcess', ['String']),
        _method('createTimer', ['String', 'boolean'], 'UTTimer'),
        _method('createTimer', ['String'], 'UTTimer'),
        _method('createWrapper', ['byte[]'], 'ByteArrayWrapper'),
        _method('getAzureusProgramDir', [], 'String'),
        _method('getAzureusUserDir', [], 'String'),
        _method('getCurrentSystemTime', [], 'long'),
        _method('getFormatters', [], 'Formatters'),
        _method('getLocaleUtilities', [], 'LocaleUtilities'),
        _method('getMonitor', [], 'Monitor'),
        _method('getResourceDownloaderFactory', [], 'ResourceDownloaderFactory'),
        _method('getResourceUploaderFactory', [], 'ResourceUploaderFactory'),
        _method('getRSSFeed', ['URL'], 'RSSFeed'),
        _method('getRSSFeed', ['ResourceDownloader'], 'RSSFeed'),
        _method('getSecurityManager', [], 'SESecurityManager'),
        _method('getSemaphore', [], 'Semaphore'),
        _method('getSimpleXMLParserDocumentFactory', [], 'SimpleXMLParserDocumentFactory'),
        _method('isCVSVersion', [], 'boolean'),
        _method('isLinux', [], 'boolean'),
        _method('isOSX', [], 'boolean'),
        _method('isSolaris', [], 'boolean'),
        _method('isWindows', [], 'boolean'),
    ])


class UTTimerDataType:
    def get_xml_type():
        return "UTTimer"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('addEvent', ['long', 'UTTimerEventPerformer'], 'UTTimerEvent'),
        _method('addPeriodicEvent', ['long', 'UTTimerEventPerformer'], 'UTTimerEvent'),
        _method('destroy'),
    ])


class UTTimerEventDataType:
    def get_xml_type():
        return "UTTimerEvent"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('cancel'),
    ])


class UTTimerEventPerformerDataType:
    def get_xml_type():
        return "UTTimerEventPerformer"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('perform', ['UTTimerEvent']),
    ])


#------------------------------------------------------------------------------
#
# Classes for package:
#     org.gudy.azureus2.plugins.utils.resourcedownloader
#
#------------------------------------------------------------------------------

class ResourceDownloaderDataType:
    def get_xml_type():
        return "ResourceDownloader"

    get_xml_type = staticmethod(get_xml_type)

    __az_constants__ = {
        'PR_STRING_CONTENT_TYPE': "ContentType",
    }

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   InputStream download()
    #   Object getProperty(String)
    #   
    __az_methods__ = AzureusMethods([
        _method('addListener', ['ResourceDownloaderListener']),
        _method('asyncDownload'),
        _method('cancel'),
        _method('getName', [], 'String'),
        _method('getSize', [], 'long'),
        _method('isCancelled', [], 'boolean'),
        _method('removeListener', ['ResourceDownloaderListener']),
        _method('reportActivity', ['String']),
    ])


class ResourceDownloaderDelayedFactoryDataType:
    def get_xml_type():
        return "ResourceDownloaderDelayedFactory"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('create', [], 'ResourceDownloader'),
    ])


class ResourceDownloaderFactoryDataType:
    def get_xml_type():
        return "ResourceDownloaderFactory"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('create', ['File'], 'ResourceDownloader'),
        _method('create', ['ResourceDownloaderDelayedFactory'], 'ResourceDownloader'),
        _method('create', ['URL', 'String', 'String'], 'ResourceDownloader'),
        _method('create', ['URL'], 'ResourceDownloader'),
        _method('getAlternateDownloader', ['ResourceDownloader[]', 'int'], 'ResourceDownloader'),
        _method('getAlternateDownloader', ['ResourceDownloader[]'], 'ResourceDownloader'),
        _method('getMetaRefreshDownloader', ['ResourceDownloader'], 'ResourceDownloader'),
        _method('getRandomDownloader', ['ResourceDownloader[]'], 'ResourceDownloader'),
        _method('getRandomDownloader', ['ResourceDownloader[]', 'int'], 'ResourceDownloader'),
        _method('getRetryDownloader', ['ResourceDownloader', 'int'], 'ResourceDownloader'),
        _method('getSuffixBasedDownloader', ['ResourceDownloader'], 'ResourceDownloader'),
        _method('getTimeoutDownloader', ['ResourceDownloader', 'int'], 'ResourceDownloader'),
        _method('getTorrentDownloader', ['ResourceDownloader', 'boolean'], 'ResourceDownloader'),
        _method('getTorrentDownloader', ['ResourceDownloader', 'boolean', 'File'], 'ResourceDownloader'),
    ])


class ResourceDownloaderListenerDataType:
    def get_xml_type():
        return "ResourceDownloaderListener"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   boolean completed(ResourceDownloader, InputStream)
    #   void failed(ResourceDownloader, ResourceDownloaderException)
    #   
    __az_methods__ = AzureusMethods([
        _method('reportActivity', ['ResourceDownloader', 'String']),
        _method('reportPercentComplete', ['ResourceDownloader', 'int']),
    ])


#------------------------------------------------------------------------------
#
# Classes for package:
#     org.gudy.azureus2.plugins.utils.resourceuploader
#
#------------------------------------------------------------------------------

class ResourceUploaderDataType:
    def get_xml_type():
        return "ResourceUploader"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   InputStream upload()
    #   


class ResourceUploaderFactoryDataType:
    def get_xml_type():
        return "ResourceUploaderFactory"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   ResourceUploader create(URL, InputStream)
    #   ResourceUploader create(URL, InputStream, String, String)
    #   


#------------------------------------------------------------------------------
#
# Classes for package:
#     org.gudy.azureus2.plugins.utils.security
#
#------------------------------------------------------------------------------

class CertificateListenerDataType:
    def get_xml_type():
        return "CertificateListener"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   boolean trustCertificate(String, X509Certificate)
    #   


class PasswordListenerDataType:
    def get_xml_type():
        return "PasswordListener"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   PasswordAuthentication getAuthentication(String, URL)
    #   
    __az_methods__ = AzureusMethods([
        _method('setAuthenticationOutcome', ['String', 'URL', 'boolean']),
    ])


class SESecurityManagerDataType:
    def get_xml_type():
        return "SESecurityManager"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   Certificate createSelfSignedCertificate(String, String, int)
    #   KeyStore getKeyStore()
    #   KeyStore getTrustStore()
    #   SSLSocketFactory installServerCertificate(URL)
    #   void runWithAuthenticator(Authenticator, Runnable)
    #   
    __az_methods__ = AzureusMethods([
        _method('addCertificateListener', ['CertificateListener']),
        _method('addPasswordListener', ['PasswordListener']),
        _method('calculateSHA1', ['byte[]'], 'byte[]'),
        _method('removeCertificateListener', ['CertificateListener']),
        _method('removePasswordListener', ['PasswordListener']),
    ])


#------------------------------------------------------------------------------
#
# Classes for package:
#     org.gudy.azureus2.plugins.utils.xml.rss
#
#------------------------------------------------------------------------------

class RSSChannelDataType:
    def get_xml_type():
        return "RSSChannel"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   Date getPublicationDate()
    #   
    __az_methods__ = AzureusMethods([
        _method('getDescription', [], 'String'),
        _method('getItems', [], 'RSSItem[]'),
        _method('getLink', [], 'URL'),
        _method('getNode', [], 'SimpleXMLParserDocumentNode'),
        _method('getTitle', [], 'String'),
    ])


class RSSFeedDataType:
    def get_xml_type():
        return "RSSFeed"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('getChannels', [], 'RSSChannel[]'),
    ])


class RSSItemDataType:
    def get_xml_type():
        return "RSSItem"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   Date getPublicationDate()
    #   
    __az_methods__ = AzureusMethods([
        _method('getDescription', [], 'String'),
        _method('getLink', [], 'URL'),
        _method('getNode', [], 'SimpleXMLParserDocumentNode'),
        _method('getTitle', [], 'String'),
    ])


#------------------------------------------------------------------------------
#
# Classes for package:
#     org.gudy.azureus2.plugins.utils.xml.simpleparser
#
#------------------------------------------------------------------------------

class SimpleXMLParserDocumentDataType:
    def get_xml_type():
        return "SimpleXMLParserDocument"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('getAttribute', ['String'], 'SimpleXMLParserDocumentAttribute'),
        _method('getAttributes', [], 'SimpleXMLParserDocumentAttribute[]'),
        _method('getChild', ['String'], 'SimpleXMLParserDocumentNode'),
        _method('getChildren', [], 'SimpleXMLParserDocumentNode[]'),
        _method('getName', [], 'String'),
        _method('getValue', [], 'String'),
        _method('print'),
    ])


class SimpleXMLParserDocumentAttributeDataType:
    def get_xml_type():
        return "SimpleXMLParserDocumentAttribute"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('getName', [], 'String'),
        _method('getValue', [], 'String'),
    ])


class SimpleXMLParserDocumentFactoryDataType:
    def get_xml_type():
        return "SimpleXMLParserDocumentFactory"

    get_xml_type = staticmethod(get_xml_type)

    # 
    # The following methods are not available, because either the return
    # type is not supported or / and one or more parameters are not
    # remotely supported:
    # 
    #   SimpleXMLParserDocument create(InputStream)
    #   
    __az_methods__ = AzureusMethods([
        _method('create', ['File'], 'SimpleXMLParserDocument'),
        _method('create', ['String'], 'SimpleXMLParserDocument'),
    ])


class SimpleXMLParserDocumentNodeDataType:
    def get_xml_type():
        return "SimpleXMLParserDocumentNode"

    get_xml_type = staticmethod(get_xml_type)

    __az_methods__ = AzureusMethods([
        _method('getAttribute', ['String'], 'SimpleXMLParserDocumentAttribute'),
        _method('getAttributes', [], 'SimpleXMLParserDocumentAttribute[]'),
        _method('getChild', ['String'], 'SimpleXMLParserDocumentNode'),
        _method('getChildren', [], 'SimpleXMLParserDocumentNode[]'),
        _method('getName', [], 'String'),
        _method('getValue', [], 'String'),
    ])


del _method

# XXX: Sort this out.
PluginConfigDataType.__az_attributes__['cached_property_values'] = 'int[]'

# Temporary value - should be removed once the import has finished.
import dopal

__epydoc_mode = dopal.__dopal_mode__ == 2

classes_to_undefine = []

_class_map = {}
for classname, classobject in locals().items():
    if hasattr(classobject, 'get_xml_type'):
        _class_map[classname] = classobject
        if __epydoc_mode:

            # These classes are required to be defined to get the epydoc code
            # generation to work, because we have custom methods defined.
            #
            # We used to generate API documentation for all classes - but this
            # was generating far too much documentation. So now we just filter
            # it down to those classes which need to exist for obj_impl to be
            # imported properly.
            accepted_classes = [
                'Download', 'DownloadAnnounceResult', 'DownloadScrapeResult',
                'DownloadStats', 'PluginConfig', 'PluginInterface', 'Torrent',
                'DiskManagerFileInfo', 'LoggerChannel', 'Peer',
            ]
            classobject.__plugin_class__ = True
            if classobject.get_xml_type() not in accepted_classes:
                classes_to_undefine.append(classname)
del classname, classobject, __epydoc_mode

# Epydoc code - prevents these classes from being generated.
for class_to_undefine in classes_to_undefine:
    del globals()[class_to_undefine]
    del _class_map[class_to_undefine]
    del class_to_undefine
del classes_to_undefine
