# -*- coding: utf-8 -*-
#------------------------------------------------------------
# http://videos.tasteofhome.com/
#------------------------------------------------------------
# License: GPL (http://www.gnu.org/licenses/gpl-3.0.html)
# Based on code from youtube addon
#------------------------------------------------------------

import os
import sys
import urlparse
import plugintools

# Entry point
def run():
    plugintools.log("tasteofhome.run")
    
    # Get params
    params = plugintools.get_params()
    
    if params.get("action") is None:
        main_list(params)
    else:
        action = params.get("action")
        exec action+"(params)"
    
    plugintools.close_item_list()

# Main menu
def main_list(params):
    plugintools.log("tasteofhome.main_list "+repr(params))

    # On first page, pagination parameters are fixed
    params["url"] = "http://videos.tasteofhome.com/"

    # Fetch menu from page
    data = plugintools.read( params.get("url") )
    
    # Extract items
    pattern = '<div class="mvp_browse_tag_item mvp_browse_tag_group1[^<]+<div class="mvp_browse_tag_item mvp_browse_tag_item1[^<]+<a class="mvp_tag_link" href="([^"]+)"><span class="mvp_browse_tag_list_decoration"></span>([^<]+)</a>'
    matches = plugintools.find_multiple_matches(data,pattern)
    
    for scrapedurl,scrapedtitle in matches:
        title = scrapedtitle.strip()
        plot = ""
        thumbnail = ""
        url = urlparse.urljoin(params.get("url"),scrapedurl)

        # Appends a new item to the xbmc item list
        plugintools.add_item( action="inner_list" , title=title , plot=plot , url=url ,thumbnail=thumbnail , folder=True )

# Inner list
def inner_list(params):
    plugintools.log("tasteofhome.inner_list "+repr(params))

    # Fetch submenu from page
    data = plugintools.read( params.get("url") )

    # Narrow search    
    data = plugintools.find_single_match(data,'<div class="mvp_browse_tag_item mvp_browse_tag_group1 mvp_browse_tag_contains_current">(.*?)</div[^<]+</div[^<]+</div[^<]+</div')
    
    # Extract items
    pattern = '<div class="mvp_browse_tag_item mvp_browse_tag_group2[^<]+<div class="mvp_browse_tag_item mvp_browse_tag_item2[^<]+<a class="mvp_tag_link" href="([^"]+)"><span class="mvp_browse_tag_list_decoration"[^<]+</span>([^<]+)</a>'
    matches = plugintools.find_multiple_matches(data,pattern)

    # If a submenu is found, builds the item list now
    if len(matches)>0:

        for scrapedurl,scrapedtitle in matches:
            title = scrapedtitle.strip()
            plot = ""
            thumbnail = ""
            url = urlparse.urljoin(params.get("url"),scrapedurl)

            # Appends a new item to the xbmc item list
            plugintools.add_item( action="video_list" , title=title , plot=plot , url=url ,thumbnail=thumbnail , folder=True )

    # If no submenu, then search for video items
    else:
        video_list(params)

# Inner list
def video_list(params):
    plugintools.log("tasteofhome.video_list "+repr(params))

    # Fetch video list from page
    data = plugintools.read( params.get("url") )
    
    # Extract items
    '''
    <div class="mvp_grid_panel_5" style="width: 118px;">
    <div class="mvp_grid_element" style="width: 98px;">
    <div class="mvp_grid_panel_thumbnail mvp_grid_panel_video" style="position: relative; width: 98px; height: 75px; margin: auto; cursor: pointer; cursor: hand;" id="mvp_grid_panel_thumbnail_8">
    <a id="mvp_grid_panel_img_8" href="/list/How-to-Cook-Videos/video/How-to-Cook-Ham-2" class="mvp_thumbnail_magnified" style="position: relative; width: 94px; height: 71px; background-image: url('http://s3.amazonaws.com/magnifythumbs/WW04HT1RJG6TPM62.jpg'); filter: progid:DXImageTransform.Microsoft.AlphaImageLoader( src='http://s3.amazonaws.com/magnifythumbs/WW04HT1RJG6TPM62.jpg',  sizingMethod='scale');" title="How to Cook Ham"></a>        
    '''
    pattern  = '<div class="mvp_grid_panel_[^<]+'
    pattern += '<div class="mvp_grid_element[^<]+'
    pattern += '<div class="mvp_grid_panel_thumbnail[^<]+'
    pattern += '<a id="mvp_grid_panel_img_\d+" href="([^"]+)" class="mvp_thumbnail_magnified" style="[^\(]+\(\'([^\']+)\'\)[^"]+" title="([^"]+)"'
    matches = plugintools.find_multiple_matches(data,pattern)
    plugintools.log(str(matches))

    for scrapedurl,scrapedthumbnail,scrapedtitle in matches:
        title = scrapedtitle.strip()
        plot = ""
        thumbnail = scrapedthumbnail
        url = urlparse.urljoin(params.get("url"),scrapedurl)

        # Appends a new item to the xbmc item list
        plugintools.add_item( action="find_video" , title=title , plot=plot , url=url ,thumbnail=thumbnail , folder=True )

    # Find link to next page of videos
    next_page = plugintools.find_single_match(data,'<a class="mvp-pagenum-next[^"]+" href="([^"]+)">Next')
    if next_page!="":
        url = urlparse.urljoin(params.get("url"),next_page)
        plugintools.add_item( action="video_list" , title=">> Next page" , plot="" , url=url , thumbnail="" , folder=True )

def find_video(params):
    plugintools.log("tasteofhome.find_video "+repr(params))

    # Fetch video page and search for the media url
    data = plugintools.read( params.get("url") )
    #plugintools.log("tasteofhome.play data="+data)

    # Search for YouTube video
    #http://www.youtube.com/v/7r-qs_2CJgU
    #youtube.com/v/([0-9A-Za-z_-]{11})
    video_id = plugintools.find_single_match(data,"youtube.com/v/([0-9A-Za-z_-]{11})")
    plugintools.log("tasteofhome.play video_id="+video_id)

    if video_id!="":
        media_url = "plugin://plugin.video.youtube/?path=/root/video&action=play_video&videoid="+video_id
        plugintools.add_item( action="play" , title=params.get("title")+" (video on YouTube)" , plot="" , url=media_url ,thumbnail="" , folder=False )

    # Search for magnify.net video
    media_url = plugintools.find_single_match(data,'<video.*?src=.*?(http\://.*?.mp4)')
    if media_url!="":
        plugintools.add_item( action="play" , title=params.get("title")+" (video on Magnify)" , plot="" , url=media_url ,thumbnail="" , isPlayable=True, folder=False )

def play(params):
    plugintools.play_resolved_url( params.get("url") )

run()