# -*- coding: utf-8 -*-
import urllib, re, sys, xbmcplugin, xbmcgui
import os, time
import xbmcaddon, xbmc


# TODO: dodać wtyczkę do freedisc.pl
# TODO: dodać ikonę do dokumentalnych
# TODO: posprzątać pliki cookie #548



if sys.version_info >=  (2, 7):
    import json as json
else:
    import simplejson as json

scriptID = 'plugin.video.mrknow'
scriptname = "Films online"
ptv = xbmcaddon.Addon(scriptID)
datapath = xbmc.translatePath(ptv.getAddonInfo('profile'))

BASE_RESOURCE_PATH = os.path.join( ptv.getAddonInfo('path'), "resources" )
sys.path.append( os.path.join( ptv.getAddonInfo('path'), "lib" ) )
sys.path.append( os.path.join( ptv.getAddonInfo('path'), "host" ) )

import common
import mrknow_pCommon

from utils import fileUtils as fu

from utils.regexUtils import parseText
from utils.xbmcUtils import getKeyboard, setSortMethodsForCurrentXBMCList

from parser2 import Parser2, ParsingResult
from favouritesManager import FavouritesManager

import entities.CListItem as ListItem

from utils import xbmcUtils

from customModulesManager import CustomModulesManager
from utils.beta.t0mm0.common.addon import Addon


MENU_TABLE = { #1000: "www.mrknow.pl [filmy online]",
               2100: "filmbox.pl",
               9000: "noobroom.com"
}
TV_ONLINE_TABLE = {
		     2100 : ["Film Box", 'filmbox'],
             2200 : ["Zobacz.jcom.pl", 'zobaczjcompl'],
              2350 : ["Looknij.tv [troche przycina]", 'looknijtv'],
             2500 : ["SCREEN-TV.pl", 'screentv'],
             2700 : ["Typertv.com.pl", 'typertv'],
}
FUN_ONLINE_TABLE = {
               3000: ["Wykop.pl","wykop"],
               #6000: ["Milanos.pl","milanos"],
               4500: ["Testyonline","testyonline"],
               #5000: ["Joemonster.org","joemonster"],
               #5100: ["Wrzuta.pl","wrzuta"],
}
DOC_ONLINE_TABLE= {
               6000: ["filmydokumentalne.eu","filmydokumentalne"],
}
VOD_ONLINE_TABLE= {
               9010: ["Player.pl [TvnPlayer]","tvnplayer"],
               7000: ["VOD Onet PL","vodpl"]

}
BAJKI_ONLINE_TABLE= {
               10010: ["Bajkipopolsku.com","bajkipopolsku"],
               10020: ["Bajkionline.com","bajkionline"],
               10030: ["Kreskowkazone.pl [nie dziala 50% linkow]", "kreskowkazone"],

}



SERIALE_ONLINE_TABLE = {
               #8000: ["Alekino.tv","kinoliveseriale"],
               8100: ["Zobaczto.tv Seriale","zobacztoseriale"],
               #8200: ["Tvseriesonline.pl    [dziala 70% stron z linkami]", "tvseriesonlinepl"],
               8300: ["Alltube.tv Seriale","alltubeseriale"],
               8400: ["eFilmy.tv Seriale","efilmyseriale"],
}

FILM_ONLINE_TABLE = {
            7200: ["Alltube.tv Filmy ","alltubefilmy"],
            7400 : ["Cda.pl", 'cdapl'],
             7700: ["EFilmy.tv [nowosc]","efilmy"],
             7600: ["Iptak","iptak"],
             #7300: ["Polvod.pl","polvod"],
             #7100: ["Filmbox Movie","filmboxmoovie"],
             7500: ["Zalukaj.tv","zalukaj"],
             #7900: ["Vod.tvpl.pl [testy]","tvppl"],
}

def mydump(obj):
  '''return a printable representation of an object for debugging'''
  newobj=obj
  if '__dict__' in dir(obj):
    newobj=obj.__dict__
    if ' object at ' in unicode(obj) and not newobj.has_key('__type__'):
      newobj['__type__']=unicode(obj)
    for attr in newobj:
      newobj[attr]=mydump(newobj[attr])
  return newobj


class MrknowAnime:



    def __init__(self):
        #BASE_RESOURCE_PATH = os.path.join( os.getcwd(), "resources" )
        BASE_RESOURCE_PATH = os.path.join( ptv.getAddonInfo('path'), "resources" )
        #BASE_RESOURCE_PATH = os.path.join( ptv2.getAddonInfo('path'), "resources" )

        sys.path.append( os.path.join( BASE_RESOURCE_PATH, "lib" ) )
        sys.path.append( os.path.join( BASE_RESOURCE_PATH, "resources" ) )

        sys.path.append( os.path.join( ptv.getAddonInfo('path'), "host" ) )
        import mrknow_pLog, settings, mrknow_Parser, mrknow_pCommon

        self.cm = mrknow_pCommon.common()
        self.log = mrknow_pLog.pLog()
        self.settings = settings.TVSettings()
        self.parser = mrknow_Parser.mrknow_Parser()
        #self.log.info("DIR " + common.Paths.modulesDir + 'mainMenu.cfg')

        self.addon = None
        self.log.info('Filmy online www.mrknow.pl')
        common.clearCache()




    def showListOptions(self,argv=None):
        params = self.parser.getParams()
        mode = self.parser.getIntParam(params, "mode")
        name = self.parser.getParam(params, "name")
        service = self.parser.getParam(params, "service")
        self.addon = Addon(scriptID, argv)
        #print("MMMMMMMM",mode,params)
        mymodes = [common.Mode2.VIEW ,common.Mode2.PLAY, common.Mode2.ADDTOFAVOURITES, common.Mode2.EXECUTE]
        mymodes2 = [common.Mode3.VIEW ,common.Mode3.PLAY]

        base = argv[0]
        handle = int(argv[1])
        parameter = argv[2]
        self.base = base
        self.handle = handle

        paramstring = urllib.unquote_plus(parameter)

        self.log.info(paramstring)
        self.log.info('Base: '+ base)
        self.log.info('Handle: '+ str(handle))
        self.log.info('Parameter: '+ parameter)
        self.log.info('LEN: ' + str(len(paramstring)))
        self.log.info('mode: ' + str(mode))


        if mode == None and name == None and service == None:
            self.log.info('Wyświetlam kategorie')
            self.CATEGORIES()
            #self.LIST(MENU_TABLE)
        elif mode == 1:
            self.LIST(TV_ONLINE_TABLE)
        elif mode == 4:
            self.LIST(FUN_ONLINE_TABLE)
        elif mode == 2:
            self.LIST(FILM_ONLINE_TABLE)
        elif mode == 3:
            self.LIST(SERIALE_ONLINE_TABLE)
        elif mode == 5:
            self.LIST(DOC_ONLINE_TABLE)
        elif mode == 6:
            self.LIST(VOD_ONLINE_TABLE)
        elif mode == 7:
            self.LIST(BAJKI_ONLINE_TABLE)



        elif mode == 20:
            self.log.info('Wyświetlam ustawienia')
            self.settings.showSettings()
        elif mode == 30:
            self.LIBRTMP()

        """
        elif mode == 4500 or service == 'testyonline':
            tv = testyonline.testyonline()
            tv.handleService()
        elif mode == 10010 or service == 'bajkipopolsku':
            tv = bajkipopolsku.bajkipopolsku()
            tv.handleService()
        elif mode == 10020 or service == 'bajkionline':
            tv = bajkionline.bajkionline()
            tv.handleService()
        elif mode == 10030 or service == 'kreskowkazone':
            tv = kreskowkazone.kreskowkazone()
            tv.handleService()
        elif mode == 8000 or service == 'kinoliveseriale':
            tv = kinoliveseriale.kinoliveseriale()
            tv.handleService()
        elif mode == 8100 or service == 'zobacztoseriale':
            tv = zobacztoseriale.zobacztoseriale()
            tv.handleService()
        elif mode == 8200 or service == 'tvseriesonlinepl':
            tv = tvseriesonlinepl.tvseriesonlinepl()
            tv.handleService()
        elif mode == 8300 or service == 'alltubeseriale':
            tv = alltubeseriale.alltubeseriale()
            tv.handleService()
        elif mode == 8400 or service == 'efilmyseriale':
            tv = efilmyseriale.efilmyseriale()
            tv.handleService()
        """




    def CATEGORIES(self):
        #self.addDir("Telewizja", 1, False, 'Telewizja', False)
        self.addDir("Filmy", 2, False, 'filmy', False)
        self.addDir("Seriale", 3, False, 'seriale', False)
        self.addDir("Polskie serwisy VOD", 6, False, 'servisyvod', False)
        self.addDir("Bajki", 7, False, 'bajki', False)
        self.addDir("Rozrywka", 4, False, 'rozrywka', False)
        self.addDir("Sport [testy działa 15% kanałów]", common.Mode3.VIEW, False, 'sport', False)
        self.addDir("Filmy popularno-naukowe i dokumentalne", 5, False, 'dokumentalne', False)
        self.addDir('Ustawienia', 20, True, 'ustawienia', False)
        #self.addDir('[COLOR yellow]Aktualizuj LIBRTMP - aby dzialy kanaly TV - Patche KSV[/COLOR]',30, False, 'Ustawienia', False)
        xbmcplugin.endOfDirectory(int(sys.argv[1]))

    def listsTable(self, table):
        for num, val in table.items():
            nTab.append(val)
        return nTab

    def LIST(self, table = {}):
        valTab = []
        strTab = []
        for num, tab in table.items():
            strTab.append(num)
            strTab.append(tab[0])
            strTab.append(tab[1])
            valTab.append(strTab)
            strTab = []
        valTab.sort(key = lambda x: x[1])
        for i in range(len(valTab)):
            if valTab[i][2] == '': icon = False
            else: icon = valTab[i][2]
            self.addDir(valTab[i][1], valTab[i][0], False, icon, False)
        xbmcplugin.endOfDirectory(int(sys.argv[1]))


    def addDir(self, name, mode, autoplay, icon, isPlayable = True, category='', murl=''):
        #print("Dane",name, mode, autoplay, icon, isPlayable)
        #u=sys.argv[0] + "?mode=" + str(mode) + "&category="+ category + "&murl="+ murl + "&name="+ name
        u=sys.argv[0] + "?mode=" + str(mode)
        if icon != False:
          icon = os.path.join(ptv.getAddonInfo('path'), "images/") + icon + '.png'
        else:
          icon = "DefaultVideoPlaylists.png"
        liz=xbmcgui.ListItem(name, iconImage=icon, thumbnailImage='')
        if autoplay and isPlayable:
          liz.setProperty("IsPlayable", "true")
        liz.setInfo( type="Video", infoLabels={ "Title": name } )
        xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]), url=u,listitem=liz, isFolder= not autoplay)
        #xbmcplugin.setPluginFanart(int(sys.argv[1]), common.Paths.pluginFanart1)


    def playVideo(self, videoItem, isAutoplay = False):
        if not videoItem:
            return

        listitem = self.createXBMCListItem(videoItem)

        title = videoItem['videoTitle']
        if title:
            listitem.setInfo('video', {'title': title})


        if not isAutoplay:
            xbmcplugin.setResolvedUrl(self.handle, True, listitem)
        else:
            url = urllib.unquote_plus(videoItem['url'])
            mrknow_pCommon.mystat(url)
            #xbmc.Player(self.getPlayerType()).play(url, listitem)
            xbmc.Player().play(url, listitem)


init = MrknowAnime()
init.showListOptions(sys.argv)
