import os
from kodipopcorntime import plugin
from kodipopcorntime.utils import ensure_fanart
from kodipopcorntime.platform import PLATFORM
from kodipopcorntime.scrapers import yify
from kodipopcorntime.player import TorrentPlayer

if PLATFORM["os"] not in ["android", "linux", "windows", "darwin"] or PLATFORM["os"] == "android" and not PLATFORM["arch"] == "arm":
    plugin.notify(plugin.addon.getLocalizedString(30302) % PLATFORM, delay=15000)
    os._exit(os.EX_SOFTWARE)

@plugin.route("/")
@ensure_fanart
def index():
    return yify.index()

@plugin.route("/play/<sub>/<uri>")
def play(uri, sub=None):
    if sub == "none":
        sub = None
    TorrentPlayer().init(uri, sub).loop()