﻿# -*- coding: utf-8 -*-
import xbmc, xbmcgui, xbmcplugin, xbmcaddon
import sys, re, json, math, time, urllib, urllib2, urlparse, cookielib
import resources.lib.common as common

handle = int(sys.argv[1])
AddonID = 'plugin.video.idanplus'
Addon = xbmcaddon.Addon(AddonID)
sortBy = int(Addon.getSetting("tenSortBy"))
module = 'ten'
baseUrl = 'http://10tv.nana10.co.il'
seriesConvUrl = 'https://raw.githubusercontent.com/Fishenzon/My/master/seriesconv.json'
userAgent = common.GetUserAgent()

def GetCategoriesList(iconimage):
	sortString = common.GetLocaleString(30002) if sortBy == 0 else common.GetLocaleString(30003)
	name = "{0}: {1}".format(common.GetLocaleString(30001), sortString)
	common.addDir(name, "toggleSortingMethod", 7, "", {"Title": name, "Plot": "{0}[CR]{1}[CR]{2} / {3}".format(name, common.GetLocaleString(30004), common.GetLocaleString(30002), common.GetLocaleString(30003))}, module=module, isFolder=False)
	url = baseUrl
	text = common.OpenURL(url)
	names = re.compile('t1677_leshonit.+?onclick=".+?\((.+?)\).+?>(.+?)<').findall(text)
	for id, name in names:
		common.addDir(name, id, 1, iconimage, infos={"Title": name}, module=module)

def GetSeriesList(id, name):
	try:
		text = common.OpenURL(seriesConvUrl)
		seriesConv = json.loads(text)
	except:
		seriesConv = {}
	url = baseUrl
	text = common.OpenURL(url)
	matches = re.compile('t1677_tab{0}.+?t1677_programs overview(.+?)</div>\s+</div>\s+</div>'.format(id), re.S).findall(text)
	matches = re.compile('<div class="t1677_Menu" onclick=".+?\'(.+?)\'.+?img src="(.+?)"', re.S).findall(matches[0])
	for url, iconimage in matches:
		if not url.startswith('http'):
			continue
		name = seriesConv.get(url, '').encode('utf-8')
		common.addDir(name, url.replace('&amp;','&'), 2, 'http:{0}'.format(iconimage), infos={"Title": name}, module=module)

def GetSectionsList(url, iconimage):
	base = '{0}://{1}'.format(urlparse.urlparse(url).scheme, urlparse.urlparse(url).netloc)
	if base != baseUrl:
		req = urllib2.Request(url)
		response = urllib2.urlopen(req)
		url = response.url
	text = common.OpenURL(url)
	matches = re.compile('<meta property="og:url" content="(.*?)" />').findall(text)
	baseVid = '{0}/Video/?VideoID=0&TypeID=13&SectionID=0&CategoryID={1}&pid=48'.format(baseUrl, matches[0]).replace('SectionID=0','SectionID={0}')
	matches = re.compile('t1672_tabs(.+?)</div>', re.S).findall(text)
	if len(matches) < 1:
		return
	matches = re.compile('sectionid="(.+?)\s*?".+?>(.+?)<', re.S).findall(matches[0])
	for id, name in matches:
		common.addDir(name, baseVid.format(id).replace('VideoID=0','VideoID={0}') + '&PageNumber=1', 3, iconimage, infos={"Title": name}, module=module)

def GetEpisodesList(url, iconimage):
	episodes = int(Addon.getSetting("tenEpisodes"))
	prms = urlparse.parse_qs(urlparse.urlparse(url).query)
	text = common.OpenURL('http://common.nana10.co.il/SectionVOD/GetSectionVOD.ashx?PageSize={0}&FetchVideo=1&PageNumber={1}&SectionID={2}'.format(episodes, prms['PageNumber'][0], prms['SectionID'][0]))
	url = url[:url.find('&PageNumber=')]
	a = json.loads(text[1:-1])
	pages = int(math.ceil(a["TotalResults"] * 1.0 / episodes))
	for i in range(episodes):
		if episodes * (a["PageNumber"] - 1) + i < a["TotalResults"]:
			b = a["HeadlineList"][i]
			name = b["Title"].encode("utf-8")
			imageID = b["MediaStockImageID"]
			basePic = 'http://f.nanafiles.co.il/upload' if len(str(imageID)) > 5 else 'http://source.nanafiles.co.il/Upload3'
			aired = re.compile('/Date\((.*)\)/').findall(b.get("ModifyDateActual", ''))[0]
			if aired != '':
				try:
					aired = time.strftime('%d/%m/%Y', time.localtime(int(aired) / 1000))
				except:
					pass
			#common.addDir(name, url.format(b["VideoID"]), 4, '{0}/mediastock/img/693/0/{1}/{2}.jpg'.format(basePic, str(imageID)[:-3], imageID), infos={"Title": name, "Plot": b["SubTitle"], "Aired": aired}, module=module, isFolder=False, isPlayable=True)
			_url = url.format(b["VideoID"])
			_icon = '{0}/mediastock/img/693/0/{1}/{2}.jpg'.format(basePic, str(imageID)[:-3], imageID)
			common.addDir(name, _url, 4, _icon, infos={"Title": name, "Plot": b["SubTitle"], "Aired": aired}, contextMenu=[(common.GetLocaleString(30005), 'RunPlugin({0}?url={1}&name={2}&mode=4&iconimage={3}&moredata=choose&module=ten)'.format(sys.argv[0], urllib.quote_plus(_url), name, urllib.quote_plus(_icon)))], moreData='best', module=module, isFolder=False, isPlayable=True)
		else:
			break
	
	if a["PageNumber"] > 1:
		name = "[COLOR green] <<  {0}[/COLOR]".format(common.GetLocaleString(30302))
		common.addDir(name, '{0}&PageNumber={1}'.format(url, a["PageNumber"] - 1), 3, iconimage, infos={"Title": name, "Plot": name}, module=module)
	if pages > a["PageNumber"]:
		name = "[COLOR green] >>  {0}[/COLOR]".format(common.GetLocaleString(30303))
		common.addDir(name, '{0}&PageNumber={1}'.format(url, a["PageNumber"] + 1), 3, iconimage, infos={"Title": name, "Plot": name}, module=module)
	if pages > 1:
		name = "[COLOR green] ><  {0}[/COLOR]".format(common.GetLocaleString(30304))
		common.addDir(name, '{0}&PageNumber={1}&Pages={2}'.format(url, a["PageNumber"], pages), 5, iconimage, infos={"Title": name, "Plot": name}, module=module)

def Play(url, name='', iconimage='', quality='best'):
	common.DelCookies()
	headers={"User-Agent": userAgent}
	text = common.OpenURL(url, headers=headers)
	matches = re.compile('UserID=(.+?);GroupId=(.+?);').findall(text)
	url = 'http://vod.ch10.cloudvideoplatform.com/api/getlink/GetFlash?showID={0}&userID={1}'.format(matches[0][1], matches[0][0])
	text = common.OpenURL(url, headers=headers)
	result = json.loads(text)[0]
	mf = result['MediaFile'].split('.')
	base_url =  '{0}{1}{2}{3}{4}.{5}'.format(result['ProtocolType'], result['ServerAddress'], result['MediaRoot'], mf[0], result['Bitrates'], mf[1])
	url = '{0}{1}{2}'.format(base_url, result['StreamingType'], result['Params'].replace('&amp;', '&'))
	cookie_jar = cookielib.LWPCookieJar()
	link = common.GetStreams(url, headers=headers, CookieJar=cookie_jar, quality=quality)
	cookies = "&".join(['Cookie={0}'.format(urllib.quote('{0}={1}'.format(_cookie.name, _cookie.value))) for _cookie in cookie_jar])
	final = '{0}|User-Agent={1}'.format(link, userAgent)
	if cookies != '':
		final = '{0}&{1}'.format(final, cookies)
	if quality == 'choose':
		listitem = xbmcgui.ListItem(name, path=final, iconImage=iconimage, thumbnailImage=iconimage)
		listitem.setInfo(type="Video", infoLabels={"Title": name})
		xbmc.Player().play(final, listitem)
	else:
		listitem = xbmcgui.ListItem(path=final)
		xbmcplugin.setResolvedUrl(handle=handle, succeeded=True, listitem=listitem)

def GetIndexFromUser(title, listLen):
	dialog = xbmcgui.Dialog()
	location = dialog.input('{0} (1-{1})'.format(title, listLen), type=xbmcgui.INPUT_NUMERIC)
	if location is None or location == "":
		return 1
	try:
		location = int(location)
		if location > listLen or location < 1:
			return 1
	except:
		return 1
	return location

def ToggleSortMethod():
	if sortBy == 0:
		Addon.setSetting("tenSortBy", "1")
	else:
		Addon.setSetting("tenSortBy", "0")
	xbmc.executebuiltin("Container.Refresh")

def WatchLive(name='', iconimage='', quality='best'):
	headers={"User-Agent": userAgent}
	text = common.OpenURL('http://live.ch10.cloudvideoplatform.com/api/getlink/?servertype=hls&ch=1', headers=headers)
	link = common.GetStreams(json.loads(text)[0]['Link'], headers=headers, quality=quality)
	final = '{0}|User-Agent={1}'.format(link, userAgent)
	if quality == 'choose':
		listitem = xbmcgui.ListItem(name, path=final, iconImage=iconimage, thumbnailImage=iconimage)
		listitem.setInfo(type="Video", infoLabels={"Title": name})
		xbmc.Player().play(final, listitem)
	else:
		listitem = xbmcgui.ListItem(path=final)
		xbmcplugin.setResolvedUrl(handle=handle, succeeded=True, listitem=listitem)

def Run(name, url, mode, iconimage='', moreData=''):
	if mode == 0:
		# "----------- Categories: ---------------"
		GetCategoriesList(iconimage)
	elif mode == 1:
		# "------------- Series: -----------------"
		GetSeriesList(url, name)
	elif mode == 2:
		# "------------ Sections: ----------------"
		GetSectionsList(url, iconimage)
	elif mode == 3:
		# "------------ Episodes: ----------------"
		GetEpisodesList(url, iconimage)
	elif mode == 4:
		# "-------- Playing episode  -------------"
		Play(url, name, iconimage, moreData)
	elif mode == 5:
		# "- Move to a specific episodes' page  --"
		prms = urlparse.parse_qs(urlparse.urlparse(url).query)
		index = GetIndexFromUser(name, int(prms['Pages'][0]))
		GetEpisodesList('{0}&PageNumber={1}'.format(url[:url.find('&PageNumber=')], index), iconimage)
	elif mode == 6:
		WatchLive(name, iconimage, moreData)
	elif mode == 7:	#------------- Toggle Lists' sorting method: -----------------
		ToggleSortMethod()
		
	if mode == 1:
		common.SetViewMode('videos')
	elif mode != 0:
		common.SetViewMode('episodes')
	if sortBy == 1 and mode != 0:
		xbmcplugin.addSortMethod(handle, 1)
