# -*- coding: utf-8 -*-
import xbmc, xbmcgui, xbmcplugin, xbmcaddon
import sys, re, json, urllib
import resources.lib.common as common

handle = int(sys.argv[1])
AddonID = 'plugin.video.idanplus'
Addon = xbmcaddon.Addon(AddonID)
sortBy = int(Addon.getSetting("reshetSortBy"))
module = 'reshet'
userAgent = "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/46.0.2490.86 Safari/537.36"

def GetUrlJson(url):
	result = {}
	try:
		text = common.OpenURL(url, headers={"User-Agent": userAgent})
		data_query = re.compile('data_query = \{(.*?)\};').findall(text)
		result = json.loads('{' + data_query[0] + '}') if len(data_query) > 0 else {}
	except:
		pass
	return result

def GetSeriesList():
	sortString = common.GetLocaleString(30002) if sortBy == 0 else common.GetLocaleString(30003)
	name = "{0}: {1}".format(common.GetLocaleString(30001), sortString)
	common.addDir(name, "toggleSortingMethod", 5, "", {"Title": name, "Plot": "{0}[CR]{1}[CR]{2} / {3}".format(name, common.GetLocaleString(30004), common.GetLocaleString(30002), common.GetLocaleString(30003))}, module=module, isFolder=False)
	url = 'http://reshet.tv/general/programs/'
	result = GetUrlJson(url)
	if len(result) < 1:
		return
	grids_arr = []
	seriesIDs = []
	grids = result.get('Content', {}).get('PageGrid', {})
	for grid in grids:
		for seriesID in grid.get('Posts', {}):
			if seriesID in seriesIDs or seriesID == 13555 or seriesID == 170768:
				continue
			seriesIDs.append(seriesID)
			serie = result.get('ItemStore', {}).get(str(seriesID), {})
			link = serie['link']
			if 'item' in link:
				continue
			name = serie['title'].encode('utf-8')
			pageTitle = serie.get('pageTitle', {})
			description = name if pageTitle is None else pageTitle.get('description'.encode('utf-8'), name)
			if sortBy == 1:
				grids_arr.append((name, link, serie['images']['sidebar_portrait'].encode('utf-8'), {"Title": name, "Plot": description}))
			else:
				common.addDir(name, link, 1, serie['images']['sidebar_portrait'].encode('utf-8'), infos={"Title": name, "Plot": description}, module=module)
	if sortBy == 1:
		grids_sorted = sorted(grids_arr,key=lambda grids_arr: grids_arr[0])
		for name, link, image, infos in grids_sorted:
			common.addDir(name, link, 1, image, infos=infos, module=module)
	
def GetSeasonList(url, name, iconimage):
	result = GetUrlJson(url)
	if len(result) < 1:
		return
	grids = result.get('Content', {}).get('PageGrid', {})
	seasons = 0
	for grid in grids:
		if not 'GridTitle' in grid:
			continue
		link = grid['GridTitle']['link']
		if link and 'episodes' in link:
			name = grid['GridTitle']['title'].encode('utf-8')
			common.addDir(name, link, 2, iconimage, infos={"Title": name}, module=module)
			seasons += 1
	#if seasons < 1:
	grids = result.get('Content', {}).get('PageGrid', {})
	if len(grids) < 1:
		return
	'''
	for grid in grids:
		for pid in grid.get('Posts', {}):
			post = result.get('ItemStore', {}).get(str(pid), {})
			link = post['link']
			if 'episodes' in link:
				title = grid.get('GridTitle', {}).get('title', '')
				name = post['category'][0]['title'].encode('utf-8') if title is None or title == '' else title.encode('utf-8')
				link = link[:link.find('episodes/')+9].replace('item/', '')
				common.addDir(name, link, 2, iconimage, infos={"Title": name}, module=module)
				break
	'''
	for grid in grids:
		title = grid.get('GridTitle', {}).get('title', '')
		#if title != '':
		#	common.addDir('[COLOR green]' + title.encode('utf-8') + '[/COLOR]', '.', 9, iconimage, module=module, isFolder=False)
		for pid in grid.get('Posts', {}):
			post = result.get('ItemStore', {}).get(str(pid), {})
			if post is None or post['video'] is None or post['video']['videoID'] is None:
				continue
			icon =  post['images'].get('sidebar_portrait', iconimage).encode('utf-8')
			#icon =  post['video'].get('poster', icon)
			name = post['title'].encode('utf-8') if title is None or title == '' else '{0} - {1}'.format(title.encode('utf-8'), post['title'].encode('utf-8'))
			link = post['video']['videoID']
			if 'episodes' in post['link']:
				common.addDir(name, link, 3, icon, infos={"Title": name, "Plot": post['subtitle'].encode('utf-8'), "Aired": post['publishDate']}, contextMenu=[(common.GetLocaleString(30005), 'XBMC.RunPlugin({0}?url={1}&name={2}&mode=3&iconimage={3}&moredata=choose&module=reshet)'.format(sys.argv[0], urllib.quote_plus(link), urllib.quote_plus(name), urllib.quote_plus(icon)))], moreData='best', module=module, isFolder=False, isPlayable=True)
	page_url = result.get('PageMeta', {}).get('page_url', '')
	ShowPaging(grids, page_url, iconimage, 1)

def GetEpisodesList(url, iconimage):
	result = GetUrlJson(url)
	if len(result) < 1:
		return
	grids = result.get('Content', {}).get('PageGrid', {})
	for grid in grids:
		for pid in grid['Posts']:
			post = result.get('ItemStore', {}).get(str(pid), {})
			if post is None or post['video']['videoID'] is None:
				continue
			icon =  post['images'].get('sidebar_portrait', iconimage).encode('utf-8')
			#icon =  post['video'].get('poster', icon)
			name = post['title'].encode('utf-8')
			link = post['video']['videoID']
			common.addDir(name, link, 3, icon, infos={"Title": name, "Plot": post['subtitle'].encode('utf-8'), "Aired": post['publishDate']}, contextMenu=[(common.GetLocaleString(30005), 'XBMC.RunPlugin({0}?url={1}&name={2}&mode=3&iconimage={3}&moredata=choose&module=reshet)'.format(sys.argv[0], urllib.quote_plus(link), urllib.quote_plus(name), urllib.quote_plus(icon)))], moreData='best', module=module, isFolder=False, isPlayable=True)
	page_url = result.get('PageMeta', {}).get('page_url', '')
	ShowPaging(grids, page_url, iconimage, 2)

def ShowPaging(grids, page_url, iconimage, mode):
	WpQuery = grids[0].get('WpQuery', None)
	if WpQuery is None:
		paged = 0  
	else: 
		paged = WpQuery.get('paged', 0)
	if paged > 0 and  len(grids) > 0:
		max_page = grids[0].get('max_page', 0)
		if max_page > paged:
			common.addDir('[COLOR green]Next Page[/COLOR]', page_url + 'page/' + str(paged+1) + '/', mode, iconimage, module=module)
		if paged > 1:
			prev_page = page_url + 'page/' + str(paged-1) + '/' if paged - 1 > 1 else page_url
			common.addDir('[COLOR green]Prev Page[/COLOR]', prev_page, mode, iconimage, module=module)

def Play(url, name='', iconimage='', quality='best'):
	try:
		#url = 'http://c.brightcove.com/services/mobile/streaming/index/master.m3u8?videoId={0}'.format(url)
		headers={"Accept": "application/json;pk=BCpkADawqM30eqkItS5d08jYUtMkbTKu99oEBllbfUaFKeknXu4iYsh75cRm2huJ_b1-pXEPuvItI-733TqJN1zENi-DcHlt7b4Dv6gCT8T3BS-ampD0XMnORQLoLvjvxD14AseHxvk0esW3", "User-Agent": userAgent}
		result = common.OpenURL('https://edge.api.brightcove.com/playback/v1/accounts/1551111274001/videos/{0}'.format(url), headers=headers)
		sources = json.loads(result)['sources']
		link = ''
		avg_bitrate = 0
		for source in sources:
			if 'src' in source:
				if source['container'] == 'M2TS':
					link = common.GetStreams(source['src'], headers=headers, quality=quality)
					break
				if source['avg_bitrate'] > avg_bitrate:
					link = source['src']
					avg_bitrate = source['avg_bitrate']
					xbmc.log('[{0}]  {1}'.format(avg_bitrate, link), 5)
		final = '{0}|User-Agent={1}'.format(link, userAgent)
		if quality == 'choose' and '.m3u8' in final:
			listitem = xbmcgui.ListItem(name, path=final, iconImage=iconimage, thumbnailImage=iconimage)
			listitem.setInfo(type="Video", infoLabels={"Title": name})
			xbmc.Player().play(final, listitem)
		else:
			listitem = xbmcgui.ListItem(path=final)
			xbmcplugin.setResolvedUrl(handle=handle, succeeded=True, listitem=listitem)
	except Exception as ex:
		xbmc.log(str(ex), 3)

def ToggleSortMethod():
	if sortBy == 0:
		Addon.setSetting("reshetSortBy", "1")
	else:
		Addon.setSetting("reshetSortBy", "0")
	xbmc.executebuiltin("XBMC.Container.Refresh()")

def WatchLive(name='', iconimage='', quality='best'):
	headers={"Accept": "application/json;pk=BCpkADawqM30eqkItS5d08jYUtMkbTKu99oEBllbfUaFKeknXu4iYsh75cRm2huJ_b1-pXEPuvItI-733TqJN1zENi-DcHlt7b4Dv6gCT8T3BS-ampD0XMnORQLoLvjvxD14AseHxvk0esW3", "User-Agent": userAgent}
	result = common.OpenURL('https://edge.api.brightcove.com/playback/v1/accounts/1551111274001/videos/ref:stream_reshet_live1', headers=headers)
	link = common.GetStreams(json.loads(result)['sources'][0]['src'], headers=headers, quality=quality)
	final = '{0}|User-Agent={1}'.format(link, userAgent)
	if quality == 'choose':
		listitem = xbmcgui.ListItem(name, path=final, iconImage=iconimage, thumbnailImage=iconimage)
		listitem.setInfo(type="Video", infoLabels={"Title": name})
		xbmc.Player().play(final, listitem)
	else:
		listitem = xbmcgui.ListItem(path=final)
		xbmcplugin.setResolvedUrl(handle=handle, succeeded=True, listitem=listitem)

def Run(name, url, mode, iconimage='', moreData=''):
	if mode == 0:
		GetSeriesList()							# Series
	elif mode == 1:
		GetSeasonList(url, name, iconimage)		# Seasons
	elif mode == 2:
		GetEpisodesList(url, iconimage)			# Episodes
	elif mode == 3:
		Play(url, name, iconimage, moreData)	# Playing episode
	elif mode == 4:
		WatchLive(name, iconimage, moreData)	# Playing Live
	elif mode == 5:	
		ToggleSortMethod()						# Toggle Lists' sorting method
	
	common.SetViewMode('episodes')
