# -*- coding: utf-8 -*-
import xbmc, xbmcgui, xbmcplugin, xbmcaddon
import os, sys, uuid, urllib, re, json, cookielib
from datetime import date
import resources.lib.common as common

handle = int(sys.argv[1])
AddonID = 'plugin.video.idanplus'
Addon = xbmcaddon.Addon(AddonID)
imagesDir = xbmc.translatePath(os.path.join(Addon.getAddonInfo('path'), 'resources', 'images')).decode("utf-8")
module = 'keshet'
AddonName = "Idan Plus"
icon = Addon.getAddonInfo('icon')
sortBy = int(Addon.getSetting("makoSortBy"))
deviceID = Addon.getSetting("makoDeviceID")
if deviceID.strip() == '':
	uuidStr = str(uuid.uuid1()).upper()
	deviceID = "W{0}{1}".format(uuidStr[:8], uuidStr[9:])
	Addon.setSetting("makoDeviceID", deviceID)
username = Addon.getSetting("makoUsername")
password = Addon.getSetting("makoPassword")
endings = 'type=service&device=desktop&strto=desktop'
UA = common.GetUserAgent()

def GetCategoriesList():
	sortString = common.GetLocaleString(30002) if sortBy == 0 else common.GetLocaleString(30003)
	name = "{0}: {1}".format(common.GetLocaleString(30001), sortString)
	common.addDir(name, "toggleSortingMethod", 7, "", infos={"Title": name, "Plot": "{0}[CR]{1}[CR]{2} / {3}".format(name, common.GetLocaleString(30004), common.GetLocaleString(30002), common.GetLocaleString(30003))}, module=module, isFolder=False)
	name = "חיפוש"
	common.addDir(name, "http://www.mako.co.il/autocomplete/vodAutocompletion.ashx?query={0}&max=60&id=query", 6, os.path.join(imagesDir, 'search.jpg'), infos={"Title": name, "Plot": "חיפוש"}, module=module)
	name = "תכניות MakoTV"
	common.addDir(name, "http://www.mako.co.il/mako-vod-index", 1, os.path.join(imagesDir, 'vod.jpg'), infos={"Title": name, "Plot": "צפיה בתכני MakoTV"}, module=module)
	name = "תכניות ילדים"
	common.addDir(name, "http://www.mako.co.il/mako-vod-kids", 1, os.path.join(imagesDir, 'kids-programs.jpg'), infos={"Title": name, "Plot": "צפיה בתכניות ילדים"}, module=module)
	name = "קלטות ילדים"
	common.addDir(name, "http://www.mako.co.il/mako-vod-kids", 1, os.path.join(imagesDir, 'kids.jpg'), infos={"Title": name, "Plot": "צפיה בקלטות ילדים"}, module=module)
	name = "לייף סטייל"
	common.addDir(name, "http://www.mako.co.il/mako-vod-more/lifestyle", 1, os.path.join(imagesDir, 'lifestyle.jpg'), infos={"Title": name, "Plot": "צפיה בתכניות לייף סטייל"}, module=module)
	name = "דוקומנטרי - תכניות"
	common.addDir(name, "http://www.mako.co.il/mako-vod-more/docu_tv", 1, os.path.join(imagesDir, 'docu.jpg'), infos={"Title": name, "Plot": "צפיה בתכנים דוקומנטריים"}, module=module)
	name = "דוקומנטרי - סרטים"
	common.addDir(name, "http://www.mako.co.il/mako-vod-more/docu_tv", 1, os.path.join(imagesDir, 'docu.jpg'), infos={"Title": name, "Plot": "צפיה בתכנים דוקומנטריים"}, module=module)
	name = "הופעות"
	common.addDir(name, "http://www.mako.co.il/mako-vod-more/concerts", 1, os.path.join(imagesDir, 'live-music.jpg'), infos={"Title": name, "Plot": "צפיה בהופעות חיות"}, module=module)
	name = "הרצאות"
	common.addDir(name, "http://www.mako.co.il/mako-vod-more/lectures", 1, os.path.join(imagesDir, 'lectures.jpg'), infos={"Title": name, "Plot": "צפיה בהרצאות"}, module=module)
	name = "חדשות 2"
	common.addDir(name, "news", 20, os.path.join(imagesDir, 'news.jpg'), infos={"Title": name, "Plot": "צפיה בחדשות ערוץ 2"}, module=module)

def GetSeriesList(catName, url, iconimage):
	url = "{0}&{1}".format(url, endings) if "?" in url else "{0}?{1}".format(url, endings)
	prms1 = GetJson(url)
	if prms1 is None:
		"Cannot get {0} list".format(catName)
		return
	key2 = None
	picKey = "picUrl_F"
	if catName == "תכניות MakoTV":
		key1 = "allPrograms"
	elif catName == "תכניות ילדים":
		key1 = "kidsPrograms"
	elif catName == "קלטות ילדים":
		key1 = "kidsCassettes"
	elif "חדשות 2" in catName:
		key1 = "newsData"
		key2 = "list"
		picKey = "picI"
	elif catName == "הופעות" or catName == "הרצאות" or catName == "דוקומנטרי - סרטים":
		key1 = "moreVOD"
		key2 = "items"
		picKey = "picB"
	else:
		key1 = "moreVOD"
		key2 = "programItems"
	if key2 is None:
		if not prms1.has_key(key1):
			"Cannot get {0} list".format(catName)
			return
		prms = prms1[key1]
	else:
		if not prms1.has_key(key1) or not prms1[key1].has_key(key2):
			"Cannot get {0} list".format(catName)
			return
		prms = prms1[key1][key2]
	seriesCount = len(prms)
	for prm in prms:
		try:
			name = prm["title"].encode("utf-8")
			mode = 2
			if "VOD-" in prm["url"]:
				mode = 5 
				if prm.has_key("subtitle") and len(prm["subtitle"]) > 0:
					name = "{0} - {1}".format(name, prm["subtitle"].encode("utf-8"))
			url = "http://www.mako.co.il{0}".format(prm["url"])
			iconimage = prm[picKey] if prm.has_key(picKey) else None
			if iconimage is None:
				iconimage = prm["pic"] if prm.has_key("pic") else None
			if iconimage is None:
				iconimage = prm["picUrl"] if prm.has_key("picUrl") else None
			description = prm["brief"].encode("utf-8") if prm.has_key("brief") else ""
			if prm.has_key("plot"):
				description = "{0} - {1}".format(description, prm["plot"].encode("utf-8"))
			if "חדשות 2" in catName:
				name = "{0} - {1}".format(prm["label"].encode("utf-8"), prm["title"].encode("utf-8"))
				description = prm["subtitle"].encode("utf-8")
			infos = {"Title": name, "Plot": description}
			if mode == 2:
				common.addDir(name, url, 2, iconimage, infos, module=module, totalItems=seriesCount)
			else:
				common.addDir(name, url, 5, iconimage, infos, contextMenu=[(common.GetLocaleString(30005), 'XBMC.RunPlugin({0}?url={1}&name={2}&mode=5&iconimage={3}&moredata=choose&module=keshet)'.format(sys.argv[0], urllib.quote_plus(url), urllib.quote_plus(name), urllib.quote_plus(iconimage)))], moreData='best', module='keshet', isFolder=False, isPlayable=True)
			
		except Exception as ex:
			xbmc.log(str(ex), 3)

def GetSeasonsList(url, iconimage):
	url = "{0}&{1}".format(url, endings) if "?" in url else "{0}?{1}".format(url, endings)
	prms = GetJson(url)
	if prms is None or not prms.has_key("programData") or not prms["programData"].has_key("seasons"):
		xbmc.log("Cannot get Seasons list", 2)
		return
	iconimage = prms["programData"]["programPicVOD"] if prms["programData"].has_key("programPicVOD") and prms["programData"]["programPicVOD"] != '' else iconimage
	for prm in prms["programData"]["seasons"]:
		try:
			if not prm.has_key("vods"):
				continue
			name = prm["name"].encode("utf-8")
			url = "http://www.mako.co.il{0}".format(prm["url"])
			description = prm["brief"].encode("utf-8")
			infos = {"Title": name, "Plot": description}
			common.addDir(name, url, 3, iconimage, infos, module=module)
		except Exception as ex:
			xbmc.log(str(ex), 3)

def GetEpisodesList(url):
	url = "{0}&{1}".format(url, endings) if "?" in url else "{0}?{1}".format(url, endings)
	prms = GetJson(url)
	if prms is None or not prms.has_key("channelId") or not prms.has_key("programData") or not prms["programData"].has_key("seasons"):
		xbmc.log("Cannot get Seasons list", 2)
		return
	videoChannelId=prms["channelId"]
	for prm in prms["programData"]["seasons"]:
		if prm is None or not prm.has_key("vods") or not prm.has_key("current") or prm["current"].lower() != "true":
			continue
		episodesCount = len(prm["vods"])
		for episode in prm["vods"]:
			try:
				vcmid = episode["guid"]
				name = "{0} - {1}".format(episode["title"].encode("utf-8"), episode["shortSubtitle"].encode("utf-8"))
				url = "http://www.mako.co.il/VodPlaylist?vcmid={0}&videoChannelId={1}".format(vcmid,videoChannelId)
				iconimage =  episode["picUrl"]
				description = episode["subtitle"].encode("utf-8")
				infos = {"Title": name, "Plot": description, "Aired": episode["date"][episode["date"].find(' ')+1:]}
				#common.addDir(name, url, 4, iconimage, infos, module=module, totalItems=episodesCount, isFolder=False, isPlayable=True)
				common.addDir(name, url, 4, iconimage, infos, contextMenu=[(common.GetLocaleString(30005), 'XBMC.RunPlugin({0}?url={1}&name={2}&mode=4&iconimage={3}&moredata=choose&module=keshet)'.format(sys.argv[0], urllib.quote_plus(url), urllib.quote_plus(name), urllib.quote_plus(iconimage)))], moreData='best', module='keshet', isFolder=False, isPlayable=True)
			except Exception as ex:
				xbmc.log(str(ex), 3)

def GetChannels(url, iconimage):
	html = common.OpenURL(url, headers={"User-Agent": UA})
	if html == "":
		return None
	match = re.compile("var makoliveJson ='(.*?)';").findall(html)
	resultJSON = json.loads(match[0])
	if resultJSON is None or len(resultJSON) < 1:
		return None
	for channel in resultJSON['list']:
		name = channel['title'].encode("utf-8")
		infos = {"Title": name, "Plot": channel['subtitle'].encode("utf-8")}
		url = 'http://www.mako.co.il{0}'.format(channel['link'])
		iconimage = channel['picUrl']
		common.addDir(name, url, 5, iconimage, infos, contextMenu=[(common.GetLocaleString(30005), 'XBMC.RunPlugin({0}?url={1}&name={2}&mode=5&iconimage={3}&moredata=choose&module=keshet)'.format(sys.argv[0], urllib.quote_plus(url), urllib.quote_plus(name), urllib.quote_plus(iconimage)))], moreData='best', module='keshet', isFolder=False, isPlayable=True)

def WatchLive(url, name='', iconimage='', quality='best'):
	channels = {
		'12': 'http://www.mako.co.il/mako-vod-live-tv/VOD-6540b8dcb64fd31006.htm',
		'24': 'http://www.mako.co.il/mako-vod-live-tv/VOD-b3480d2eff3fd31006.htm',
		'keshetBest': 'http://www.mako.co.il/mako-vod-live-tv/VOD-49a6215abae1b51006.htm'
	}
	PlayItem(channels[url], name, iconimage, quality)
	

def PlayItem(url, name='', iconimage='', quality='best'):
	url = "{0}&{1}".format(url, endings) if "?" in url else "{0}?{1}".format(url, endings)
	prms = GetJson(url)
	if prms is None or not prms.has_key("video"):
		xbmc.log("Cannot get item", 2)
		return
	videoChannelId=prms["channelId"]
	vcmid = prms["video"]["guid"]
	url = "http://www.mako.co.il/VodPlaylist?vcmid={0}&videoChannelId={1}".format(vcmid,videoChannelId)
	Play(url, name, iconimage, quality)

def Play(url, name='', iconimage='', quality='best'):
	common.DelCookies()
	headers={"User-Agent": UA}
	g = url[url.find('vcmid=')+6: url.find('&videoChannelId=')]
	h = url[url.find('&videoChannelId=')+16:]
	text = common.OpenURL('http://www.mako.co.il/AjaxPage?jspName=playlist.jsp&vcmid={0}&videoChannelId={1}&consumer=web&encryption=no'.format(g, h), headers=headers)
	result = json.loads(text)['media']
	u = ""
	for item in result:
		if item['format'] == 'AKAMAI_HLS':
			u = item['url']
			if '512035/CH2LIVE_LOW' in u:
				u = u.replace('512035/CH2LIVE_LOW', '512033/CH2LIVE_HIGH')
			u2 = u[u.find('/', 7):]
			break
	if username.strip() == '':
		l = 'http://mass.mako.co.il/ClicksStatistics/entitlementsServicesV2.jsp?et=gt&rv=akamai&lp={0}'.format(u2)
	else:
		l = 'http://mass.mako.co.il/ClicksStatistics/entitlementsServicesV2.jsp?et=gt&na=2.0&da=6gkr2ks9-4610-392g-f4s8-d743gg4623k2&du={0}&dv={1}&rv=akamai&lp={2}'.format(deviceID, g, u2)
	text = common.OpenURL(l, headers=headers)
	result = json.loads(text)
	if result['caseId'] == '4':
		result = Login()
		text = common.OpenURL(l, headers=headers)
		result = json.loads(text)
		if result['caseId'] != '1':
			xbmc.executebuiltin("XBMC.Notification({0}, You need to pay if you want to watch this video., {1}, {2})".format(AddonName, 5000 ,icon))
			return
	elif result['caseId'] != '1':
		xbmc.executebuiltin("XBMC.Notification({0}, Cannot get access for this video., {1}, {2})".format(AddonName, 5000 ,icon))
		return
	t = urllib.unquote_plus(result['tickets'][0]['ticket'])
	if u.startswith('//'):
		u = 'http:{0}'.format(u)
	cookie_jar = cookielib.LWPCookieJar()
	link = common.GetStreams('{0}?{1}'.format(u, t), headers=headers, CookieJar=cookie_jar, quality=quality)
	cookies = ";".join(['{0}'.format(urllib.quote('{0}={1}'.format(_cookie.name, _cookie.value))) for _cookie in cookie_jar])
	final = '{0}|User-Agent={1}&Cookie={2}'.format(link, UA, cookies)
	if quality == 'choose':
		listitem = xbmcgui.ListItem(name, path=final, iconImage=iconimage, thumbnailImage=iconimage)
		listitem.setInfo(type="Video", infoLabels={"Title": name})
		xbmc.Player().play(final, listitem)
	else:
		listitem = xbmcgui.ListItem(path=final)
		xbmcplugin.setResolvedUrl(handle=handle, succeeded=True, listitem=listitem)

def Login():
	headers={"User-Agent": UA}
	link = 'http://mass.mako.co.il/ClicksStatistics/entitlementsServicesV2.jsp?eu={0}&da=6gkr2ks9-4610-392g-f4s8-d743gg4623k2&dwp={1}&et=ln&du={2}'
	text = common.OpenURL(link.format(username, password, deviceID), headers=headers)
	result = json.loads(text)
	if result['caseId'] != '1':
		return result
	link = 'http://mass.mako.co.il/ClicksStatistics/entitlementsServicesV2.jsp?da=6gkr2ks9-4610-392g-f4s8-d743gg4623k2&et=gds&du={0}'
	text = common.OpenURL(link.format(deviceID), headers=headers)
	result = json.loads(text)
	return result

def ShowYears():
	for year in range(date.today().year, 2007, -1):
		name = 'חדשות 2 לשנת {0}'.format(year)
		common.addDir(name, str(year), 21, "http://www.orian.com/_uploads/imagesgallery/logo.bmp", {"Title": name, "Plot": "צפיה ב{0}".format(name)}, module=module)

def ShowMonthes(year):
	fromMonth = 12 if date.today().year != int(year) else date.today().month
	toMonth = 0 if year != '2008' else 4
	for month in range(fromMonth, toMonth, -1):
		name = 'חדשות 2 לחודש {0:02d}-{1}'.format(month, year)
		common.addDir(name, 'http://www.mako.co.il/mako-vod-channel2-news/{0}-{1:02d}'.format(year, month), 1, "http://www.orian.com/_uploads/imagesgallery/logo.bmp", {"Title": name, "Plot": "צפיה ב{0}".format(name)}, module=module)

def GetJson(url):
	html = common.OpenURL(url, headers={"User-Agent": UA})
	if html == "":
		return None
	resultJSON = json.loads(html)
	if resultJSON is None or len(resultJSON) < 1:
		return None
	if resultJSON.has_key("root"):
		return resultJSON["root"]
	else:
		return resultJSON

def Search(url, iconimage):
	search_entered =''
	keyboard = xbmc.Keyboard(search_entered, 'מילים לחיפוש')
	keyboard.doModal()
	if keyboard.isConfirmed():
		search_entered = keyboard.getText()
	if search_entered !='':
		url = url.format(search_entered)
		params = GetJson(url)
		suggestions = params["suggestions"]
		data = params["data"]
		for i in range(len(suggestions)):
			if "mako-vod-channel2-news" in data[i]:
				continue
			url = "http://www.mako.co.il{0}".format(data[i])
			name = common.UnEscapeXML(suggestions[i]).encode("utf-8")
			infos={"Title": name, "Plot": name}
			if "VOD-" in data[i]:
				common.addDir(name, url, 5, iconimage, infos, contextMenu=[(common.GetLocaleString(30005), 'XBMC.RunPlugin({0}?url={1}&name={2}&mode=5&iconimage={3}&moredata=choose&module=keshet)'.format(sys.argv[0], urllib.quote_plus(url), urllib.quote_plus(name), urllib.quote_plus(iconimage)))], moreData='best', module='keshet', isFolder=False, isPlayable=True)
			else:
				common.addDir(name, url, 2, iconimage, infos, module=module)
	else:
		return

def ToggleSortMethod():
	if sortBy == 0:
		Addon.setSetting("makoSortBy", "1")
	else:
		Addon.setSetting("makoSortBy", "0")
	xbmc.executebuiltin("XBMC.Container.Refresh()")

def Run(name, url, mode, iconimage='', moreData=''):
	if mode == 0:
		GetCategoriesList()
	elif mode == 1:	#"------------- Series: -----------------
		GetSeriesList(name, url, iconimage)
	elif mode == 2:	#------------- Seasons: -----------------
		GetSeasonsList(url, iconimage)
	elif mode == 3:	#------------- Episodes: -----------------
		GetEpisodesList(url)
	elif mode == 4:	#------------- Playing episode  -----------------
		Play(url, name, iconimage, moreData)
	elif mode == 5:	#------------- Playing item: -----------------
		if moreData == '':
			moreData = 'best'
		PlayItem(url, name, iconimage, moreData)
	elif mode == 6:	#------------- Search items: -----------------
		Search(url, iconimage)
	elif mode == 7:	#------------- Toggle Lists' sorting method: -----------------
		ToggleSortMethod()
	elif mode == 8:
		GetChannels(url, iconimage)
	elif mode == 10:
		WatchLive(url, name, iconimage, moreData)
	elif mode == 20:
		ShowYears()
	elif mode == 21:
		ShowMonthes(url)
		
	common.SetViewMode('episodes')
	if sortBy == 1 and mode != 0 and mode != 6:
		xbmcplugin.addSortMethod(handle, 1)
