﻿# -*- coding: utf-8 -*-
import xbmc, xbmcgui, xbmcplugin, xbmcaddon
import sys, os, re, json, urllib, urllib2, urlparse, time, datetime
import resources.lib.common as common

handle = int(sys.argv[1])
AddonID = 'plugin.video.idanplus'
Addon = xbmcaddon.Addon(AddonID)
module = 'epg'
epgsDir = os.path.join(xbmc.translatePath(Addon.getAddonInfo("profile")).decode("utf-8"), 'EPG')
if not os.path.exists(epgsDir):
	os.makedirs(epgsDir)
userAgent = common.GetUserAgent()
channels = {
	"11": {"auto": "yes", "yes": "CH30", "hot": "839", "walla": "3787"},
	"12": {"auto": "yes", "yes": "CH34", "hot": "861", "walla": "3819"},
	"13": {"auto": "yes", "yes": "CH36", "hot": "863", "walla": "3821"},
	"14": {"auto": "yes", "yes": "TV04", "hot": "859", "walla": "3817"},
	"20": {"auto": "yes", "yes": "PT92", "hot": "766"},
	"24": {"auto": "yes", "yes": "TV67", "hot": "578", "walla": "255"},
	"33": {"auto": "yes", "yes": "CH32", "hot": "841"},
	"66": {"auto": "hot", "hot": "569"},
	"96": {"auto": "yes", "yes": "PT89"},
	"97": {"auto": "yes", "yes": "PT30", "hot": "565"},
	"99": {"auto": "yes", "yes": "TV89", "hot": "573"}
}

def ShowChannelEPG(channel, name='', iconimage='', provider='auto', days=2):
	now = int(time.time())
	common.addDir('------- [B][COLOR {0}]{1}[/COLOR][/B] -------'.format(Addon.getSetting("chColor"), name, Addon.getSetting("prColor")), name, 99, iconimage, isFolder=False)
	day = ""
	programs = GetEPG(channel, provider=provider, days=days)
	for program in programs:
		if now >= program['end']:
			continue
		startdate = datetime.datetime.fromtimestamp(program["start"]).strftime('%d/%m/%y')
		if startdate != day:
			day = startdate
			dayS = '[COLOR {0}][B]{1}:[/B][/COLOR]'.format(Addon.getSetting("nprColor"), day)
			common.addDir(dayS, 'epg', 99, iconimage, {"Title": dayS}, module=module, isFolder=False)
		start_time = datetime.datetime.fromtimestamp(program["start"]).strftime('%H:%M')
		end_time = datetime.datetime.fromtimestamp(program["end"]).strftime('%H:%M')
		programName = "[COLOR {0}][{1}-{2}][/COLOR] [COLOR {3}][B]{4}[/B][/COLOR]".format(Addon.getSetting("timesColor"), start_time, end_time, Addon.getSetting("prColor"), program["name"].strip().encode('utf-8'))
		description = program["description"].strip().encode('utf-8')
		common.addDir(programName, 'epg', 99, iconimage, {"Title": programName, "Plot": description}, module=module, isFolder=False)

def GetWallaChannelEPG(channel, days=5):
	programs = []
	now = int(time.time())
	today = int(time.mktime(datetime.date.today().timetuple()))
	headers={"User-Agent": userAgent}
	url = 'https://tv-guide.walla.co.il/channel/{0}'.format(channel)
	text = common.OpenURL(url, headers=headers)
	lines = re.compile('<li class="channel-line(.*?)</ol>').findall(text)
	day = 0
	for line in lines:
		matches = re.compile('<li style="flex:.*?data-obj=\'(.*?)\'.*?</li>').findall(line)
		for match in matches:
			program = json.loads(match)
			start_time = today + (int(program['start_time'][:2]) * 60 + int(program['start_time'][3:]))*60
			end_time = today + (int(program['end_time'][:2]) * 60 + int(program['end_time'][3:]))*60
			if now >= end_time:
				continue
			programs.append({"start": start_time, "end": end_time, "name": program['name'].strip(), "description": program['description'].strip()})
		day += 1
		if day ==  days:
			break
	return programs

def GetYesChannelEPG(channel, days=2):
	programs = []
	now = int(time.time())
	today = int(time.mktime(datetime.date.today().timetuple()))
	headers={"User-Agent": userAgent}
	for day in range(days):
		url = 'https://www.yes.co.il/content/YesChannelsHandler.ashx?action=GetDailyShowsByDayAndChannelCode&dayValue={0}&dayPartByHalfHour=0&channelCode={1}'.format(day, channel)
		text = common.OpenURL(url, headers=headers)
		matches = re.compile('<a Schedule_Item_ID="(.*?)".*?"text">(.*?)\s*\-\s*(.*?)</span>').findall(text)
		for i in range(len(matches)):
			if day == 0:
				end_time = today + (int(matches[i+1][1][:2]) * 60 + int(matches[i+1][1][3:5]))*60 if i+1 < len(matches) else today+86400
				if now >= end_time:
					continue
			url = 'https://www.yes.co.il/content/YesChannelsHandler.ashx?action=GetProgramDataByScheduleItemID&ScheduleItemID={0}'.format(matches[i][0])
			program = json.loads(common.OpenURL(url, headers=headers))
			start_time = int(re.compile('Date\((\d*)\)').findall(program['Start_Time_Fix_DateTime'])[0])/1000
			end_time = int(re.compile('Date\((\d*)\)').findall(program['End_Time_Fix_DateTime'])[0])/1000
			programs.append({"start": start_time, "end": end_time, "name": program['Hebrew_Name'].strip(), "description": program['PreviewText'].strip()})
	return programs

def GetHotChannelEPG(channel, days=2):
	programs = []
	now = int(time.time())
	t = datetime.date.today()
	todayS = t.strftime('%d/%m/%Y %H:%M:00').replace(' ', '%20')
	daysS = (t+datetime.timedelta(days=days)).strftime('%d/%m/%Y %H:%M:00').replace(' ', '%20')
	headers={"User-Agent": userAgent}
	basUrl = 'http://www.hot.net.il/PageHandlers/LineUpAdvanceSearch.aspx?text=&channel={0}&genre=-1&ageRating=-1&publishYear=-1&productionCountry=-1&startDate={1}&endDate={2}&startTime={1}&endTime={2}&currentPage=undefined&pageSize={3}&isOrderByDate=true&lcid=1037'
	url = basUrl.format(channel, todayS, daysS, '10')
	text = common.OpenURL(url, headers=headers)
	matches = re.compile('<h2>.+?(\d+).+?</h2>').findall(text)
	url = basUrl.format(channel, todayS, daysS, matches[0])
	text = common.OpenURL(url, headers=headers)
	matches = re.compile('<tr.*?LineUpId=(\d*)\'".*?<td.*?></td>\s*?<td.*?>\d*</td>\s*?<td.*?>(.*?)</td>\s*?<td.*?>.*?/td>\s*?<td.*?>.*?, (.*?)</td>\s*?<td.*?>(.*?)</td>.*?</tr>', re.S).findall(text)
	for match in matches:
		startStr = match[2]
		startDT = datetime.datetime(int(startStr[6:10]), int(startStr[3:5]), int(startStr[0:2]), int(startStr[11:13]), int(startStr[14:16]), 0)
		start_time = int(time.mktime(startDT.timetuple()))
		end_time = start_time + (int(match[3][:2]) * 60 + int(match[3][3:]))*60
		if now >= end_time:
			continue
		url = 'http://www.hot.net.il/heb/TV/TVGuide/ShowTime/.aspx?LineUpId={0}'.format(match[0])
		text = common.OpenURL(url, headers=headers)
		desc = re.compile('<div class="widgetHPTitle">.*?<td.*?>(.*?)</td>', re.S).findall(text)
		description = desc[0].strip().decode('utf-8')
		programs.append({"start": start_time, "end": end_time, "name": match[1].strip().decode('utf-8'), "description": description, "id": match[0]})
	return programs

def GetEPG(channel, provider='auto', days=2):
	filename = os.path.join(epgsDir, '{0}.json'.format(channel))
	if provider == 'auto':
		provider = channels[channel].get('auto')
	channel = channels[channel].get(provider)
	if channel is None:
		return []
	if common.isFileOld(filename):
		programs = []
		try:
			if provider == 'yes':
				programs = GetYesChannelEPG(channel, days=days)
			elif provider == 'hot':
				programs = GetHotChannelEPG(channel, days=days)
			elif provider == 'walla':
				programs = GetWallaChannelEPG(channel, days=days)
		except Exception as ex:
			xbmc.log("{0}".format(ex), 3)
		common.WriteList(filename, programs)
	return common.ReadList(filename)

def GetNowEPG():
	yesEPG = GetYesNowEPG()
	hotEPG = GetHotNowEPG()
	for ch in list(hotEPG.keys()):
		if ch not in list(yesEPG.keys()):
			yesEPG[ch] = hotEPG[ch]
	return yesEPG

def GetHotNowEPG():
	epg = {}
	try:
		#today = int(time.mktime(datetime.date.today().timetuple()))
		now = datetime.datetime.now()
		nowS = now.strftime('%d/%m/%Y %H:%M:%S').replace(' ', '%20')
		hourS = now.strftime('%H:00')
		headers={"User-Agent": userAgent}
		url = 'http://www.hot.net.il/PageHandlers/LineUpGuide.aspx?lcid=1037&controlId=2882&Date={0}&Hour={1}&GenreId=-1'.format(nowS, hourS)
		text = common.OpenURL(url, headers=headers)
		chs = re.compile('<td class="LineUpGenres ChannelTd">.*?<span>\s*(\d*)</span>', re.S).findall(text)
		programs = re.compile('<tr>\s*<td  class="lineupguideshows"(.*?)</tr>', re.S).findall(text)
		if len(chs) != len(programs):
			return {}
		
		for i in range(len(chs)):
			ch = chs[i]
			if ch == '96':
				ch = '66'
			if ch not in list(channels.keys()) or 'hot' not in list(channels[ch].keys()):
				continue
			program = re.compile('id="(\d*)"\s*title="(\d\d):(\d\d)\s*(.*?)"').findall(programs[i])[0]
			epg[ch] = {"name": common.UnEscapeXML(program[3].strip()), "start": '{0}:{1}'.format(program[1], program[2]), "id": program[0]}
			#epg[ch] = {"name": program[3].strip(), "start": today + (int(program[1]) * 60 + int(program[2]))*60, "id": program[0]}
	except Exception as ex:
		xbmc.log("{0}".format(ex), 3)
	return epg

def GetYesNowEPG():
	epg = {}
	try:
		#today = int(time.mktime(datetime.date.today().timetuple()))
		headers={"User-Agent": userAgent}
		url = 'https://www.yes.co.il/content/tvguide'
		text = common.OpenURL(url, headers=headers)
		matches = re.compile('<div class="number">(\d*)</div>.*?<li(.*?)</ul>', re.S).findall(text)
		for match in matches:
			ch = match[0]
			if ch not in list(channels.keys()) or 'yes' not in list(channels[ch].keys()):
				continue
			progs = re.compile('Schedule_Item_ID="(\d*)".*?<span class="text">(\d*):(\d*) - (.*?)</span>').findall(match[1])
			program = progs[0]
			epg[ch] = {"name": program[3].strip(), "start": '{0}:{1}'.format(program[1], program[2]), "id": program[0]}
			#epg[ch] = {"name": program[3].strip(), "start": today + (int(program[1]) * 60 + int(program[2]))*60, "id": program[0]}
	except Exception as ex:
		xbmc.log("{0}".format(ex), 3)
	return epg

def Run(name, url, mode, iconimage='', moreData=''):
	if mode == 2:
		days = 2
		provider = 'auto'
		if moreData != '':
			params = moreData.split(';')
			for param in params:
				prm = param.split('=')
				if prm[0] == 'provider':
					provider = prm[1]
				elif prm[0] == 'days':
					days = prm[1]
		ShowChannelEPG(url, name, iconimage, provider, days)
	common.SetViewMode('episodes')