# -*- coding: utf-8 -*-
import sys, os, urlparse, urllib
import xbmc, xbmcplugin, xbmcaddon
import resources.lib.common as common
import resources.lib.epg as epg

handle = int(sys.argv[1])
AddonID = 'plugin.video.idanplus'
Addon = xbmcaddon.Addon(AddonID)
icon = Addon.getAddonInfo('icon')
imagesDir = xbmc.translatePath(os.path.join(Addon.getAddonInfo('path'), 'resources', 'images')).decode("utf-8")

params = dict(urlparse.parse_qsl(sys.argv[2].replace('?','')))
url = urllib.unquote_plus(params.get('url', ''))
mode = int(params.get('mode','-1'))
name = urllib.unquote_plus(params.get('name', ''))
iconimage = urllib.unquote_plus(params.get('iconimage', ''))
module = params.get('module')
moreData = urllib.unquote_plus(params.get('moredata', ''))

def GetCategoriesList():
	name = '[B]שידורים חיים[/B]'
	common.addDir(name, '', 1, icon, {"Title": name})
	name = 'מאקו VOD'
	common.addDir(name, '', 0, os.path.join(imagesDir, "mako.png"), infos={"Title": name}, module='keshet')
	name = 'רשת VOD'
	common.addDir(name, '', 0, os.path.join(imagesDir, "reshet.png"), infos={"Title": name}, module='reshet')
	name = 'עשר VOD'
	common.addDir(name, '', 0, os.path.join(imagesDir, "ten.png"), infos={"Title": name}, module='ten')

def LiveChannels():
	name = '[B]קליק ימני על ערוץ להורדת מדריך מפורט [/B]'
	common.addDir(name, '', 99, icon, infos={"Title": name}, isFolder=False)
	name = '[B]רענון רשימה[/B]'
	common.addDir(name, '', 2, icon, infos={"Title": name}, isFolder=False)
	nowEPG = epg.GetNowEPG()
	LiveChannel('כאן 11', '11', 10, os.path.join(imagesDir, "11.png"), 'kan', nowEPG=nowEPG)
	LiveChannel('קשת 12', '12', 10, 'http://img.mako.co.il/2017/11/01/i_12_c.jpg', 'keshet', nowEPG=nowEPG)
	LiveChannel('רשת 13', '13', 4, os.path.join(imagesDir, "reshet.png"), 'reshet', nowEPG=nowEPG)
	LiveChannel('עשר 14', '14', 6, os.path.join(imagesDir, "ten.png"), 'ten', nowEPG=nowEPG)
	LiveChannel('מורשת 20', '20', 10, os.path.join(imagesDir, "20.png"), 'twenty', nowEPG=nowEPG)
	LiveChannel('מוזיקה 24', '24', 10, 'http://img.mako.co.il/2016/07/11/eyal_c.jpg', 'keshet', nowEPG=nowEPG)
	LiveChannel('מכאן 33', '33', 10, os.path.join(imagesDir, "33.png"), 'kan', nowEPG=nowEPG)
	LiveChannel('קבלה 66', '66', 10, os.path.join(imagesDir, "kabbalah.jpg"), 'kabbalah', nowEPG=nowEPG)
	LiveChannel('מאיר 96', '96', 10, os.path.join(imagesDir, "meirtv.jpg"), 'meirtv', nowEPG=nowEPG)
	LiveChannel('הידברות 97', '97', 10, os.path.join(imagesDir, "hidabroot.jpg"), 'hidabroot', nowEPG=nowEPG)
	LiveChannel('כנסת 99', '99', 10, os.path.join(imagesDir, "knesset.png"), 'knesset', nowEPG=nowEPG)
	LiveChannel('i24 English', 'i24en', 10, os.path.join(imagesDir, "i24.png"), 'i24', epg=False, nowEPG=nowEPG)
	LiveChannel('i24 French', 'i24fr', 10, os.path.join(imagesDir, "i24.png"), 'i24', epg=False, nowEPG=nowEPG)
	LiveChannel('i24 Arabic', 'i24ar', 10, os.path.join(imagesDir, "i24.png"), 'i24', epg=False, nowEPG=nowEPG)
	LiveChannel('קשת המיטב', 'keshetBest', 10, 'http://img.mako.co.il/2017/03/30/meitav_i_c.jpg', 'keshet', epg=False, nowEPG=nowEPG)

def LiveChannel(name, url, mode, iconimage, module, choose=True, epg=True, nowEPG={}):
	contextMenu = []
	if choose:
		contextMenu.append((common.GetLocaleString(30005), 'RunPlugin({0}?url={1}&name={2}&mode={3}&iconimage={4}&moredata=choose&module={5})'.format(sys.argv[0], url, urllib.quote_plus(name), mode, urllib.quote_plus(iconimage), module)))
	if epg:
		contextMenu.append(('EPG', 'Container.Update({0}?url={1}&name={2}&mode=2&iconimage={3}&module=epg)'.format(sys.argv[0], url, urllib.quote_plus(name), urllib.quote_plus(iconimage))))
	if contextMenu == []:
		contextMenu = None
	displayName = "[COLOR {0}][B]{1}[/B][/COLOR]".format(Addon.getSetting("chColor"), name)
	if url in list(nowEPG.keys()):
		programmeName = "[COLOR {0}][B]{1}[/B][/COLOR] [COLOR {2}][{3}][/COLOR]".format(Addon.getSetting("prColor"), nowEPG[url]['name'], Addon.getSetting("timesColor"), nowEPG[url]['start'])
		displayName = "{0} - {1}".format(displayName, programmeName)
	common.addDir(displayName, url, mode, iconimage, infos={"Title": displayName}, contextMenu=contextMenu, moreData='best', module=module, isFolder=False, isPlayable=True)

if module is None:
	if mode == -1:
		GetCategoriesList()
	elif mode == 1:
		LiveChannels()
	elif mode == 2:
		xbmc.executebuiltin("Container.Refresh()")
else:
	try:
		moduleScript = __import__('resources.lib.{0}'.format(module), fromlist=[module])
		moduleScript.Run(name, url, mode, iconimage, moreData)
	except Exception as ex:
		xbmc.log(str(ex), 3)

xbmcplugin.endOfDirectory(handle)