# -*- coding: utf-8 -*-

"""
    Greek Voice Add-on
    Author: Twilight

        This program is free software: you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

import re, os, sys
import urllib2, urlparse
import xbmc, xbmcaddon, xbmcgui, xbmcplugin


# Commands:
join = os.path.join
addon = xbmcaddon.Addon

language = addon().getLocalizedString
addonname = addon().getAddonInfo("name")
addonid = addon().getAddonInfo("id")
addonpath = addon().getAddonInfo("path")
addonfanart = addon().getAddonInfo("fanart")
addonicon = addon().getAddonInfo("icon")
addonmedia = join(addon('script.greekvoice.artwork').getAddonInfo('path'), 'resources', 'media')
addDirItem = xbmcplugin.addDirectoryItem
addDirItems = xbmcplugin.addDirectoryItems
endDir = xbmcplugin.endOfDirectory
dialog = xbmcgui.Dialog()

# Handlers:
addon_url = sys.argv[0]
addon_handle = int(sys.argv[1])
params = dict(urlparse.parse_qsl(sys.argv[2][1:]))
action = params.get('action')
url = params.get('url')

items = [
    {
        'title': 'Greek Voice 1',
        'icon': join(addonmedia, 'GV1_icon.png'),
        'url': 'http://stream.ssh101.com:1935/live/greekvoice/playlist.m3u8',
        'fanart': join(addonmedia, 'GV_TV1_fanart.jpg'),
        'plot': 'Greek Voice 1'.decode('utf-8')
    },
    {
        'title': 'Greek Voice 2',
        'icon': join(addonmedia, 'GV2_icon.png'),
        'url': 'http://stream.ssh101.com:1935/live/greekvoice/playlist.m3u8',
        'fanart': join(addonmedia, 'GV_TV2_fanart.jpg'),
        'plot': 'Greek Voice 2'.decode('utf-8')
    },
    {
        'title': 'TILEMOUSIKI 1 SD',
        'icon': join(addonmedia, 'TILEMOUSIKI1SD.png'),
        'url': 'mmsh://wpso.com:200/music',
        'fanart': join(addonmedia, 'TILEMOUSIKI_fanart.jpg'),
        'plot': 'Εκπέμπει Παλαιά Τραγούδια και κονσέρτα σε ποιότητα SD'.decode('utf-8')
    },
    {
        'title': 'TILEMOUSIKI 2 HD',
        'icon': join(addonmedia, 'TILEMOUSIKI2HD.png'),
        'url': 'http://iphone-streaming.ustream.tv/uhls/18655753/streams/live/iphone/playlist.m3u8',
        'fanart': join(addonmedia, 'TILEMOUSIKI_fanart.jpg'),
        'plot': 'Μουσικό κανάλι εκπέμπει 24/7 σε σύστημα HD'.decode('utf-8')
    },
    {
        'title': 'WZRA KIDS',
        'icon': join(addonmedia, 'WZRA_KIDS_icon.png'),
        'url': 'mmsh://wpso.com:200/kids',
        'fanart': addonfanart,
        'plot': 'Παιδικό Κανάλι 24/7'.decode('utf-8')
    },
    {
        'title': 'WPSO Greek Voice Radio',
        'icon': join(addonmedia, 'wpso_icon.png'),
        'url': 'http://wpso.com:8000/',
        'fanart': join(addonmedia, 'GV_Radio_fanart.jpg'),
        'plot': 'Ραδιοφωνικός σταθμός Φωνή Των Ελλήνων, παγκοσμία κάλυψη'.decode('utf-8')
    },
    {
        'title': 'WXYB Radio GR IT ES',
        'icon': join(addonmedia, 'wxyb_icon.png'),
        'url': 'http://wpso.com:7071/',
        'fanart': join(addonmedia, 'GV_Radio_fanart.jpg'),
        'plot': 'Radio WXYB 1520Khz Greek Italian & Spanish'
    },
    {
        'title': 'XAMOS Youth Radio',
        'icon': join(addonmedia, 'xamos_icon.png'),
        'url': 'http://xamosam.com:9050',
        'fanart': join(addonmedia, 'xamos_fanart.jpg'),
        'plot': 'XAMOS Youth Radio 1500 KHz AM'
    }
]


# Build Root Menu:
def main_menu():

    xbmc.executebuiltin('Container.SetViewMode(50)')

    tv_item_list = []
    radio_item_list = []

    _list_item = xbmcgui.ListItem(label=language(30001))
    _list_item.setInfo('video', {'title': language(30001)})
    _list_item.setArt({'icon': addonicon, 'fanart': addonfanart})
    addDirItem(handle=addon_handle, url=None, listitem=_list_item, isFolder=False)

    for item in items[:5]:
        _list_item = xbmcgui.ListItem(label=item['title'])
        _list_item.setInfo(type='video', infoLabels={'title': item['title'], 'plot': item['plot']})
        _list_item.setArt({'icon': item['icon'], 'thumb': item['icon'], 'fanart': item['fanart']})
        _list_item.setProperty('IsPlayable', 'true')
        _url = '{0}?action=play&url={1}'.format(addon_url, item['url'])
        _isFolder = False
        tv_item_list.append((_url, _list_item, _isFolder))

    addDirItems(addon_handle, tv_item_list, len(tv_item_list))

    _list_item = xbmcgui.ListItem(label=language(30002))
    _list_item.setInfo('video', {'title': language(30002)})
    _list_item.setArt({'icon': addonicon, 'fanart': addonfanart})
    addDirItem(handle=addon_handle, url=None, listitem=_list_item, isFolder=False)

    for item in items[5:]:
        _list_item = xbmcgui.ListItem(label=item['title'])
        _list_item.setInfo('audio', {'title': item['title'], 'plot': item['plot']})
        _list_item.setArt({'icon': item['icon'], 'thumb': item['icon'], 'fanart': item['fanart']})
        _list_item.setProperty('IsPlayable', 'true')
        _url = '{0}?action=play&url={1}'.format(addon_url, item['url'])
        _isFolder = False
        radio_item_list.append((_url, _list_item, _isFolder))

    addDirItems(addon_handle, radio_item_list, len(radio_item_list))

    _list_item = xbmcgui.ListItem(label=language(30003))
    _list_item.setInfo('video', {'title': language(30003)})
    _list_item.setArt({'icon': addonicon, 'fanart': addonfanart})
    addDirItem(handle=addon_handle, url=None, listitem=_list_item, isFolder=False)

    youtube_channel = 'plugin://plugin.video.youtube/channel/UC0HzJJlSxjhhN4OAXHHQIOg/'
    _list_item = xbmcgui.ListItem(label='Youtube Channel')
    _list_item.setInfo('video', {'title': 'Youtube Channel'})
    _list_item.setArt({'icon': join(addonmedia, 'GV_YT_icon.png'), 'fanart': addonfanart})
    addDirItem(handle=addon_handle, url=youtube_channel, listitem=_list_item, isFolder=True)

    guide_url = '{0}?action=guide'.format(addon_url)
    _list_item = xbmcgui.ListItem(label='TV Guide')
    _list_item.setInfo('video', {'title': 'TV Guide'})
    _list_item.setArt({'icon': join(addonmedia, 'tvguide_icon.png'), 'fanart': addonfanart})
    addDirItem(handle=addon_handle, url=guide_url, listitem=_list_item, isFolder=False)

    settings_url = '{0}?action=settings'.format(addon_url)
    _list_item = xbmcgui.ListItem(label=language(30004))
    _list_item.setInfo('video', {'title': language(30004)})
    _list_item.setArt({'icon': join(addonmedia, 'settings.png'), 'fanart': addonfanart})
    addDirItem(handle=addon_handle, url=settings_url, listitem=_list_item, isFolder=False)

    endDir(addon_handle)


def play_item(url):

    list_item = xbmcgui.ListItem(path=url)
    xbmcplugin.setResolvedUrl(addon_handle, True, listitem=list_item)


def txt_box(heading, announce):

    window_id = 10147
    control_id1 = 1
    control_id2 = 5
    gui_window = xbmcgui.Window(window_id)

    xbmc.executebuiltin('ActivateWindow(%d)' % window_id)
    xbmc.sleep(500)

    gui_window.getControl(control_id1).setLabel(heading)
    try:
        txt = open(announce)
        text = txt.read()
    except:
        text = announce
    gui_window.getControl(control_id2).setText(str(text))

    return


def requester(url):

    requester = urllib2.Request(url)
    requester.add_header('User-Agent', 'Mozilla/5.0 (Windows NT 6.3; rv:36.0) Gecko/20100101 Firefox/36.04')
    response = urllib2.urlopen(requester)
    result = response.read()
    response.close()

    return result


def txt_processor():

    tv_guide_url1 = 'http://wzra48.com/tvguide.htm'
    tv_guide_url2 = 'http://wzra48.com/tvguide2.htm'
    tv_guide_url3 = 'http://wpso.com/news.htm'

    guide1 = requester(tv_guide_url1)
    guide2 = requester(tv_guide_url2)
    guide3 = requester(tv_guide_url3)

    page1 = re.findall('<span class="xr_tl xr_kern xr_s\d*" style="top: -11.77px;">(.*?)</span>', guide1, re.U)
    page2a = re.findall('<span class="xr_tl xr_kern xr_s\d*?" style="top: -11.77px;">(.*?)</span>', guide2, re.U)
    page2b = re.findall('<span class="xr_s\d*?" style="">(.*?)</span>', guide2, re.U)
    page2 = page2a + page2b

    page3a = re.findall('<span class="xr_tl xr_kern xr_s28" style="top: -11.77px;">(.*?)</span>', guide3, re.U)
    page3b = re.findall('<span class="xr_tl xr_kern xr_s57" style="top: [0-9]*?.[0-9]*?px;">(.*?)</span>', guide3, re.U)
    page3c = re.findall('<span class="xr_tl xr_kern xr_s58" style="top: 75.36px;">(.*?) </span>', guide3, re.U)
    page3 = [rc.replace('&nbsp;', '').replace('Program Monday thu Friday ', '[B]Monday through Friday[/B]')
             for rc in page3a] + [rc.replace('&nbsp;', '').replace('SUNDAY', '[B]Sunday[/B]') for rc in page3b] + \
            [rc.replace('Program Saturdays', '[B]Saturday[/B]') for rc in page3c]

    results1 = [rc.replace('&nbsp;', '').replace('&#38;', '&').replace('(727) 725-5555', '[COLOR yellow](727) 725-5555[/COLOR]') for rc in page1]
    results2 = [rc.replace('&nbsp;', '').replace('&#38;', '&').replace('1100', '11:00').replace('<span class="xr_s15" style="">', '')
                    .replace('<span class="xr_s111" style="">', '').replace('<span class="xr_s115" style="">', '')
                    .replace('Recorder', 'Recorded').replace('Recored', 'Recorded') for rc in page2]

    announce = '[B]Time:[/B]' + ' ' * 8 + '[B]Monday through Friday[/B]' + '\n' * 2 + \
               results1[11] + ' ' * 6 + results1[12] + '\n' + results1[13] + ' ' * 5 + results1[17] + '\n' + \
               results1[14] + ' ' * 5 + results1[20] + '\n' + results1[18] + ' ' * 5 + results1[21] + '\n' + \
               results1[22] + ' ' * 6 + results1[51] + '\n' + results1[24] + ' ' * 5 + results1[44] + '\n' + \
               results1[28] + ' ' * 3 + results1[43] + ' ' * 51 + '\n' + results1[29] + ' ' * 3 + results1[48] + '\n' + \
               results1[30] + ' ' + results1[47] + '\n' + results1[31] + ' ' * 6 + results1[46] + '\n' + \
               results1[33] + ' ' * 6 + results1[45] + '\n' + results1[32] + ' ' * 6 + results1[52] + '\n' + \
               results1[36] + ' ' * 6 + results1[53] + '\n' + results1[35] + ' ' * 6 + \
               results1[49] + '\n' + results1[34] + ' ' * 6 + results1[50] + ' ' * 6 + \
               results2[49] + '\n' + results2[11] + ' ' * 6 + results2[40] + results2[41] + '\n' + \
               results2[13] + ' ' * 3 + results2[44] + results2[45] + '\n' + results2[14] + ' ' * 3 + results2[42] + \
               results2[43] + '\n' + results2[18] + ' ' * 3 + results2[21] + '\n' + results2[22] + ' ' * 6 + \
               results2[34] + '\n' + results2[24] + ' ' * 5 + results2[35] + '\n' + results2[28] + ' ' * 5 + \
               results2[36] + '\n' + results2[29] + ' ' * 5 + results2[33] + '\n' + results2[30] + ' ' * 6 + \
               results2[46] + results2[47] + '\n' * 2 + \
               '[B]Time:[/B]' + ' ' * 8 + '[B]Weekends[/B]' + '\n' * 2 + results1[11] + ' ' * 6 + results1[8] + '\n' + \
               results1[13] + ' ' * 5 + results1[16] + '\n' + results1[14] + ' ' * 5 + results1[15] + '\n' + \
               results1[18] + ' ' * 5 + results1[19] + '\n' + results1[22] + ' ' * 6 + results1[23] + '\n' + \
               results1[24] + ' ' * 5 + results1[25] + '\n' + results1[28] + ' ' * 3 + results1[26] + ' ' * 51 + '\n' + \
               results1[29] + ' ' * 3 + results1[27] + '\n' + results1[30] + ' ' + results1[37] + '\n' + \
               results1[31] + ' ' * 6 + results1[38] + '\n' + results1[33] + ' ' * 6 + results1[39] + '\n' + \
               results1[32] + ' ' * 6 + results1[40] + '\n' + results1[36] + ' ' * 6 + results1[41] + '\n' + \
               results1[35] + ' ' * 6 + results1[42] + '\n' + results1[34] + ' ' * 6 + results2[49] + '\n' + \
               results2[11] + ' ' * 6 + results2[8] + '\n' + results2[13] + ' ' * 3 + results2[16] + '\n' + \
               results2[14] + ' ' * 3 + results2[15] + '\n' + results2[18] + ' ' * 3 + results2[19] + '\n' + \
               results2[22] + ' ' * 6 + results2[23] + '\n' + results2[24] + ' ' * 5 + results2[25] + '\n' + \
               results2[28] + ' ' * 5 + results2[26] + '\n' + results2[29] + ' ' * 5 + results2[27] + '\n' + \
               results2[30] + ' ' * 6 + results2[31] + '\n' * 3 + \
               '[COLOR darkorange][B]Greek Voice - Radio Guide[/B][/COLOR]' + '\n' * 2 + page3[0] + '\n' + \
               page3[1] + '\n' + page3[2] + '\n' + page3[3] + '\n' + page3[4] + '\n' + page3[5] + '\n' * 2 + \
               page3[14] + '\n' + page3[6] + '\n' + page3[7] + '\n' + page3[8] + '\n' + page3[9] + '\n' * 2 + \
               page3[10] + '\n' + page3[11] + '\n' + page3[12]

    return announce


def guide():

    txt_box('Greek Voice - TV Guide', txt_processor())


def yt_setup():

    # Please do not copy these keys, instead create your own with this tutorial:
    # http://forum.kodi.tv/showthread.php?tid=267160&pid=2299960#pid2299960

    api_keys = {
        'enablement': 'true',
        'id': '498788153161-pe356urhr0uu2m98od6f72k0vvcdsij0.apps.googleusercontent.com',
        'api_key': 'AIzaSyA8k1OyLGf03HBNl0byD511jr9cFWo2GR4',
        'secret': 'e6RBIFCVh1Fm-IX87PVJjgUu'
    }

    if addon('plugin.video.youtube').getSetting('youtube.api.enable') == 'true':
        if dialog.yesno(heading=addonname, line1=language(30007), line2=language(30008)):
            addon('plugin.video.youtube').setSetting('youtube.api.enable', api_keys['enablement'])
            addon('plugin.video.youtube').setSetting('youtube.api.id', api_keys['id'])
            addon('plugin.video.youtube').setSetting('youtube.api.key', api_keys['api_key'])
            addon('plugin.video.youtube').setSetting('youtube.api.secret', api_keys['secret'])
            dialog.notification(heading=addonname, message=language(30009), time=3000, sound=False)
        else:
            dialog.notification(heading=addonname, message=language(30010), time=3000, sound=False)
    else:
        if dialog.yesno(heading=addonname, line1=language(30011), line2=language(30008)):
            addon('plugin.video.youtube').setSetting('youtube.api.enable', api_keys['enablement'])
            addon('plugin.video.youtube').setSetting('youtube.api.id', api_keys['id'])
            addon('plugin.video.youtube').setSetting('youtube.api.key', api_keys['api_key'])
            addon('plugin.video.youtube').setSetting('youtube.api.secret', api_keys['secret'])
            dialog.notification(heading=addonname, message=language(30009), time=3000, sound=False)
        else:
            dialog.notification(heading=addonname, message=language(30010), time=3000, sound=False)


if action is None:
    main_menu()

elif action == 'play':
    play_item(url)

elif action == 'guide':
    guide()

elif action == 'settings':
    addon().openSettings()

elif action == 'yt_setup':
    yt_setup()
