# -*- coding: utf-8 -*-
#Библиотеки, които използват python и Kodi в тази приставка
import re
import sys
import os
import urllib
import urllib2
import json
import xbmc
import xbmcgui
import xbmcplugin
import xbmcaddon

reload(sys)
sys.setdefaultencoding('latin')

#Място за дефиниране на константи, които ще се използват няколкократно из отделните модули
__addon_id__= 'plugin.video.dramafever'
__Addon = xbmcaddon.Addon(__addon_id__)
__settings__ = xbmcaddon.Addon(id='plugin.video.dramafever')

sublang =__settings__.getSetting('lang')
if sublang =='0':
    lang='en'
    language = 'English'
elif sublang =='1':
    lang='es'
    language = 'Spanish'
elif sublang =='2':
    lang='pt'
    language = 'Portuguese'
elif sublang =='3':
    lang='chs'
    language = 'Chinese'
elif sublang =='4':
    lang='ar'
    language = 'Arabic'
elif sublang =='5':
    lang='tr'
    language = 'Turkish'
else:
    lang='en'
    language = 'English'

md = xbmc.translatePath(__Addon.getAddonInfo('path') + "/resources/media/")
search_string = urllib.unquote_plus(__settings__.getSetting('lastsearch'))
srtsubs_path = xbmc.translatePath('special://temp/dramafever.'+language+'.srt')

UA = 'Roku/DVP-8.1 (508.01E04018A)'

#Инициализация
req = urllib2.Request('https://www.dramafever.com/api/5/consumer/www/')
req.add_header('User-Agent', UA)
opener = urllib2.build_opener()
f = opener.open(req)
jsonrsp = json.loads(f.read())
#print jsonrsp
#print jsonrsp['url']
#print jsonrsp['consumer_secret']
base_url = jsonrsp['url']
consumer_secret = jsonrsp['consumer_secret']


#Меню с директории в приставката
def CATEGORIES():
        addDir('Search series','search','',3,md+'DefaultAddonsSearch.png')
        
        #Нови и популярни
        addDir('New and Popular',base_url+'/api/5/1/series?order_by=new_and_popular&trans=en&cs='+consumer_secret+'&page=@1','',1,md+'DefaultFolder.png')
        
        #Целия каталог
        addDir('Everything',base_url+'/api/5/1/series?trans=en&cs='+consumer_secret+'&page=@1','',1,md+'DefaultFolder.png')
        
        #Жанрове
        try:
            req = urllib2.Request(base_url+'/api/5/1/collections/meta/type/genre?page=1&trans=en&cs='+consumer_secret)
            req.add_header('User-Agent', UA)
            opener = urllib2.build_opener()
            f = opener.open(req)
            jsonrsp = json.loads(f.read())
            #print jsonrsp['values'][0]['title']
            
            for genre in range(0, len(jsonrsp['values'])):
                addDir(jsonrsp['values'][genre]['title'],jsonrsp['values'][genre]['metadata']['type']+'@'+jsonrsp['values'][genre]['slug']+'@1','',1,md+'DefaultFolder.png')
        except:
            pass
        
        #Curated
        try:
            req = urllib2.Request(base_url+'/api/5/1/collections/meta/type/curated?page=1&trans=en&cs='+consumer_secret)
            req.add_header('User-Agent', UA)
            opener = urllib2.build_opener()
            f = opener.open(req)
            jsonrsp = json.loads(f.read())
            #print jsonrsp['values'][0]['title']
            
            for genre in range(0, len(jsonrsp['values'])):
                addDir(jsonrsp['values'][genre]['title'],jsonrsp['values'][genre]['metadata']['type']+'@'+jsonrsp['values'][genre]['slug']+'@1','',1,md+'DefaultFolder.png')
        except:
            pass
        
        #Теми
        try:
            req = urllib2.Request(base_url+'/api/5/1/collections/meta/type/theme?page=1&trans=en&cs='+consumer_secret)
            req.add_header('User-Agent', UA)
            opener = urllib2.build_opener()
            f = opener.open(req)
            jsonrsp = json.loads(f.read())
            #print jsonrsp['values'][0]['title']
            
            for genre in range(0, len(jsonrsp['values'])):
                addDir(jsonrsp['values'][genre]['title'],jsonrsp['values'][genre]['metadata']['type']+'@'+jsonrsp['values'][genre]['slug']+'@1','',1,md+'DefaultFolder.png')
        except:
            pass
        
        xbmc.executebuiltin("Notification(DramaFever,Welcome to the Hallyu World!,2000)")
        

#Разлистване на заглавията
def TYPE(url):
        try:
            type, genre, page = url.split("@")
            #currentlisturl = base_url+'/api/4/browse/?cs='+consumer_secret+'&browser_type='+type+'&criteria='+genre+'&page_number='+page+'&page_size=25&order='+sort
            currentlisturl = base_url+'/api/5/1/collection-items/slug/'+genre+'?page='+page+'&trans=en&cs='+consumer_secret+'&page_size=100'
            req = urllib2.Request(currentlisturl)
        except:
            currentlisturl, page = url.split("@")
            req = urllib2.Request(url.replace('@',''))
            
        try:    
            req.add_header('User-Agent', UA)
            opener = urllib2.build_opener()
            f = opener.open(req)
            jsonrsp = json.loads(f.read())
            #print jsonrsp
        except:
            xbmcgui.Dialog().ok('DramaFever', jsonrsp['errors']['message'])
        
        #print 'number of dramas is '+str(len(jsonrsp['values']))
        try:
            for titles in range(0, len(jsonrsp['values'])):
                #try:
                    #print jsonrsp['values'][titles]['item']['title'].encode('ascii','ignore')
                    #print jsonrsp['values'][titles]['item']['id']
                #except:
                    #pass
                try:
                    addDir(jsonrsp['values'][titles]['item']['title'].encode('ascii','ignore'),str(jsonrsp['values'][titles]['item']['id'])+'@'+jsonrsp['values'][titles]['item']['title'].encode('ascii','ignore')+'@'+page,jsonrsp['values'][titles]['item']['description_short'].encode('ascii','ignore')+' Starring: '+jsonrsp['values'][titles]['item']['starring'].encode('ascii','ignore'),2,'https://www.dramafever.com/st/img/epth/'+str(jsonrsp['values'][titles]['item']['id'])+'_1.jpg')
                except:
                    try:
                        addDir(jsonrsp['values'][titles]['title'].encode('ascii','ignore'),str(jsonrsp['values'][titles]['id'])+'@'+jsonrsp['values'][titles]['title'].encode('ascii','ignore')+'@'+page,jsonrsp['values'][titles]['description_short'].encode('ascii','ignore')+' Starring: '+jsonrsp['values'][titles]['starring'].encode('ascii','ignore'),2,'https://www.dramafever.com/st/img/epth/'+str(jsonrsp['values'][titles]['id'])+'_1.jpg')
                    except:
                        pass
            
            #Ако имаме още страници...
            #print jsonrsp['num_pages']
            #print page
            if (jsonrsp['num_pages'] > 1 and int(page) <= jsonrsp['num_pages']-1):
                #print 'page ' + str(int(page)+1)
                try:
                    urln = type+'@'+genre+'@'+str(int(page)+1)
                except:
                    urln = currentlisturl+'@'+str(int(page)+1)
                addDir('Check out page '+str(int(page)+1)+' of '+str(jsonrsp['num_pages'])+' >>>',urln,'',1,md+'DefaultFolder.png')
            
        except:
            addDir('Go back - there are no results','','','',md+'DefaultFolderBack.png')
            #pass
        
#Разлистване на епизодите
def INDEX(url):
        series, name, page = url.split("@")
        #currentlisturl = base_url+'/api/4/episode/series/?cs='+consumer_secret+'&page_size=60&series_id='+series+'&page_number='+page
        currentlisturl = base_url+'/api/5/series/'+series+'/episodes/?cs='+consumer_secret+'&page_size=100&page='+page
        #print currentlisturl
        req = urllib2.Request(currentlisturl)
        req.add_header('User-Agent', UA)
        opener = urllib2.build_opener()
        f = opener.open(req)
        jsonrsp = json.loads(f.read())        
        #print jsonrsp
        
        try:
            for episodes in range(0, len(jsonrsp['values'])):
                #print 'Episode '+str(jsonrsp['values'][episodes]['number'])
                #print jsonrsp['values'][episodes]['subfile']
                #print jsonrsp['values'][episodes]['duration']
                #print str(jsonrsp['values'][episodes]['id'])
                #print jsonrsp['values'][episodes]['thumbnail']
                #print jsonrsp['values'][episodes]['description']
                #print jsonrsp['values'][episodes]['video']['status']
                duration = jsonrsp['values'][episodes]['duration'].split(':')
                duration = int(duration[0]) * 3600 + int(duration[1]) * 60 + int(duration[2])
                
                #Тагване на геоблокирани видеа
                if jsonrsp['values'][episodes]['video']['status'] =='geoblocked':
                    vname = '[B][COLOR red][GEOBLOCKED][/COLOR][/B] ' + name
                else:
                    vname = name
                
                #Номер на епизода
                epn = str(jsonrsp['values'][episodes]['number'])                #addLink(name,url,plot,vd,mode,iconimage)
                
                if len(jsonrsp['values']) ==1:
                    addLink(vname.encode('ascii','ignore'),str(jsonrsp['values'][episodes]['number'])+'@'+series+'@'+jsonrsp['values'][episodes]['subfile']+'@'+jsonrsp['values'][episodes]['thumbnail']+'@'+jsonrsp['values'][episodes]['description'].encode('ascii','ignore'),jsonrsp['values'][episodes]['description'].encode('ascii','ignore'),duration,4,jsonrsp['values'][episodes]['thumbnail'])
                else:
                    addLink(vname.encode('ascii','ignore')+' Episode '+epn,str(jsonrsp['values'][episodes]['number'])+'@'+series+'@'+jsonrsp['values'][episodes]['subfile']+'@'+jsonrsp['values'][episodes]['thumbnail']+'@'+jsonrsp['values'][episodes]['description'].encode('ascii','ignore'),jsonrsp['values'][episodes]['description'].encode('ascii','ignore'),duration,4,jsonrsp['values'][episodes]['thumbnail'])
                #xbmcgui.Dialog().ok('DramaFever',jsonrsp['values'][episodes]['description'].encode('ascii','ignore'))
            #Ако имаме още страници...
            #print 'Pages Number:' + str(jsonrsp['num_pages'])
            if (jsonrsp['num_pages'] > 1 and int(page) <= jsonrsp['num_pages']-1):
                #print 'page ' + str(int(page)+1)
                INDEX(series+'@'+name+'@'+str(int(page)+1))
                #urln = series+'@'+name+'@'+str(int(page)+1)
                #addDir('Check out page '+str(int(page)+1)+' of '+str(jsonrsp['num_pages'])+' >>>',urln,'',2,md+'DefaultFolder.png')
        except:
            addDir('Go back - there are no results','','','',md+'DefaultFolderBack.png')


#Търсачка
def SEARCH(url):
        keyb = xbmc.Keyboard(search_string, 'Search')
        keyb.doModal()
        searchText = ''
        if (keyb.isConfirmed()):
            searchText = urllib.quote_plus(keyb.getText())
            searchText=searchText.replace(' ','+')
            if searchText == "":
                addDir('Go back - there are no results','','','',md+'DefaultFolderBack.png')
            else:
                #Записване на заявката за търсене в настройките
                __settings__.setSetting('lastsearch', searchText)
            
                req = urllib2.Request('https://api.swiftype.com/api/v1/public/engines/suggest.json?q='+searchText+'&engine_key=CywzyscJAHKCwrezfzpN&search_fields[tag][]=title&search_fields[series][]=title^4&search_fields[series][]=alt_title^2')
                req.add_header('User-Agent', UA)
                opener = urllib2.build_opener()
                f = opener.open(req)
                jsonrsp = json.loads(f.read())        
                #print jsonrsp
                
                br=0
                for index in range(0, len(jsonrsp['records']['series'])):
                    #print jsonrsp['records']['series'][index]['title']
                    #print jsonrsp['records']['series'][index]['external_id']
                    #print jsonrsp['records']['series'][index]['thumbnail']
                    try:
                        cover = 'https://www.dramafever.com'+jsonrsp['records']['series'][index]['thumbnail']
                    except:
                        cover = md+'DefaultFolder.png'
                    addDir(jsonrsp['records']['series'][index]['title'],jsonrsp['records']['series'][index]['external_id']+'@'+jsonrsp['records']['series'][index]['title']+'@1','',2,cover)
                    br=br+1
                if br==0:
                    addDir('Go back - there are no results','','','',md+'DefaultFolderBack.png')




#Зареждане на видео
def PLAY(name,url,iconimage):           #addLink(name,url,plot,vd,mode,iconimage)
        episode, series, srtsubtitles, thumbnail, desc = url.split("@")
        try:
            #req = urllib2.Request(base_url+'/api/4/stream/hls_stream/?cs='+consumer_secret+'&series_id='+series+'&number='+episode+'&subs=0&format=srt')
            req = urllib2.Request(base_url+'/api/5/video/'+series+'.'+episode+'/stream/?subs=All&trans=en&cs='+consumer_secret)
            req.add_header('User-Agent', UA)
            opener = urllib2.build_opener()
            f = opener.open(req)
            jsonrsp = json.loads(f.read())
            #print jsonrsp
            link = jsonrsp['stream_url'].replace('_,400,.','_,2400,1800,1200,800,400,.').replace('_,800,400,.','_,2400,1800,1200,800,400,.').replace('_,5803434,5829237,5848705,.','_,4446182,5803434,5829237,5848705,.')
        except:
            #xbmcgui.Dialog().ok('Paywall restriction', 'This video is available for DramaFever Premium members only!')
            link = xbmc.translatePath(__Addon.getAddonInfo('path') + "/resources/media/blank.mp4")
            
        #Субтитри
        try:
            reqs = urllib2.Request(base_url+'/api/5/video/'+series+'.'+episode+'/subtitles/srt/?trans=en&cs='+consumer_secret)
            reqs.add_header('User-Agent', UA)
            opener = urllib2.build_opener()
            s = opener.open(reqs)
            jsonrsps = json.loads(s.read())
            #print jsonrsps
        except:
            reqs = urllib2.Request(base_url+'/api/5/video/'+series+'.'+episode+'/subtitles/webvtt/?trans=en&cs='+consumer_secret)
            reqs.add_header('User-Agent', UA)
            opener = urllib2.build_opener()
            s = opener.open(reqs)
            jsonrsps = json.loads(s.read())
            #print jsonrsps
        

        
        try:
            #Изтегляме официалните субтитри за епизода в SRT формат или ако не е възможно, в TTML формат и ги конвертираме към SRT
            for index in range(0, len(jsonrsps)):
                if jsonrsps[index]['language'] == language:
                    if '.vtt' in jsonrsps[index]['url']:
                        req = urllib2.Request(jsonrsps[index]['url'])
                        req.add_header('User-Agent', UA)
                        response = urllib2.urlopen(req)
                        data=response.read()
                        response.close()
                        
                        subs = re.compile('<p[^>]+begin="([^"]+)\D(\d+)"[^>]+end="([^"]+)\D(\d+)"[^>]*>([\w\W]+?)</p>').findall(data)
                        row = 0
                        buffer = ''
                        for sub in subs:
                            #print sub
                            row = row + 1
                            buffer += str(row) +'\n'
                            buffer += "%s,%03d" % (sub[0], int(sub[1])) + ' --> ' + "%s,%03d" % (sub[2], int(sub[3])) + '\n'
                            buffer += urllib.unquote_plus(sub[4]).replace('<br/>','\n').replace('<br />','\n').replace("\r\n", "").replace("&lt;", "<").replace("&gt;", ">").replace("\n    ","").strip()
                            buffer += '\n\n'
                        #print 'buffer '+buffer
                        sub = 'true'
                        #print srtsubs_path
                        with open(srtsubs_path, "w") as subfile:
                            subfile.write(buffer)
                    else:
                        subfile = urllib.URLopener()
                        subfile.retrieve(jsonrsps[index]['url'], srtsubs_path)
                        sub = 'true'
            #Генерира грешка, за да задейства използването на английски субтитри, ако няма налични на избраният език
            if sub != 'true':
                raise Exception()
                    
        except:
            try:
                #Изтегляме редакторските английски SRT субтитри във временна директория
                subfile = urllib.URLopener()
                subfile.retrieve(srtsubtitles, srtsubs_path)
                sub = 'true'
                #print srtsubs_path
            except:
                sub = 'false'
                #print '[dramafever]>> This video has no subtitles !'
                
        
        #Възпроизвеждане на видеото
        try:
            if '.m3u8' in link:
                li = xbmcgui.ListItem(iconImage=thumbnail, thumbnailImage=thumbnail, path=link+'|X-Forwarded-For=13.33.115.88&User-Agent=stagefright&Referer=https://www.dramafever.com')
                li.setInfo( type="Video", infoLabels={ 'title': name, "plot": desc } )
                if sub=='true':
                    li.setSubtitles([srtsubs_path])
                xbmcplugin.setResolvedUrl(int(sys.argv[1]), True, li)
            
            elif 'dash' in link:
                li = xbmcgui.ListItem(iconImage=thumbnail, thumbnailImage=thumbnail, path=link)
                li.setInfo( type="Video", infoLabels={ 'title': name, "plot": desc } )
                li.setProperty('inputstreamaddon', 'inputstream.adaptive')
                li.setProperty('inputstream.adaptive.manifest_type', 'mpd')
                li.setProperty('inputstream.adaptive.stream_headers', 'X-Forwarded-For=13.33.115.88&User-Agent=stagefright&Referer=https://www.dramafever.com')
                if sub=='true':
                    li.setSubtitles([srtsubs_path])
                xbmcplugin.setResolvedUrl(int(sys.argv[1]), True, li)
            
        except:
            pass
            

        

            




#Модул за добавяне на отделно заглавие и неговите атрибути към съдържанието на показваната в Kodi директория - НЯМА НУЖДА ДА ПРОМЕНЯТЕ НИЩО ТУК
def addLink(name,url,plot,vd,mode,iconimage):
        u=sys.argv[0]+"?url="+urllib.quote_plus(url)+"&mode="+str(mode)+"&name="+urllib.quote_plus(name)
        ok=True
        liz=xbmcgui.ListItem(name, iconImage=iconimage, thumbnailImage=iconimage)
        liz.setArt({ 'thumb': iconimage,'poster': iconimage, 'banner' : iconimage, 'fanart': iconimage })
        liz.setInfo( type="Video", infoLabels={ "duration": vd, "plot": plot } )
        liz.addStreamInfo('video', { 'width': 1280, 'height': 720 })
        liz.addStreamInfo('video', { 'aspect': 1.78, 'codec': 'h264' })
        liz.addStreamInfo('audio', { 'codec': 'aac', 'channels': 2 })
        liz.setProperty("IsPlayable" , "true")
        ok=xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]),url=u,listitem=liz,isFolder=False)
        return ok

#Модул за добавяне на отделна директория и нейните атрибути към съдържанието на показваната в Kodi директория - НЯМА НУЖДА ДА ПРОМЕНЯТЕ НИЩО ТУК
def addDir(name,url,plot,mode,iconimage):
        u=sys.argv[0]+"?url="+urllib.quote_plus(url)+"&mode="+str(mode)+"&name="+urllib.quote_plus(name)
        ok=True
        liz=xbmcgui.ListItem(name, iconImage=iconimage, thumbnailImage=iconimage)
        liz.setInfo( type="Video", infoLabels={ "Title": name, "Plot": plot } )
        ok=xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]),url=u,listitem=liz,isFolder=True)
        return ok


#НЯМА НУЖДА ДА ПРОМЕНЯТЕ НИЩО ТУК
def get_params():
        param=[]
        paramstring=sys.argv[2]
        if len(paramstring)>=2:
                params=sys.argv[2]
                cleanedparams=params.replace('?','')
                if (params[len(params)-1]=='/'):
                        params=params[0:len(params)-2]
                pairsofparams=cleanedparams.split('&')
                param={}
                for i in range(len(pairsofparams)):
                        splitparams={}
                        splitparams=pairsofparams[i].split('=')
                        if (len(splitparams))==2:
                                param[splitparams[0]]=splitparams[1]
                                
        return param



params=get_params()
url=None
name=None
iconimage=None
mode=None

try:
        url=urllib.unquote_plus(params["url"])
except:
        pass
try:
        name=urllib.unquote_plus(params["name"])
except:
        pass
try:
        name=urllib.unquote_plus(params["iconimage"])
except:
        pass
try:
        mode=int(params["mode"])
except:
        pass


#Списък на отделните подпрограми/модули в тази приставка - трябва напълно да отговаря на кода отгоре
if mode==None or url==None or len(url)<1:
        CATEGORIES()
    
elif mode==1:
        TYPE(url)

elif mode==2:
        INDEX(url)

elif mode==3:
        SEARCH(url)

elif mode==4:
        PLAY(name,url,iconimage)


xbmcplugin.endOfDirectory(int(sys.argv[1]))
