# -*- coding: utf-8 -*-

'''
    AresMoTV Add-on
    Copyright (C) 2016 AresMoTV
    
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

import re,sys,json,time,xbmc,xbmcgui,xbmcplugin,xbmcaddon,xbmcvfs
import hashlib,os,zlib,base64,codecs,xmlrpclib

try: from sqlite3 import dbapi2 as database
except: from pysqlite2 import dbapi2 as database

sleep = xbmc.sleep
infoLabel = xbmc.getInfoLabel
items = xbmcgui.ListItem
players = xbmc.Player()
resolve = xbmcplugin.setResolvedUrl
window = xbmcgui.Window(10000)
addonInfo = xbmcaddon.Addon().getAddonInfo
condVisibility = xbmc.getCondVisibility
dialog = xbmcgui.Dialog()

makeFile = xbmcvfs.mkdir

addon = xbmcaddon.Addon()
path = addon.getAddonInfo('path')
dataPath = xbmc.translatePath(addonInfo('profile')).decode('utf-8')
bookmarksFile = os.path.join(dataPath, 'bookmarks.db')

class player(xbmc.Player):
    def __init__ (self):
        xbmc.Player.__init__(self)

    def run(self, title, year='0', season=None, episode=None, imdb='', tvdb='',  url='', meta={}):
        try:
            sleep(200)

            self.totalTime = 0 ; self.currentTime = 0

            self.content = 'movie' if season == None or episode == None else 'episode'

            self.title = title ; self.year = year

            self.name = '%s (%s)' % (title, year) if self.content == 'movie' else '%s S%02dE%02d' % (title, int(season), int(episode))
            # self.season = '%01d' % int(season) if self.content == 'episode' else None
            # self.episode = '%01d' % int(episode) if self.content == 'episode' else None

            # self.imdb = imdb if not imdb == None else '0'
            # self.tvdb = tvdb if not tvdb == None else '0'
            # self.ids = {'imdb': self.imdb, 'tvdb': self.tvdb}
            # self.ids = dict((k,v) for k, v in self.ids.iteritems() if not v == '0')

            self.offset = bookmarks().get(self.name, self.year)

            thumb = meta['thumbnail']
            item = items(path=url)
            item.setArt({'icon': thumb, 'thumb': thumb})
            item.setInfo(type='Video', infoLabels = meta)

            if 'plugin' in infoLabel('Container.PluginName'):
                players.play(url, item)

            resolve(int(sys.argv[1]), False, item)

            self.keepPlaybackAlive()

        except:
            return


    def keepPlaybackAlive(self):
        pname = '%s.player.overlay' % addonInfo('id')
        window.clearProperty(pname)

        overlay = '6'

        for i in range(0, 240):
            if self.isPlayingVideo(): break
            xbmc.sleep(1000)


        if overlay == '7':

            while self.isPlayingVideo():
                try:
                    self.totalTime = self.getTotalTime()
                    self.currentTime = self.getTime()
                except:
                    pass
                xbmc.sleep(2000)


        elif self.content == 'movie':

            while self.isPlayingVideo():
                try:
                    self.totalTime = self.getTotalTime()
                    self.currentTime = self.getTime()

                    watcher = (self.currentTime / self.totalTime >= .9)
                    property = control.window.getProperty(pname)

                except:
                    pass
                xbmc.sleep(2000)


        elif self.content == 'episode':

            while self.isPlayingVideo():
                try:
                    self.totalTime = self.getTotalTime()
                    self.currentTime = self.getTime()

                    watcher = (self.currentTime / self.totalTime >= .9)
                    property = window.getProperty(pname)

                except:
                    pass
                xbmc.sleep(2000)


        window.clearProperty(pname)


    def idleForPlayback(self):
        for i in range(0, 200):
            if condVisibility('Window.IsActive(busydialog)') == 1: self.idle()
            else: break
            sleep(100)

    def idle(self):
        return execute('Dialog.Close(busydialog)')

    def onPlayBackStarted(self):
        if not self.offset == '0': self.seekTime(float(self.offset))
        self.idleForPlayback()


    def onPlayBackStopped(self):
        bookmarks().reset(self.currentTime, self.totalTime, self.name, self.year)


    def onPlayBackEnded(self):
        self.onPlayBackStopped()


class bookmarks:
    def get(self, name, year='0'):
        try:
            offset = '0'

            idFile = hashlib.md5()
            for i in name: idFile.update(str(i))
            for i in year: idFile.update(str(i))
            idFile = str(idFile.hexdigest())

            dbcon = database.connect(bookmarksFile)
            dbcur = dbcon.cursor()
            dbcur.execute("SELECT * FROM bookmark WHERE idFile = '%s'" % idFile)
            match = dbcur.fetchone()
            self.offset = str(match[1])
            dbcon.commit()

            if self.offset == '0': raise Exception()

            minutes, seconds = divmod(float(self.offset), 60) ; hours, minutes = divmod(minutes, 60)
            label = '%02d:%02d:%02d' % (hours, minutes, seconds)
            label = ('Resume from %s' % label).encode('utf-8')

            try: yes = dialog.contextmenu([label, 'Start from beginning'.encode('utf-8'), ])
            except: 
                yes = self.yesnoDialog(label, '', '', str(name), ("Resume").encode('utf-8'), ("Start from beginning").encode('utf-8'))

            if yes: self.offset = '0'

            return self.offset
        except:
            return offset

    def yesnoDialog(self, line1, line2, line3, heading=addonInfo('name'), nolabel='', yeslabel=''):
        return dialog.yesno(heading, line1, line2, line3, nolabel, yeslabel)

    def reset(self, currentTime, totalTime, name, year='0'):
        try:
            timeInSeconds = str(currentTime)
            ok = int(currentTime) > 180 and (currentTime / totalTime) <= .92

            idFile = hashlib.md5()
            for i in name: idFile.update(str(i))
            for i in year: idFile.update(str(i))
            idFile = str(idFile.hexdigest())

            makeFile(dataPath)
            dbcon = database.connect(bookmarksFile)
            dbcur = dbcon.cursor()
            dbcur.execute("CREATE TABLE IF NOT EXISTS bookmark (""idFile TEXT, ""timeInSeconds TEXT, ""UNIQUE(idFile)"");")
            dbcur.execute("DELETE FROM bookmark WHERE idFile = '%s'" % idFile)
            if ok: dbcur.execute("INSERT INTO bookmark Values (?, ?)", (idFile, timeInSeconds))
            dbcon.commit()
        except:
            pass


