# -*- coding: UTF-8 -*-
"""
    Copyright (C) 2014  smokdpi

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

""" Site information used for main menu if more than 1 site """
title = 'Anime4fun'
image = 'anime4fun-icon.png'
art = 'anime4fun-fanart.jpg'
order = 1


class Site:
    def __init__(self, params):
        import re
        from addon import Addon
        from addondict import AddonDict as XBMCDict
        from BeautifulSoup import BeautifulSoup, SoupStrainer, Comment

        a = Addon()
        site = self.__module__
        mode = params['mode']

        home_url = 'http://animeonlinetv.tv'
        search_url = home_url + '/search?keyword='
        series_url = home_url + '/category/anime-list/'
        movies_url = home_url + '/category/anime-movies/'
        lastest_episodes_url = home_url + '/last-episodes/'
        search_url_2 = home_url + '/search?character='
        popular_series_url = search_url_2 + 'popular'
        ongoing_series_url = search_url_2 + 'ongoing'
        new_series_url = search_url_2 + 'new'
        completed_series_url = search_url_2 + 'completed'

        if mode == 'main':
            item_list = [{'site': site, 'mode': 'list_index', 'title': a.language(30021), 'content': '',
                          'url': series_url, 'cover_url': a.image('allseries.png', image), 'backdrop_url': a.art(),
                          'type': 3},
                         {'site': site, 'mode': 'list_series', 'title': a.language(30022), 'content': '',
                          'url': movies_url, 'cover_url': a.image('allmovies.png', image), 'backdrop_url': a.art(),
                          'type': 3},
                         {'site': site, 'mode': 'az', 'title': a.language(30029), 'content': '',
                          'url': '', 'cover_url': a.image('az.png', image),
                          'backdrop_url': a.art(), 'type': 3},
                         {'site': site, 'mode': 'list_articles', 'title': a.language(30023), 'content': '',
                          'url': popular_series_url, 'cover_url': a.image('mostpopular.png', image),
                          'backdrop_url': a.art(), 'type': 3},
                         {'site': site, 'mode': 'list_articles', 'title': a.language(30026), 'content': '',
                          'url': ongoing_series_url, 'cover_url': a.image('ongoingseries.png', image),
                          'backdrop_url': a.art(), 'type': 3},
                         {'site': site, 'mode': 'list_articles', 'title': a.language(30027), 'content': '',
                          'url': new_series_url, 'cover_url': a.image('newseries.png', image),
                          'backdrop_url': a.art(), 'type': 3},
                         {'site': site, 'mode': 'list_articles', 'title': a.language(30028), 'content': '',
                          'url': completed_series_url, 'cover_url': a.image('completedseries.png', image),
                          'backdrop_url': a.art(), 'type': 3},
                         {'site': site, 'mode': 'list_series', 'title': a.language(30024), 'content': '',
                          'url': lastest_episodes_url, 'cover_url': a.image('latestepisodes.png', image),
                          'backdrop_url': a.art(), 'type': 3},
                         {'site': site, 'mode': 'list_upcoming', 'title': a.language(30025), 'content': '',
                          'url': home_url, 'cover_url': a.image('upcomingepisodes.png', image), 'backdrop_url': a.art(),
                          'type': 3},
                         {'site': site, 'mode': 'list_articles', 'title': a.language(30015), 'url': search_url,
                          'content': 'search', 'cover_url': a.image('search.png', image), 'backdrop_url': a.art(),
                          'type': 3}]
            item_list.extend(a.favs_hist_menu(site))
            item_list.extend(a.extended_menu())
            a.add_items(item_list)
            a.end_of_directory()

        elif mode == 'az':
            import string
            items = string.ascii_lowercase
            item_list = [{'site': site, 'mode': 'list_articles', 'url': search_url_2 + 'special',
                          'content': '', 'title': '#', 'cover_url': a.image(),
                          'backdrop_url': a.art(), 'type': 3}]
            for item in items:
                item_list.extend([{'site': site, 'mode': 'list_articles', 'url': search_url_2 + item,
                                   'content': '', 'title': item.upper(), 'cover_url': a.image(),
                                   'backdrop_url': a.art(), 'type': 3}])
            a.add_items(item_list)
            a.end_of_directory()

        elif mode == 'list_index':
            html = a.get_page(params['url'])
            soup = BeautifulSoup(html, parseOnlyThese=SoupStrainer('div', {'class': 'list-anime-char'}),
                                 convertEntities=BeautifulSoup.HTML_ENTITIES)
            item_list = []
            params['context'] = 0
            params['content'] = 'tvshows'
            xbmcdict = XBMCDict().update(params)
            for index, item in enumerate(soup.findAll('div', {'class': 'col-md-3 item-anime country-all '})):
                _dict = xbmcdict.copy()
                _dict['mode'] = 'list_episodes'
                _dict['title'] = item.a.string.encode('UTF-8')
                _dict['url'] = item.a.get('href')
                if _dict['url'].startswith('/'): _dict['url'] = home_url + _dict['url']
                _dict['sub_site'] = site
                item_list.extend([_dict])
            if item_list:
                a.add_items(item_list)
                a.end_of_directory(default_sort=10)

        elif mode == 'list_ongoing':
            html = a.get_page(params['url'])
            soup = BeautifulSoup(html, parseOnlyThese=SoupStrainer('section', {'class': 'content_right'}),
                                 convertEntities=BeautifulSoup.HTML_ENTITIES)
            item_list = []
            params['context'] = 0
            params['content'] = 'tvshows'
            xbmcdict = XBMCDict().update(params)
            ul = soup.find('h2', text='Ongoing series').previous.previous.previous.previous.nav.ul
            if ul:
                for li in ul.findAll('li'):
                    if li.a:
                        _dict = xbmcdict.copy()
                        _dict['title'] = li.a.contents[0].encode('UTF-8').strip()
                        _dict['tvshowtitle'] = _dict['title']
                        _dict['originaltitle'] = _dict['title']
                        _dict['mode'] = 'list_episodes'
                        if re.match('.*movie[^s].*', _dict['title'].lower()):
                            _dict['content'] = 'movies'
                        elif re.match('.*season\s*[0-9]+.*', _dict['title'].lower()):
                            _dict['season'] = int(re.search('season\s*([0-9]+)', _dict['title'].lower()).group(1))
                        _dict['url'] = li.a.get('href')
                        if _dict['url'].startswith('/'): _dict['url'] = home_url + _dict['url']
                        _dict['sub_site'] = site
                        item_list.extend([_dict])
            if item_list:
                a.add_items(item_list)
                a.end_of_directory()

        elif mode == 'list_upcoming':
            html = a.get_page(params['url'])
            soup = BeautifulSoup(html, parseOnlyThese=SoupStrainer('section', {'class': 'content_right'}),
                                 convertEntities=BeautifulSoup.HTML_ENTITIES)
            item_list = []
            params['context'] = 0
            params['content'] = 'episodes'
            xbmcdict = XBMCDict().update(params)
            ul = soup.find('h2', text='Coming Soon Episodes').previous.previous.previous.previous.nav.ul
            if ul:
                for li in ul.findAll('li'):
                    if li.a:
                        _dict = xbmcdict.copy()
                        _dict['title'] = li.a.contents[0].encode('UTF-8').strip()
                        if li.findNext('li'):
                            temp = li.findNext('li').contents[0].encode('UTF-8').strip().replace('About ', '')
                            if temp.lower() == 'delayed':
                                _dict['title'] = temp + ' : ' + _dict['title']
                            else:
                                temp = re.sub('([0-9]+) ([hHdDwWmMyY]).+', '\g<01>\g<02>', temp)
                                _dict['title'] = '~' + temp + ' : ' + _dict['title']
                        _dict['tvshowtitle'] = _dict['title']
                        _dict['originaltitle'] = _dict['title']
                        _dict['mode'] = 'play'
                        _dict['type'] = 0
                        if re.match('.*movie[^s].*', _dict['title'].lower()):
                            _dict['content'] = 'movies'
                        elif re.match('.*season\s*[0-9]+.*', _dict['title'].lower()):
                            _dict['season'] = int(re.search('season\s*([0-9]+)', _dict['title'].lower()).group(1))
                        _dict['url'] = li.a.get('href')
                        if _dict['url'].startswith('/'): _dict['url'] = home_url + _dict['url']
                        _dict['sub_site'] = site
                        item_list.extend([_dict])
            if item_list:
                a.add_items(item_list)
                a.end_of_directory()

        elif mode == 'list_articles':
            if params.get('content', '') == 'search':
                item = a.search_input()
                if item:
                    params['url'] = search_url + item
                else:
                    exit(1)
            if params.get('content', '') == 'goto':
                last_item = re.search('page=([0-9]+)', params['url'])
                if last_item:
                    last_item = int(last_item.group(1))
                else:
                    last_item = 10000
                item = a.page_input(last_item)
                if item:
                    params['url'] = re.sub('page=[0-9]+', 'page=' + str(item), params['url'])
                else:
                    exit(1)
            html = a.get_page(params['url'])
            soup = BeautifulSoup(html, parseOnlyThese=SoupStrainer('div', 'box-container'),
                                 convertEntities=BeautifulSoup.HTML_ENTITIES)
            item_list = []
            params['context'] = 0
            params['content'] = 'tvshows'
            xbmcdict = XBMCDict().update(params)
            for li in soup.findAll('article'):
                check = li.find('a', href=True)
                if check:
                    _dict = xbmcdict.copy()
                    _dict['title'] = li.a.findChild('h2').contents[0].encode('UTF-8').strip()
                    _dict['tvshowtitle'] = _dict['title']
                    _dict['originaltitle'] = _dict['title']
                    _dict['mode'] = 'list_episodes'
                    if ('movie' in params['url']) or (re.match('.*movie[^s].*', _dict['title'].lower())):
                        _dict['content'] = 'movies'
                        _dict['duration'] = '4500'
                    elif re.match('.*season\s*[0-9]+.*', _dict['title'].lower()):
                        _dict['season'] = int(re.search('season\s*([0-9]+)', _dict['title'].lower()).group(1))
                    _dict['url'] = li.a.get('href')
                    if _dict['url'].startswith('/'): _dict['url'] = home_url + _dict['url']
                    img = li.find('img', {'src': True})
                    if img:
                        img = img.get('src').replace(' ', '%20')
                    else:
                        img = ''
                    _dict['cover_url'] = img
                    _dict['thumb_url'] = _dict['cover_url']
                    _dict['banner_url'] = _dict['cover_url']
                    _dict['poster'] = _dict['cover_url']
                    item = li.find('div', {'class': 'list_fields'})
                    if item:
                        label = re.search('status:\s*([a-z]+?)\s', item.contents[0], re.IGNORECASE)
                        if label:
                            _dict['status'] = label
                        label = re.search('release:\s*([0-9]{4})\s', item.contents[0], re.IGNORECASE)
                        if label:
                            _dict['year'] = label
                    item = li.find('div', {'class': 'text_intro'})
                    if item:
                        plot = item.contents[0]
                        if plot:
                            _dict['plotoutline'] = item.contents[0].string
                            _dict['plot'] = _dict['plotoutline']
                    _dict['sub_site'] = site
                    item_list.extend([_dict])
            pages = soup.find('ul', {'class': 'pagination-list'})
            if pages:
                previouspage = pages.find('li', {'class': 'previous'})
                nextpage = pages.find('li', {'class': 'next'})
                lastpage = pages.find('li', {'class': 'last'})
                if previouspage:
                    item_list.extend([{'site': site, 'mode': 'list_articles',
                                       'url': home_url + previouspage.a.get('href'), 'content': params['content'],
                                       'title': a.language(30017, True), 'cover_url': a.image(image, image),
                                       'backdrop_url': a.art(), 'type': 3}])
                if nextpage:
                    item_list.extend([{'site': site, 'mode': 'list_articles', 'url': home_url + nextpage.a.get('href'),
                                       'content': params['content'], 'title': a.language(30018, True),
                                       'cover_url': a.image(image, image), 'backdrop_url': a.art(), 'type': 3}])
                if lastpage:
                    item_list.extend(
                        [{'site': site, 'mode': 'list_articles', 'url': home_url + lastpage.a.get('href'),
                          'content': 'goto', 'title': a.language(30019, True),
                          'cover_url': a.image(image, image), 'backdrop_url': a.art(), 'type': 3}])
            if item_list:
                a.add_items(item_list)
                a.end_of_directory()

        elif mode == 'list_series':
            if 'movie' not in params['url']:
                content = 'tvshows'
            else:
                content = 'movies'
            if params.get('content', '') == 'goto':
                params['content'] = content
                last_item = re.search('\?page=([0-9]+)', params['url'])
                if last_item:
                    last_item = int(last_item.group(1))
                else:
                    last_item = 10000
                item = a.page_input(last_item)
                if item:
                    params['url'] = re.sub('\?page=[0-9]+', '?page=' + str(item), params['url'])
                else:
                    exit(1)
            html = a.get_page(params['url'])
            soup = BeautifulSoup(html, parseOnlyThese=SoupStrainer('div', 'last_episodes'),
                                 convertEntities=BeautifulSoup.HTML_ENTITIES)
            item_list = []
            params['context'] = 0
            params['content'] = content
            if 'episode' in params['url']: params['content'] = 'episodes'
            xbmcdict = XBMCDict().update(params)
            for li in soup.findAll('div', {'class': 'last_episodes_items'}):
                if li.a.get('href'):
                    _dict = xbmcdict.copy()
                    _dict['title'] = li.a.get('title').encode('UTF-8').strip()
                    _dict['tvshowtitle'] = _dict['title']
                    _dict['originaltitle'] = _dict['title']
                    _dict['mode'] = 'list_episodes'
                    if ('episode' in params['url']) or (re.match('.*episode[s]*.*', _dict['title'].lower())):
                        _dict['content'] = 'episodes'
                        _dict['mode'] = 'play'
                        _dict['type'] = 0
                    elif ('movie' in params['url']) or (re.match('.*movie[^s].*', _dict['title'].lower())):
                        _dict['content'] = 'movies'
                        _dict['duration'] = '4500'
                    elif re.match('.*season\s*[0-9]+.*', _dict['title'].lower()):
                        _dict['season'] = int(re.search('season\s*([0-9]+)', _dict['title'].lower()).group(1))
                    _dict['url'] = li.a.get('href')
                    if _dict['url'].startswith('/'): _dict['url'] = home_url + _dict['url']
                    img = li.find('img', {'src': True})
                    if img:
                        img = img.get('src').replace(' ', '%20')
                    else:
                        img = ''
                    _dict['cover_url'] = img
                    _dict['thumb_url'] = _dict['cover_url']
                    _dict['banner_url'] = _dict['cover_url']
                    _dict['poster'] = _dict['cover_url']
                    _dict['sub_site'] = site
                    item_list.extend([_dict])
            soup = BeautifulSoup(html, parseOnlyThese=SoupStrainer('ul', 'pagination-list'))
            item = soup.find('li', {'class': 'previous'})
            if item:
                item_list.extend([{'site': site, 'mode': 'list_series', 'url': home_url + item.a.get('href'),
                                   'content': params['content'], 'title': '  ' + a.language(30017, True),
                                   'cover_url': a.image(), 'backdrop_url': a.art(), 'type': 3}])
            item = soup.find('li', {'class': 'next'})
            if item:
                item_list.extend([{'site': site, 'mode': 'list_series', 'url': home_url + item.a.get('href'),
                                   'content': params['content'], 'title': '  ' + a.language(30018, True),
                                   'cover_url': a.image(), 'backdrop_url': a.art(), 'type': 3}])
            item = soup.find('li', {'class': 'last'})
            if item:
                item_list.extend(
                    [{'site': site, 'mode': 'list_series', 'url': home_url + item.a.get('href'), 'content': 'goto',
                      'title': a.language(30019, True), 'cover_url': a.image('goto.png', image),
                      'backdrop_url': a.art(), 'type': 3}])
            if item_list:
                a.add_items(item_list)
                a.end_of_directory()

        elif mode == 'list_episodes':
            html = a.get_page(params['url'])
            soup = BeautifulSoup(html, parseOnlyThese=SoupStrainer('div', {'class': 'box-info'}),
                                 convertEntities=BeautifulSoup.HTML_ENTITIES)
            if 'movie' in params['title'].lower():
                params['content'] = 'movies'
                params['duration'] = '4500'
            else:
                params['content'] = 'episodes'
            params['type'] = 0
            params['context'] = 0
            item_list = []
            xbmcdict = XBMCDict().update(params)
            xbmcdict['mode'] = 'play'
            xbmcdict['cover_url'] = soup.find('img').get('src').replace(' ', '%20')
            xbmcdict['thumb_url'] = xbmcdict['cover_url']
            xbmcdict['banner_url'] = xbmcdict['cover_url']
            xbmcdict['poster'] = xbmcdict['cover_url']
            xbmcdict['tvshowtitle'] = soup.find('h1').contents[0].encode('UTF-8').strip()
            xbmcdict['originaltitle'] = soup.find('h1').contents[0].encode('UTF-8').strip()
            xbmcdict['status'] = soup.find('span', text='Status: ').next.strip()
            try:
                xbmcdict['year'] = int(soup.find('span', text='Released: ').next.strip())
            except:
                pass
            item = soup.find('span', text='Plot Summary: ').next.strip()
            if item:
                xbmcdict['plotoutline'] = item
                xbmcdict['plot'] = xbmcdict['plotoutline']
                try:
                    item = soup.find('span', {'class': 'desc_more'}).next.strip()
                    if item:
                        xbmcdict['plot'] += item
                except:
                    pass
            xbmcdict['genre'] = soup.find('span', text='Genre: ').encode('UTF-8')
            soup = BeautifulSoup(html, parseOnlyThese=SoupStrainer('ul', {'class': 'list-episode'}),
                                 convertEntities=BeautifulSoup.HTML_ENTITIES)
            for index, item in enumerate(soup.findAll('a', {'href': True})):
                li = soup.findAll('li')
                _dict = xbmcdict.copy()
                _dict['title'] = li[index].contents[0].encode('UTF-8').strip()
                _dict['url'] = item.get('href')
                if _dict['url'].startswith('/'): _dict['url'] = home_url + _dict['url']
                if re.match('.*episode\s*[0-9]+.*', _dict['title'].lower()):
                    _dict['episode'] = int(re.search('episode\s*([0-9]+)', _dict['title'].lower()).group(1))
                    if re.match('.*season\s*[0-9]+.*', _dict['title'].lower()):
                        _dict['season'] = int(re.search('season\s*([0-9]+)', _dict['title'].lower()).group(1))
                    try:
                        if int(_dict['season']) == 0: _dict['season'] = 1
                    except:
                        pass
                _dict['sub_site'] = site
                item_list.extend([_dict])
            if item_list:
                a.add_items(item_list)
                a.end_of_directory(default_sort=10)
            else:
                a.alert(a.language(30050), sound=False)

        elif mode == 'play':
            html = a.get_page(params['url'])
            soup = BeautifulSoup(html, parseOnlyThese=SoupStrainer('div', {'class': 'content_inner'}),
                                 convertEntities=BeautifulSoup.HTML_ENTITIES)
            item_list = []
            xbmcdict = XBMCDict().update(params)
            temp = soup.find('div', {'class': 'vivan'})
            if temp:
                if temp.contents:
                    _dict = xbmcdict.copy()
                    _dict['url'] = temp.contents[0]
                    _dict['src_title'] = 'Vivan'
                    item_list.extend([_dict])
            soup = BeautifulSoup(html, parseOnlyThese=SoupStrainer('div', {'id': 'tabs'}),
                                 convertEntities=BeautifulSoup.HTML_ENTITIES)
            for index, items in enumerate(soup.findAll('div', {'class': 'servername'})):
                _dict = xbmcdict.copy()
                item = items.find('iframe')
                if item:
                    if re.match('.*(?:anime4fun\.com|animeonlinetv\.tv)/embed[g]*\.php.*', item.get('src')):
                        html = a.get_page(item.get('src'))
                        new_soup = BeautifulSoup(html, parseOnlyThese=SoupStrainer('video', {'id': 'anime_player'}),
                                                 convertEntities=BeautifulSoup.HTML_ENTITIES)
                        item = new_soup.source
                    _dict['url'] = item.get('src')
                    _dict['src_title'] = soup.findAll('a')[index].string.encode('utf-8')
                    if _dict['url']:
                        item_list.extend([_dict])
            soup_contents = soup.renderContents()
            temp = re.search('jQuery\("#server1"\)\.html\(\'&lt;iframe.+?src="(.+?)"', soup_contents, re.IGNORECASE)
            if temp:
                _dict = xbmcdict.copy()
                _dict['url'] = temp.group(1)
                _dict['src_title'] = 'Server 1'
                item_list.extend([_dict])
            temp = re.search('jQuery\("#server2"\)\.html\(\'&lt;iframe.+?src="(.+?)"', soup_contents, re.IGNORECASE)
            if temp:
                _dict = xbmcdict.copy()
                _dict['url'] = temp.group(1)
                _dict['src_title'] = 'Server 2'
                item_list.extend([_dict])
            for item in item_list:
                if item['src_title'] == 'Server HD':
                    item['src_quality'] = 'hd'
                elif item['src_title'] == 'Server 1':
                    item['src_quality'] = 'hd'
                elif re.search('.*(?:1080|720|[hH][dD].*)', item['src_title']):
                    item['src_quality'] = 'hd'
                elif item['src_title'] == 'Vivan':
                    item['src_quality'] = 'hq'
                elif item['src_title'] == 'Server standard':
                    item['src_quality'] = 'hq'
                elif item['src_title'] == 'Standard Server':
                    item['src_quality'] = 'hq'
                elif item['src_title'] == 'Server 2':
                    item['src_quality'] = 'hq'
            if item_list:
                from playback import Playback
                Playback().choose_sources(item_list)
            else:
                a.alert(a.language(30904, True))
