# -*- coding: utf-8 -*-

import urllib2,urllib
import re
import time
import mydecode
import urlparse

BASEURL='http://tele-wizja.com/'
UA = 'Mozilla/5.0 (Windows NT 6.1; rv:22.0) Gecko/20100101 Firefox/22.0'
fix={'animalplanet': 'Animal Planet',
 'boomerang': 'Boomerang',
 'canal': 'Canal+',
 'canaldiscovery': 'Canal+ Discovery HD',
 'canalfamily': 'Canal+ Film',
 'canalsport': 'Canal+ Sport',
 'canalsport2': 'Canal+ Sport 2',
 'cartoon': 'Cartoon Network',
 'cfilm': 'Canal+ Film',
 'cinemax': 'Cinemax',
 'comedycenter': 'Comedy Central',
 'discovery': 'Discovery Channel',
 'discoverys': 'Discovery Science',
 'disney-channel': 'Disney Channel',
 'eleven': 'Eleven',
 'elevensport': 'Eleven Sports',
 'eurosport': 'Eurosport',
 'eurosport2': 'Eurosport 2',
 'fox': 'Fox',
 'h2 ': 'History 2 ',
 'hbo': 'HBO',
 'hbo2': 'HBO2',
 'hbo3': 'HBO3',
 'id': 'ID',
 'kinopolska': 'Kino Polska',
 'kuchene': 'Kuchnia+',
 'minimini': 'Minimini+',
 'natgeo': 'National Geographic Channel',
 'natgeowild': 'Nat Geo Wild',
 'nsport': 'nSport',
 'stopklatka': 'Stopklatka TV',
 'tlc': 'TLC',
 'tvn': 'TVN',
 'tvn24': 'TVN 24',
 'tvn24bis': 'TVN 24 BIS',
 'tvn7': 'TVN 7',
 'tvnstyle': 'TVN Style',
 'tvnturbo': 'TVN Turbo',
 'tvp1': 'TVP 1',
 'tvp2': 'TVP 2',
 'tvphd': 'TVP HD',
 'tvpinfo1': 'TVP Info',
 'tvpseriale': 'TVP Seriale',
 'tvpsport': 'TVP Sport',
 'tvpuls': 'TV Puls',
 'tvrepublika': 'TV Republika',
 'xtra': 'Xtra'}


def fixForEPG(one):
    newName = fix.get(one.get('tvid'),'')
    if newName:
        one['title']=newName
        one['tvid']=newName
    return one
    
def getUrl(url,data=None,header={}):
    if not header:
        header = {'User-Agent':UA}
    req = urllib2.Request(url,data,headers=header)
    try:
        response = urllib2.urlopen(req, timeout=10)
        link = response.read()
        response.close()
    except:
        link=''
    return link
    
def get_root(addheader=False):
    out=[]
    urls=['http://tele-wizja.com/ogolne.html']
    urls=['http://tele-wizja.com/ogolne.html','http://tele-wizja.com/info.html',
            'http://tele-wizja.com/filmowe.html','http://tele-wizja.com/naukowe.html',
            'http://tele-wizja.com/sportowe.html','http://tele-wizja.com/bajkowe.html']
        

    for url in urls:
        content = getUrl(url)
        
        code=url[:-5].split('/')[-1]
        items = re.compile('<a href="(.*?)" class="link"><img src="(.*?)"').findall(content)

        #href,icon=items[0]
        for href,icon in items:
            #print h,t,i
            c = code
            #c = href.split('/')[0]
            t = icon.split('.')[0].split('/')[-1]
            i = urlparse.urljoin(BASEURL,icon)
            h = urlparse.urljoin(BASEURL,href)
            # if t in orange:
            #     print t
            #     c = '[COLOR orange]'+c+'[/COLOR]'
            out.append(fixForEPG({'title':t,'tvid':t,'img':i,'url':h,'group':'','urlepg':'','code':c}))
        #return sorted(out, key=lambda k: k['title'],reverse=True)    
    
    if addheader and len(out):
        t='[COLOR yellow]Updated: %s (telewizja-live)[/COLOR]' %time.strftime("%d/%m/%Y: %H:%M:%S")
        out.insert(0,{'title':t,'tvid':'','img':'','url':BASEURL,'group':'','urlepg':''})
    return out

def decode_url(url='http://tele-wizja.com/tvp1.html'):
    vido_url=''
    
    content = getUrl(url)
    iframe = re.compile('<iframe(.*?)</iframe>',re.DOTALL).findall(content)
    if iframe:
        pageUrl = re.compile('src="(.*?)"').findall(iframe[0])
        if pageUrl:
            data = getUrl(pageUrl[0])
            vido_url = mydecode.decode(url,data)
            # data = getUrl(vido_url)
            print '$$$$$$$$$$$$$$$$$$$$$$$',vido_url
    return vido_url 
    
# def test():
#     out = get_root(False)
#     # fix={o.get('title'):o.get('title') for o in out}
#     outg=[]
#     one =out[0]
#     for one in out:
#         print '\n',one.get('title')
#         video=decode_url(one.get('url'))
#         if not video:
#             outg.append(one.get('title'))
#         print video
   
