import classes
import comm
import config
import json
import sys
import uuid
import xbmcaddon
import xbmcgui
import xbmcplugin

from aussieaddonscommon import utils

ADDON = xbmcaddon.Addon()


def play(params):
    try:
        p = classes.Program()
        p.parse_xbmc_url(sys.argv[2])

        dash = ADDON.getSetting('dash_enabled') == 'true'
        hd = ADDON.getSetting('hd_enabled') == 'true'
        if dash:
            if hd:
                stream_url = p.dash_url
            else:
                stream_url = p.sd_dash_url
        else:
            if hd:
                stream_url = p.url
            else:
                stream_url = p.sd_url

        # live channels
        if p.id:
            url = config.CHANNEL_URL.format(ppid=uuid.uuid4(), cid=p.id)
            data = json.loads(comm.fetch_url(url))
            stream_url = data.get('hls_url')

        listitem = xbmcgui.ListItem(label=p.get_title(),
                                    iconImage=p.get_thumb(),
                                    thumbnailImage=p.get_thumb(),
                                    path=stream_url)
        listitem.setInfo('video', p.get_kodi_list_item())

        if hasattr(listitem, 'addStreamInfo'):
            listitem.addStreamInfo('audio', p.get_kodi_audio_stream_info())
            listitem.addStreamInfo('video', p.get_kodi_video_stream_info())

        if dash and not p.live:
            import drmhelper

            if drmhelper.check_inputstream(drm=False):
                listitem.setProperty('inputstreamaddon',
                                     'inputstream.adaptive')
                listitem.setProperty('inputstream.adaptive.manifest_type',
                                     'mpd')
        # Play video
        utils.log('Attempting to play: {0} : {1}'.format(p.get_title(),
                                                         stream_url))
        xbmcplugin.setResolvedUrl(int(sys.argv[1]), True, listitem=listitem)

    except Exception:
        utils.handle_error('Unable to play video')
