import comm
import sys
import xbmcgui
import xbmcplugin

from aussieaddonscommon import utils


def make_categories_list():
    utils.log('Showing category list')
    try:
        categories_list = comm.get_categories()
        for c in categories_list:
            url = '{0}?action=list_categories&{1}'.format(sys.argv[0],
                                                          c.make_kodi_url())
            listitem = xbmcgui.ListItem(label=c.title,
                                        iconImage=c.get_thumb(),
                                        thumbnailImage=c.get_thumb())

            ok = xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]),
                                             url=url,
                                             listitem=listitem,
                                             isFolder=True)

        xbmcplugin.endOfDirectory(handle=int(sys.argv[1]), succeeded=ok)
        xbmcplugin.setContent(handle=int(sys.argv[1]), content='tvshows')
    except Exception:
        utils.handle_error("Unable to show category listing")


def make_programs_list(params):
    try:
        programs = comm.get_programs_list(params)

        ok = True
        for p in programs:

            listitem = xbmcgui.ListItem(label=p.get_list_title(),
                                        iconImage=p.get_thumb(),
                                        thumbnailImage=p.get_thumb())
            listitem.setInfo('video', p.get_kodi_list_item())
            listitem.setProperty('IsPlayable', 'true')

            if hasattr(listitem, 'addStreamInfo'):
                listitem.addStreamInfo('audio', p.get_kodi_audio_stream_info())
                listitem.addStreamInfo('video', p.get_kodi_video_stream_info())

            # Build the URL for the program, including the list_info
            url = '{0}?action=list_programs&{1}'.format(sys.argv[0],
                                                        p.make_kodi_url())

            # Add the program item to the list
            ok = xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]),
                                             url=url,
                                             listitem=listitem,
                                             isFolder=False)

        xbmcplugin.endOfDirectory(handle=int(sys.argv[1]), succeeded=ok)
        xbmcplugin.setContent(handle=int(sys.argv[1]), content='episodes')
    except Exception:
        utils.handle_error("Unable to fetch program listing")


def make_series_list(params):
    utils.log('Showing series list')
    try:
        series_list = comm.get_series_list(params)
        series_list.sort()

        ok = True
        for s in series_list:
            url = '{0}?action=list_series&{1}'.format(sys.argv[0],
                                                      s.make_kodi_url())
            listitem = xbmcgui.ListItem(s.title,
                                        iconImage=s.get_thumb(),
                                        thumbnailImage=s.get_thumb())
            listitem.setInfo('video', {'plot': ''})

            # add the item to the media list
            ok = xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]),
                                             url=url,
                                             listitem=listitem,
                                             isFolder=True)

        xbmcplugin.endOfDirectory(handle=int(sys.argv[1]), succeeded=ok)
        xbmcplugin.setContent(handle=int(sys.argv[1]), content='tvshows')
    except Exception:
        utils.handle_error("Unable to fetch series listing")


def make_live_list(url):
    try:
        channels = comm.get_live()
        if not channels:
            return

        ok = True
        for c in channels:

            listitem = xbmcgui.ListItem(label=c.get_list_title(),
                                        iconImage=c.get_thumb(),
                                        thumbnailImage=c.get_thumb())
            listitem.setInfo('video', c.get_kodi_list_item())
            listitem.setProperty('IsPlayable', 'true')

            if hasattr(listitem, 'addStreamInfo'):
                listitem.addStreamInfo('audio', c.get_kodi_audio_stream_info())
                listitem.addStreamInfo('video', c.get_kodi_video_stream_info())

            # Build the URL for the program, including the list_info
            url = '{0}?action=list_channels&{1}'.format(sys.argv[0],
                                                        c.make_kodi_url())
            # Add the program item to the list
            ok = xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]),
                                             url=url,
                                             listitem=listitem,
                                             isFolder=False)

        xbmcplugin.endOfDirectory(handle=int(sys.argv[1]), succeeded=ok)
        xbmcplugin.setContent(handle=int(sys.argv[1]), content='episodes')
    except Exception:
        utils.handle_error("Unable to fetch live channel listing")
