import classes
import config
import json
import urlparse
import xbmcaddon

from aussieaddonscommon import session
from aussieaddonscommon import utils

ADDON = xbmcaddon.Addon()


def fetch_url(url, headers=None, retries=1):
    """Simple function that fetches a URL using requests."""
    with session.Session() as sess:
        if headers:
            sess.headers.update(headers)
        while retries > 0:
            try:
                request = sess.get(url)
                data = request.text
                return data
            except session.requests.exceptions.HTTPError as e:
                if e.response.status_code == 404:
                    retries -= 1
                else:
                    raise e
                if retries == 0:
                    raise e
    return data


def get_market_id():
    try:
        data = json.loads(
            fetch_url(config.MARKET_URL, retries=3))  # sometimes 404s
        return str(data.get('_id'))
    except session.requests.exceptions.HTTPError as e:
        if e.response.status_code == 404:
            return '15'


def api_query(key=None):
    market_id = get_market_id()
    headers = {'market-id': market_id, 'api-version': config.API_VER}
    if not key:
        key = 'home'
    query_url = urlparse.urljoin(config.CONTENT_URL, key)
    # deal with intermittient api timeout errors
    data = json.loads(fetch_url(query_url, headers=headers))
    return data


def get_categories():
    """Fetch list of all genres"""
    categories_list = []

    for category in config.CATEGORIES:
        c = classes.Category()
        c.title = category
        categories_list.append(c)
    data = json.loads(fetch_url(config.CATEGORIES_URL))
    for heading in data:
        c = classes.Category(title='--- {0} ---'.format(heading))
        c.dummy = True
        categories_list.append(c)
        for item in data.get(heading):
            print item
            c = classes.Category()
            c.title = item.get('title')
            c.id = item.get('id')
            c.playlist_id = item.get('playlistId')
            c.premium = item.get('premium')
            c.code = item.get('code')
            categories_list.append(c)
    return categories_list


def get_programs_list(params):
    """Fetch the episode list for a given series"""
    program_list = []
    json_data = json.loads(
        fetch_url(config.ITEMS_URL.format(params.get('id'))))

    for item in json_data.get('items'):

        p = classes.Program()
        p.title = item.get('title')
        p.thumb = item.get('thumbnailUrl')
        p.description = item.get('shortDescription')
        p.sd_url = item.get('sdHlsUrl')
        p.url = item.get('hlsUrl')
        p.dash_url = item.get('dashUrl')
        p.sd_dash_url = item.get('sdDashUrl')
        utils.log('added program')
        program_list.append(p)

    return program_list


def get_live():
    """Fetch live channel info for available channels"""
    market = get_market_id()
    json_data = json.loads(fetch_url(config.EPG_URL.format('now', market)))
    channel_list = []
    for channel in json_data.get('channels'):
        c = classes.Program()
        c.live = True
        c.thumb = channel.get('logoUrl')
        c.title = channel['programs'][0].get('title')
        c.description = channel['programs'][0].get('synopsis')
        c.id = channel.get('id')
        channel_list.append(c)

    return channel_list
