import os
import sys
import xbmcaddon
import xbmcgui
# fix for python bug
import _strptime  # noqa: F401

import drmhelper
from aussieaddonscommon import utils

# Add our resources/lib to the python path
addon_dir = xbmcaddon.Addon().getAddonInfo('path')
sys.path.insert(0, os.path.join(addon_dir, 'resources', 'lib'))

import menu  # noqa: E402
import play  # noqa: E402

# Print our platform/version debugging information
utils.log_kodi_platform_version()


if __name__ == "__main__":
    params_str = sys.argv[2]
    params = utils.get_url(params_str)
    utils.log('Running with params: {0}'.format(params))
    if len(params) == 0:
        menu.make_categories_list()
    elif 'action' in params:
        action = params.get('action')
        if action == 'list_categories':
            if params['title'] == 'Settings':
                xbmcaddon.Addon().openSettings()
            elif params['title'] == 'On Now':
                menu.make_live_list(params)
            else:
                if params.get('dummy') == 'True':
                    pass
                else:
                    menu.make_programs_list(params)
        elif action == 'list_programs':
            play.play(params)
        elif action == 'list_channels':
            play.play(params)
        elif action == 'sendreport':
            utils.user_report()
        elif action == 'reinstall_widevine_cdm':
            drmhelper.get_widevinecdm()
        elif action == 'reinstall_ssd_wv':
            drmhelper.get_ssd_wv()
        elif action == 'update_ia':
            addon = drmhelper.get_addon(drm=True)
            if not drmhelper.is_ia_current(addon, latest=True):
                if xbmcgui.Dialog().yesno(
                    'Upgrade?', ('Newer version of inputstream.adaptive '
                                 'available ({0}) - would you like to '
                                 'upgrade to this version?'.format(
                                    drmhelper.get_latest_ia_ver()))):
                    drmhelper.get_ia_direct(update=True, drm=True)
            else:
                ver = addon.getAddonInfo('version')
                utils.dialog_message('Up to date: Inputstream.adaptive '
                                     'version {0} installed and enabled.'
                                     ''.format(ver))
    else:
        utils.log('nothing')
