#######################################################################
 # ----------------------------------------------------------------------------
 # "THE BEER-WARE LICENSE" (Revision 42):
 # @tantrumdev wrote this file.  As long as you retain this notice you
 # can do whatever you want with this stuff. If we meet some day, and you think
 # this stuff is worth it, you can buy me a beer in return. - Muad'Dib
 # ----------------------------------------------------------------------------
#######################################################################

import xbmc, xbmcaddon, xbmcgui, xbmcplugin, os, sys, xbmcvfs, glob
import shutil
import urllib2,urllib
import re
import uservar
import time
from datetime import date, datetime, timedelta
try:    from sqlite3 import dbapi2 as database
except: from pysqlite2 import dbapi2 as database
from string import digits

ADDON_ID       = uservar.ADDON_ID
ADDONTITLE     = uservar.ADDONTITLE
ADDON          = xbmcaddon.Addon(ADDON_ID)
VERSION        = ADDON.getAddonInfo('version')
USER_AGENT     = 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-GB; rv:1.9.0.3) Gecko/2008092417 Firefox/3.0.3'
DIALOG         = xbmcgui.Dialog()
DP             = xbmcgui.DialogProgress()
HOME           = xbmc.translatePath('special://home/')
LOG            = xbmc.translatePath('special://logpath/')
PROFILE        = xbmc.translatePath('special://profile/')
ADDONS         = os.path.join(HOME, 'addons')
USERDATA       = os.path.join(HOME, 'userdata')
PLUGIN         = os.path.join(ADDONS, ADDON_ID)
PACKAGES       = os.path.join(ADDONS, 'packages')
ADDONDATA      = os.path.join(USERDATA, 'addon_data', ADDON_ID)
ADVANCED       = os.path.join(USERDATA, 'advancedsettings.xml')
SOURCES        = os.path.join(USERDATA, 'sources.xml')
FAVOURITES     = os.path.join(USERDATA, 'favourites.xml')
PROFILES       = os.path.join(USERDATA, 'profiles.xml')
THUMBS         = os.path.join(USERDATA, 'Thumbnails')
DATABASE       = os.path.join(USERDATA, 'Database')
FANART         = os.path.join(PLUGIN, 'fanart.jpg')
ICON           = os.path.join(PLUGIN, 'icon.png')
WIZLOG         = os.path.join(ADDONDATA, 'wizard.log')

TODAY          = date.today()

def getS(name):
    try: return ADDON.getSetting(name)
    except: return False

def setS(name, value):
    try: ADDON.setSetting(name, value)
    except: return False

def openS():
    ADDON.openSettings();

def clearS(type):
    trakt   = {'exodus':'', 'covenant':'', 'salts':'', 'saltshd':'', 'royalwe':'', 'velocity':'', 'velocity':'', 'specto':'', 'trakt':'', 'keeptrakt':'false', 'traktlastsave':'2016-01-01'}
    debrid  = {'exodus':'', 'covenant':'', 'specto':'', 'urlresolver':'', 'keepdebrid':'false', 'debridlastsave':'2016-01-01'}
    build   = {'buildname':'', 'buildversion':'', 'buildtheme':'', 'latestversion':'', 'lastbuildcheck':'2016-01-01'}
    install = {'installed':'false', 'extract':'', 'errors':''}
    if type == 'trakt':
        for set in trakt:
            setS(set, trakt[set])
    if type == 'debrid':
        for set in debrid:
            setS(set, debrid[set])
    elif type == 'build':
        for set in build:
            setS(set, build[set])
        for set in install:
            setS(set, install[set])
    elif type == 'install':
        for set in install:
            setS(set, install[set])


def TextBoxes(heading,announce):
    class TextBox():
        WINDOW=10147
        CONTROL_LABEL=1
        CONTROL_TEXTBOX=5
        def __init__(self,*args,**kwargs):
            xbmc.executebuiltin("ActivateWindow(%d)" % (self.WINDOW, )) # activate the text viewer window
            self.win=xbmcgui.Window(self.WINDOW) # get window
            xbmc.sleep(500) # give window time to initialize
            self.setControls()
        def setControls(self):
            self.win.getControl(self.CONTROL_LABEL).setLabel(heading) # set heading
            try: f=open(announce); text=f.read()
            except: text=announce
            self.win.getControl(self.CONTROL_TEXTBOX).setText(str(text))
            return
    TextBox()
    while xbmc.getCondVisibility('Window.IsVisible(10147)'):
        time.sleep(.5)

def LogNotify(title,message,times=4000,icon=ICON):
    xbmc.executebuiltin('XBMC.Notification(%s, %s, %s, %s)' % (title , message , times, icon))

def log(log):
    xbmc.log("[%s]: %s" % (ADDONTITLE, log))
    if not os.path.exists(ADDONDATA): os.makedirs(ADDONDATA)
    if not os.path.exists(WIZLOG): f = open(WIZLOG, 'w'); f.close()
    with open(WIZLOG, 'r+') as f:
        line = "[%s %s] %s" % (datetime.now().date(), str(datetime.now().time())[:8], log)
        content = f.read()
        f.seek(0, 0)
        f.write(line.rstrip('\r\n') + '\n' + content)

def addonId(add):
    return xbmcaddon.Addon(id=add)

def convertSize(num, suffix='B'):
    for unit in ['', 'K', 'M', 'G']:
        if abs(num) < 1024.0:
            return "%3.02f %s%s" % (num, unit, suffix)
        num /= 1024.0
    return "%.02f %s%s" % (num, 'G', suffix)

def latestDB(DB):
    if DB in ['Addons', 'ADSP', 'Epg', 'MyMusic', 'MyVideos', 'Textures', 'TV', 'ViewModes']:
        match = glob.glob(os.path.join(DATABASE,'%s*.db' % DB))
        comp = '%s(.+?).db' % DB[1:]
        highest = 0
        for file in match :
            try: check = int(re.compile(comp).findall(file)[0])
            except: check = 0
            if highest < check :
                highest = check
        return '%s%s.db' % (DB, highest)
    else: return False

def clearOldThumbs(over=None):
    dbfile = os.path.join(DATABASE, latestDB('Textures'))
    use    = 10
    week   = TODAY - timedelta(days=7)
    ids    = []
    images = []
    size   = 0
    if os.path.exists(dbfile):
        try:
            textdb = database.connect(dbfile)
            textexe = textdb.cursor()
        except Exception, e:
            log("DB Connection Error: %s" % str(e), xbmc.LOGERROR)
            return False
    else: log('%s not found.' % dbfile, xbmc.LOGERROR); return False
    textexe.execute("SELECT idtexture FROM sizes WHERE usecount < ? AND lastusetime < ?", (use, str(week)))
    found = textexe.fetchall()
    for rows in found:
        idfound = rows[0]
        ids.append(idfound)
        textexe.execute("SELECT cachedurl FROM texture WHERE id = ?", (idfound, ))
        found2 = textexe.fetchall()
        for rows2 in found2:
            images.append(rows2[0])
    for id in ids:
        textexe.execute("DELETE FROM sizes   WHERE idtexture = ?", (id, ))
        textexe.execute("DELETE FROM texture WHERE id        = ?", (id, ))
    textexe.execute("VACUUM")
    textdb.commit()
    textexe.close()
    for image in images:
        path = os.path.join(THUMBS, image)
        try:
            imagesize = os.path.getsize(path)
            os.remove(path)
            size += imagesize
        except:
            pass
    removed = convertSize(size)
    if len(images) > 0: LogNotify(ADDONTITLE, '[COLOR white]Clear Thumbnails:[/COLOR] [COLOR red]%s Files / %s MB[/COLOR]!' % (str(len(images)), removed))
    else: LogNotify(ADDONTITLE, '[COLOR white]Clear Thumbnails:[/COLOR] [COLOR red]None Found![/COLOR]')

def clearPackages(over=None):
    if os.path.exists(PACKAGES):
        try:
            for root, dirs, files in os.walk(PACKAGES):
                file_count = 0
                file_count += len(files)
                # Count files and give option to delete
                if file_count > 0:
                    if over: yes=1
                    else: yes=DIALOG.yesno("Delete Package Cache Files", str(file_count) + " files found", "Do you want to delete them?", nolabel='No, Cancel',yeslabel='Yes, Remove')
                    if yes:
                        for f in files: os.unlink(os.path.join(root, f))
                        for d in dirs: shutil.rmtree(os.path.join(root, d))
                        LogNotify(ADDONTITLE,'[COLOR white]Packages Purged:[/COLOR] [COLOR red]Success[/COLOR]!')
                else: LogNotify(ADDONTITLE,'[COLOR white]Packages:[/COLOR] [COLOR red]None Found![/COLOR]')
        except: LogNotify(ADDONTITLE,'[COLOR white]Packages:[/COLOR] [COLOR red]Error[/COLOR]!')
    else: LogNotify(ADDONTITLE,'[COLOR white]Packages:[/COLOR] [COLOR red]None Found![/COLOR]')

def clearCrashLogs(over=None):
    crashfiles = []
    tracefiles = []
    for file in glob.glob(os.path.join(LOG, '*crashlog*.*')):
        crashfiles.append(file)
    for file in glob.glob(os.path.join(LOG, '*stacktrace*.*')):
        tracefiles.append(file)
    totalfiles = len(crashfiles) + len(tracefiles)
    if len(totalfiles) > 0:
        if over:
            yes=1
        else:
            yes=DIALOG.yesno(ADDONTITLE, 'Would you like to delete the Crash logs?', '%s Files Found' % (len(files)), nolabel="No, Cancel", yeslabel="Yes, Remove")
        if yes:
            if len(crashfiles) > 0:
                for f in files:
                    os.remove(f)
            if len(tracefiles) > 0:
                for f in files:
                    os.remove(f)
            LogNotify(ADDONTITLE, '[COLOR white]Clear Crash Logs[/COLOR] [COLOR red]%s Crash Logs Removed[/COLOR]' % (totalfiles))
        else:
            LogNotify(ADDONTITLE, '[COLOR white]Clear Crash Logs[/COLOR] [COLOR red]Clear Crash Logs Cancelled[/COLOR]')
    else:
        LogNotify(ADDONTITLE, '[COLOR white]Clear Crash Logs[/COLOR] [COLOR red]No Crash Logs Found[/COLOR]')

def clearCache():
    PROFILEADDONDATA = os.path.join(PROFILE,'addon_data')
    cachelist = [
        (PROFILEADDONDATA),
        (ADDONDATA),
        (os.path.join(HOME,'cache')),
        (os.path.join(HOME,'temp')),
        (os.path.join('/private/var/mobile/Library/Caches/AppleTV/Video/', 'Other')),
        (os.path.join('/private/var/mobile/Library/Caches/AppleTV/Video/', 'LocalAndRental')),
        (os.path.join(ADDONDATA, 'plugin.video.bob', 'cache.db')),
        (os.path.join(ADDONDATA, 'plugin.video.bob.unleashed', 'cache.db')),
        (os.path.join(ADDONDATA, 'plugin.video.specto', 'cache.db')),
        (os.path.join(ADDONDATA, 'plugin.video.genesis', 'cache.db')),
        (os.path.join(ADDONDATA, 'plugin.video.exodus', 'cache.db')),
        (os.path.join(ADDONDATA, 'plugin.video.covenant', 'cache.db')),
        (os.path.join(ADDONDATA, 'plugin.video.TheDeLorean', 'cache.db')),
        (os.path.join(ADDONDATA, 'plugin.video.itv','Images')),
        (os.path.join(DATABASE,  'onechannelcache.db')),
        (os.path.join(DATABASE,  'saltscache.db')),
        (os.path.join(DATABASE,  'saltshd.lite.db')),
        (os.path.join(PROFILEADDONDATA,'script.module.simple.downloader')),
        (os.path.join(PROFILEADDONDATA,'plugin.video.itv','Images'))]

    delfiles = 0

    for item in cachelist:
        if os.path.exists(item) and not item in [ADDONDATA, PROFILEADDONDATA]:
            for root, dirs, files in os.walk(item):
                file_count = 0
                file_count += len(files)
                if file_count > 0:
                    for f in files:
                        if not f in ['kodi.log', 'tvmc.log', 'spmc.log', 'xbmc.log']:
                            try:
                                os.unlink(os.path.join(root, f))
                            except:
                                pass
                        else: log('Ignore Log File: %s' % f)
                    for d in dirs:
                        try:
                            shutil.rmtree(os.path.join(root, d))
                            delfiles += 1
                            log("[COLOR red][Success]  %s Files Removed From %s [/COLOR]" % (str(file_count), os.path.join(item,d)))
                        except:
                            log("[COLOR red][Failed] To Wipe Cache In: %s [/COLOR]" % os.path.join(item,d))
        else:
            for root, dirs, files in os.walk(item):
                for d in dirs:
                    if 'cache' in d.lower():
                        try:
                            shutil.rmtree(os.path.join(root, d))
                            delfiles += 1
                            log("[COLOR white][Success] Wiped %s [/COLOR]" % os.path.join(item,d))
                        except:
                            log("[COLOR red][Failed] To Wipe Cache In: %s [/COLOR]" % os.path.join(item,d))

    LogNotify(ADDONTITLE,'[COLOR white]Cache:[/COLOR] [COLOR red] %s Items Removed[/COLOR]' % delfiles)