import re, os, sys
import xbmc, xbmcgui, xbmcplugin, xbmcvfs, xbmcaddon
import json
    

ADDON_ID      = 'plugin.program.senyortools'
REAL_SETTINGS = xbmcaddon.Addon(id=ADDON_ID)
ADDON_ID      = REAL_SETTINGS.getAddonInfo('id')
ADDON_NAME    = REAL_SETTINGS.getAddonInfo('name')
ADDON_PATH    = (REAL_SETTINGS.getAddonInfo('path').decode('utf-8'))
ADDON_VERSION = REAL_SETTINGS.getAddonInfo('version')
ICON          = os.path.join(ADDON_PATH, 'icon.png')
FANART        = os.path.join(ADDON_PATH, 'fanart.jpg')

CONTENTS = ["unknown",
            "video",
            "audio",
            "image",	
            "executable"]
            
TYPES    = ["unknown",
            "xbmc.player.musicviz",
            "xbmc.pvrclient",
            "xbmc.gui.skin",
            "kodi.adsp",
            "kodi.inputstream",
            "kodi.peripheral",
            "xbmc.python.script",
            "xbmc.python.weather",
            "xbmc.subtitle.module",
            "xbmc.python.lyrics",
            "xbmc.metadata.scraper.albums",
            "xbmc.metadata.scraper.artists",
            "xbmc.metadata.scraper.movies",
            "xbmc.metadata.scraper.musicvideos",
            "xbmc.metadata.scraper.tvshows",
            "xbmc.ui.screensaver",
            "xbmc.python.pluginsource",
            "xbmc.addon.repository",
            "xbmc.webinterface",
            "xbmc.service",
            "xbmc.audioencoder",
            "kodi.context.item",
            "kodi.audiodecoder",
            "kodi.resource.images",
            "kodi.resource.language",
            "kodi.resource.uisounds",
            "xbmc.addon.video",
            "xbmc.addon.audio",
            "xbmc.addon.image",
            "xbmc.addon.executable",
            "xbmc.metadata.scraper.library",
            "xbmc.python.library",
            "xbmc.python.module",
            "kodi.game.controller"]

CONTENT_TYPES = ["kodi.inputstream"]
 
 

def set_Kodi_JSON(params):
    xbmc.executeJSONRPC('{"jsonrpc": "2.0", %s, "id": 1}' % params)
    
def set_Kodi_Enabled(plugin):
    set_Kodi_JSON('"method":"Addons.SetAddonEnabled","params":{"addonid":"%s","enabled":true}'%plugin)
        
def get_Kodi_JSON(params):
    return json.loads(unicode(xbmc.executeJSONRPC('{"jsonrpc": "2.0", %s, "id": 1}' % params), 'utf-8', errors='ignore'))
    
def get_Kodi_Disabled(type,content):
     return get_Kodi_JSON('"method":"Addons.GetAddons","params":{"type":"%s","content":"%s","enabled":false,"installed":true}'%(type,content))

def aaa():
    percent       = 0
    count         = 0
    loop          = 0
    details       = []
    dlg           = xbmcgui.DialogProgress()
    dlg.create(ADDON_NAME)
    
    for content in CONTENTS:
        for type in CONTENT_TYPES:
            loop += 1
            if (dlg.iscanceled()):
                dlg.close()
                break
            percent = loop * 100 // len(CONTENT_TYPES)
            dlg.update(percent)
            details.append(get_Kodi_Disabled(type,content))
            
    for json_response in details:
        if json_response.has_key('result') and (json_response['result'] != None) and json_response['result'].has_key('addons'):
            count   = 0
            for item in json_response['result']['addons']:
                if (dlg.iscanceled()):
                    dlg.close()
                    break
                dlg.update((count * 100 // len(json_response['result']['addons'])),'Checking: %s'%item['type'],'Enabling: %s'%item['addonid'])
                set_Kodi_Enabled(item['addonid'])
                xbmc.sleep(100)
    dlg.update(100)
    dlg.close()
    
    
aaa()
xbmc.sleep(1000)      